/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.core.ModBlocks;
import com.github.alexthe666.iceandfire.entity.DragonUtils;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityDragonFire;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class FireExplosion
extends Explosion {
    private final boolean isSmoking;
    private final Random explosionRNG = new Random();
    private final World worldObj;
    private final double explosionX;
    private final double explosionY;
    private final double explosionZ;
    private final Entity exploder;
    private final float explosionSize;
    private final List<BlockPos> affectedBlockPositions = Lists.newArrayList();
    private final Map<EntityPlayer, Vec3d> playerKnockbackMap = Maps.newHashMap();
    private final Vec3d position;
    private boolean mobGreifing;

    public FireExplosion(World world, Entity entity, double x, double y, double z, float size, boolean smoke) {
        super(world, entity, x, y, z, size, true, smoke);
        this.worldObj = world;
        this.exploder = entity;
        this.explosionSize = size;
        this.explosionX = x;
        this.explosionY = y;
        this.explosionZ = z;
        this.isSmoking = smoke;
        this.position = new Vec3d(this.explosionX, this.explosionY, this.explosionZ);
        this.mobGreifing = this.worldObj.func_82736_K().func_82766_b("mobGriefing");
    }

    public void func_77278_a() {
        HashSet set = Sets.newHashSet();
        int i = 16;
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 3.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.explosionX;
                    double d6 = this.explosionY;
                    double d8 = this.explosionZ;
                    float f1 = 0.3f;
                    for (float f = this.explosionSize * (0.7f + this.worldObj.field_73012_v.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockpos = new BlockPos(d4, d6, d8);
                        IBlockState iblockstate = this.worldObj.func_180495_p(blockpos);
                        if (iblockstate.func_185904_a() != Material.field_151579_a) {
                            float f2 = this.exploder != null ? this.exploder.func_180428_a((Explosion)this, this.worldObj, blockpos, iblockstate) : iblockstate.func_177230_c().getExplosionResistance(this.worldObj, blockpos, (Entity)null, (Explosion)this);
                            f -= (f2 + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && (this.exploder == null || this.exploder.func_174816_a((Explosion)this, this.worldObj, blockpos, iblockstate, f)) && iblockstate.func_177230_c().canEntityDestroy(iblockstate, (IBlockAccess)this.worldObj, blockpos, this.exploder)) {
                            set.add(blockpos);
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.affectedBlockPositions.addAll(set);
        float f3 = this.explosionSize * 2.0f;
        int k1 = MathHelper.func_76128_c((double)(this.explosionX - (double)f3 - 1.0));
        int l1 = MathHelper.func_76128_c((double)(this.explosionX + (double)f3 + 1.0));
        int i2 = MathHelper.func_76128_c((double)(this.explosionY - (double)f3 - 1.0));
        int i1 = MathHelper.func_76128_c((double)(this.explosionY + (double)f3 + 1.0));
        int j2 = MathHelper.func_76128_c((double)(this.explosionZ - (double)f3 - 1.0));
        int j1 = MathHelper.func_76128_c((double)(this.explosionZ + (double)f3 + 1.0));
        List list = this.worldObj.func_72839_b(this.exploder, new AxisAlignedBB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        ForgeEventFactory.onExplosionDetonate((World)this.worldObj, (Explosion)this, (List)list, (double)f3);
        Vec3d Vec3d2 = new Vec3d(this.explosionX, this.explosionY, this.explosionZ);
        for (Entity entity : list) {
            double d12;
            if (entity instanceof EntityDragonFire || entity.func_180427_aV() || entity.func_70028_i(this.exploder) || !((d12 = entity.func_70011_f(this.explosionX, this.explosionY, this.explosionZ) / (double)f3) <= 1.0)) continue;
            double d5 = entity.field_70165_t - this.explosionX;
            double d7 = entity.field_70163_u + (double)entity.func_70047_e() - this.explosionY;
            double d9 = entity.field_70161_v - this.explosionZ;
            double d13 = MathHelper.func_76133_a((double)(d5 * d5 + d7 * d7 + d9 * d9));
            double d14 = this.worldObj.func_72842_a(Vec3d2, entity.func_174813_aQ());
            double d10 = (1.0 - d12) * d14;
            if (d13 != 0.0) {
                d5 /= d13;
                d7 /= d13;
                d9 /= d13;
                if (this.exploder != null && this.exploder instanceof EntityDragonBase) {
                    if (entity instanceof EntityDragonBase && ((EntityDragonBase)entity).func_152114_e(((EntityDragonBase)this.exploder).func_70902_q())) {
                        return;
                    }
                    if (entity instanceof EntityLivingBase && ((EntityDragonBase)this.exploder).func_152114_e((EntityLivingBase)entity)) {
                        entity.func_70097_a(IceAndFire.dragonFire, (float)((int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)f3 + 1.0)) / 6.0f);
                        if (entity.field_70128_L && entity instanceof EntityPlayer) {
                            // empty if block
                        }
                    } else if (!entity.func_70028_i(this.exploder)) {
                        entity.func_70097_a(IceAndFire.dragonFire, (float)((int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)f3 + 1.0)) / 3.0f);
                    }
                }
                if (entity.field_70128_L && this.exploder != null && this.exploder instanceof EntityDragonBase) {
                    ((EntityDragonBase)this.exploder).attackDecision = true;
                }
            }
            double d11 = 1.0;
            if (entity instanceof EntityLivingBase) {
                d11 = EnchantmentProtection.func_92092_a((EntityLivingBase)((EntityLivingBase)entity), (double)d10);
            }
            entity.field_70159_w += d5 * d11;
            entity.field_70181_x += d7 * d11;
            entity.field_70179_y += d9 * d11;
            if (!(entity instanceof EntityPlayer) || ((EntityPlayer)entity).field_71075_bZ.field_75102_a) continue;
            this.playerKnockbackMap.put((EntityPlayer)entity, new Vec3d(d5 * d10, d7 * d10, d9 * d10));
        }
    }

    public void func_77279_a(boolean spawnParticles) {
        if (this.isSmoking) {
            for (BlockPos blockpos : this.affectedBlockPositions) {
                IBlockState state = this.worldObj.func_180495_p(blockpos);
                Block block = this.worldObj.func_180495_p(blockpos).func_177230_c();
                if (spawnParticles) {
                    double d0 = (float)blockpos.func_177958_n() + this.worldObj.field_73012_v.nextFloat();
                    double d1 = (float)blockpos.func_177956_o() + this.worldObj.field_73012_v.nextFloat();
                    double d2 = (float)blockpos.func_177952_p() + this.worldObj.field_73012_v.nextFloat();
                    double d3 = d0 - this.explosionX;
                    double d4 = d1 - this.explosionY;
                    double d5 = d2 - this.explosionZ;
                    double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
                    d3 /= d6;
                    d4 /= d6;
                    d5 /= d6;
                    double d7 = 0.5 / (d6 / (double)this.explosionSize + 0.1);
                    this.worldObj.func_175688_a(EnumParticleTypes.FLAME, d0, d1, d2, d3 *= (d7 *= (double)(this.worldObj.field_73012_v.nextFloat() * this.worldObj.field_73012_v.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7, new int[0]);
                    this.worldObj.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, d3, d4, d5, new int[0]);
                    this.worldObj.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, d3, d4, d5, new int[0]);
                }
                if (state.func_185904_a() == Material.field_151579_a || state.func_177230_c().func_149739_a().contains("grave") || !DragonUtils.canDragonBreak(state.func_177230_c()) || !this.mobGreifing) continue;
                if (block == Blocks.field_185774_da) {
                    this.worldObj.func_175656_a(blockpos, ModBlocks.charedGrassPath.func_176223_P());
                }
                if (block instanceof BlockGrass) {
                    this.worldObj.func_175656_a(blockpos, ModBlocks.charedGrass.func_176223_P());
                }
                if (block instanceof BlockDirt) {
                    this.worldObj.func_175656_a(blockpos, ModBlocks.charedDirt.func_176223_P());
                }
                if (block instanceof BlockLeaves || state.func_185904_a() == Material.field_151586_h) {
                    this.worldObj.func_175656_a(blockpos, Blocks.field_150350_a.func_176223_P());
                }
                if (block instanceof BlockGravel) {
                    this.worldObj.func_175656_a(blockpos, ModBlocks.charedGravel.func_176223_P());
                }
                if (state.func_185904_a() == Material.field_151575_d) {
                    this.worldObj.func_175656_a(blockpos, ModBlocks.ash.func_176223_P());
                }
                if (state.func_185904_a() == Material.field_151576_e && block != ModBlocks.charedCobblestone && block != Blocks.field_150347_e && block != Blocks.field_150341_Y && block != Blocks.field_150463_bK) {
                    this.worldObj.func_175656_a(blockpos, ModBlocks.charedStone.func_176223_P());
                    continue;
                }
                if (state.func_185904_a() != Material.field_151576_e) continue;
                this.worldObj.func_175656_a(blockpos, ModBlocks.charedCobblestone.func_176223_P());
            }
        }
        for (BlockPos blockpos1 : this.affectedBlockPositions) {
            if (this.worldObj.func_180495_p(blockpos1).func_185904_a() != Material.field_151579_a || !this.worldObj.func_180495_p(blockpos1.func_177977_b()).func_185913_b() || this.explosionRNG.nextInt(3) != 0 || !this.mobGreifing) continue;
            this.worldObj.func_175656_a(blockpos1, Blocks.field_150480_ab.func_176223_P());
        }
    }

    public Map<EntityPlayer, Vec3d> func_77277_b() {
        return this.playerKnockbackMap;
    }

    public EntityLivingBase func_94613_c() {
        return this.exploder == null ? null : (this.exploder instanceof EntityTNTPrimed ? ((EntityTNTPrimed)this.exploder).func_94083_c() : (this.exploder instanceof EntityLivingBase ? (EntityLivingBase)this.exploder : null));
    }

    public void func_180342_d() {
        this.affectedBlockPositions.clear();
    }

    public List<BlockPos> func_180343_e() {
        return this.affectedBlockPositions;
    }

    public Vec3d getPosition() {
        return this.position;
    }
}

