/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.client.model.IFChainBuffer;
import com.github.alexthe666.iceandfire.core.ModSounds;
import com.github.alexthe666.iceandfire.entity.DragonUtils;
import com.github.alexthe666.iceandfire.entity.EntityMutlipartPart;
import com.github.alexthe666.iceandfire.entity.EntitySeaSerpentBubbles;
import com.github.alexthe666.iceandfire.entity.IAnimalFear;
import com.github.alexthe666.iceandfire.entity.IVillagerFear;
import com.github.alexthe666.iceandfire.entity.ai.EntityAIWatchClosestIgnoreRider;
import com.github.alexthe666.iceandfire.entity.ai.FlyingAITarget;
import com.github.alexthe666.iceandfire.entity.ai.PathNavigateAmphibious;
import com.github.alexthe666.iceandfire.entity.ai.SeaSerpentAIAttackMelee;
import com.github.alexthe666.iceandfire.entity.ai.SeaSerpentAIGetInWater;
import com.github.alexthe666.iceandfire.enums.EnumSeaSerpent;
import com.google.common.base.Predicate;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.ilexiconn.llibrary.server.entity.multipart.IMultipartEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySeaSerpent
extends EntityAnimal
implements IAnimatedEntity,
IMultipartEntity,
IVillagerFear,
IAnimalFear {
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntitySeaSerpent.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> SCALE = EntityDataManager.func_187226_a(EntitySeaSerpent.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> JUMPING = EntityDataManager.func_187226_a(EntitySeaSerpent.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> BREATHING = EntityDataManager.func_187226_a(EntitySeaSerpent.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ANCIENT = EntityDataManager.func_187226_a(EntitySeaSerpent.class, (DataSerializer)DataSerializers.field_187198_h);
    public int swimCycle;
    private int animationTick;
    private Animation currentAnimation;
    private EntityMutlipartPart[] segments = new EntityMutlipartPart[9];
    private float lastScale;
    private boolean isLandNavigator;
    private SwimBehavior swimBehavior = SwimBehavior.WANDER;
    private boolean changedSwimBehavior = false;
    private int ticksCircling;
    public float orbitRadius = 0.0f;
    @SideOnly(value=Side.CLIENT)
    public IFChainBuffer roll_buffer;
    @SideOnly(value=Side.CLIENT)
    public IFChainBuffer tail_buffer;
    @SideOnly(value=Side.CLIENT)
    public IFChainBuffer head_buffer;
    @SideOnly(value=Side.CLIENT)
    public IFChainBuffer pitch_buffer;
    @Nullable
    public BlockPos orbitPos = null;
    public static final Animation ANIMATION_BITE = Animation.create((int)15);
    public static final Animation ANIMATION_SPEAK = Animation.create((int)15);
    public static final Animation ANIMATION_ROAR = Animation.create((int)40);
    private boolean isArcing = false;
    private float arcingYAdditive = 0.0f;
    public float jumpProgress = 0.0f;
    public float wantJumpProgress = 0.0f;
    public float jumpRot = 0.0f;
    public float breathProgress = 0.0f;
    private int ticksSinceJump = 0;
    private int ticksSinceRoar = 0;
    private int ticksJumping = 0;
    public static final int TIME_BETWEEN_JUMPS = 170;
    public static final int TIME_BETWEEN_ROARS = 300;
    private static final Predicate NOT_SEA_SERPENT = new Predicate<Entity>(){

        public boolean apply(@Nullable Entity entity) {
            return entity instanceof EntityLivingBase && !(entity instanceof EntitySeaSerpent) && DragonUtils.isAlive((EntityLivingBase)entity);
        }
    };
    public boolean attackDecision = false;
    private boolean isBreathing;
    public static final ResourceLocation LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "sea_serpent"));

    public EntitySeaSerpent(World worldIn) {
        super(worldIn);
        this.switchNavigator(true);
        this.func_70105_a(0.5f, 0.5f);
        this.field_70158_ak = true;
        this.resetParts(1.0f);
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.roll_buffer = new IFChainBuffer();
            this.pitch_buffer = new IFChainBuffer();
            this.tail_buffer = new IFChainBuffer();
            this.head_buffer = new IFChainBuffer();
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AISwimBite());
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AISwimWander());
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AISwimCircle());
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new SeaSerpentAIAttackMelee(this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new SeaSerpentAIGetInWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosestIgnoreRider((EntityLiving)this, EntityLivingBase.class, 6.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new FlyingAITarget((EntityCreature)this, EntityLivingBase.class, 0, true, false, NOT_SEA_SERPENT));
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.field_70765_h = new EntityMoveHelper((EntityLiving)this);
            this.field_70699_by = new PathNavigateAmphibious((EntityLiving)this, this.field_70170_p);
            this.isLandNavigator = true;
        } else {
            this.field_70765_h = new SwimmingMoveHelper();
            this.field_70699_by = new PathNavigateSwimmer((EntityLiving)this, this.field_70170_p);
            this.isLandNavigator = false;
        }
    }

    public boolean isDirectPathBetweenPoints(BlockPos pos) {
        RayTraceResult movingobjectposition = this.field_70170_p.func_147447_a(this.func_174791_d().func_72441_c(0.0, (double)this.field_70131_O * 0.5, 0.0), new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5), false, true, false);
        return movingobjectposition == null || movingobjectposition.field_72313_a != RayTraceResult.Type.BLOCK;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.15);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a((double)Math.min(2048, IceAndFire.CONFIG.dragonTargetSearchLength));
    }

    public void resetParts(float scale) {
        this.clearParts();
        this.segments = new EntityMutlipartPart[9];
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = i > 3 ? new EntityMutlipartPart((EntityLiving)this, (2.0f - (float)(i + 1) * 0.55f) * scale, 0.0f, 0.0f, 0.5f * scale, 0.5f * scale, 1.0f) : new EntityMutlipartPart((EntityLiving)this, (1.8f - (float)i * 0.5f) * scale, 0.0f, 0.0f, 0.45f * scale, 0.4f * scale, 1.0f);
        }
    }

    public void onUpdateParts() {
        for (EntityMutlipartPart entity : this.segments) {
            if (entity == null) continue;
            entity.func_70071_h_();
        }
    }

    private void clearParts() {
        for (EntityMutlipartPart entity : this.segments) {
            if (entity == null) continue;
            this.field_70170_p.func_72973_f((Entity)entity);
        }
    }

    public void func_70106_y() {
        this.clearParts();
        super.func_70106_y();
    }

    public void func_98054_a(boolean par1) {
        this.func_98055_j(this.getSeaSerpentScale());
        if (this.getSeaSerpentScale() != this.lastScale) {
            this.resetParts(this.getSeaSerpentScale());
        }
        this.lastScale = this.getSeaSerpentScale();
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.getAnimation() != ANIMATION_BITE) {
            this.setAnimation(ANIMATION_BITE);
            return true;
        }
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_98054_a(true);
        this.onUpdateParts();
        if (this.func_70090_H()) {
            this.spawnParticlesAroundEntity(EnumParticleTypes.WATER_BUBBLE, (Entity)this, (int)this.getSeaSerpentScale());
            for (EntityMutlipartPart entity : this.segments) {
                this.spawnParticlesAroundEntity(EnumParticleTypes.WATER_BUBBLE, (Entity)entity, (int)this.getSeaSerpentScale());
            }
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    private void spawnParticlesAroundEntity(EnumParticleTypes type, Entity entity, int count) {
        for (int i = 0; i < count; ++i) {
            double z;
            double y;
            double x = entity.field_70165_t + (double)(this.field_70146_Z.nextFloat() * entity.field_70130_N * 2.0f) - (double)entity.field_70130_N;
            if (this.field_70170_p.func_180495_p(new BlockPos(x, y = entity.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * entity.field_70131_O), z = entity.field_70161_v + (double)(this.field_70146_Z.nextFloat() * entity.field_70130_N * 2.0f) - (double)entity.field_70130_N)).func_185904_a() != Material.field_151586_h) continue;
            this.field_70170_p.func_175688_a(type, x, y, z, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    private void spawnSlamParticles(EnumParticleTypes type) {
        int i = 0;
        while ((float)i < this.getSeaSerpentScale() * 3.0f) {
            for (int i1 = 0; i1 < 20; ++i1) {
                double motionX = this.func_70681_au().nextGaussian() * 0.07;
                double motionY = this.func_70681_au().nextGaussian() * 0.07;
                double motionZ = this.func_70681_au().nextGaussian() * 0.07;
                float radius = 1.25f * this.getSeaSerpentScale();
                float angle = (float)Math.PI / 180 * this.field_70761_aq + (float)i1 * 1.0f;
                double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.8f;
                double extraZ = radius * MathHelper.func_76134_b((float)angle);
                if (!this.field_70170_p.field_72995_K) continue;
                this.field_70170_p.func_175682_a(type, true, this.field_70165_t + extraX, this.field_70163_u + extraY, this.field_70161_v + extraZ, motionX, motionY, motionZ, new int[]{0});
            }
            ++i;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(SCALE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(JUMPING, (Object)false);
        this.field_70180_af.func_187214_a(BREATHING, (Object)false);
        this.field_70180_af.func_187214_a(ANCIENT, (Object)false);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74768_a("TicksSinceRoar", this.ticksSinceRoar);
        compound.func_74776_a("Scale", this.getSeaSerpentScale());
        compound.func_74757_a("JumpingOutOfWater", this.isJumpingOutOfWater());
        compound.func_74757_a("AttackDecision", this.attackDecision);
        compound.func_74757_a("Breathing", this.isBreathing());
        compound.func_74757_a("Ancient", this.isAncient());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
        this.ticksSinceRoar = compound.func_74762_e("TicksSinceRoar");
        this.setSeaSerpentScale(compound.func_74760_g("Scale"));
        this.setJumpingOutOfWater(compound.func_74767_n("JumpingOutOfWater"));
        this.attackDecision = compound.func_74767_n("AttackDecision");
        this.setBreathing(compound.func_74767_n("Breathing"));
        this.setAncient(compound.func_74767_n("Ancient"));
    }

    private void setSeaSerpentScale(float scale) {
        this.field_70180_af.func_187227_b(SCALE, (Object)Float.valueOf(scale));
        this.updateAttributes();
    }

    private void updateAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(Math.min(0.25, 0.15 * (double)this.getSeaSerpentScale() * (double)this.getAncientModifier()));
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(Math.max(4.0, IceAndFire.CONFIG.seaSerpentAttackStrength * (double)this.getSeaSerpentScale() * (double)this.getAncientModifier()));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Math.max(10.0, IceAndFire.CONFIG.seaSerpentBaseHealth * (double)this.getSeaSerpentScale() * (double)this.getAncientModifier()));
        this.func_70691_i(30.0f * this.getSeaSerpentScale());
    }

    private float getAncientModifier() {
        return this.isAncient() ? 1.5f : 1.0f;
    }

    public float getSeaSerpentScale() {
        return Float.valueOf(((Float)this.field_70180_af.func_187225_a(SCALE)).floatValue()).floatValue();
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public boolean isJumpingOutOfWater() {
        return (Boolean)this.field_70180_af.func_187225_a(JUMPING);
    }

    public boolean isAncient() {
        return (Boolean)this.field_70180_af.func_187225_a(ANCIENT);
    }

    public boolean isBreathing() {
        if (this.field_70170_p.field_72995_K) {
            boolean breathing;
            this.isBreathing = breathing = ((Boolean)this.field_70180_af.func_187225_a(BREATHING)).booleanValue();
            return breathing;
        }
        return this.isBreathing;
    }

    public void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public void setJumpingOutOfWater(boolean jump) {
        this.field_70180_af.func_187227_b(JUMPING, (Object)jump);
    }

    public void setAncient(boolean ancient) {
        this.field_70180_af.func_187227_b(ANCIENT, (Object)ancient);
    }

    public void setBreathing(boolean breathing) {
        this.field_70180_af.func_187227_b(BREATHING, (Object)breathing);
        if (!this.field_70170_p.field_72995_K) {
            this.isBreathing = breathing;
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K && this.isJumpingOutOfWater() && this.swimBehavior == SwimBehavior.WANDER && this.shouldStopJumping()) {
            this.field_70181_x -= 0.25;
            if (this.func_70090_H()) {
                this.setJumpingOutOfWater(false);
                this.ticksSinceJump = 0;
            }
        }
        super.func_70636_d();
        boolean breathing = this.isBreathing() && this.getAnimation() != ANIMATION_BITE && this.getAnimation() != ANIMATION_ROAR;
        boolean jumping = !this.func_70090_H() && !this.field_70122_E && this.field_70181_x >= 0.0;
        boolean wantJumping = false;
        boolean ground = !this.func_70090_H() && this.field_70122_E;
        boolean prevJumping = this.isJumpingOutOfWater();
        ++this.ticksSinceRoar;
        ++this.ticksSinceJump;
        if (this.ticksSinceRoar > 300 && this.isAtSurface() && this.getAnimation() != ANIMATION_BITE && this.jumpProgress == 0.0f && !this.isJumpingOutOfWater()) {
            this.setAnimation(ANIMATION_ROAR);
            this.ticksSinceRoar = 0;
        }
        if (this.getAnimation() == ANIMATION_ROAR && this.getAnimationTick() == 1) {
            this.func_184185_a(ModSounds.SEA_SERPENT_ROAR, this.func_70599_aP() + 1.0f, 1.0f);
        }
        if (this.getAnimation() == ANIMATION_BITE && this.getAnimationTick() == 5) {
            this.func_184185_a(ModSounds.SEA_SERPENT_BITE, this.func_70599_aP(), 1.0f);
        }
        this.ticksJumping = this.isJumpingOutOfWater() ? ++this.ticksJumping : 0;
        if (this.isJumpingOutOfWater() && EntitySeaSerpent.isWaterBlock(this.field_70170_p, new BlockPos((Entity)this).func_177981_b(2))) {
            this.setJumpingOutOfWater(false);
        }
        if (!(this.isJumpingOutOfWater() || EntitySeaSerpent.isWaterBlock(this.field_70170_p, new BlockPos((Entity)this).func_177984_a()) || this.ticksSinceJump <= 170 && this.func_70638_az() == null)) {
            this.ticksSinceJump = 0;
            this.setJumpingOutOfWater(true);
        }
        this.swimCycle = this.swimCycle < 38 ? (this.swimCycle += 2) : 0;
        if (breathing && this.breathProgress < 20.0f) {
            this.breathProgress += 0.5f;
        } else if (!breathing && this.breathProgress > 0.0f) {
            this.breathProgress -= 0.5f;
        }
        if (jumping && this.jumpProgress < 10.0f) {
            this.jumpProgress += 0.5f;
        } else if (!jumping && this.jumpProgress > 0.0f) {
            this.jumpProgress -= 0.5f;
        }
        if (wantJumping && this.wantJumpProgress < 10.0f) {
            this.wantJumpProgress += 2.0f;
        } else if (!wantJumping && this.wantJumpProgress > 0.0f) {
            this.wantJumpProgress -= 2.0f;
        }
        if (this.isJumpingOutOfWater() && this.jumpRot < 1.0f) {
            this.jumpRot += 0.1f;
        } else if (!this.isJumpingOutOfWater() && this.jumpRot > 0.0f) {
            this.jumpRot -= 0.1f;
        }
        if (prevJumping != this.isJumpingOutOfWater() && !this.isJumpingOutOfWater()) {
            this.func_184185_a(ModSounds.SEA_SERPENT_SPLASH, 5.0f, 0.75f);
            this.spawnSlamParticles(EnumParticleTypes.FIREWORKS_SPARK);
            this.spawnSlamParticles(EnumParticleTypes.WATER_BUBBLE);
            this.spawnSlamParticles(EnumParticleTypes.WATER_BUBBLE);
            this.spawnSlamParticles(EnumParticleTypes.WATER_BUBBLE);
            this.doSplashDamage();
        }
        if (!ground && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (ground && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
        this.field_70761_aq = this.field_70177_z;
        this.field_70125_A = (float)this.field_70181_x * 20.0f;
        if (this.field_70170_p.field_72995_K) {
            this.pitch_buffer.calculateChainWaveBuffer(90.0f, 10, 10.0f, 0.5f, (EntityLivingBase)this);
            if (!jumping) {
                this.tail_buffer.calculateChainSwingBuffer(70.0f, 20, 5.0f, (EntityLivingBase)this);
                this.head_buffer.calculateChainSwingBuffer(70.0f, 20, 5.0f, (EntityLivingBase)this);
            }
        }
        if (this.changedSwimBehavior) {
            this.changedSwimBehavior = false;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.attackDecision) {
                this.setBreathing(false);
            }
            if (this.func_70638_az() != null && this.getAnimation() != ANIMATION_ROAR) {
                if (!this.attackDecision) {
                    if (!this.func_70638_az().func_70090_H() || !this.isDirectPathBetweenPoints(this.func_70638_az().func_180425_c()) || this.func_70068_e((Entity)this.func_70638_az()) < (double)(60.0f * this.getSeaSerpentScale())) {
                        this.attackDecision = true;
                    }
                    if (!this.attackDecision) {
                        this.shoot(this.func_70638_az());
                    }
                } else if (this.func_70068_e((Entity)this.func_70638_az()) > (double)(500.0f * this.getSeaSerpentScale())) {
                    this.attackDecision = false;
                }
            } else {
                this.setBreathing(false);
            }
            this.ticksCircling = this.swimBehavior == SwimBehavior.CIRCLE ? ++this.ticksCircling : 0;
            if (this.func_70638_az() != null) {
                this.swimBehavior = this.func_70090_H() ? (this.attackDecision ? (this.isPreyAtSurface() && this.func_70068_e((Entity)this.func_70638_az()) < (double)(200.0f * this.getSeaSerpentScale()) ? SwimBehavior.JUMP : SwimBehavior.ATTACK) : SwimBehavior.ATTACK) : (this.field_70122_E ? SwimBehavior.ATTACK : SwimBehavior.WANDER);
            } else if (this.swimBehavior == SwimBehavior.JUMP && this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) > (double)(200.0f * this.getSeaSerpentScale())) {
                this.swimBehavior = SwimBehavior.WANDER;
                this.ticksSinceJump = 0;
                this.setJumpingOutOfWater(false);
            }
            if (this.swimBehavior != SwimBehavior.JUMP && this.swimBehavior != SwimBehavior.ATTACK && this.ticksSinceJump > 170) {
                this.swimBehavior = SwimBehavior.JUMP;
            }
            if (this.swimBehavior != SwimBehavior.ATTACK) {
                this.arcingYAdditive = 0.0f;
            }
            if (this.swimBehavior == SwimBehavior.JUMP && this.field_70181_x < 0.0 && !this.func_70090_H()) {
                this.swimBehavior = SwimBehavior.WANDER;
                this.ticksSinceJump = 0;
                this.setJumpingOutOfWater(false);
            }
            if (this.swimBehavior == SwimBehavior.ATTACK && this.func_70638_az() != null && !this.func_70638_az().func_70090_H()) {
                this.swimBehavior = SwimBehavior.WANDER;
                this.func_70625_a((Entity)this.func_70638_az(), 360.0f, 360.0f);
            }
            if (!(this.swimBehavior != SwimBehavior.ATTACK || this.func_70638_az() != null && this.isDirectPathBetweenPoints(new BlockPos((Entity)this.func_70638_az())))) {
                this.swimBehavior = SwimBehavior.WANDER;
            }
        }
        if (this.getAnimation() == ANIMATION_BITE && this.func_70638_az() != null && (this.isTouchingMob((Entity)this.func_70638_az()) || this.func_70068_e((Entity)this.func_70638_az()) < 50.0)) {
            this.hurtMob(this.func_70638_az());
        }
        this.breakBlock();
    }

    private void doSplashDamage() {
        double width = 2.0 * (double)this.getSeaSerpentScale();
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b(width, width * 0.5, width), NOT_SEA_SERPENT);
        for (Entity entity : list) {
            if (!(entity instanceof EntityLivingBase)) continue;
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
            this.destroyBoat(entity);
            double xRatio = this.field_70165_t - entity.field_70165_t;
            double zRatio = this.field_70161_v - entity.field_70161_v;
            float f = MathHelper.func_76133_a((double)(xRatio * xRatio + zRatio * zRatio));
            float strength = 0.3f * this.getSeaSerpentScale();
            entity.field_70159_w /= 2.0;
            entity.field_70179_y /= 2.0;
            entity.field_70159_w -= xRatio / (double)f * (double)strength;
            entity.field_70179_y -= zRatio / (double)f * (double)strength;
            entity.field_70181_x += (double)strength;
            if (!(this.field_70181_x > (double)0.4f)) continue;
            this.field_70181_x = 0.4f;
        }
    }

    public void destroyBoat(Entity sailor) {
        if (sailor.func_184187_bx() != null && sailor.func_184187_bx() instanceof EntityBoat && !this.field_70170_p.field_72995_K) {
            EntityBoat boat = (EntityBoat)sailor.func_184187_bx();
            boat.func_70106_y();
            if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                for (int i = 0; i < 3; ++i) {
                    boat.func_70099_a(new ItemStack(Item.func_150898_a((Block)Blocks.field_150344_f), 1, boat.func_184453_r().func_184982_b()), 0.0f);
                }
                for (int j = 0; j < 2; ++j) {
                    boat.func_145778_a(Items.field_151055_y, 1, 0.0f);
                }
            }
        }
    }

    private boolean isPreyAtSurface() {
        if (this.func_70638_az() != null) {
            BlockPos pos = new BlockPos((Entity)this.func_70638_az());
            return !EntitySeaSerpent.isWaterBlock(this.field_70170_p, pos.func_177981_b((int)Math.ceil(this.func_70638_az().field_70131_O)));
        }
        return false;
    }

    private void hurtMob(EntityLivingBase entity) {
        if (this.getAnimation() == ANIMATION_BITE && entity != null && this.getAnimationTick() > 6) {
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
            this.attackDecision = this.func_70681_au().nextBoolean();
        }
    }

    public void moveJumping() {
        float velocity = 0.5f;
        double x = -MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(this.field_70125_A * ((float)Math.PI / 180)));
        double z = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(this.field_70125_A * ((float)Math.PI / 180)));
        float f = MathHelper.func_76133_a((double)(x * x + z * z));
        x /= (double)f;
        z /= (double)f;
        this.field_70159_w = x *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
    }

    private boolean isTouchingMob(Entity entity) {
        if (this.func_174813_aQ().func_72321_a((double)(this.getSeaSerpentScale() * 3.0f), (double)(this.getSeaSerpentScale() * 3.0f), (double)(this.getSeaSerpentScale() * 3.0f)).func_72326_a(entity.func_174813_aQ())) {
            return true;
        }
        for (EntityMutlipartPart segment : this.segments) {
            if (!segment.func_174813_aQ().func_72321_a((double)(this.getSeaSerpentScale() * 2.0f), (double)(this.getSeaSerpentScale() * 2.0f), (double)(this.getSeaSerpentScale() * 2.0f)).func_72326_a(entity.func_174813_aQ())) continue;
            return true;
        }
        return false;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_70090_H() {
        return super.func_70090_H() || this.func_70055_a(Material.field_151586_h) || this.func_70055_a(Material.field_151589_v);
    }

    public void breakBlock() {
        if (IceAndFire.CONFIG.seaSerpentGriefing) {
            for (int a = (int)Math.round(this.func_174813_aQ().field_72340_a) - 2; a <= (int)Math.round(this.func_174813_aQ().field_72336_d) + 2; ++a) {
                for (int b = (int)Math.round(this.func_174813_aQ().field_72338_b); b <= (int)Math.round(this.func_174813_aQ().field_72337_e) + 2 && b <= 127; ++b) {
                    for (int c = (int)Math.round(this.func_174813_aQ().field_72339_c) - 2; c <= (int)Math.round(this.func_174813_aQ().field_72334_f) + 2; ++c) {
                        BlockPos pos = new BlockPos(a, b, c);
                        IBlockState state = this.field_70170_p.func_180495_p(pos);
                        Block block = state.func_177230_c();
                        if (state.func_185904_a() == Material.field_151579_a || block instanceof BlockLiquid || state.func_185904_a() != Material.field_151585_k || block == Blocks.field_150350_a || this.field_70170_p.field_72995_K) continue;
                        this.field_70170_p.func_175655_b(pos, true);
                    }
                }
            }
        }
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        boolean ancient;
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.setVariant(this.func_70681_au().nextInt(7));
        boolean bl = ancient = this.func_70681_au().nextInt(16) == 1;
        if (ancient) {
            this.setAncient(true);
            this.setSeaSerpentScale(6.0f + this.func_70681_au().nextFloat() * 3.0f);
        } else {
            this.setSeaSerpentScale(1.5f + this.func_70681_au().nextFloat() * 4.0f);
        }
        return livingdata;
    }

    public void onWorldSpawn(Random random) {
        boolean ancient;
        this.setVariant(random.nextInt(6));
        boolean bl = ancient = random.nextInt(15) == 1;
        if (ancient) {
            this.setAncient(true);
            this.setSeaSerpentScale(6.0f + random.nextFloat() * 3.0f);
        } else {
            this.setSeaSerpentScale(1.5f + random.nextFloat() * 4.0f);
        }
    }

    @Nullable
    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_BITE, ANIMATION_ROAR, ANIMATION_SPEAK};
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return ModSounds.SEA_SERPENT_IDLE;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return ModSounds.SEA_SERPENT_HURT;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return ModSounds.SEA_SERPENT_DIE;
    }

    public void func_70642_aH() {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.func_70642_aH();
    }

    protected void func_184581_c(DamageSource source) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.func_184581_c(source);
    }

    @Override
    public boolean shouldAnimalsFear(Entity entity) {
        return true;
    }

    public boolean isBlinking() {
        return this.field_70173_aa % 50 > 43;
    }

    private boolean canMove() {
        return true;
    }

    public boolean wantsToJump() {
        return this.ticksSinceJump > 170 && this.swimBehavior == SwimBehavior.JUMP;
    }

    private boolean shouldStopJumping() {
        return this.ticksJumping > 30 || !EntitySeaSerpent.isWaterBlock(this.field_70170_p, this.field_70170_p.func_175645_m(new BlockPos((Entity)this)).func_177979_c(1));
    }

    public static BlockPos getPositionRelativeToSeafloor(EntitySeaSerpent entity, World world, double x, double z, Random rand) {
        BlockPos topY = new BlockPos(x, entity.field_70163_u, z);
        BlockPos bottomY = new BlockPos(x, entity.field_70163_u, z);
        while (EntitySeaSerpent.isWaterBlock(world, topY) && topY.func_177956_o() < world.func_72800_K()) {
            topY = topY.func_177984_a();
        }
        while (EntitySeaSerpent.isWaterBlock(world, bottomY) && bottomY.func_177956_o() > 0) {
            bottomY = bottomY.func_177977_b();
        }
        if (entity.ticksSinceJump > 170) {
            return topY.func_177981_b((int)Math.ceil(3.0f * entity.getSeaSerpentScale()));
        }
        if (entity.ticksSinceRoar > 300 || entity.getAnimation() == ANIMATION_ROAR) {
            return topY.func_177977_b();
        }
        for (int tries = 0; tries < 5; ++tries) {
            BlockPos pos = new BlockPos(x, (double)(bottomY.func_177956_o() + 1 + rand.nextInt(Math.max(1, topY.func_177956_o() - bottomY.func_177956_o() - 2))), z);
            if (!EntitySeaSerpent.isWaterBlock(world, pos)) continue;
            return pos;
        }
        return entity.func_180425_c();
    }

    public static BlockPos getPositionInOrbit(EntitySeaSerpent entity, World world, BlockPos orbit, Random rand) {
        float possibleOrbitRadius = entity.orbitRadius + 10.0f;
        float radius = 5.0f * entity.getSeaSerpentScale();
        float angle = (float)Math.PI / 180 * possibleOrbitRadius;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        BlockPos radialPos = new BlockPos((double)orbit.func_177958_n() + extraX, (double)orbit.func_177956_o(), (double)orbit.func_177952_p() + extraZ);
        entity.orbitRadius = possibleOrbitRadius;
        return radialPos;
    }

    public static BlockPos getPositionPreyArc(EntitySeaSerpent entity, BlockPos target, World world) {
        float radius = 10.0f * entity.getSeaSerpentScale();
        entity.field_70761_aq = entity.field_70177_z;
        float angle = (float)Math.PI / 180 * entity.field_70761_aq;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        double signum = Math.signum((double)((float)target.func_177956_o() + 0.5f) - entity.field_70163_u);
        BlockPos pos = new BlockPos((double)target.func_177958_n() + extraX, (double)target.func_177956_o() + (double)entity.field_70146_Z.nextInt(5) * signum, (double)target.func_177952_p() + extraZ);
        entity.isArcing = true;
        return EntitySeaSerpent.clampBlockPosToWater((Entity)entity, world, pos);
    }

    private static BlockPos clampBlockPosToWater(Entity entity, World world, BlockPos pos) {
        BlockPos topY = new BlockPos((double)pos.func_177958_n(), entity.field_70163_u, (double)pos.func_177952_p());
        BlockPos bottomY = new BlockPos((double)pos.func_177958_n(), entity.field_70163_u, (double)pos.func_177952_p());
        while (EntitySeaSerpent.isWaterBlock(world, topY) && topY.func_177956_o() < world.func_72800_K()) {
            topY = topY.func_177984_a();
        }
        while (EntitySeaSerpent.isWaterBlock(world, bottomY) && bottomY.func_177956_o() > 0) {
            bottomY = bottomY.func_177977_b();
        }
        return new BlockPos(pos.func_177958_n(), MathHelper.func_76125_a((int)pos.func_177956_o(), (int)(bottomY.func_177956_o() + 1), (int)(topY.func_177956_o() - 1)), pos.func_177952_p());
    }

    public static boolean isWaterBlock(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_185904_a() == Material.field_151586_h;
    }

    public boolean isAtSurface() {
        BlockPos pos = new BlockPos((Entity)this);
        return EntitySeaSerpent.isWaterBlock(this.field_70170_p, pos.func_177977_b()) && !EntitySeaSerpent.isWaterBlock(this.field_70170_p, pos.func_177984_a());
    }

    private void shoot(EntityLivingBase entity) {
        if (!this.attackDecision) {
            if (!this.func_70090_H()) {
                this.setBreathing(false);
                this.attackDecision = true;
            }
            if (this.isBreathing()) {
                if (this.field_70173_aa % 40 == 0) {
                    this.func_184185_a(ModSounds.SEA_SERPENT_BREATH, 4.0f, 1.0f);
                }
                if (this.field_70173_aa % 3 == 0) {
                    this.field_70177_z = this.field_70761_aq;
                    float f1 = 0.0f;
                    float f2 = 0.0f;
                    float f3 = 0.0f;
                    float headPosX = f1 + (float)(this.segments[0].field_70165_t + (double)(0.3f * this.getSeaSerpentScale()) * Math.cos((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
                    float headPosZ = f2 + (float)(this.segments[0].field_70161_v + (double)(0.3f * this.getSeaSerpentScale()) * Math.sin((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
                    float headPosY = f3 + (float)(this.segments[0].field_70163_u + (double)(0.2f * this.getSeaSerpentScale()));
                    double d2 = entity.field_70165_t - (double)headPosX;
                    double d3 = entity.field_70163_u - (double)headPosY;
                    double d4 = entity.field_70161_v - (double)headPosZ;
                    EntitySeaSerpentBubbles entitylargefireball = new EntitySeaSerpentBubbles(this.field_70170_p, this, d2, d3, d4);
                    float size = 0.8f;
                    entitylargefireball.func_70107_b(headPosX, headPosY, headPosZ);
                    if (!this.field_70170_p.field_72995_K && !entity.field_70128_L) {
                        this.field_70170_p.func_72838_d((Entity)entitylargefireball);
                    }
                    entitylargefireball.setSizes(size, size);
                    if (entity.field_70128_L || entity == null) {
                        this.setBreathing(false);
                        this.attackDecision = this.func_70681_au().nextBoolean();
                    }
                }
            } else {
                this.setBreathing(true);
            }
        }
        this.func_70625_a((Entity)entity, 360.0f, 360.0f);
    }

    public EnumSeaSerpent getEnum() {
        switch (this.getVariant()) {
            default: {
                return EnumSeaSerpent.BLUE;
            }
            case 1: {
                return EnumSeaSerpent.BRONZE;
            }
            case 2: {
                return EnumSeaSerpent.DEEPBLUE;
            }
            case 3: {
                return EnumSeaSerpent.GREEN;
            }
            case 4: {
                return EnumSeaSerpent.PURPLE;
            }
            case 5: {
                return EnumSeaSerpent.RED;
            }
            case 6: 
        }
        return EnumSeaSerpent.TEAL;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.swimBehavior != SwimBehavior.JUMP || !this.isJumpingOutOfWater() || this.func_70638_az() == null) {
            // empty if block
        }
        if (this.func_70613_aW()) {
            if (this.func_70090_H()) {
                this.func_191958_b(strafe, vertical, forward, 0.1f);
                float f4 = 0.6f;
                float d0 = EnchantmentHelper.func_185294_d((EntityLivingBase)this);
                if (d0 > 3.0f) {
                    d0 = 3.0f;
                }
                if (!this.field_70122_E) {
                    d0 *= 0.5f;
                }
                if (d0 > 0.0f) {
                    f4 += (0.54600006f - f4) * d0 / 3.0f;
                }
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)f4;
                this.field_70159_w *= 0.900000011920929;
                this.field_70181_x *= 0.900000011920929;
                this.field_70181_x *= (double)f4;
                this.field_70179_y *= 0.900000011920929;
                this.field_70179_y *= (double)f4;
            } else {
                super.func_191986_a(strafe, vertical, forward);
            }
        }
        this.field_184618_aE = this.field_70721_aZ;
        double deltaX = this.field_70165_t - this.field_70169_q;
        double deltaY = this.field_70163_u - this.field_70167_r;
        double deltaZ = this.field_70161_v - this.field_70166_s;
        float delta = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ)) * 4.0f;
        if (delta > 1.0f) {
            delta = 1.0f;
        }
        this.field_70721_aZ += (delta - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    public void func_70074_a(EntityLivingBase entity) {
        super.func_70074_a(entity);
        this.attackDecision = this.func_70681_au().nextBoolean();
    }

    class AISwimBite
    extends EntityAIBase {
        BlockPos target;
        boolean secondPhase = false;
        boolean isOver = false;
        public int max_distance = 1000;

        public AISwimBite() {
            this.func_75248_a(1);
        }

        public void func_75251_c() {
            this.target = null;
            this.secondPhase = false;
            this.isOver = false;
            EntitySeaSerpent.this.isArcing = false;
            EntitySeaSerpent.this.arcingYAdditive = 0.0f;
        }

        public boolean func_75250_a() {
            if (!EntitySeaSerpent.this.attackDecision && EntitySeaSerpent.this.func_70638_az() != null && EntitySeaSerpent.this.func_70068_e((Entity)EntitySeaSerpent.this.func_70638_az()) < 300.0) {
                return false;
            }
            if (EntitySeaSerpent.this.swimBehavior != SwimBehavior.ATTACK && EntitySeaSerpent.this.swimBehavior != SwimBehavior.JUMP || !EntitySeaSerpent.this.canMove() || EntitySeaSerpent.this.func_70638_az() == null) {
                return false;
            }
            if (EntitySeaSerpent.this.func_70090_H() && EntitySeaSerpent.this.func_70638_az() != null) {
                this.target = new BlockPos((Entity)EntitySeaSerpent.this.func_70638_az());
                EntitySeaSerpent.this.orbitPos = null;
                this.secondPhase = false;
                EntitySeaSerpent.this.isArcing = false;
                return true;
            }
            return false;
        }

        protected boolean isDirectPathBetweenPoints(BlockPos posVec31, BlockPos posVec32) {
            return true;
        }

        public boolean func_75253_b() {
            if (this.isOver) {
                return false;
            }
            if (!EntitySeaSerpent.this.attackDecision && EntitySeaSerpent.this.func_70638_az() != null && EntitySeaSerpent.this.func_70068_e((Entity)EntitySeaSerpent.this.func_70638_az()) < 300.0) {
                ((EntitySeaSerpent)EntitySeaSerpent.this).field_70765_h.field_188491_h = EntityMoveHelper.Action.WAIT;
                this.func_75251_c();
                return false;
            }
            if (this.secondPhase) {
                if (EntitySeaSerpent.this.func_70638_az() == null || EntitySeaSerpent.this.func_174818_b(this.target) > (double)this.max_distance || this.isOver) {
                    EntitySeaSerpent.this.swimBehavior = SwimBehavior.WANDER;
                    this.func_75251_c();
                    return false;
                }
                return true;
            }
            return EntitySeaSerpent.this.func_70638_az() != null;
        }

        public void func_75246_d() {
            if (EntitySeaSerpent.this.swimBehavior == SwimBehavior.JUMP) {
                if (EntitySeaSerpent.this.func_70638_az() != null && EntitySeaSerpent.this.func_70090_H()) {
                    this.target = new BlockPos((Entity)EntitySeaSerpent.this.func_70638_az()).func_177981_b((int)Math.ceil(3.0f * EntitySeaSerpent.this.getSeaSerpentScale()));
                }
            } else {
                if (EntitySeaSerpent.this.func_70638_az() == null || EntitySeaSerpent.this.func_70638_az().field_70128_L) {
                    this.secondPhase = true;
                } else {
                    double d0 = EntitySeaSerpent.this.func_70638_az().field_70165_t - EntitySeaSerpent.this.field_70165_t;
                    double d1 = EntitySeaSerpent.this.func_70638_az().field_70161_v - EntitySeaSerpent.this.field_70161_v;
                    double d2 = d0 * d0 + d1 * d1;
                    d2 = MathHelper.func_76133_a((double)d2);
                    EntitySeaSerpent.this.arcingYAdditive = (float)(this.secondPhase ? 1 : -1) * (float)d2;
                }
                if (!this.secondPhase) {
                    this.target = new BlockPos((Entity)EntitySeaSerpent.this.func_70638_az());
                    if (!EntitySeaSerpent.this.attackDecision) {
                        if (EntitySeaSerpent.this.func_70638_az() != null) {
                            if (EntitySeaSerpent.this.func_174818_b(this.target) > (double)(10.0f * EntitySeaSerpent.this.getSeaSerpentScale())) {
                                EntitySeaSerpent.this.setBreathing(true);
                            } else {
                                EntitySeaSerpent.this.attackDecision = true;
                            }
                        }
                    } else {
                        if (EntitySeaSerpent.this.func_70638_az() != null && (EntitySeaSerpent.this.func_174818_b(this.target) < (double)(30.0f * EntitySeaSerpent.this.getSeaSerpentScale()) || EntitySeaSerpent.this.isTouchingMob((Entity)EntitySeaSerpent.this.func_70638_az()))) {
                            EntitySeaSerpent.this.setAnimation(ANIMATION_BITE);
                        }
                        if (EntitySeaSerpent.this.func_70638_az() == null || EntitySeaSerpent.this.func_174818_b(this.target) < (double)(30.0f * EntitySeaSerpent.this.getSeaSerpentScale())) {
                            this.target = null;
                            this.secondPhase = true;
                        }
                    }
                }
                if (this.secondPhase && EntitySeaSerpent.this.func_70638_az() != null) {
                    if (EntitySeaSerpent.this.func_70068_e((Entity)EntitySeaSerpent.this.func_70638_az()) > (double)this.max_distance || this.target != null && EntitySeaSerpent.this.func_174818_b(this.target) < 5.0) {
                        this.func_75251_c();
                        this.isOver = true;
                    } else {
                        this.target = EntitySeaSerpent.getPositionPreyArc(EntitySeaSerpent.this, new BlockPos((Entity)EntitySeaSerpent.this.func_70638_az()), EntitySeaSerpent.this.field_70170_p);
                    }
                }
            }
            if (this.target != null && (EntitySeaSerpent.isWaterBlock(EntitySeaSerpent.this.field_70170_p, this.target) || EntitySeaSerpent.this.swimBehavior == SwimBehavior.JUMP)) {
                EntitySeaSerpent.this.field_70765_h.func_75642_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, 0.5);
                if (EntitySeaSerpent.this.func_70638_az() == null) {
                    EntitySeaSerpent.this.func_70671_ap().func_75650_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, 180.0f, 20.0f);
                }
            }
        }
    }

    class AISwimCircle
    extends EntityAIBase {
        BlockPos target;

        public AISwimCircle() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            if (EntitySeaSerpent.this.swimBehavior != SwimBehavior.CIRCLE || !EntitySeaSerpent.this.canMove()) {
                return false;
            }
            if (!EntitySeaSerpent.this.func_70605_aq().func_75640_a()) {
                EntitySeaSerpent.this.swimBehavior = SwimBehavior.WANDER;
                return false;
            }
            if (EntitySeaSerpent.this.func_70090_H() && !EntitySeaSerpent.this.isJumpingOutOfWater()) {
                BlockPos gen = this.generateTarget();
                if (gen != null) {
                    EntitySeaSerpent.this.orbitPos = gen;
                    this.target = EntitySeaSerpent.getPositionInOrbit(EntitySeaSerpent.this, EntitySeaSerpent.this.field_70170_p, EntitySeaSerpent.this.orbitPos, EntitySeaSerpent.this.field_70146_Z);
                    return EntitySeaSerpent.this.isDirectPathBetweenPoints(this.target);
                }
                EntitySeaSerpent.this.swimBehavior = SwimBehavior.WANDER;
            }
            return false;
        }

        protected BlockPos generateTarget() {
            for (int i = 0; i < 5; ++i) {
                BlockPos pos = EntitySeaSerpent.getPositionRelativeToSeafloor(EntitySeaSerpent.this, EntitySeaSerpent.this.field_70170_p, EntitySeaSerpent.this.field_70165_t + (double)EntitySeaSerpent.this.field_70146_Z.nextInt(30) - 15.0, EntitySeaSerpent.this.field_70161_v + (double)EntitySeaSerpent.this.field_70146_Z.nextInt(30) - 15.0, EntitySeaSerpent.this.field_70146_Z);
                if (!EntitySeaSerpent.isWaterBlock(EntitySeaSerpent.this.field_70170_p, pos) || !EntitySeaSerpent.this.isDirectPathBetweenPoints(pos)) continue;
                return pos;
            }
            return null;
        }

        public boolean func_75253_b() {
            if (this.target != null && !EntitySeaSerpent.this.isDirectPathBetweenPoints(this.target)) {
                return false;
            }
            return EntitySeaSerpent.this.func_70638_az() == null && EntitySeaSerpent.this.swimBehavior == SwimBehavior.CIRCLE;
        }

        public void func_75246_d() {
            if (EntitySeaSerpent.this.func_70011_f(this.target.func_177958_n(), this.target.func_177956_o(), this.target.func_177952_p()) < 5.0) {
                this.target = EntitySeaSerpent.getPositionInOrbit(EntitySeaSerpent.this, EntitySeaSerpent.this.field_70170_p, EntitySeaSerpent.this.orbitPos, EntitySeaSerpent.this.field_70146_Z);
            }
            if (EntitySeaSerpent.isWaterBlock(EntitySeaSerpent.this.field_70170_p, this.target) && EntitySeaSerpent.this.isDirectPathBetweenPoints(this.target)) {
                EntitySeaSerpent.this.field_70765_h.func_75642_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, 0.25);
                if (EntitySeaSerpent.this.func_70638_az() == null) {
                    EntitySeaSerpent.this.func_70671_ap().func_75650_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, 180.0f, 20.0f);
                }
            }
        }
    }

    public class AISwimWander
    extends EntityAIBase {
        BlockPos target;

        public AISwimWander() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            BlockPos gen;
            if (EntitySeaSerpent.this.swimBehavior != SwimBehavior.WANDER && EntitySeaSerpent.this.swimBehavior != SwimBehavior.JUMP || !EntitySeaSerpent.this.canMove() || EntitySeaSerpent.this.func_70638_az() != null) {
                return false;
            }
            if (EntitySeaSerpent.this.func_70090_H() && (gen = this.generateTarget()) != null) {
                this.target = gen;
                EntitySeaSerpent.this.orbitPos = null;
                return EntitySeaSerpent.this.swimBehavior == SwimBehavior.JUMP || !EntitySeaSerpent.this.func_70605_aq().func_75640_a();
            }
            return false;
        }

        protected BlockPos generateTarget() {
            if (EntitySeaSerpent.this.swimBehavior == SwimBehavior.JUMP) {
                BlockPos pos = EntitySeaSerpent.getPositionRelativeToSeafloor(EntitySeaSerpent.this, EntitySeaSerpent.this.field_70170_p, EntitySeaSerpent.this.field_70165_t, EntitySeaSerpent.this.field_70161_v, EntitySeaSerpent.this.field_70146_Z);
                return pos.func_177981_b(3 * (int)Math.ceil(EntitySeaSerpent.this.getSeaSerpentScale()));
            }
            for (int i = 0; i < 5; ++i) {
                BlockPos pos = EntitySeaSerpent.getPositionRelativeToSeafloor(EntitySeaSerpent.this, EntitySeaSerpent.this.field_70170_p, EntitySeaSerpent.this.field_70165_t + (double)EntitySeaSerpent.this.field_70146_Z.nextInt(30) - 15.0, EntitySeaSerpent.this.field_70161_v + (double)EntitySeaSerpent.this.field_70146_Z.nextInt(30) - 15.0, EntitySeaSerpent.this.field_70146_Z);
                if ((!EntitySeaSerpent.isWaterBlock(EntitySeaSerpent.this.field_70170_p, pos) || !EntitySeaSerpent.this.isDirectPathBetweenPoints(pos)) && EntitySeaSerpent.this.swimBehavior != SwimBehavior.JUMP) continue;
                return pos;
            }
            return null;
        }

        protected boolean isDirectPathBetweenPoints(BlockPos posVec31, BlockPos posVec32) {
            return true;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            if (this.target == null) {
                this.target = this.generateTarget();
            }
            if (this.target != null && (EntitySeaSerpent.isWaterBlock(EntitySeaSerpent.this.field_70170_p, this.target) || EntitySeaSerpent.this.swimBehavior == SwimBehavior.JUMP) && EntitySeaSerpent.this.isDirectPathBetweenPoints(this.target)) {
                EntitySeaSerpent.this.field_70765_h.func_75642_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, 0.25);
                if (EntitySeaSerpent.this.func_70638_az() == null) {
                    EntitySeaSerpent.this.func_70671_ap().func_75650_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, 180.0f, 20.0f);
                }
            }
        }
    }

    public class SwimmingMoveHelper
    extends EntityMoveHelper {
        private EntitySeaSerpent serpent;

        public SwimmingMoveHelper() {
            super((EntityLiving)EntitySeaSerpent.this);
            this.serpent = EntitySeaSerpent.this;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                int dist;
                double d0 = this.field_75646_b - EntitySeaSerpent.this.field_70165_t;
                double d1 = this.field_75647_c - EntitySeaSerpent.this.field_70163_u;
                double d2 = this.field_75644_d - EntitySeaSerpent.this.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if ((d3 = (double)MathHelper.func_76133_a((double)d3)) < 6.0 && EntitySeaSerpent.this.func_70638_az() == null) {
                    if (!EntitySeaSerpent.this.changedSwimBehavior && EntitySeaSerpent.this.swimBehavior == SwimBehavior.WANDER && EntitySeaSerpent.this.field_70146_Z.nextInt(20) == 0) {
                        EntitySeaSerpent.this.swimBehavior = SwimBehavior.CIRCLE;
                        EntitySeaSerpent.this.changedSwimBehavior = true;
                    }
                    if (!EntitySeaSerpent.this.changedSwimBehavior && EntitySeaSerpent.this.swimBehavior == SwimBehavior.CIRCLE && EntitySeaSerpent.this.field_70146_Z.nextInt(5) == 0 && EntitySeaSerpent.this.ticksCircling > 150) {
                        EntitySeaSerpent.this.swimBehavior = SwimBehavior.WANDER;
                        EntitySeaSerpent.this.changedSwimBehavior = true;
                    }
                }
                if (EntitySeaSerpent.this.swimBehavior == SwimBehavior.JUMP && !EntitySeaSerpent.this.func_70090_H() && !EntitySeaSerpent.this.field_70122_E) {
                    EntitySeaSerpent.this.ticksSinceJump = 0;
                }
                int n = dist = EntitySeaSerpent.this.swimBehavior == SwimBehavior.JUMP ? 10 : 3;
                if (d3 < (double)dist && EntitySeaSerpent.this.func_70638_az() == null || EntitySeaSerpent.this.swimBehavior == SwimBehavior.JUMP && EntitySeaSerpent.this.shouldStopJumping() && EntitySeaSerpent.this.func_70638_az() == null) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    EntitySeaSerpent.this.field_70159_w *= 0.5;
                    EntitySeaSerpent.this.field_70179_y *= 0.5;
                    if (EntitySeaSerpent.this.swimBehavior == SwimBehavior.JUMP) {
                        EntitySeaSerpent.this.swimBehavior = SwimBehavior.WANDER;
                        EntitySeaSerpent.this.ticksSinceJump = 0;
                        EntitySeaSerpent.this.setJumpingOutOfWater(false);
                    }
                } else {
                    float f1;
                    EntitySeaSerpent.this.field_70159_w += d0 / d3 * 0.5 * this.field_75645_e;
                    EntitySeaSerpent.this.field_70181_x += d1 / d3 * 0.5 * this.field_75645_e;
                    EntitySeaSerpent.this.field_70179_y += d2 / d3 * 0.5 * this.field_75645_e;
                    this.field_75648_a.field_70125_A = f1 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.29577951308232));
                    if (!EntitySeaSerpent.this.isArcing) {
                        if (EntitySeaSerpent.this.func_70638_az() == null) {
                            EntitySeaSerpent.this.field_70761_aq = EntitySeaSerpent.this.field_70177_z = -((float)MathHelper.func_181159_b((double)EntitySeaSerpent.this.field_70159_w, (double)EntitySeaSerpent.this.field_70179_y)) * 57.295776f;
                        } else if (EntitySeaSerpent.this.swimBehavior != SwimBehavior.JUMP) {
                            double d4 = EntitySeaSerpent.this.func_70638_az().field_70165_t - EntitySeaSerpent.this.field_70165_t;
                            double d5 = EntitySeaSerpent.this.func_70638_az().field_70161_v - EntitySeaSerpent.this.field_70161_v;
                            EntitySeaSerpent.this.field_70761_aq = EntitySeaSerpent.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                        }
                    }
                }
            }
        }
    }

    static enum SwimBehavior {
        CIRCLE,
        WANDER,
        ATTACK,
        JUMP,
        NONE;

    }
}

