/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.core.ModItems;
import com.github.alexthe666.iceandfire.core.ModSounds;
import com.github.alexthe666.iceandfire.entity.DragonUtils;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityDragonFire;
import com.github.alexthe666.iceandfire.entity.EntityDragonFireCharge;
import com.github.alexthe666.iceandfire.entity.ai.AquaticAITempt;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIAirTarget;
import com.github.alexthe666.iceandfire.entity.ai.DragonAILookIdle;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIMate;
import com.github.alexthe666.iceandfire.entity.ai.DragonAITarget;
import com.github.alexthe666.iceandfire.entity.ai.DragonAITargetItems;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIWander;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIWatchClosest;
import com.google.common.base.Predicate;
import java.util.Random;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityFireDragon
extends EntityDragonBase {
    public static Animation ANIMATION_FIRECHARGE;
    public static final float[] growth_stage_1;
    public static final float[] growth_stage_2;
    public static final float[] growth_stage_3;
    public static final float[] growth_stage_4;
    public static final float[] growth_stage_5;
    public static final ResourceLocation FEMALE_LOOT;
    public static final ResourceLocation MALE_LOOT;
    public static final ResourceLocation SKELETON_LOOT;

    public EntityFireDragon(World worldIn) {
        super(worldIn, 1.0, 1 + IceAndFire.CONFIG.dragonAttackDamage, (double)IceAndFire.CONFIG.dragonHealth * 0.04, IceAndFire.CONFIG.dragonHealth, 0.15f, 0.4f);
        this.func_70105_a(0.78f, 1.2f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.LAVA, 8.0f);
        this.field_70178_ae = true;
        this.field_70158_ak = true;
        ANIMATION_SPEAK = Animation.create((int)20);
        ANIMATION_BITE = Animation.create((int)35);
        ANIMATION_SHAKEPREY = Animation.create((int)65);
        ANIMATION_TAILWHACK = Animation.create((int)40);
        ANIMATION_FIRECHARGE = Animation.create((int)25);
        ANIMATION_WINGBLAST = Animation.create((int)50);
        ANIMATION_ROAR = Animation.create((int)40);
        this.growth_stages = new float[][]{growth_stage_1, growth_stage_2, growth_stage_3, growth_stage_4, growth_stage_5};
        this.field_70138_W = 1.0f;
    }

    protected void func_184651_r() {
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new DragonAIMate(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.5, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AquaticAITempt((EntityCreature)this, 1.0, ModItems.fire_stew, false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new DragonAIAirTarget(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new DragonAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new DragonAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new DragonAILookIdle(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(4, new DragonAITarget<Entity>(this, EntityLivingBase.class, true, new Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                return entity instanceof EntityLivingBase && DragonUtils.isAlive((EntityLivingBase)entity);
            }
        }));
        this.field_70715_bh.func_75776_a(5, new DragonAITargetItems((EntityCreature)this, false));
    }

    @Override
    public String getVariantName(int variant) {
        switch (variant) {
            default: {
                return "red_";
            }
            case 1: {
                return "green_";
            }
            case 2: {
                return "bronze_";
            }
            case 3: 
        }
        return "gray_";
    }

    @Override
    public Item getVariantScale(int variant) {
        switch (variant) {
            default: {
                return ModItems.dragonscales_red;
            }
            case 1: {
                return ModItems.dragonscales_green;
            }
            case 2: {
                return ModItems.dragonscales_bronze;
            }
            case 3: 
        }
        return ModItems.dragonscales_gray;
    }

    @Override
    public Item getVariantEgg(int variant) {
        switch (variant) {
            default: {
                return ModItems.dragonegg_red;
            }
            case 1: {
                return ModItems.dragonegg_green;
            }
            case 2: {
                return ModItems.dragonegg_bronze;
            }
            case 3: 
        }
        return ModItems.dragonegg_gray;
    }

    @Override
    public boolean func_82171_bF() {
        return true;
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (this.getAnimation() == ANIMATION_WINGBLAST) {
            return false;
        }
        switch (new Random().nextInt(4)) {
            case 0: {
                if (this.getAnimation() != ANIMATION_BITE) {
                    this.setAnimation(ANIMATION_BITE);
                    return false;
                }
                if (this.getAnimationTick() <= 15 || this.getAnimationTick() >= 25) break;
                boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
                this.attackDecision = this.func_70681_au().nextBoolean();
                return flag;
            }
            case 1: {
                if (new Random().nextInt(2) == 0 && this.isDirectPathBetweenPoints((Entity)this, this.func_174791_d(), entityIn.func_174791_d()) && entityIn.field_70130_N < this.field_70130_N * 0.5f && this.func_184179_bs() == null && this.getDragonStage() > 1 && !(entityIn instanceof EntityDragonBase) && !DragonUtils.isAnimaniaMob(entityIn)) {
                    if (this.getAnimation() == ANIMATION_SHAKEPREY) break;
                    this.setAnimation(ANIMATION_SHAKEPREY);
                    entityIn.func_184220_m((Entity)this);
                    this.attackDecision = this.func_70681_au().nextBoolean();
                    return true;
                }
                if (this.getAnimation() != ANIMATION_BITE) {
                    this.setAnimation(ANIMATION_BITE);
                    return false;
                }
                if (this.getAnimationTick() <= 15 || this.getAnimationTick() >= 25) break;
                boolean flag1 = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
                this.attackDecision = this.func_70681_au().nextBoolean();
                return flag1;
            }
            case 2: {
                if (this.getAnimation() != ANIMATION_TAILWHACK) {
                    this.setAnimation(ANIMATION_TAILWHACK);
                    return false;
                }
                if (this.getAnimationTick() <= 20 || this.getAnimationTick() >= 25) break;
                boolean flag2 = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
                if (entityIn instanceof EntityLivingBase) {
                    ((EntityLivingBase)entityIn).func_70653_a(entityIn, 1.0f, 1.0, 1.0);
                }
                this.attackDecision = this.func_70681_au().nextBoolean();
                return flag2;
            }
            case 3: {
                if (this.field_70122_E && !this.isHovering() && !this.isFlying() && this.getDragonStage() > 2) {
                    if (this.getAnimation() == ANIMATION_WINGBLAST) break;
                    this.setAnimation(ANIMATION_WINGBLAST);
                    return true;
                }
                if (this.getAnimation() != ANIMATION_BITE) {
                    this.setAnimation(ANIMATION_BITE);
                    return false;
                }
                if (this.getAnimationTick() <= 15 || this.getAnimationTick() >= 25) break;
                boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
                this.attackDecision = this.func_70681_au().nextBoolean();
                return flag;
            }
            default: {
                if (this.getAnimation() != ANIMATION_BITE) {
                    this.setAnimation(ANIMATION_BITE);
                    return false;
                }
                if (this.getAnimationTick() <= 15 || this.getAnimationTick() >= 25) break;
                boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
                this.attackDecision = this.func_70681_au().nextBoolean();
                return flag;
            }
        }
        return false;
    }

    public void moveEntityTowards(Entity entity, double x, double y, double z, float velocity, float inaccuracy) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        entity.field_70159_w = x *= (double)velocity;
        entity.field_70181_x = y *= (double)velocity;
        entity.field_70179_y = z *= (double)velocity;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70638_az() != null && !this.isSleeping() && this.getAnimation() != ANIMATION_SHAKEPREY) {
                if (!(this.attackDecision && !this.isFlying() || this.isTargetBlocked(new Vec3d(this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v)))) {
                    this.shootFireAtMob(this.func_70638_az());
                } else if (this.func_174813_aQ().func_72314_b((double)(this.getRenderSize() * 0.5f), (double)(this.getRenderSize() * 0.5f), (double)(this.getRenderSize() * 0.5f)).func_72326_a(this.func_70638_az().func_174813_aQ())) {
                    this.func_70652_k((Entity)this.func_70638_az());
                }
            } else {
                this.setBreathingFire(false);
            }
        }
    }

    @Override
    public void riderShootFire(Entity controller) {
        if (this.func_70681_au().nextInt(5) == 0 && !this.func_70631_g_()) {
            if (this.getAnimation() != ANIMATION_FIRECHARGE) {
                this.setAnimation(ANIMATION_FIRECHARGE);
            } else if (this.getAnimationTick() == 15) {
                this.field_70177_z = this.field_70761_aq;
                float headPosX = (float)(this.field_70165_t + (double)(1.8f * this.getRenderSize() * 0.3f) * Math.cos((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
                float headPosZ = (float)(this.field_70161_v + (double)(1.8f * this.getRenderSize() * 0.3f) * Math.sin((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
                float headPosY = (float)(this.field_70163_u + 0.5 * (double)this.getRenderSize() * (double)0.3f);
                this.func_184185_a(ModSounds.FIREDRAGON_BREATH, 4.0f, 1.0f);
                double d2 = controller.func_70040_Z().field_72450_a;
                double d3 = controller.func_70040_Z().field_72448_b;
                double d4 = controller.func_70040_Z().field_72449_c;
                EntityDragonFireCharge entitylargefireball = new EntityDragonFireCharge(this.field_70170_p, this, d2, d3, d4);
                float size = this.func_70631_g_() ? 0.4f : (this.isAdult() ? 1.3f : 0.8f);
                entitylargefireball.setSizes(size, size);
                entitylargefireball.func_70107_b(headPosX, headPosY, headPosZ);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)entitylargefireball);
                }
            }
        } else if (this.isBreathingFire()) {
            if (this.isActuallyBreathingFire() && this.field_70173_aa % 3 == 0) {
                this.field_70177_z = this.field_70761_aq;
                float headPosX = (float)(this.field_70165_t + (double)(1.8f * this.getRenderSize() * 0.3f) * Math.cos((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
                float headPosZ = (float)(this.field_70161_v + (double)(1.8f * this.getRenderSize() * 0.3f) * Math.sin((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
                float headPosY = (float)(this.field_70163_u + 0.5 * (double)this.getRenderSize() * (double)0.3f);
                double d2 = controller.func_70040_Z().field_72450_a;
                double d3 = controller.func_70040_Z().field_72448_b;
                double d4 = controller.func_70040_Z().field_72449_c;
                EntityDragonFire entitylargefireball = new EntityDragonFire(this.field_70170_p, this, d2, d3, d4);
                this.func_184185_a(ModSounds.FIREDRAGON_BREATH, 4.0f, 1.0f);
                float size = this.func_70631_g_() ? 0.4f : (this.isAdult() ? 1.3f : 0.8f);
                entitylargefireball.func_70107_b(headPosX, headPosY, headPosZ);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)entitylargefireball);
                }
            }
        } else {
            this.setBreathingFire(true);
        }
    }

    @Override
    public ResourceLocation getDeadLootTable() {
        if (this.getDeathStage() >= this.getAgeInDays() / 5 / 2) {
            return SKELETON_LOOT;
        }
        return this.isMale() ? MALE_LOOT : FEMALE_LOOT;
    }

    private void shootFireAtMob(EntityLivingBase entity) {
        if (!this.attackDecision) {
            if (this.func_70681_au().nextInt(5) == 0) {
                if (this.getAnimation() != ANIMATION_FIRECHARGE) {
                    this.setAnimation(ANIMATION_FIRECHARGE);
                } else if (this.getAnimationTick() == 15) {
                    this.field_70177_z = this.field_70761_aq;
                    float headPosX = (float)(this.field_70165_t + (double)(1.8f * this.getRenderSize() * 0.3f) * Math.cos((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
                    float headPosZ = (float)(this.field_70161_v + (double)(1.8f * this.getRenderSize() * 0.3f) * Math.sin((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
                    float headPosY = (float)(this.field_70163_u + 0.5 * (double)this.getRenderSize() * (double)0.3f);
                    double d2 = entity.field_70165_t - (double)headPosX;
                    double d3 = entity.field_70163_u - (double)headPosY;
                    double d4 = entity.field_70161_v - (double)headPosZ;
                    this.func_184185_a(ModSounds.FIREDRAGON_BREATH, 4.0f, 1.0f);
                    EntityDragonFireCharge entitylargefireball = new EntityDragonFireCharge(this.field_70170_p, this, d2, d3, d4);
                    float size = this.func_70631_g_() ? 0.4f : (this.isAdult() ? 1.3f : 0.8f);
                    entitylargefireball.setSizes(size, size);
                    entitylargefireball.func_70107_b(headPosX, headPosY, headPosZ);
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_72838_d((Entity)entitylargefireball);
                    }
                    if (entity.field_70128_L || entity == null) {
                        this.setBreathingFire(false);
                        this.attackDecision = this.func_70681_au().nextBoolean();
                    }
                }
            } else if (this.isBreathingFire()) {
                if (this.isActuallyBreathingFire() && this.field_70173_aa % 3 == 0) {
                    this.field_70177_z = this.field_70761_aq;
                    float headPosX = (float)(this.field_70165_t + (double)(1.8f * this.getRenderSize() * 0.3f) * Math.cos((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
                    float headPosZ = (float)(this.field_70161_v + (double)(1.8f * this.getRenderSize() * 0.3f) * Math.sin((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
                    float headPosY = (float)(this.field_70163_u + 0.5 * (double)this.getRenderSize() * (double)0.3f);
                    double d2 = entity.field_70165_t - (double)headPosX;
                    double d3 = entity.field_70163_u - (double)headPosY;
                    double d4 = entity.field_70161_v - (double)headPosZ;
                    this.func_184185_a(ModSounds.FIREDRAGON_BREATH, 4.0f, 1.0f);
                    EntityDragonFire entitylargefireball = new EntityDragonFire(this.field_70170_p, this, d2, d3, d4);
                    float size = this.func_70631_g_() ? 0.4f : (this.isAdult() ? 1.3f : 0.8f);
                    entitylargefireball.func_70107_b(headPosX, headPosY, headPosZ);
                    if (!this.field_70170_p.field_72995_K && !entity.field_70128_L) {
                        this.field_70170_p.func_72838_d((Entity)entitylargefireball);
                    }
                    entitylargefireball.setSizes(size, size);
                    if (entity.field_70128_L || entity == null) {
                        this.setBreathingFire(false);
                        this.attackDecision = this.func_70681_au().nextBoolean();
                    }
                }
            } else {
                this.setBreathingFire(true);
            }
        }
        this.func_70625_a((Entity)entity, 360.0f, 360.0f);
    }

    protected SoundEvent func_184639_G() {
        return this.isTeen() ? ModSounds.FIREDRAGON_TEEN_IDLE : (this.isAdult() ? ModSounds.FIREDRAGON_ADULT_IDLE : ModSounds.FIREDRAGON_CHILD_IDLE);
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return this.isTeen() ? ModSounds.FIREDRAGON_TEEN_HURT : (this.isAdult() ? ModSounds.FIREDRAGON_ADULT_HURT : ModSounds.FIREDRAGON_CHILD_HURT);
    }

    protected SoundEvent func_184615_bR() {
        return this.isTeen() ? ModSounds.FIREDRAGON_TEEN_DEATH : (this.isAdult() ? ModSounds.FIREDRAGON_ADULT_DEATH : ModSounds.FIREDRAGON_CHILD_DEATH);
    }

    @Override
    public SoundEvent getRoarSound() {
        return this.isTeen() ? ModSounds.FIREDRAGON_TEEN_ROAR : (this.isAdult() ? ModSounds.FIREDRAGON_ADULT_ROAR : ModSounds.FIREDRAGON_CHILD_ROAR);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{IAnimatedEntity.NO_ANIMATION, EntityDragonBase.ANIMATION_EAT, EntityDragonBase.ANIMATION_SPEAK, EntityDragonBase.ANIMATION_BITE, EntityDragonBase.ANIMATION_SHAKEPREY, ANIMATION_TAILWHACK, ANIMATION_FIRECHARGE, ANIMATION_WINGBLAST, ANIMATION_ROAR};
    }

    public boolean func_70877_b(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() != null && stack.func_77973_b() == ModItems.fire_stew;
    }

    static {
        growth_stage_1 = new float[]{1.0f, 3.0f};
        growth_stage_2 = new float[]{3.0f, 7.0f};
        growth_stage_3 = new float[]{7.0f, 12.5f};
        growth_stage_4 = new float[]{12.5f, 20.0f};
        growth_stage_5 = new float[]{20.0f, 30.0f};
        FEMALE_LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "dragon/fire_dragon_female"));
        MALE_LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "dragon/fire_dragon_male"));
        SKELETON_LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "dragon/fire_dragon_skeleton"));
    }
}

