/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.util.serializer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Field;
import javax.annotation.Nullable;
import yuudaari.soulus.common.config.CaseConversion;
import yuudaari.soulus.common.config.ConfigProfile;
import yuudaari.soulus.common.util.Logger;

public class SerializationHandlers {

    public static interface IClassDeserializationHandler<T> {
        @Nullable
        default public T instantiate(Class<?> cls) {
            T instance = null;
            try {
                instance = (T)cls.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                Logger.warn("Could not instantiate: ");
                Logger.error(e);
            }
            return instance;
        }

        @Nullable
        default public T getProfile(Class<?> cls, String profileName) {
            for (Field field : cls.getFields()) {
                ConfigProfile profile;
                if (field.getType() != cls || (profile = field.getAnnotation(ConfigProfile.class)) == null) continue;
                String name = profile.value();
                if (name.equals("")) {
                    name = CaseConversion.toSnakeCase(field.getName());
                }
                if (!name.equals(profileName)) continue;
                try {
                    return (T)field.get(null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            Logger.warn("Unable to find a default profile object for the profile '" + profileName + "'");
            return null;
        }

        public T deserialize(@Nullable T var1, JsonElement var2);
    }

    public static interface IClassSerializationHandler<T> {
        public void serialize(T var1, JsonObject var2);
    }

    public static interface IFieldDeserializationHandler<T> {
        public T deserialize(Class<?> var1, JsonElement var2);
    }

    public static interface IFieldSerializationHandler<T> {
        public JsonElement serialize(Class<?> var1, T var2);
    }
}

