/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.util.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Array;
import javax.annotation.Nullable;
import yuudaari.soulus.common.util.Logger;
import yuudaari.soulus.common.util.serializer.DefaultClassSerializer;
import yuudaari.soulus.common.util.serializer.FieldSerializer;
import yuudaari.soulus.common.util.serializer.Serializable;
import yuudaari.soulus.common.util.serializer.SerializationHandlers;

public class DefaultFieldSerializer
extends FieldSerializer<Object> {
    @Override
    public final JsonElement serialize(Class<? extends Object> requestedType, Object object) {
        Logger.scopes.push(requestedType.getSimpleName());
        JsonElement result = null;
        SerializationHandlers.IClassSerializationHandler<Object> serializer = DefaultFieldSerializer.getClassSerializer(requestedType);
        if (serializer == null) {
            result = this.trySerializePrimitive(requestedType, object);
            if (result == null) {
                result = this.trySerializeArray(requestedType, object);
            }
            if (result == null) {
                Logger.warn("Unable to automatically deserialize the type '" + requestedType.getSimpleName() + "'");
            }
        } else {
            try {
                result = new JsonObject();
                DefaultFieldSerializer.serializeClass(serializer, object, (JsonObject)result);
            }
            catch (Exception e) {
                Logger.warn("Unable to deserialize class: " + (e.getClass() == Exception.class ? e.getMessage() : e));
            }
        }
        Logger.scopes.pop();
        return result;
    }

    @Override
    public final Object deserialize(Class<?> requestedType, JsonElement element) {
        Logger.scopes.push(requestedType.getSimpleName());
        Object result = null;
        SerializationHandlers.IClassDeserializationHandler<Object> deserializer = DefaultFieldSerializer.getClassDeserializer(requestedType);
        if (deserializer == null) {
            result = this.tryDeserializePrimitive(requestedType, element);
            if (result == null) {
                result = this.tryDeserializeArray(requestedType, element);
            }
            if (result == null) {
                Logger.warn("Unable to automatically deserialize the type '" + requestedType.getSimpleName() + "'");
            }
        } else {
            try {
                result = DefaultFieldSerializer.deserializeClass(deserializer, requestedType, element, null);
            }
            catch (Exception e) {
                Logger.warn("Unable to deserialize class: " + (e.getClass() == Exception.class ? e.getMessage() : e));
            }
        }
        Logger.scopes.pop();
        return result;
    }

    @Nullable
    public static final void serializeClass(SerializationHandlers.IClassSerializationHandler<Object> serializer, Object instance, JsonObject jsonObject) {
        serializer.serialize(instance, jsonObject);
    }

    @Nullable
    public static final Object deserializeClass(SerializationHandlers.IClassDeserializationHandler<Object> deserializer, Class<?> requestedType, JsonElement element, @Nullable String profile) {
        Object instance = null;
        if (profile != null) {
            instance = deserializer.getProfile(requestedType, profile);
        }
        if (instance == null) {
            instance = deserializer.instantiate(requestedType);
        }
        return deserializer.deserialize(instance, element);
    }

    @Nullable
    private final JsonElement serializePrimitive(Class<?> requestedType, Object instance) {
        if (requestedType == Boolean.TYPE || requestedType == Boolean.class) {
            return new JsonPrimitive((Boolean)instance);
        }
        if (this.isNumber(requestedType)) {
            if (requestedType == Byte.TYPE || requestedType == Byte.class) {
                return new JsonPrimitive((Number)((Byte)instance));
            }
            if (requestedType == Short.TYPE || requestedType == Short.class) {
                return new JsonPrimitive((Number)((Short)instance));
            }
            if (requestedType == Integer.TYPE || requestedType == Integer.class) {
                return new JsonPrimitive((Number)((Integer)instance));
            }
            if (requestedType == Long.TYPE || requestedType == Long.class) {
                return new JsonPrimitive((Number)((Long)instance));
            }
            if (requestedType == Float.TYPE || requestedType == Float.class) {
                return new JsonPrimitive((Number)((Float)instance));
            }
            if (requestedType == Double.TYPE || requestedType == Double.class) {
                return new JsonPrimitive((Number)((Double)instance));
            }
        } else if (requestedType == String.class) {
            return new JsonPrimitive((String)instance);
        }
        Logger.warn("Can't serialize primitive '" + requestedType.getSimpleName() + "'");
        return null;
    }

    private boolean isNumber(Class<?> cls) {
        return Number.class.isAssignableFrom(cls) || cls == Byte.TYPE || cls == Short.TYPE || cls == Integer.TYPE || cls == Long.TYPE || cls == Float.TYPE || cls == Double.TYPE;
    }

    @Nullable
    private final Object tryDeserializePrimitive(Class<?> requestedType, JsonElement element) {
        if (requestedType.isPrimitive() || requestedType == String.class || Number.class.isAssignableFrom(requestedType)) {
            if (element.isJsonPrimitive()) {
                return this.deserializePrimitive(requestedType, element);
            }
            Logger.warn("Json value is the wrong type");
        }
        return null;
    }

    @Nullable
    private final JsonElement trySerializePrimitive(Class<?> requestedType, Object object) {
        if (requestedType.isPrimitive() || requestedType == String.class || Number.class.isAssignableFrom(requestedType)) {
            return this.serializePrimitive(requestedType, object);
        }
        return null;
    }

    @Nullable
    private final Object deserializePrimitive(Class<?> requestedType, JsonElement element) {
        JsonPrimitive primitive = element.getAsJsonPrimitive();
        if (primitive.isBoolean() && requestedType == Boolean.TYPE || requestedType == Boolean.class) {
            return primitive.getAsBoolean();
        }
        if (primitive.isNumber()) {
            if (requestedType == Byte.TYPE || requestedType == Byte.class) {
                return primitive.getAsByte();
            }
            if (requestedType == Short.TYPE || requestedType == Short.class) {
                return primitive.getAsShort();
            }
            if (requestedType == Integer.TYPE || requestedType == Integer.class) {
                return primitive.getAsInt();
            }
            if (requestedType == Long.TYPE || requestedType == Long.class) {
                return primitive.getAsLong();
            }
            if (requestedType == Float.TYPE || requestedType == Float.class) {
                return Float.valueOf(primitive.getAsFloat());
            }
            if (requestedType == Double.TYPE || requestedType == Double.class) {
                return primitive.getAsDouble();
            }
        } else if (primitive.isString()) {
            return primitive.getAsString();
        }
        Logger.warn("Can't deserialize primitive '" + primitive.getClass().getSimpleName() + "'");
        return null;
    }

    @Nullable
    private final JsonElement trySerializeArray(Class<?> requestedType, Object object) {
        if (requestedType.isArray()) {
            return this.serializeArray(requestedType, object);
        }
        return null;
    }

    @Nullable
    private final Object tryDeserializeArray(Class<?> requestedType, JsonElement element) {
        if (requestedType.isArray()) {
            if (element.isJsonArray()) {
                return this.deserializeArray(requestedType, element.getAsJsonArray());
            }
            Logger.warn("Json value is not an array");
        }
        return null;
    }

    @Nullable
    private final JsonArray serializeArray(Class<?> requestedType, Object object) {
        Class<?> containedType = requestedType.getComponentType();
        Object[] arr = (Object[])object;
        JsonArray result = new JsonArray();
        for (int i = 0; i < arr.length; ++i) {
            JsonElement value = this.serialize((Class<? extends Object>)containedType, arr[i]);
            if (value == null) continue;
            result.add(value);
        }
        return result;
    }

    @Nullable
    private final Object deserializeArray(Class<?> requestedType, JsonArray element) {
        Class<?> containedType = requestedType.getComponentType();
        Object[] result = (Object[])Array.newInstance(containedType, element.size());
        for (int i = 0; i < element.size(); ++i) {
            Object value = this.deserialize(containedType, element.get(i));
            if (value == null) {
                return null;
            }
            result[i] = value;
        }
        return result;
    }

    @Nullable
    public static SerializationHandlers.IClassDeserializationHandler<Object> getClassDeserializer(Class<?> classWithSerializableAnnotation) {
        Serializable serializableClassAnnotation = classWithSerializableAnnotation.getAnnotation(Serializable.class);
        if (serializableClassAnnotation == null) {
            return null;
        }
        Class<? extends SerializationHandlers.IClassDeserializationHandler> deserializerClass = serializableClassAnnotation.deserializer();
        if (deserializerClass == DefaultClassSerializer.class && serializableClassAnnotation.value() != DefaultClassSerializer.class) {
            deserializerClass = serializableClassAnnotation.value();
        }
        try {
            return deserializerClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            Logger.warn("Unable to instantiate deserializer: " + deserializerClass.getSimpleName());
            Logger.error(e);
            return null;
        }
    }

    @Nullable
    public static SerializationHandlers.IClassSerializationHandler<Object> getClassSerializer(Class<?> classWithSerializableAnnotation) {
        Serializable serializableClassAnnotation = classWithSerializableAnnotation.getAnnotation(Serializable.class);
        if (serializableClassAnnotation == null) {
            return null;
        }
        Class<? extends SerializationHandlers.IClassSerializationHandler> serializerClass = serializableClassAnnotation.serializer();
        if (serializerClass == DefaultClassSerializer.class && serializableClassAnnotation.value() != DefaultClassSerializer.class) {
            serializerClass = serializableClassAnnotation.value();
        }
        try {
            return serializerClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            Logger.warn("Unable to instantiate serializer: " + serializerClass.getSimpleName());
            Logger.error(e);
            return null;
        }
    }
}

