/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.util.serializer;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.annotation.Nullable;
import yuudaari.soulus.common.config.CaseConversion;
import yuudaari.soulus.common.util.Logger;
import yuudaari.soulus.common.util.serializer.ClassSerializationEventHandlers;
import yuudaari.soulus.common.util.serializer.ClassSerializer;
import yuudaari.soulus.common.util.serializer.DefaultFieldSerializer;
import yuudaari.soulus.common.util.serializer.NullableField;
import yuudaari.soulus.common.util.serializer.SerializationHandlers;
import yuudaari.soulus.common.util.serializer.Serialized;

public class DefaultClassSerializer
extends ClassSerializer<Object> {
    @Override
    public void serialize(Object instance, JsonObject object) {
        if (object == null) {
            Logger.warn("Did not receive a Json object to serialize into");
            return;
        }
        Class<?> cls = instance.getClass();
        for (Field field : cls.getFields()) {
            DefaultClassSerializer.trySerializeField(instance, field, object);
        }
        for (AccessibleObject accessibleObject : cls.getMethods()) {
            if (!accessibleObject.isAnnotationPresent(ClassSerializationEventHandlers.SerializationEventHandler.class)) continue;
            try {
                ((Method)accessibleObject).invoke(null, instance, object);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                Logger.warn("Failed to run class serialization handler:");
                Logger.error(e);
            }
        }
    }

    @Override
    public Object deserialize(@Nullable Object instance, JsonElement element) {
        if (instance == null) {
            Logger.warn("Not instantiated");
            return null;
        }
        if (element == null || !element.isJsonObject()) {
            Logger.warn("Json value must be an object. Using base instance.");
            return instance;
        }
        Class<?> cls = instance.getClass();
        for (Field field : cls.getFields()) {
            DefaultClassSerializer.tryDeserializeField(field, instance, element.getAsJsonObject());
        }
        for (AccessibleObject accessibleObject : cls.getMethods()) {
            if (!accessibleObject.isAnnotationPresent(ClassSerializationEventHandlers.DeserializationEventHandler.class)) continue;
            try {
                ((Method)accessibleObject).invoke(null, instance, element.getAsJsonObject());
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                Logger.warn("Failed to run class serialization handler:");
                Logger.error(e);
            }
        }
        return instance;
    }

    private static void trySerializeField(Object instance, Field field, JsonObject containingObject) {
        block7: {
            Logger.scopes.push(field.getName());
            SerializationHandlers.IFieldSerializationHandler<Object> serializer = DefaultClassSerializer.getFieldSerializer(field);
            if (serializer != null) {
                try {
                    Object value = field.get(instance);
                    JsonElement serializedValue = DefaultClassSerializer.serializeValue(serializer, field.getType(), field.isAnnotationPresent(NullableField.class), value);
                    if (DefaultClassSerializer.getIsTopLevel(field)) {
                        if (!serializedValue.isJsonObject()) {
                            throw new Exception("Serializing a property to top-level must return a JsonObject.");
                        }
                        for (Map.Entry entry : serializedValue.getAsJsonObject().entrySet()) {
                            containingObject.add((String)entry.getKey(), (JsonElement)entry.getValue());
                        }
                    } else {
                        String jsonFieldName = CaseConversion.toSnakeCase(field.getName());
                        containingObject.add(jsonFieldName, serializedValue);
                    }
                }
                catch (Exception e) {
                    boolean isNormalException = e.getClass() == Exception.class;
                    Logger.warn("Could not serialize field: " + (isNormalException ? e.getMessage() : ""));
                    if (isNormalException) break block7;
                    Logger.error(e);
                }
            }
        }
        Logger.scopes.pop();
    }

    public static JsonElement serializeValue(SerializationHandlers.IFieldSerializationHandler<Object> serializer, Class<?> requestedType, boolean nullable, Object value) throws Exception {
        JsonNull serializedValue = JsonNull.INSTANCE;
        if (value == null) {
            boolean isPrimitive = requestedType.isPrimitive();
            if (!nullable) {
                throw new Exception("Recieved null, cannot be null.");
            }
            if (isPrimitive) {
                throw new Exception("Recieved null, primitives cannot be null.");
            }
        } else {
            serializedValue = serializer.serialize(requestedType, value);
            if (serializedValue == null) {
                throw new Exception("Cannot serialize null");
            }
        }
        return serializedValue;
    }

    private static void tryDeserializeField(Field field, Object instance, JsonObject containingObject) {
        block4: {
            Logger.scopes.push(field.getName());
            SerializationHandlers.IFieldDeserializationHandler<Object> deserializer = DefaultClassSerializer.getFieldDeserializer(field);
            if (deserializer != null) {
                try {
                    JsonObject jsonValue = containingObject;
                    if (!DefaultClassSerializer.getIsTopLevel(field)) {
                        String jsonFieldName = CaseConversion.toSnakeCase(field.getName());
                        jsonValue = containingObject.get(jsonFieldName);
                    }
                    Object deserializedValue = DefaultClassSerializer.deserializeValue(deserializer, field.getType(), field.isAnnotationPresent(NullableField.class), (JsonElement)jsonValue);
                    field.set(instance, deserializedValue);
                }
                catch (Exception e) {
                    boolean isNormalException = e.getClass() == Exception.class;
                    Logger.warn("Could not deserialize field: " + (isNormalException ? e.getMessage() : ""));
                    if (isNormalException) break block4;
                    Logger.error(e);
                }
            }
        }
        Logger.scopes.pop();
    }

    public static Object deserializeValue(SerializationHandlers.IFieldDeserializationHandler<Object> deserializer, Class<?> requestedType, boolean nullable, JsonElement jsonValue) throws Exception {
        Object deserializedValue = null;
        if (jsonValue == null || jsonValue.isJsonNull()) {
            boolean isPrimitive = requestedType.isPrimitive();
            if (!nullable) {
                throw new Exception("Recieved null, cannot be null.");
            }
            if (isPrimitive) {
                throw new Exception("Recieved null, primitives cannot be null.");
            }
        } else {
            deserializedValue = deserializer.deserialize(requestedType, jsonValue);
            if (deserializedValue == null && !nullable) {
                throw new Exception("Recieved null, cannot be null.");
            }
        }
        return deserializedValue;
    }

    @Nullable
    public static SerializationHandlers.IFieldSerializationHandler<Object> getFieldSerializer(Field field) {
        Serialized serializedFieldAnnotation = field.getAnnotation(Serialized.class);
        if (serializedFieldAnnotation == null) {
            return null;
        }
        Class<? extends SerializationHandlers.IFieldSerializationHandler> serializerClass = serializedFieldAnnotation.serializer();
        if (serializerClass == DefaultFieldSerializer.class && serializedFieldAnnotation.value() != DefaultFieldSerializer.class) {
            serializerClass = serializedFieldAnnotation.value();
        }
        try {
            return serializerClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            Logger.warn("Unable to instantiate serializer");
            Logger.error(e);
            return null;
        }
    }

    public static boolean getIsTopLevel(Field field) {
        Serialized serializedFieldAnnotation = field.getAnnotation(Serialized.class);
        return serializedFieldAnnotation.topLevel();
    }

    @Nullable
    private static SerializationHandlers.IFieldDeserializationHandler<Object> getFieldDeserializer(Field field) {
        Serialized serializedFieldAnnotation = field.getAnnotation(Serialized.class);
        if (serializedFieldAnnotation == null) {
            return null;
        }
        Class<? extends SerializationHandlers.IFieldDeserializationHandler> deserializerClass = serializedFieldAnnotation.deserializer();
        if (deserializerClass == DefaultFieldSerializer.class && serializedFieldAnnotation.value() != DefaultFieldSerializer.class) {
            deserializerClass = serializedFieldAnnotation.value();
        }
        try {
            return deserializerClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            Logger.warn("Unable to instantiate deserializer");
            Logger.error(e);
            return null;
        }
    }
}

