/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.util.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import yuudaari.soulus.common.util.Logger;
import yuudaari.soulus.common.util.serializer.DefaultClassSerializer;
import yuudaari.soulus.common.util.serializer.DefaultFieldSerializer;
import yuudaari.soulus.common.util.serializer.FieldSerializer;

public abstract class CollectionSerializer<T>
extends FieldSerializer<Collection<T>> {
    public Class<T> getValueClass() {
        return null;
    }

    @Override
    public final JsonElement serialize(Class<?> objectType, Collection<T> object) {
        JsonArray result = new JsonArray();
        try {
            for (T item : object) {
                result.add(this.serializeValue(item));
            }
        }
        catch (Exception e) {
            Logger.warn("Couldn't serialize list:");
            Logger.error(e);
            result = new JsonArray();
        }
        return result;
    }

    @Override
    public final Collection<T> deserialize(Class<?> requestedType, JsonElement json) {
        if (json == null || !json.isJsonArray()) {
            Logger.warn("Not a Json Array");
            return null;
        }
        Collection<T> result = this.getCollectionOfClass(requestedType);
        if (result == null) {
            return result;
        }
        try {
            for (JsonElement item : json.getAsJsonArray()) {
                result.add(this.deserializeValue(item));
            }
        }
        catch (Exception e) {
            Logger.warn("Couldn't deserialize list:");
            Logger.error(e);
        }
        return result;
    }

    private Collection<T> getCollectionOfClass(Class<?> requestedType) {
        if (requestedType == List.class) {
            return new ArrayList();
        }
        if (requestedType == Set.class) {
            return new HashSet();
        }
        try {
            return (Collection)requestedType.newInstance();
        }
        catch (Exception e) {
            Logger.warn("Can't deserialize Collection class '" + requestedType.getCanonicalName() + "':");
            Logger.error(e);
            return null;
        }
    }

    public JsonElement serializeValue(T value) throws Exception {
        Class<T> valueClass = this.getValueClass();
        if (valueClass == null) {
            throw new Exception("List serializers that use default value serialization must implement getValueClass()");
        }
        DefaultFieldSerializer serializer = new DefaultFieldSerializer();
        return DefaultClassSerializer.serializeValue(serializer, valueClass, false, value);
    }

    public T deserializeValue(JsonElement value) throws Exception {
        Class<T> valueClass = this.getValueClass();
        if (valueClass == null) {
            throw new Exception("List serializers that use default value serialization must implement getValueClass()");
        }
        DefaultFieldSerializer deserializer = new DefaultFieldSerializer();
        return (T)DefaultClassSerializer.deserializeValue(deserializer, valueClass, false, value);
    }

    public static class OfStrings
    extends CollectionSerializer<String> {
        @Override
        public Class<String> getValueClass() {
            return String.class;
        }
    }
}

