/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.util.JsonUtils;
import yuudaari.soulus.common.util.Logger;

public class JSON {
    public static String getString(JsonElement json, String indent) {
        try {
            StringWriter stringWriter = new StringWriter();
            JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
            jsonWriter.setLenient(true);
            jsonWriter.setIndent(indent == null ? "" : indent);
            Streams.write((JsonElement)json, (JsonWriter)jsonWriter);
            return stringWriter.toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void writeFile(JsonElement json, File file) {
        String itemsJsonString = JSON.getString(json, "\t");
        try {
            Files.write(file.toPath(), itemsJsonString.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            Logger.error(e);
            Logger.error("Unable to export json file '" + file.toString() + "'");
        }
    }

    public static boolean mergeInto(JsonElement into, JsonElement from) {
        if (into.getClass() != from.getClass()) {
            return false;
        }
        if (into.isJsonObject()) {
            JsonObject intoObj = into.getAsJsonObject();
            for (Map.Entry entry : from.getAsJsonObject().entrySet()) {
                String key = (String)entry.getKey();
                JsonElement current = intoObj.get(key);
                JsonElement replacement = (JsonElement)entry.getValue();
                if (current == null || current.getClass() != replacement.getClass() || !current.isJsonObject() && !current.isJsonArray()) {
                    intoObj.add(key, replacement);
                    continue;
                }
                JSON.mergeInto(current, replacement);
            }
        } else if (into.isJsonArray()) {
            into.getAsJsonArray().addAll(from.getAsJsonArray());
        } else {
            return false;
        }
        return true;
    }

    public static Set<String> getStringSet(JsonObject json, String key) {
        return com.google.common.collect.Streams.stream((Iterable)JsonUtils.func_151213_a((JsonObject)json, (String)key, (JsonArray)new JsonArray())).map(val -> {
            if (val.isJsonPrimitive() && val.getAsJsonPrimitive().isString()) {
                return val.getAsString();
            }
            throw new JsonParseException("Members of '" + key + "' array must be strings.");
        }).collect(Collectors.toSet());
    }
}

