/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Colour {
    private int colour;

    public Colour(byte r, byte g, byte b) {
        this.set(r, g, b);
    }

    public Colour(int r, int g, int b) {
        this.set((byte)r, (byte)g, (byte)b);
    }

    public Colour(int hexCode) {
        this.set(hexCode);
    }

    public Colour set(byte r, byte g, byte b) {
        this.colour = r;
        this.colour = (this.colour << 8) + g;
        this.colour = (this.colour << 8) + b;
        return this;
    }

    public Colour set(int hexCode) {
        this.colour = hexCode;
        return this;
    }

    public int get() {
        return this.colour;
    }

    public int getRed() {
        return this.colour >> 16 & 0xFF;
    }

    public int getGreen() {
        return this.colour >> 8 & 0xFF;
    }

    public int getBlue() {
        return this.colour & 0xFF;
    }

    public static Colour mix(Colour ... colours) {
        int red = 0;
        int blue = 0;
        int green = 0;
        for (Colour colour : colours) {
            red += colour.getRed();
            blue += colour.getBlue();
            green += colour.getGreen();
        }
        return new Colour(red / colours.length, green / colours.length, blue / colours.length);
    }

    public static Colour mix(Colour firstColour, Colour secondColour, double percentage) {
        if (percentage <= 0.0) {
            return new Colour(firstColour.colour);
        }
        if (percentage >= 1.0) {
            return new Colour(secondColour.colour);
        }
        double red = (double)firstColour.getRed() * (1.0 - percentage);
        double green = (double)firstColour.getGreen() * (1.0 - percentage);
        double blue = (double)firstColour.getBlue() * (1.0 - percentage);
        return new Colour((byte)Math.floor(red += (double)secondColour.getRed() * percentage), (byte)Math.floor(green += (double)secondColour.getGreen() * percentage), (byte)Math.floor(blue += (double)secondColour.getBlue() * percentage));
    }

    public Colour mixWith(Colour ... colours) {
        List<Colour> colourList = Arrays.asList(colours);
        colourList.add(this);
        return Colour.mix((Colour[])colourList.toArray());
    }

    public Colour mixWith(Colour secondColour, double percentage) {
        return Colour.mix(this, secondColour, percentage);
    }

    public static Colour mix(int ... hexColours) {
        ArrayList<Colour> colours = new ArrayList<Colour>();
        for (int hexColour : hexColours) {
            colours.add(new Colour(hexColour));
        }
        return Colour.mix((Colour[])colours.toArray());
    }

    public static Colour mix(int firstHexColour, int secondHexColour, double percentage) {
        return Colour.mix(new Colour(firstHexColour), new Colour(secondHexColour), percentage);
    }

    public Colour mixWith(int ... hexColours) {
        ArrayList<Colour> colours = new ArrayList<Colour>();
        colours.add(this);
        for (int hexColour : hexColours) {
            colours.add(new Colour(hexColour));
        }
        return Colour.mix((Colour[])colours.toArray());
    }

    public Colour mixWith(int secondHexColour, float percentage) {
        return Colour.mix(this, new Colour(secondHexColour), (double)percentage);
    }
}

