/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.recipe.ingredient;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.crafting.IIngredientFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.UniversalBucket;

public class IngredientFluid
extends Ingredient {
    private static List<UniversalBucket> UNIVERSAL_BUCKETS;
    private final Fluid fluid;

    public static ItemStack[] getMatchingStacks1(Fluid fluid) {
        if (UNIVERSAL_BUCKETS == null) {
            UNIVERSAL_BUCKETS = new ArrayList<UniversalBucket>();
            for (Item item : Item.field_150901_e) {
                if (!(item instanceof UniversalBucket)) continue;
                UNIVERSAL_BUCKETS.add((UniversalBucket)item);
            }
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (UniversalBucket bucket : UNIVERSAL_BUCKETS) {
            if (bucket.equals(ForgeModContainer.getInstance().universalBucket)) {
                stacks.add(FluidUtil.getFilledBucket((FluidStack)new FluidStack(fluid, 1000)));
                continue;
            }
            ItemStack filledBucket = new ItemStack((Item)bucket);
            FluidStack fluidContents = new FluidStack(fluid, bucket.getCapacity());
            FluidUtil.getFluidHandler((ItemStack)filledBucket).fill(fluidContents, true);
            stacks.add(filledBucket);
        }
        return stacks.toArray(new ItemStack[0]);
    }

    public IngredientFluid(Fluid fluid) {
        super(IngredientFluid.getMatchingStacks1(fluid));
        this.fluid = fluid;
    }

    public boolean apply(ItemStack stack) {
        FluidStack contained = FluidUtil.getFluidContained((ItemStack)stack);
        return contained != null && contained.isFluidEqual(new FluidStack(this.fluid, 1000));
    }

    public boolean isSimple() {
        return false;
    }

    public static class Factory
    implements IIngredientFactory {
        public Ingredient parse(JsonContext context, JsonObject json) {
            if (!json.has("fluid")) {
                throw new JsonParseException("IngredientFluid requires a fluid type");
            }
            String fluidName = JsonUtils.func_151200_h((JsonObject)json, (String)"fluid");
            Fluid fluid = FluidRegistry.getFluid((String)fluidName);
            if (fluid == null) {
                throw new JsonParseException("Unknown fluid '" + fluidName + "'");
            }
            return new IngredientFluid(fluid);
        }
    }
}

