/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.recipe;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.common.crafting.JsonContext;
import yuudaari.soulus.common.recipe.Recipe;

public class RecipeShaped
extends Recipe
implements IShapedRecipe {
    public static final int MAX_CRAFT_GRID_WIDTH = 3;
    public static final int MAX_CRAFT_GRID_HEIGHT = 3;
    @Nonnull
    protected ItemStack output = ItemStack.field_190927_a;
    protected NonNullList<Ingredient> input = null;
    protected int width = 0;
    protected int height = 0;
    protected boolean mirrored = true;
    protected ResourceLocation group;

    public RecipeShaped(ResourceLocation group, Block result, Object ... recipe) {
        this(group, new ItemStack(result), recipe);
    }

    public RecipeShaped(ResourceLocation group, Item result, Object ... recipe) {
        this(group, new ItemStack(result), recipe);
    }

    public RecipeShaped(ResourceLocation group, @Nonnull ItemStack result, Object ... recipe) {
        this(group, result, CraftingHelper.parseShaped((Object[])recipe));
    }

    public RecipeShaped(ResourceLocation group, @Nonnull ItemStack result, CraftingHelper.ShapedPrimer primer) {
        this.group = group;
        this.output = result.func_77946_l();
        this.width = primer.width;
        this.height = primer.height;
        this.input = primer.input;
        this.mirrored = primer.mirrored;
    }

    public int getRecipeWidth() {
        return this.width;
    }

    public int getRecipeHeight() {
        return this.height;
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting var1) {
        return this.output.func_77946_l();
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return this.output;
    }

    public boolean func_77569_a(@Nonnull InventoryCrafting inv, @Nonnull World world) {
        for (int x = 0; x <= 3 - this.width; ++x) {
            for (int y = 0; y <= 3 - this.height; ++y) {
                if (this.checkMatch(inv, x, y, false)) {
                    return true;
                }
                if (!this.mirrored || !this.checkMatch(inv, x, y, true)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean checkMatch(InventoryCrafting inv, int startX, int startY, boolean mirror) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                int subX = x - startX;
                int subY = y - startY;
                Ingredient target = Ingredient.field_193370_a;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirror ? (Ingredient)this.input.get(this.width - subX - 1 + subY * this.width) : (Ingredient)this.input.get(subX + subY * this.width);
                }
                if (target.apply(inv.func_70463_b(x, y))) continue;
                return false;
            }
        }
        return true;
    }

    public RecipeShaped setMirrored(boolean mirror) {
        this.mirrored = mirror;
        return this;
    }

    @Nonnull
    public NonNullList<Ingredient> func_192400_c() {
        return this.input;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @Nonnull
    public String func_193358_e() {
        return this.group == null ? "" : this.group.toString();
    }

    @Override
    public boolean func_194133_a(int width, int height) {
        return width >= this.width && height >= this.height;
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            String override = JsonUtils.func_151219_a((JsonObject)json, (String)"override", (String)"");
            HashMap ingMap = Maps.newHashMap();
            for (Map.Entry entry : JsonUtils.func_152754_s((JsonObject)json, (String)"key").entrySet()) {
                if (((String)entry.getKey()).length() != 1) {
                    throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
                }
                if (" ".equals(entry.getKey())) {
                    throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
                }
                ingMap.put(Character.valueOf(((String)entry.getKey()).toCharArray()[0]), CraftingHelper.getIngredient((JsonElement)((JsonElement)entry.getValue()), (JsonContext)context));
            }
            ingMap.put(Character.valueOf(' '), Ingredient.field_193370_a);
            JsonArray patternJ = JsonUtils.func_151214_t((JsonObject)json, (String)"pattern");
            if (patternJ.size() == 0) {
                throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
            }
            String[] pattern = new String[patternJ.size()];
            for (int x = 0; x < pattern.length; ++x) {
                String line = JsonUtils.func_151206_a((JsonElement)patternJ.get(x), (String)("pattern[" + x + "]"));
                if (x > 0 && pattern[0].length() != line.length()) {
                    throw new JsonSyntaxException("Invalid pattern: each row must  be the same width");
                }
                pattern[x] = line;
            }
            CraftingHelper.ShapedPrimer primer = new CraftingHelper.ShapedPrimer();
            primer.width = pattern[0].length();
            primer.height = pattern.length;
            primer.mirrored = JsonUtils.func_151209_a((JsonObject)json, (String)"mirrored", (boolean)true);
            primer.input = NonNullList.func_191197_a((int)(primer.width * primer.height), (Object)Ingredient.field_193370_a);
            HashSet keys = Sets.newHashSet(ingMap.keySet());
            keys.remove(Character.valueOf(' '));
            int x = 0;
            for (String line : pattern) {
                for (char chr : line.toCharArray()) {
                    Ingredient ing = (Ingredient)ingMap.get(Character.valueOf(chr));
                    if (ing == null) {
                        throw new JsonSyntaxException("Pattern references symbol '" + chr + "' but it's not defined in the key");
                    }
                    primer.input.set(x++, (Object)ing);
                    keys.remove(Character.valueOf(chr));
                }
            }
            if (!keys.isEmpty()) {
                throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + keys);
            }
            ItemStack output = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
            RecipeShaped result = new RecipeShaped(group.isEmpty() ? null : new ResourceLocation(group), output, primer);
            if (!override.isEmpty()) {
                result.setRegistryName(override);
            }
            return result;
        }
    }
}

