/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.network.packet.client;

import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import yuudaari.soulus.common.util.GeneratorName;

public class LocationCommand
implements IMessage {
    private int entityId;
    private String[] structures;

    public LocationCommand() {
    }

    public LocationCommand(EntityPlayer player) {
        this.entityId = player.func_145782_y();
        BlockPos pos = player.func_180425_c();
        World world = player.func_130014_f_();
        ChunkProviderServer cps = (ChunkProviderServer)world.func_72863_F();
        ArrayList<String> result = new ArrayList<String>();
        for (InitMapGenEvent.EventType t : InitMapGenEvent.EventType.values()) {
            boolean isInsideStructure = cps.func_193413_a(world, GeneratorName.get(t.name()), pos);
            if (!isInsideStructure) continue;
            result.add(t.name());
        }
        this.structures = result.toArray(new String[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public EntityPlayer getPlayer() {
        return (EntityPlayer)Minecraft.func_71410_x().field_71441_e.func_73045_a(this.entityId);
    }

    @SideOnly(value=Side.CLIENT)
    public String[] getStructures() {
        return this.structures;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.structures.length);
        for (int i = 0; i < this.structures.length; ++i) {
            buf.writeInt(this.structures[i].length());
            buf.writeBytes(this.structures[i].getBytes());
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.structures = new String[buf.readInt()];
        for (int i = 0; i < this.structures.length; ++i) {
            this.structures[i] = buf.readBytes(buf.readInt()).toString(Charset.defaultCharset());
        }
    }
}

