/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.misc;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import yuudaari.soulus.common.config.ConfigInjected;
import yuudaari.soulus.common.config.creature.ConfigCreature;
import yuudaari.soulus.common.config.creature.ConfigCreatureBiome;
import yuudaari.soulus.common.config.creature.ConfigCreatureDimension;
import yuudaari.soulus.common.config.creature.ConfigCreatures;
import yuudaari.soulus.common.config.misc.ConfigMobSpawnItems;

@Mod.EventBusSubscriber
@ConfigInjected(value="soulus")
public class NoMobSpawning {
    @ConfigInjected.Inject
    public static ConfigCreatures CONFIG;
    @ConfigInjected.Inject
    public static ConfigMobSpawnItems CONFIG_SPAWN_ITEMS;
    private static long lastAttemptedSpawn;

    @SubscribeEvent
    public static void onMobJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity == null || !(entity instanceof EntityLiving) || event.getWorld().field_72995_K) {
            return;
        }
        if (NoMobSpawning.wasSpawnedFromItem(event)) {
            return;
        }
        NBTTagCompound entityData = entity.getEntityData();
        if (entityData.func_150297_b("soulus:spawn_whitelisted", 1)) {
            return;
        }
        if (((EntityLiving)entity).func_104002_bU() && entity instanceof EntitySlime) {
            NoMobSpawning.approveSpawn(entity);
            return;
        }
        DimensionType dimension = event.getWorld().field_73011_w.func_186058_p();
        ConfigCreatureDimension dimensionConfig = NoMobSpawning.CONFIG.dimensionConfigs.get(dimension.func_186065_b());
        if (dimensionConfig == null && (dimensionConfig = NoMobSpawning.CONFIG.dimensionConfigs.get("*")) == null) {
            NoMobSpawning.approveSpawn(entity);
            return;
        }
        BlockPos pos = entity.func_180425_c();
        Biome biome = event.getWorld().func_180494_b(pos);
        ConfigCreatureBiome biomeConfig = dimensionConfig.biomeConfigs.get(biome.getRegistryName().toString());
        if (biomeConfig == null && (biomeConfig = dimensionConfig.biomeConfigs.get(biome.getRegistryName().func_110624_b() + ":*")) == null && (biomeConfig = dimensionConfig.biomeConfigs.get("*")) == null) {
            NoMobSpawning.approveSpawn(entity);
            return;
        }
        String entityName = EntityList.func_191301_a((Entity)entity).toString();
        ConfigCreature creatureConfig = biomeConfig.creatureConfigs.get(entityName);
        if (creatureConfig == null && (creatureConfig = biomeConfig.creatureConfigs.get(new ResourceLocation(entityName).func_110624_b() + ":*")) == null && (creatureConfig = biomeConfig.creatureConfigs.get("*")) == null) {
            NoMobSpawning.approveSpawn(entity);
            return;
        }
        if (creatureConfig.spawnChance == 1.0) {
            NoMobSpawning.approveSpawn(entity);
            return;
        }
        if (creatureConfig.spawnChance == 0.0 || event.getWorld().field_73012_v.nextDouble() >= creatureConfig.spawnChance) {
            event.setCanceled(true);
        }
    }

    public static void approveSpawn(Entity entity) {
        entity.getEntityData().func_74774_a("soulus:spawn_whitelisted", (byte)1);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        lastAttemptedSpawn = 0L;
        if (event.isCanceled() || event.getUseItem() == Event.Result.DENY) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (CONFIG_SPAWN_ITEMS.isSpawningItem(stack)) {
            lastAttemptedSpawn = System.currentTimeMillis();
        }
    }

    @SubscribeEvent
    public static void canEntitySpawn(LivingSpawnEvent.CheckSpawn event) {
        lastAttemptedSpawn = 0L;
    }

    private static boolean wasSpawnedFromItem(EntityJoinWorldEvent event) {
        return System.currentTimeMillis() - lastAttemptedSpawn <= 1L;
    }

    static {
        lastAttemptedSpawn = 0L;
    }
}

