/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.misc;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.event.entity.player.SleepingTimeCheckEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import yuudaari.soulus.common.registration.ItemRegistry;
import yuudaari.soulus.common.util.Translation;

@Mod.EventBusSubscriber
public class MidnightDraught {
    private static long startSleepingTime = -1L;
    public static final PotionType POTION_TYPE_SLEEPY = (PotionType)new PotionType("soulus:sleepy", new PotionEffect[]{new PotionEffect((Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation("blindness")), 1200), new PotionEffect((Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation("slowness")), 1200), new PotionEffect((Potion)PotionSleepy.INSTANCE, 1200)}).setRegistryName("soulus", "sleepy");

    @SubscribeEvent
    public static void onTryWakeUp(PlayerWakeUpEvent event) {
        World world = event.getEntityPlayer().field_70170_p;
        if (world.field_72995_K || startSleepingTime == -1L) {
            return;
        }
        for (EntityPlayer player : event.getEntityPlayer().field_70170_p.field_73010_i) {
            if (player.field_71076_b >= 99 && player.func_70644_a((Potion)PotionSleepy.INSTANCE)) continue;
            return;
        }
        if (startSleepingTime > 12500L && startSleepingTime < 19000L) {
            world.func_72877_b(23500L);
        } else if ((startSleepingTime > 23500L || startSleepingTime > 0L) && startSleepingTime < 6000L) {
            world.func_72877_b(13000L);
        } else {
            world.func_72877_b((startSleepingTime + 8000L) % 24000L);
        }
        startSleepingTime = -1L;
        for (EntityPlayer player : event.getEntityPlayer().field_70170_p.field_73010_i) {
            player.func_184589_d((Potion)PotionSleepy.INSTANCE);
            player.func_184589_d((Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation("blindness")));
            player.func_184589_d((Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation("slowness")));
        }
    }

    @SubscribeEvent
    public static void onSleepTimeCheck(SleepingTimeCheckEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        event.setResult(player.func_70644_a((Potion)PotionSleepy.INSTANCE) ? Event.Result.ALLOW : Event.Result.DENY);
        startSleepingTime = player.field_70170_p.func_72820_D() % 24000L;
    }

    @SubscribeEvent
    public static void onSleepLocationCheck(SleepingLocationCheckEvent event) {
        if (event.getEntityPlayer().func_70644_a((Potion)PotionSleepy.INSTANCE)) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    public static void register() {
        ForgeRegistries.POTIONS.register((IForgeRegistryEntry)PotionSleepy.INSTANCE);
        ForgeRegistries.POTION_TYPES.register((IForgeRegistryEntry)POTION_TYPE_SLEEPY);
        ItemStack potionInput = PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185233_e);
        BrewingRecipeRegistry.addRecipe((ItemStack)potionInput, (ItemStack)ItemRegistry.DUST_MIDNIGHT.getItemStack(), (ItemStack)MidnightDraught.getItemStack());
    }

    public static ItemStack getItemStack() {
        ItemStack stack = new ItemStack((Item)Items.field_151068_bn);
        PotionUtils.func_185188_a((ItemStack)stack, (PotionType)POTION_TYPE_SLEEPY);
        return stack;
    }

    public static class PotionSleepy
    extends Potion {
        public static final ResourceLocation POTION_SLEEPY_ICON = new ResourceLocation("soulus", "textures/gui/potion_effect/sleepy.png");
        public static final PotionSleepy INSTANCE = new PotionSleepy();

        public PotionSleepy() {
            super(false, 1709630);
            this.setRegistryName("soulus", "sleepy");
        }

        public String func_76393_a() {
            return Translation.localize("potion.effect.soulus:sleepy.name", new Object[0]);
        }

        public void renderInventoryEffect(int x, int y, PotionEffect effect, Minecraft mc) {
            mc.func_110434_K().func_110577_a(POTION_SLEEPY_ICON);
            Gui.func_146110_a((int)(x + 6), (int)(y + 7), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
        }

        public void renderHUDEffect(int x, int y, PotionEffect effect, Minecraft mc, float alpha) {
            mc.func_110434_K().func_110577_a(POTION_SLEEPY_ICON);
            Gui.func_146110_a((int)(x + 3), (int)(y + 3), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
        }
    }
}

