/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.compat.jei;

import java.util.Collection;
import java.util.List;
import java.util.Random;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import scala.Tuple2;
import yuudaari.soulus.common.compat.jei.JeiDescriptionRegistry;
import yuudaari.soulus.common.compat.jei.RecipeCategoryComposer;
import yuudaari.soulus.common.compat.jei.RecipeCategoryEssence;
import yuudaari.soulus.common.compat.jei.RecipeWrapperComposer;
import yuudaari.soulus.common.compat.jei.RecipeWrapperEssence;
import yuudaari.soulus.common.compat.jei.SubtypeInterpreterEssence;
import yuudaari.soulus.common.config.ConfigInjected;
import yuudaari.soulus.common.config.bones.ConfigBoneType;
import yuudaari.soulus.common.config.bones.ConfigBoneTypes;
import yuudaari.soulus.common.config.essence.ConfigEssence;
import yuudaari.soulus.common.config.essence.ConfigEssences;
import yuudaari.soulus.common.config.misc.ConfigModSupport;
import yuudaari.soulus.common.item.Essence;
import yuudaari.soulus.common.recipe.composer.RecipeComposerShaped;
import yuudaari.soulus.common.recipe.composer.RecipeComposerShapeless;
import yuudaari.soulus.common.registration.BlockRegistry;
import yuudaari.soulus.common.registration.ItemRegistry;

@ConfigInjected(value="soulus")
@JEIPlugin
public class Jei
implements IModPlugin {
    @ConfigInjected.Inject
    public static ConfigBoneTypes CONFIG_BONE_TYPES;
    @ConfigInjected.Inject
    public static ConfigModSupport CONFIG_MOD_SUPPORT;

    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
        subtypeRegistry.registerSubtypeInterpreter((Item)ItemRegistry.ESSENCE, (ISubtypeRegistry.ISubtypeInterpreter)new SubtypeInterpreterEssence());
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper helper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new RecipeCategoryComposer(helper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new RecipeCategoryEssence(helper)});
    }

    public void register(IModRegistry registry) {
        this.registerDescriptions(registry);
        this.registerComposer(registry);
        this.registerEssenceDrops(registry);
    }

    private void registerEssenceDrops(IModRegistry registry) {
        ConfigEssences essences = Essence.CONFIG;
        if (essences.essences.size() == 0) {
            return;
        }
        ConfigEssence essence = null;
        for (int i = 0; i < 100; ++i) {
            essence = essences.essences.get(new Random().nextInt(essences.essences.size()));
            if (!essence.essence.equals("NONE")) break;
        }
        registry.addRecipeCatalyst((Object)Essence.getStack(essence.essence), new String[]{"soulus:essence"});
        registry.handleRecipes(ConfigBoneType.class, RecipeWrapperEssence::new, "soulus:essence");
        registry.addRecipes(Jei.CONFIG_BONE_TYPES.boneTypes, "soulus:essence");
    }

    private void registerComposer(IModRegistry registry) {
        registry.addRecipeCatalyst((Object)BlockRegistry.COMPOSER.getItemStack(), new String[]{"soulus:composer"});
        registry.handleRecipes(RecipeComposerShaped.class, RecipeWrapperComposer::new, "soulus:composer");
        registry.handleRecipes(RecipeComposerShapeless.class, RecipeWrapperComposer::new, "soulus:composer");
        if (Jei.CONFIG_MOD_SUPPORT.jei.showNormalRecipesInComposerTab) {
            registry.handleRecipes(ShapedOreRecipe.class, RecipeWrapperComposer::new, "soulus:composer");
            registry.handleRecipes(ShapedRecipes.class, RecipeWrapperComposer::new, "soulus:composer");
            registry.handleRecipes(ShapelessOreRecipe.class, RecipeWrapperComposer::new, "soulus:composer");
            registry.handleRecipes(ShapelessRecipes.class, RecipeWrapperComposer::new, "soulus:composer");
        }
        registry.addRecipes((Collection)ForgeRegistries.RECIPES.getValues(), "soulus:composer");
    }

    private void registerDescriptions(IModRegistry registry) {
        JeiDescriptionRegistry descriptionRegistry = new JeiDescriptionRegistry();
        ItemRegistry.registerDescriptions(descriptionRegistry);
        BlockRegistry.registerDescriptions(descriptionRegistry);
        for (Tuple2<List<ItemStack>, String> description : descriptionRegistry.ingredients) {
            registry.addIngredientInfo((List)description._1(), ItemStack.class, new String[]{"jei.description." + (String)description._2()});
        }
    }
}

