/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.block.soul_totem;

import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import yuudaari.soulus.Soulus;
import yuudaari.soulus.client.util.ParticleType;
import yuudaari.soulus.common.advancement.Advancements;
import yuudaari.soulus.common.block.soul_totem.SoulTotem;
import yuudaari.soulus.common.block.upgradeable_block.UpgradeableBlockTileEntity;
import yuudaari.soulus.common.config.ConfigInjected;
import yuudaari.soulus.common.config.block.ConfigSoulTotem;
import yuudaari.soulus.common.registration.BlockRegistry;

@ConfigInjected(value="soulus")
public class SoulTotemTileEntity
extends UpgradeableBlockTileEntity {
    @ConfigInjected.Inject
    public static ConfigSoulTotem CONFIG;
    private boolean isConnected = false;
    private float fuelTimeRemaining = 0.0f;
    private int signalStrength = 0;
    private int timeTillNextStructureValidation = 0;
    @Nullable
    private UUID owner;
    private boolean isActive = false;
    private byte kickstartCost = 0;
    ForgeChunkManager.Ticket ticket = null;
    public float scale = 0.0f;
    public float lastScale = 0.0f;
    public float rotation;
    public float lastRotation = this.rotation = new Random().nextFloat() * 360.0f;
    private float velocity = 0.0f;
    private float timeTillParticle = 0.0f;

    public SoulTotem getBlock() {
        return BlockRegistry.SOUL_TOTEM;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public int getSignalStrength() {
        return this.isActive ? (int)Math.floor(14.0f * this.getFuelPercent()) + 1 : 0;
    }

    public float getFuelPercent() {
        return this.fuelTimeRemaining / (float)SoulTotemTileEntity.CONFIG.soulCatalystFuelTime;
    }

    public void setOwner(EntityPlayer owner) {
        this.owner = owner.func_110124_au();
    }

    @Nullable
    public EntityPlayer getOwner() {
        return this.owner == null ? null : this.field_145850_b.func_152378_a(this.owner);
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void func_73660_a() {
        if (this.timeTillNextStructureValidation-- <= 0) {
            this.timeTillNextStructureValidation = 20;
            this.validateStructure();
        }
        this.updateIsActive();
        if (this.isActive) {
            this.createChunkLoader();
            if (this.fuelTimeRemaining <= 0.0f) {
                this.upgrades.put(SoulTotem.Upgrade.SOUL_CATALYST, (Integer)this.upgrades.get(SoulTotem.Upgrade.SOUL_CATALYST) - 1);
                this.fuelTimeRemaining += (float)SoulTotemTileEntity.CONFIG.soulCatalystFuelTime;
                this.blockUpdate();
            } else {
                this.fuelTimeRemaining = (float)((double)this.fuelTimeRemaining - SoulTotemTileEntity.CONFIG.efficiencyUpgradesRange.get((double)((Integer)this.upgrades.get(SoulTotem.Upgrade.EFFICIENCY)).intValue() / (double)SoulTotem.Upgrade.EFFICIENCY.getMaxQuantity()));
            }
        } else {
            if (this.kickstartCost < 100) {
                this.kickstartCost = (byte)(this.kickstartCost + 1);
            }
            this.removeChunkLoader();
        }
        this.updateSignalStrength();
        if (this.field_145850_b.field_72995_K) {
            this.updateRenderer();
        }
    }

    public void updateIsActive() {
        boolean isActive;
        boolean bl = isActive = !(!this.isConnected || (Integer)this.upgrades.get(SoulTotem.Upgrade.SOUL_CATALYST) <= 0 && !(this.fuelTimeRemaining > 0.0f) || SoulTotemTileEntity.CONFIG.canDisableWithRedstone && this.field_145850_b.func_175687_A(this.field_174879_c) != 0);
        if (this.isActive == isActive) {
            return;
        }
        this.isActive = isActive;
        if (isActive && !this.field_145850_b.field_72995_K) {
            this.fuelTimeRemaining -= (float)SoulTotemTileEntity.CONFIG.kickstartFuelUse * Math.min(100.0f, (float)this.kickstartCost) / 100.0f;
            this.kickstartCost = 0;
        }
        this.blockUpdate();
    }

    private void updateSignalStrength() {
        int signalStrength;
        int n = signalStrength = this.fuelTimeRemaining <= 0.0f ? 0 : (int)Math.floor(15.0f * this.getFuelPercent()) + 1;
        if (signalStrength != this.signalStrength) {
            this.signalStrength = signalStrength;
            this.func_70296_d();
        }
    }

    private void createChunkLoader() {
        if (this.ticket == null && this.isActive) {
            if (SoulTotemTileEntity.CONFIG.isChunkloader) {
                this.ticket = ForgeChunkManager.requestTicket((Object)Soulus.INSTANCE, (World)this.field_145850_b, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
                if (this.ticket != null) {
                    ChunkPos cp = new ChunkPos(this.field_174879_c);
                    for (int x = -1; x < 2; ++x) {
                        for (int z = -1; z < 3; ++z) {
                            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkPos)new ChunkPos(cp.field_77276_a + x, cp.field_77275_b + z));
                        }
                    }
                }
            } else {
                this.removeChunkLoader();
            }
        }
    }

    private void removeChunkLoader() {
        if (this.ticket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
            this.ticket = null;
        }
    }

    public void onLoad() {
        this.createChunkLoader();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.removeChunkLoader();
    }

    private void validateStructure() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        boolean structureValid = this.getBlock().structure.isValid(this.field_145850_b, this.field_174879_c);
        if ((Boolean)state.func_177229_b((IProperty)SoulTotem.CONNECTED) != structureValid) {
            this.field_145850_b.func_180501_a(this.field_174879_c, state.func_177226_a((IProperty)SoulTotem.CONNECTED, (Comparable)Boolean.valueOf(structureValid)), 3);
            if (structureValid) {
                Advancements.CONSTRUCT.trigger(this.getOwner(), this.getBlock());
            }
        }
        this.isConnected = structureValid;
    }

    @Override
    public void onReadFromNBT(NBTTagCompound compound) {
        this.fuelTimeRemaining = compound.func_74760_g("fuel_time_remaining");
        this.isActive = compound.func_74767_n("active");
        this.kickstartCost = compound.func_74771_c("kickstart_cost");
        String ownerString = compound.func_74779_i("owner");
        this.owner = ownerString == "" ? null : UUID.fromString(ownerString);
    }

    @Override
    public void onWriteToNBT(NBTTagCompound compound) {
        compound.func_74776_a("fuel_time_remaining", this.fuelTimeRemaining);
        compound.func_74757_a("active", this.isActive);
        compound.func_74774_a("kickstart_cost", this.kickstartCost);
        if (this.owner != null) {
            compound.func_74778_a("owner", this.owner.toString());
        }
    }

    private void updateRenderer() {
        this.lastScale = this.scale;
        this.lastRotation = this.rotation;
        if (this.isActive) {
            this.velocity = (float)((double)this.velocity + 0.1);
            this.scale += (1.0f - this.scale) / 20.0f;
        } else {
            this.scale = (float)((double)this.scale - (0.005 + (double)((1.0f - this.scale) / 20.0f)));
        }
        this.velocity = (float)((double)this.velocity * 0.9);
        this.scale = Math.min(1.0f, Math.max(0.0f, this.scale));
        this.rotation += this.velocity;
        if (!this.isActive) {
            return;
        }
        double particleCount = SoulTotemTileEntity.CONFIG.particleCountIn;
        if (particleCount < 1.0) {
            this.timeTillParticle = (float)((double)this.timeTillParticle + (0.01 + particleCount));
            if (this.timeTillParticle < 1.0f) {
                return;
            }
        }
        this.timeTillParticle = 0.0f;
        int i = 0;
        while ((double)i < particleCount) {
            double d3 = (float)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextFloat();
            double d2 = this.field_145850_b.field_73012_v.nextFloat();
            double d4 = (double)this.field_174879_c.func_177956_o() + d2;
            double d5 = (float)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextFloat();
            this.field_145850_b.func_175720_a(ParticleType.SOUL_TOTEM.getId(), false, d3, d4 + 0.6, d5, d3 - (double)this.field_174879_c.func_177958_n() - 0.5, -d2 * 1.6, d5 - (double)this.field_174879_c.func_177952_p() - 0.5, new int[]{1});
            ++i;
        }
    }
}

