/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.block.skewer;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import yuudaari.soulus.common.block.skewer.SkewerTileEntity;
import yuudaari.soulus.common.block.upgradeable_block.UpgradeableBlock;
import yuudaari.soulus.common.block.upgradeable_block.UpgradeableBlockTileEntity;
import yuudaari.soulus.common.config.ConfigInjected;
import yuudaari.soulus.common.config.block.ConfigSkewer;
import yuudaari.soulus.common.item.CrystalBlood;
import yuudaari.soulus.common.item.SoulCatalyst;
import yuudaari.soulus.common.registration.BlockRegistry;
import yuudaari.soulus.common.registration.ItemRegistry;
import yuudaari.soulus.common.util.Material;
import yuudaari.soulus.common.util.Translation;

@ConfigInjected(value="soulus")
public class Skewer
extends UpgradeableBlock<SkewerTileEntity> {
    @ConfigInjected.Inject
    public static ConfigSkewer CONFIG;
    public static final PropertyDirection FACING;
    public static final PropertyBool EXTENDED;

    @Override
    public UpgradeableBlock.IUpgrade[] getUpgrades() {
        return Upgrade.values();
    }

    public Skewer() {
        super("skewer", new Material(MapColor.field_151670_w));
        this.setHasItem();
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)EXTENDED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.setHarvestLevel("pickaxe", 1);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(3.0f);
        this.setHasDescription();
    }

    @Override
    public UpgradeableBlock<SkewerTileEntity> getInstance() {
        return BlockRegistry.SKEWER;
    }

    @Override
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        SkewerTileEntity te = (SkewerTileEntity)world.func_175625_s(pos);
        if (te == null) {
            return;
        }
        if (placer instanceof EntityPlayer) {
            te.setOwner((EntityPlayer)placer);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.updateExtendedState(state, world, pos);
    }

    public void updateExtendedState(IBlockState state, World world, BlockPos pos) {
        int power = world.func_175687_A(pos);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        BlockPos spikePos = pos.func_177972_a(facing);
        Block blockAtSpikePos = world.func_180495_p(spikePos).func_177230_c();
        boolean spikeBlocked = !blockAtSpikePos.equals(Blocks.field_150350_a) && !blockAtSpikePos.func_176200_f((IBlockAccess)world, spikePos);
        boolean shouldBeExtended = power > 0 && !spikeBlocked;
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof SkewerTileEntity && (Integer)((SkewerTileEntity)te).upgrades.get(Upgrade.POWER) > 0) {
            boolean bl = shouldBeExtended = !shouldBeExtended;
        }
        if ((Boolean)state.func_177229_b((IProperty)EXTENDED) != shouldBeExtended) {
            world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)EXTENDED, (Comparable)Boolean.valueOf(shouldBeExtended)), 11);
            world.func_184133_a(null, pos, SoundEvents.field_187715_dR, SoundCategory.BLOCKS, 0.5f, world.field_73012_v.nextFloat() * 0.25f + 0.6f);
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, EXTENDED});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)EXTENDED, (Comparable)Boolean.valueOf((meta & 1) != 0)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta / 2)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() * 2 + ((Boolean)state.func_177229_b((IProperty)EXTENDED) != false ? 1 : 0);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        int power = world.func_175687_A(pos);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer)).func_177226_a((IProperty)EXTENDED, (Comparable)Boolean.valueOf(power > 0));
    }

    @Override
    public boolean hasTileEntity(IBlockState blockState) {
        return true;
    }

    @Override
    public Class<? extends UpgradeableBlockTileEntity> getTileEntityClass() {
        return SkewerTileEntity.class;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean isActualState) {
        EnumFacing facing;
        AxisAlignedBB box;
        Skewer.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)state.func_185890_d((IBlockAccess)worldIn, pos));
        if (((Boolean)state.func_177229_b((IProperty)EXTENDED)).booleanValue() && entityBox.func_72326_a(box = Skewer.getSpikeHitbox(facing = (EnumFacing)state.func_177229_b((IProperty)FACING), pos))) {
            if (facing == EnumFacing.UP) {
                if (entityBox.func_72326_a(this.getUpwardsCollisionBoxBottom(facing, pos)) && entityBox.func_72326_a(this.getUpwardsCollisionBoxTop(facing, pos))) {
                    collidingBoxes.add(box);
                }
            } else if (facing.func_176740_k() != EnumFacing.Axis.Y && (entityBox.func_72326_a(this.getHorizontalCollisionBoxTop(facing, pos)) || entityBox.func_72326_a(this.getHorizontalCollisionBoxSideLeft(facing, pos)) || entityBox.func_72326_a(this.getHorizontalCollisionBoxSideRight(facing, pos)))) {
                collidingBoxes.add(box);
            }
        }
    }

    public static AxisAlignedBB getSpikeHitbox(EnumFacing facing, BlockPos pos) {
        AxisAlignedBB result = new AxisAlignedBB(pos.func_177972_a(facing));
        double topPadding = 0.3;
        double sidePadding = 0.2;
        return result.func_191195_a(facing.func_82601_c() == 1 ? 0.3 : 0.4, facing.func_96559_d() == 1 ? 0.3 : 0.4, facing.func_82599_e() == 1 ? 0.3 : 0.4).func_72317_d(facing.func_82601_c() == 1 ? 0.0 : 0.2, facing.func_96559_d() == 1 ? 0.0 : 0.2, facing.func_82599_e() == 1 ? 0.0 : 0.2);
    }

    private AxisAlignedBB getHorizontalCollisionBoxTop(EnumFacing facing, BlockPos pos) {
        return this.contract(this.contract(new AxisAlignedBB(pos.func_177972_a(facing).func_177981_b(2)), EnumFacing.UP, 0.5), EnumFacing.DOWN, 0.25);
    }

    private AxisAlignedBB getHorizontalCollisionBoxSideLeft(EnumFacing facing, BlockPos pos) {
        EnumFacing side = facing.func_176735_f();
        return this.contract(new AxisAlignedBB(pos.func_177972_a(facing).func_177972_a(side)), side.func_176734_d(), 0.4);
    }

    private AxisAlignedBB getHorizontalCollisionBoxSideRight(EnumFacing facing, BlockPos pos) {
        EnumFacing side = facing.func_176746_e();
        return this.contract(new AxisAlignedBB(pos.func_177972_a(facing).func_177972_a(side)), side.func_176734_d(), 0.4);
    }

    private AxisAlignedBB getUpwardsCollisionBoxBottom(EnumFacing facing, BlockPos pos) {
        return this.contract(Skewer.getSpikeHitbox(facing, pos), facing, 0.69);
    }

    private AxisAlignedBB getUpwardsCollisionBoxTop(EnumFacing facing, BlockPos pos) {
        return this.offset(this.getUpwardsCollisionBoxBottom(facing, pos), facing, 0.69);
    }

    private AxisAlignedBB offset(AxisAlignedBB box, EnumFacing facing, double n) {
        return box.func_72317_d((double)facing.func_82601_c() * n, (double)facing.func_96559_d() * n, (double)facing.func_82599_e() * n);
    }

    private AxisAlignedBB contract(AxisAlignedBB box, EnumFacing facing, double n) {
        return box.func_191195_a((double)facing.func_82601_c() * n, (double)facing.func_96559_d() * n, (double)facing.func_82599_e() * n);
    }

    @Override
    protected void onWailaTooltipHeader(List<String> currentTooltip, IBlockState blockState, SkewerTileEntity te, EntityPlayer player) {
        currentTooltip.add(Translation.localize("waila.soulus" + ((Boolean)blockState.func_177229_b((IProperty)EXTENDED) != false ? ":skewer.extended" : ":skewer.not_extended"), new Object[0]));
        if ((Integer)te.upgrades.get(Upgrade.CRYSTAL_BLOOD) == 1) {
            currentTooltip.add(new Translation("waila.soulus:skewer.crystal_blood_stored_blood", new Object[0]).addArgs(te.crystalBloodContainedBlood, CrystalBlood.CONFIG.requiredBlood).get(new Object[0]));
        }
    }

    static {
        FACING = PropertyDirection.func_177714_a((String)"facing");
        EXTENDED = PropertyBool.func_177716_a((String)"extended");
    }

    public static enum Upgrade implements UpgradeableBlock.IUpgrade
    {
        CRYSTAL_BLOOD(0, "crystal_blood", ItemRegistry.CRYSTAL_BLOOD.getItemStack()),
        DAMAGE(1, "damage", new ItemStack(Items.field_151128_bU)),
        POISON(2, "poison", new ItemStack(Items.field_151070_bp)),
        POWER(3, "power", new ItemStack(Blocks.field_150429_aA)),
        TETHER(4, "tether", ItemRegistry.ASH.getItemStack()),
        PLAYER(5, "player", ItemRegistry.SOUL_CATALYST.getItemStack());

        private final int index;
        private final String name;
        private final ItemStack stack;
        private Integer maxQuantity;

        private Upgrade(int index, String name, ItemStack item) {
            this.index = index;
            this.name = name;
            this.stack = item;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getMaxQuantity() {
            if (this.maxQuantity == null) {
                if (this.name.equals("crystal_blood")) {
                    return 1;
                }
                if (this.name.equals("damage")) {
                    return 64;
                }
                if (this.name.equals("poison")) {
                    return 16;
                }
                if (this.name.equals("power")) {
                    return 1;
                }
                if (this.name.equals("tether")) {
                    return 16;
                }
                if (this.name.equals("player")) {
                    return 1;
                }
                if (this.name.equals("looting")) {
                    return 64;
                }
            }
            return this.maxQuantity;
        }

        @Override
        public boolean canOverrideMaxQuantity() {
            return !this.name.equals("crystal_blood") && !this.name.equals("player");
        }

        @Override
        public void setMaxQuantity(int quantity) {
            this.maxQuantity = quantity;
        }

        @Override
        public boolean isItemStack(ItemStack stack) {
            if (stack.func_77973_b() != this.stack.func_77973_b()) {
                return false;
            }
            if (this.name == "crystal_blood") {
                return !CrystalBlood.isFilled(stack);
            }
            if (this.name == "player") {
                return SoulCatalyst.isFilled(stack);
            }
            return true;
        }

        @Override
        public ItemStack getItemStack(int quantity) {
            ItemStack stack = new ItemStack(this.stack.func_77973_b(), quantity);
            if (this.name == "player") {
                SoulCatalyst.setFilled(stack);
            }
            return stack;
        }

        @Override
        public ItemStack getItemStackForTileEntity(UpgradeableBlockTileEntity te, int quantity) {
            ItemStack stack = this.getItemStack(quantity);
            if (this.name == "crystal_blood") {
                SkewerTileEntity ste = (SkewerTileEntity)te;
                CrystalBlood.setContainedBlood(stack, Math.min(CrystalBlood.CONFIG.requiredBlood, ste.crystalBloodContainedBlood));
            }
            return stack;
        }
    }
}

