/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.block.enderlink;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import yuudaari.soulus.common.block.DustEnderBlock;
import yuudaari.soulus.common.block.enderlink.EnderlinkTileEntity;
import yuudaari.soulus.common.block.upgradeable_block.UpgradeableBlock;
import yuudaari.soulus.common.block.upgradeable_block.UpgradeableBlockTileEntity;
import yuudaari.soulus.common.config.ConfigInjected;
import yuudaari.soulus.common.config.block.ConfigEnderlink;
import yuudaari.soulus.common.item.OrbMurky;
import yuudaari.soulus.common.registration.BlockRegistry;
import yuudaari.soulus.common.registration.ItemRegistry;
import yuudaari.soulus.common.util.Material;
import yuudaari.soulus.common.util.Translation;

@ConfigInjected(value="soulus")
public class Enderlink
extends UpgradeableBlock<EnderlinkTileEntity> {
    private static final Map<Long, Set<BlockPos>> ENDERLINKS = new HashMap<Long, Set<BlockPos>>();
    @ConfigInjected.Inject
    public static ConfigEnderlink CONFIG;
    public static final PropertyDirection FACING;

    private static long getChunkPosition(BlockPos pos) {
        return Enderlink.getChunkPosition(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    private static long getChunkPosition(int cx, int cz) {
        return (long)cx * Integer.MAX_VALUE + (long)cz;
    }

    public static Set<BlockPos> getEnderlinksInChunk(BlockPos pos) {
        return Enderlink.getEnderlinksInChunk(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    public static Set<BlockPos> getEnderlinksInChunk(int cx, int cz) {
        long cp = Enderlink.getChunkPosition(cx, cz);
        HashSet enderlinks = ENDERLINKS.get(cp);
        return enderlinks == null ? new HashSet() : enderlinks;
    }

    public static void notifyEnderlink(EnderlinkTileEntity te) {
        long cp = Enderlink.getChunkPosition(te.func_174877_v());
        Set<BlockPos> enderlinks = ENDERLINKS.get(cp);
        if (enderlinks == null) {
            enderlinks = new HashSet<BlockPos>();
            ENDERLINKS.put(cp, enderlinks);
        }
        enderlinks.add(te.func_174877_v());
    }

    @Override
    public UpgradeableBlock.IUpgrade[] getUpgrades() {
        return Upgrade.values();
    }

    public Enderlink() {
        super("enderlink", new Material(MapColor.field_151665_m).setTransparent());
        this.setHasItem();
        this.func_149711_c(5.0f);
        this.func_149752_b(30.0f);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149649_H();
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP));
        this.setHasDescription();
        this.registerWailaProvider(DustEnderBlock.class);
    }

    @Override
    public UpgradeableBlock<EnderlinkTileEntity> getInstance() {
        return BlockRegistry.ENDERLINK;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer));
    }

    @Override
    public boolean hasTileEntity(IBlockState blockState) {
        return true;
    }

    @Override
    public Class<? extends UpgradeableBlockTileEntity> getTileEntityClass() {
        return EnderlinkTileEntity.class;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        Enderlink.notifyEnderlink((EnderlinkTileEntity)world.func_175625_s(pos));
    }

    @Override
    public void onBlockDestroy(World world, BlockPos pos, int fortune, EntityPlayer player) {
        long cp = Enderlink.getChunkPosition(pos);
        Set<BlockPos> enderlinks = ENDERLINKS.get(cp);
        if (enderlinks != null) {
            enderlinks.remove(pos);
            if (enderlinks.size() == 0) {
                ENDERLINKS.remove(cp);
            }
        }
        super.onBlockDestroy(world, pos, fortune, player);
    }

    @Override
    public boolean onActivateInsert(World world, BlockPos pos, EntityPlayer player, ItemStack stack) {
        Item item = stack.func_77973_b();
        EnderlinkTileEntity te = (EnderlinkTileEntity)world.func_175625_s(pos);
        if (item.equals(Items.field_151100_aR) && te.setColor(EnumDyeColor.func_176766_a((int)stack.func_77952_i()))) {
            stack.func_190918_g(1);
            return true;
        }
        return super.onActivateInsert(world, pos, player, stack);
    }

    @Override
    protected void onWailaTooltipHeader(List<String> currentTooltip, IBlockState blockState, EnderlinkTileEntity te, EntityPlayer player) {
        if (te == null) {
            return;
        }
        currentTooltip.add(Translation.localize("waila.soulus:misc.color." + te.color.func_192396_c(), new Object[0]));
    }

    static {
        FACING = PropertyDirection.func_177714_a((String)"facing");
    }

    public static enum Upgrade implements UpgradeableBlock.IUpgrade
    {
        RANGE(2, "range", ItemRegistry.ORB_MURKY.getItemStack());

        private final int index;
        private final String name;
        private final ItemStack stack;
        private int maxQuantity = 16;

        private Upgrade(int index, String name, ItemStack item) {
            this.index = index;
            this.name = name;
            this.stack = item;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getMaxQuantity() {
            return this.maxQuantity;
        }

        @Override
        public void setMaxQuantity(int quantity) {
            this.maxQuantity = quantity;
        }

        @Override
        public boolean isItemStack(ItemStack stack) {
            if (stack.func_77973_b() != this.stack.func_77973_b()) {
                return false;
            }
            if (this.name == "range") {
                return OrbMurky.isFilled(stack);
            }
            return true;
        }

        @Override
        public ItemStack getItemStack(int quantity) {
            ItemStack stack = new ItemStack(this.stack.func_77973_b(), quantity);
            if (this.name == "range") {
                OrbMurky.setFilled(stack);
            }
            return stack;
        }
    }
}

