/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.block;

import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import yuudaari.soulus.common.block.upgradeable_block.UpgradeableBlockTileEntity;
import yuudaari.soulus.common.registration.Registration;
import yuudaari.soulus.common.util.Material;

public class Unloader
extends Registration.Block {
    public Unloader() {
        super("unloader", new Material(MapColor.field_151665_m));
        this.setHasItem();
        this.setHarvestLevel("pickaxe", 1);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(3.0f);
        this.setHasDescription();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Override
    public Class<? extends TileEntity> getTileEntityClass() {
        return UnloaderTileEntity.class;
    }

    public TileEntity createTileEntity(World worldIn, IBlockState blockState) {
        return new UnloaderTileEntity();
    }

    public static class UnloaderTileEntity
    extends TileEntity
    implements ITickable {
        public ItemHandler itemHandler = new ItemHandler(this);

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemHandler);
            }
            return (T)super.getCapability(capability, facing);
        }

        public void func_145839_a(NBTTagCompound compound) {
            this.itemHandler = new ItemHandler(this);
            this.itemHandler.deserializeNBT(compound.func_74775_l("item_handler"));
            super.func_145839_a(compound);
        }

        public NBTTagCompound func_189515_b(NBTTagCompound compound) {
            compound.func_74782_a("item_handler", (NBTBase)this.itemHandler.serializeNBT());
            return super.func_189515_b(compound);
        }

        public void func_73660_a() {
            ItemStack stack = this.itemHandler.getStackInSlot(0);
            if (!stack.func_190926_b()) {
                UpgradeableBlockTileEntity.dispenseItem(stack, this.field_145850_b, this.field_174879_c, EnumFacing.DOWN);
                this.itemHandler.setStackInSlot(0, ItemStack.field_190927_a);
            }
        }

        public boolean canUnload() {
            IBlockState below = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
            if (below.func_185913_b()) {
                return false;
            }
            if (below.func_177230_c() instanceof BlockTrapDoor) {
                return (Boolean)below.func_177229_b((IProperty)BlockTrapDoor.field_176283_b);
            }
            return true;
        }

        public static class ItemHandler
        extends ItemStackHandler {
            private UnloaderTileEntity te;

            public ItemHandler(UnloaderTileEntity te) {
                this.te = te;
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                if (!this.te.canUnload()) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }

            protected void onContentsChanged(int slot) {
                this.te.func_70296_d();
            }
        }
    }
}

