/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.block;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import yuudaari.soulus.common.CreativeTab;
import yuudaari.soulus.common.block.EndersteelType;
import yuudaari.soulus.common.config.ConfigInjected;
import yuudaari.soulus.common.config.block.ConfigSummoner;
import yuudaari.soulus.common.registration.IBlockRegistration;
import yuudaari.soulus.common.registration.Registration;
import yuudaari.soulus.common.util.Material;
import yuudaari.soulus.common.util.Translation;

@ConfigInjected(value="soulus")
public class BarsEndersteel
extends Registration.BlockPane {
    @ConfigInjected.Inject
    public static ConfigSummoner CONFIG;
    public static final IProperty<EndersteelType> VARIANT;

    public BarsEndersteel() {
        super("bars_endersteel", new Material(MapColor.field_151661_c));
        this.setHasItem();
        this.func_149711_c(5.0f);
        this.func_149752_b(30.0f);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EndersteelType.NORMAL)));
        this.setHasDescription();
        this.registerWailaProvider(BarsEndersteel.class);
    }

    protected BlockStateContainer func_180661_e() {
        ArrayList<IProperty<EndersteelType>> props = new ArrayList<IProperty<EndersteelType>>(super.func_180661_e().func_177623_d());
        props.add(VARIANT);
        return new BlockStateContainer((Block)this, props.toArray(new IProperty[0]));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EndersteelType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EndersteelType)((Object)state.func_177229_b(VARIANT))).getMeta();
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EndersteelType enumType : EndersteelType.values()) {
            list.add((Object)new ItemStack((Block)this, 1, enumType.getMeta()));
        }
    }

    @Override
    public Registration.ItemBlock createItemBlock() {
        return new Registration.ItemBlock(this){

            public int func_77647_b(int damage) {
                return damage;
            }

            @SideOnly(value=Side.CLIENT)
            public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
                tooltip.add(Translation.localize("tooltip.soulus:summoner.style." + EndersteelType.byMetadata(stack.func_77952_i()).func_176610_l(), new Object[0]));
            }
        }.setHasSubtypes(true);
    }

    @Override
    public void registerItemModel() {
        NonNullList stacks = NonNullList.func_191196_a();
        this.func_149666_a(CreativeTab.INSTANCE, (NonNullList<ItemStack>)stacks);
        for (ItemStack stack : stacks) {
            String variantName = EndersteelType.byMetadata(stack.func_77960_j()).func_176610_l();
            ModelResourceLocation model = new ModelResourceLocation(this.getRegistryName() + "/" + variantName, "inventory;" + VARIANT.func_177701_a() + "=" + variantName);
            ModelLoader.setCustomModelResourceLocation((Item)this.getItemBlock(), (int)stack.func_77960_j(), (ModelResourceLocation)model);
        }
    }

    @Override
    public void onRegisterRecipes(IForgeRegistry<IRecipe> registry) {
        registry.registerAll((IForgeRegistryEntry[])BarsEndersteel.CONFIG.styleItems.entrySet().stream().map(item -> {
            ArrayList<Object> recipe = new ArrayList<Object>();
            recipe.add(ForgeRegistries.ITEMS.getValue(new ResourceLocation((String)item.getKey())));
            recipe.addAll(Collections.nCopies(8, this.getIngredientFromStacksOfOtherEndersteelTypes((EndersteelType)((Object)((Object)item.getValue())))));
            return (IRecipe)new ShapelessOreRecipe(null, this.getStackFromEndersteelType((EndersteelType)((Object)((Object)item.getValue())), 8), recipe.toArray(new Object[0])).setRegistryName(this.getRegistryName() + "_" + ((EndersteelType)((Object)((Object)item.getValue()))).func_176610_l().toLowerCase());
        }).toArray(ShapelessOreRecipe[]::new));
    }

    public ItemStack getStackFromEndersteelType(EndersteelType type) {
        return this.getStackFromEndersteelType(type, 1);
    }

    public ItemStack getStackFromEndersteelType(EndersteelType type, int count) {
        return this.getItemStack(count, this.func_176201_c(this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)type))));
    }

    private Ingredient getIngredientFromStacksOfOtherEndersteelTypes(EndersteelType type) {
        return Ingredient.func_193369_a((ItemStack[])((ItemStack[])Arrays.stream(EndersteelType.values()).filter(e -> e != type).map(e -> this.getStackFromEndersteelType((EndersteelType)((Object)e))).toArray(ItemStack[]::new)));
    }

    @Override
    public final List<String> getWailaTooltip(List<String> currentTooltip, IBlockRegistration.IDataAccessor accessor) {
        String variant = ((EndersteelType)((Object)accessor.getBlockState().func_177229_b(VARIANT))).func_176610_l();
        currentTooltip.add(Translation.localize("tooltip.soulus:summoner.style." + variant, new Object[0]));
        return currentTooltip;
    }

    static {
        VARIANT = PropertyEnum.func_177709_a((String)"variant", EndersteelType.class);
    }
}

