/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.client.exporter.exports;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IShapedRecipe;
import yuudaari.soulus.common.recipe.RecipeFurnace;
import yuudaari.soulus.common.recipe.composer.IRecipeComposer;
import yuudaari.soulus.common.util.serializer.CollectionSerializer;
import yuudaari.soulus.common.util.serializer.Serializable;
import yuudaari.soulus.common.util.serializer.Serialized;

@Serializable
public class RecipeExport {
    @Serialized
    public final String name;
    @Serialized
    public final String type;
    @Serialized
    public final StackExport output;
    @Serialized(value=IngredientListSerializer.class)
    public final List<IngredientExport> ingredients;
    @Serialized
    public final float compositionTime;

    public RecipeExport(IRecipe recipe) {
        this.name = recipe.getRegistryName().toString();
        this.type = this.getRecipeType(recipe);
        this.output = new StackExport(recipe.func_77571_b());
        this.compositionTime = recipe instanceof IRecipeComposer ? ((IRecipeComposer)recipe).getTime() : 1.0f;
        this.ingredients = recipe.func_192400_c().stream().map(ingredient -> new IngredientExport((Ingredient)ingredient)).collect(Collectors.toList());
    }

    private String getRecipeType(IRecipe recipe) {
        if (recipe instanceof RecipeFurnace) {
            return "furnace";
        }
        if (recipe instanceof IRecipeComposer) {
            return recipe instanceof IShapedRecipe ? "composer_shaped" : "composer_shapeless";
        }
        return recipe instanceof IShapedRecipe ? "craft_shaped" : "craft_shapeless";
    }

    public static class IngredientListSerializer
    extends CollectionSerializer<IngredientExport> {
        @Override
        public Class<IngredientExport> getValueClass() {
            return IngredientExport.class;
        }
    }

    public static class StackListSerializer
    extends CollectionSerializer<StackExport> {
        @Override
        public Class<StackExport> getValueClass() {
            return StackExport.class;
        }
    }

    @Serializable
    public static class IngredientExport {
        @Serialized(value=IngredientListSerializer.class)
        public final List<StackExport> matchingStacks;

        public IngredientExport(Ingredient ingredient) {
            this.matchingStacks = Arrays.stream(ingredient.func_193365_a()).map(stack -> new StackExport((ItemStack)stack)).collect(Collectors.toList());
        }
    }

    @Serializable
    public static class StackExport {
        @Serialized
        public final String item;
        @Serialized
        public final int data;
        @Serialized
        public final String nbt;
        @Serialized
        public final int count;

        public StackExport(ItemStack stack) {
            this.item = stack.func_77973_b().getRegistryName().toString();
            this.data = stack.func_77960_j();
            this.nbt = stack.func_77942_o() ? stack.func_77978_p().toString() : "";
            this.count = stack.func_190916_E();
        }
    }
}

