/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.client.exporter;

import com.google.common.io.Files;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class Renderer {
    private static final int SIZE = 64;
    private static float oldZLevel;

    public static void setUpRenderState() {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution res = new ScaledResolution(mc);
        int size = Math.min(Math.min(mc.field_71440_d, mc.field_71443_c), 64);
        mc.field_71460_t.func_78478_c();
        RenderHelper.func_74520_c();
        float scale = (float)size / (16.0f * (float)res.func_78325_e());
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(-(scale * 100.0f)));
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        oldZLevel = mc.func_175599_af().field_77023_b;
        mc.func_175599_af().field_77023_b = -50.0f;
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
        GlStateManager.func_179126_j();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)770, (int)1);
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179118_c();
    }

    public static void tearDownRenderState() {
        GlStateManager.func_179140_f();
        GlStateManager.func_179119_h();
        GlStateManager.func_179097_i();
        GlStateManager.func_179084_k();
        Minecraft.func_71410_x().func_175599_af().field_77023_b = oldZLevel;
    }

    public static String render(ItemStack stack, String baseFilename, File folder) {
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.func_179094_E();
        GlStateManager.func_179082_a((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179086_m((int)16640);
        mc.func_175599_af().func_180450_b(stack, 0, 0);
        GlStateManager.func_179121_F();
        try {
            BufferedImage img = Renderer.createFlipped(Renderer.readPixels(64, 64));
            String filename = baseFilename + ".png";
            File f = new File(folder, filename);
            int i = 2;
            while (f.exists()) {
                filename = baseFilename + "_" + i + ".png";
                f = new File(folder, filename);
                ++i;
            }
            Files.createParentDirs((File)f);
            f.createNewFile();
            ImageIO.write((RenderedImage)img, "PNG", f);
            return filename;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static BufferedImage readPixels(int width, int height) throws InterruptedException {
        GL11.glReadBuffer((int)1029);
        ByteBuffer buf = BufferUtils.createByteBuffer((int)(width * height * 4));
        GL11.glReadPixels((int)0, (int)(Minecraft.func_71410_x().field_71440_d - height), (int)width, (int)height, (int)32993, (int)5121, (ByteBuffer)buf);
        BufferedImage img = new BufferedImage(width, height, 2);
        int[] pixels = new int[width * height];
        buf.asIntBuffer().get(pixels);
        img.setRGB(0, 0, width, height, pixels, 0, width);
        return img;
    }

    private static BufferedImage createFlipped(BufferedImage image) {
        AffineTransform at = new AffineTransform();
        at.concatenate(AffineTransform.getScaleInstance(1.0, -1.0));
        at.concatenate(AffineTransform.getTranslateInstance(0.0, -image.getHeight()));
        return Renderer.createTransformed(image, at);
    }

    private static BufferedImage createTransformed(BufferedImage image, AffineTransform at) {
        BufferedImage newImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g = newImage.createGraphics();
        g.transform(at);
        g.drawImage((Image)image, 0, 0, null);
        g.dispose();
        return newImage;
    }
}

