/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.mods.itemfilters.filters;

import com.latmod.mods.itemfilters.api.IItemFilter;
import com.latmod.mods.itemfilters.api.ItemFiltersAPI;
import com.latmod.mods.itemfilters.filters.LogicFilter;
import com.latmod.mods.itemfilters.item.ItemMissing;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.INBTSerializable;

public class ORFilter
extends LogicFilter
implements INBTSerializable<NBTTagList> {
    public final List<ItemStack> items = new ArrayList<ItemStack>();

    @Override
    public String getID() {
        return "or";
    }

    @Override
    public boolean filter(ItemStack stack) {
        if (this.items.size() == 1) {
            return ItemFiltersAPI.filter(this.items.get(0), stack);
        }
        for (ItemStack stack1 : this.items) {
            if (!ItemFiltersAPI.filter(stack1, stack)) continue;
            return true;
        }
        return false;
    }

    public NBTTagList serializeNBT() {
        NBTTagList list = new NBTTagList();
        for (ItemStack stack : this.items) {
            if (stack.func_190926_b()) continue;
            list.func_74742_a(ItemMissing.write(stack, true));
        }
        return list;
    }

    public void deserializeNBT(NBTTagList nbt) {
        this.items.clear();
        for (int i = 0; i < nbt.func_74745_c(); ++i) {
            ItemStack stack = ItemMissing.read(nbt.func_179238_g(i));
            if (stack.func_190926_b()) continue;
            this.items.add(stack);
        }
    }

    @Override
    public void getValidItems(List<ItemStack> list) {
        for (ItemStack item : this.items) {
            if (!ItemFiltersAPI.isFilter(item)) continue;
            super.getValidItems(list);
            return;
        }
        list.addAll(this.items);
    }

    @Override
    public void clearCache() {
        super.clearCache();
        for (ItemStack item : this.items) {
            IItemFilter f = ItemFiltersAPI.getFilter(item);
            if (f == null) continue;
            f.clearCache();
        }
    }
}

