/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.integration.recipe;

import com.google.common.collect.Lists;
import hellfirepvp.modularmachinery.client.ClientScheduler;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.requirements.RequirementEnergy;
import hellfirepvp.modularmachinery.common.crafting.requirements.RequirementItem;
import hellfirepvp.modularmachinery.common.integration.ModIntegrationJEI;
import hellfirepvp.modularmachinery.common.integration.recipe.CategoryDynamicRecipe;
import hellfirepvp.modularmachinery.common.integration.recipe.RecipeLayoutHelper;
import hellfirepvp.modularmachinery.common.integration.recipe.RecipeLayoutPart;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.model.animation.Animation;

public class DynamicRecipeWrapper
implements IRecipeWrapper {
    private final MachineRecipe recipe;
    public final Map<MachineComponent.IOType, Map<Class<?>, List<ComponentRequirement<?>>>> finalOrderedComponents = new HashMap();

    public DynamicRecipeWrapper(MachineRecipe recipe) {
        this.recipe = recipe;
        for (MachineComponent.IOType type : MachineComponent.IOType.values()) {
            this.finalOrderedComponents.put(type, new HashMap());
        }
        for (ComponentRequirement req : recipe.getCraftingRequirements()) {
            ComponentRequirement.JEIComponent comp = req.provideJEIComponent();
            this.finalOrderedComponents.get((Object)req.getActionType()).computeIfAbsent(comp.getJEIRequirementClass(), clazz -> new LinkedList()).add(req);
        }
    }

    @Nonnull
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        ArrayList tooltips = Lists.newArrayList();
        CategoryDynamicRecipe recipeCategory = ModIntegrationJEI.getCategory(this.recipe.getOwningMachine());
        if (recipeCategory != null && recipeCategory.rectangleProcessArrow.contains(mouseX, mouseY)) {
            tooltips.add(I18n.func_135052_a((String)"tooltip.machinery.duration", (Object[])new Object[]{this.recipe.getRecipeTotalTickTime()}));
        }
        return tooltips;
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        CategoryDynamicRecipe recipeCategory = ModIntegrationJEI.getCategory(this.recipe.getOwningMachine());
        if (recipeCategory == null) {
            return;
        }
        int totalDur = this.recipe.getRecipeTotalTickTime();
        int tick = (int)(ClientScheduler.getClientTick() % (long)totalDur);
        int pxPart = MathHelper.func_76123_f((float)(((float)tick + Animation.getPartialTickTime()) / (float)totalDur * (float)RecipeLayoutHelper.PART_PROCESS_ARROW_ACTIVE.xSize));
        ModIntegrationJEI.jeiHelpers.getGuiHelper().createDrawable(RecipeLayoutHelper.LOCATION_JEI_ICONS, 84, 15, pxPart, RecipeLayoutHelper.PART_PROCESS_ARROW_ACTIVE.zSize).draw(minecraft, recipeCategory.rectangleProcessArrow.x, recipeCategory.rectangleProcessArrow.y);
        int offsetY = recipeCategory.realHeight;
        long totalEnergyIn = 0L;
        for (ComponentRequirement req : this.recipe.getCraftingRequirements().stream().filter(r -> r instanceof RequirementEnergy).filter(r -> r.getActionType() == MachineComponent.IOType.INPUT).collect(Collectors.toList())) {
            totalEnergyIn += (long)((RequirementEnergy)req).getRequiredEnergyPerTick();
        }
        if (totalEnergyIn > 0L) {
            offsetY -= 36;
        }
        long totalEnergyOut = 0L;
        for (Object req : this.recipe.getCraftingRequirements().stream().filter(r -> r instanceof RequirementEnergy).filter(r -> r.getActionType() == MachineComponent.IOType.OUTPUT).collect(Collectors.toList())) {
            totalEnergyOut += (long)((RequirementEnergy)req).getRequiredEnergyPerTick();
        }
        if (totalEnergyOut > 0L) {
            offsetY -= 36;
        }
        int totalFuelIn = 0;
        for (ComponentRequirement req : this.recipe.getCraftingRequirements().stream().filter(c -> c instanceof RequirementItem).filter(c -> c.getActionType() == MachineComponent.IOType.INPUT).filter(c -> ((RequirementItem)c).requirementType == RequirementItem.ItemRequirementType.FUEL).collect(Collectors.toList())) {
            totalFuelIn += ((RequirementItem)req).fuelBurntime;
        }
        if (totalFuelIn > 0) {
            offsetY -= 26;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        long finalTotalEnergyIn = totalEnergyIn;
        recipeCategory.inputComponents.stream().filter(r -> r instanceof RecipeLayoutPart.Energy).forEach(part -> ((RecipeLayoutPart.Energy)part).drawEnergy(minecraft, finalTotalEnergyIn));
        long finalTotalEnergyOut = totalEnergyOut;
        recipeCategory.outputComponents.stream().filter(r -> r instanceof RecipeLayoutPart.Energy).forEach(part -> ((RecipeLayoutPart.Energy)part).drawEnergy(minecraft, finalTotalEnergyOut));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (totalEnergyIn > 0L) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            minecraft.field_71466_p.func_78276_b(I18n.func_135052_a((String)"tooltip.machinery.energy.in", (Object[])new Object[0]), 8, offsetY + 10, 0x222222);
            minecraft.field_71466_p.func_78276_b(I18n.func_135052_a((String)"tooltip.machinery.energy.in.tick", (Object[])new Object[]{totalEnergyIn}), 8, offsetY + 20, 0x222222);
            minecraft.field_71466_p.func_78276_b(I18n.func_135052_a((String)"tooltip.machinery.energy.in.total", (Object[])new Object[]{totalEnergyIn * (long)this.recipe.getRecipeTotalTickTime()}), 8, offsetY + 30, 0x222222);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            offsetY += 36;
        }
        if (totalFuelIn > 0) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            minecraft.field_71466_p.func_78276_b(I18n.func_135052_a((String)"tooltip.machinery.fuel.in", (Object[])new Object[0]), 8, offsetY + 10, 0x222222);
            minecraft.field_71466_p.func_78276_b(I18n.func_135052_a((String)"tooltip.machinery.fuel.in.total", (Object[])new Object[]{totalFuelIn}), 8, offsetY + 20, 0x222222);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            offsetY += 26;
        }
        if (totalEnergyOut > 0L) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            minecraft.field_71466_p.func_78276_b(I18n.func_135052_a((String)"tooltip.machinery.energy.out", (Object[])new Object[0]), 8, offsetY + 10, 0x222222);
            minecraft.field_71466_p.func_78276_b(I18n.func_135052_a((String)"tooltip.machinery.energy.out.tick", (Object[])new Object[]{totalEnergyOut}), 8, offsetY + 20, 0x222222);
            minecraft.field_71466_p.func_78276_b(I18n.func_135052_a((String)"tooltip.machinery.energy.out.total", (Object[])new Object[]{totalEnergyOut * (long)this.recipe.getRecipeTotalTickTime()}), 8, offsetY + 30, 0x222222);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            offsetY += 36;
        }
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        HashMap<Class, Map> componentMap = new HashMap<Class, Map>();
        for (ComponentRequirement req : this.recipe.getCraftingRequirements()) {
            if (req instanceof RequirementEnergy) continue;
            ComponentRequirement.JEIComponent comp = req.provideJEIComponent();
            componentMap.computeIfAbsent(comp.getJEIRequirementClass(), clazz -> new HashMap()).computeIfAbsent(req.getActionType(), type -> new LinkedList()).add(req);
        }
        for (Class clazz2 : componentMap.keySet()) {
            Map ioGroup = (Map)componentMap.get(clazz2);
            for (MachineComponent.IOType ioType : ioGroup.keySet()) {
                List components = (List)ioGroup.get((Object)ioType);
                ArrayList componentObjects = new ArrayList(components.size());
                for (ComponentRequirement req : components) {
                    componentObjects.add(req.provideJEIComponent().getJEIIORequirements());
                }
                switch (ioType) {
                    case INPUT: {
                        ingredients.setInputLists(clazz2, componentObjects);
                        break;
                    }
                    case OUTPUT: {
                        ingredients.setOutputLists(clazz2, componentObjects);
                    }
                }
            }
        }
    }
}

