/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.client.util;

import hellfirepvp.modularmachinery.client.util.Blending;
import hellfirepvp.modularmachinery.client.util.BlockArrayRenderHelper;
import hellfirepvp.modularmachinery.client.util.DynamicMachineRenderContext;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.util.BlockArray;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class BlockArrayPreviewRenderHelper {
    private BlockArrayRenderHelper renderHelper = null;
    private BlockPos attachedPosition = null;
    private DynamicMachine machine = null;
    private static int hash = -1;
    private static int batchDList = -1;

    public boolean startPreview(DynamicMachineRenderContext currentContext) {
        if (currentContext.getShiftSnap() != -1L) {
            this.renderHelper = currentContext.getRender();
            this.renderHelper.sampleSnap = currentContext.getShiftSnap();
            this.machine = currentContext.getDisplayedMachine();
            this.attachedPosition = null;
            if (Minecraft.func_71410_x().field_71439_g != null) {
                Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentTranslation("gui.blueprint.popout.place", new Object[0]));
            }
            return true;
        }
        return false;
    }

    public boolean placePreview() {
        RayTraceResult lookBlock;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && this.renderHelper != null && this.attachedPosition == null && (lookBlock = this.getLookBlock((Entity)player, false, true, 20.0)) != null) {
            this.attachedPosition = lookBlock.func_178782_a();
            return true;
        }
        return false;
    }

    public void tick() {
        if (this.attachedPosition != null) {
            if (Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.func_174831_c(this.attachedPosition) >= 1024.0) {
                this.clearSelection();
            }
            if (Minecraft.func_71410_x().field_71441_e != null && this.renderHelper != null && this.renderHelper.getBlocks().matches((World)Minecraft.func_71410_x().field_71441_e, this.attachedPosition, true, this.machine.getModifiersAsMatchingReplacements())) {
                this.clearSelection();
            }
        }
    }

    void renderTranslucentBlocks() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179094_E();
        float partialTicks = Minecraft.func_71410_x().func_184121_ak();
        Entity rView = Minecraft.func_71410_x().func_175606_aa();
        if (rView == null) {
            rView = Minecraft.func_71410_x().field_71439_g;
        }
        Entity entity = rView;
        double tx = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
        double ty = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
        double tz = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
        GlStateManager.func_179137_b((double)(-tx), (double)(-ty), (double)(-tz));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (batchDList == -1) {
            this.batchBlocks();
            hash = this.hashBlocks();
        } else {
            int currentHash = this.hashBlocks();
            if (hash != currentHash) {
                GLAllocation.func_74523_b((int)batchDList);
                this.batchBlocks();
                hash = currentHash;
            }
        }
        GlStateManager.func_179147_l();
        Blending.ALPHA.applyStateManager();
        GlStateManager.func_179148_o((int)batchDList);
        Blending.DEFAULT.applyStateManager();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private int hashBlocks() {
        int hash = 80238287;
        if (this.renderHelper != null && Minecraft.func_71410_x().field_71439_g != null) {
            RayTraceResult res;
            BlockPos move = this.attachedPosition;
            if (move == null && (res = this.getLookBlock((Entity)Minecraft.func_71410_x().field_71439_g, false, true, 20.0)) != null) {
                move = res.func_178782_a();
            }
            if (move != null) {
                BlockArray render = new BlockArray(this.renderHelper.getBlocks(), (Vec3i)move);
                for (Map.Entry<BlockPos, BlockArray.BlockInformation> entry : render.getPattern().entrySet()) {
                    if (Minecraft.func_71410_x().field_71441_e != null && entry.getValue().matches((World)Minecraft.func_71410_x().field_71441_e, entry.getKey(), false)) continue;
                    hash = hash << 4 ^ hash >> 28 ^ entry.getKey().func_177958_n() * 5449 % 130651;
                    hash = hash << 4 ^ hash >> 28 ^ entry.getKey().func_177956_o() * 5449 % 130651;
                    hash = hash << 4 ^ hash >> 28 ^ entry.getKey().func_177952_p() * 5449 % 130651;
                    hash = hash << 4 ^ hash >> 28 ^ entry.getValue().getSampleState(Optional.of(this.renderHelper.sampleSnap)).hashCode() * 5449 % 130651;
                }
            }
        }
        return hash % 75327403;
    }

    private void batchBlocks() {
        RayTraceResult res;
        BlockPos move = this.attachedPosition;
        if (move == null && (res = this.getLookBlock((Entity)Minecraft.func_71410_x().field_71439_g, false, true, 20.0)) != null) {
            move = res.func_178782_a();
        }
        if (move == null || this.renderHelper == null) {
            batchDList = GLAllocation.func_74526_a((int)1);
            GlStateManager.func_187423_f((int)batchDList, (int)4864);
            GlStateManager.func_187415_K();
            return;
        }
        batchDList = GLAllocation.func_74526_a((int)1);
        GlStateManager.func_179147_l();
        Blending.DEFAULT.applyStateManager();
        GlStateManager.func_187423_f((int)batchDList, (int)4864);
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        BlockArrayRenderHelper.WorldBlockArrayRenderAccess access = this.renderHelper.getRenderAccess().move(this.renderHelper, (Vec3i)move);
        BlockRendererDispatcher brd = Minecraft.func_71410_x().func_175602_ab();
        VertexFormat blockFormat = DefaultVertexFormats.field_176600_a;
        vb.func_181668_a(7, blockFormat);
        for (Map.Entry<BlockPos, BlockArrayRenderHelper.BakedBlockData> data : access.blockRenderData.entrySet()) {
            BlockPos offset = data.getKey();
            BlockArrayRenderHelper.BakedBlockData renderData = data.getValue();
            BlockArrayRenderHelper.SampleRenderState state = renderData.getSampleState();
            if (Minecraft.func_71410_x().field_71441_e != null && this.renderHelper.getBlocks().getPattern().get(offset.func_177973_b((Vec3i)move)).matches((World)Minecraft.func_71410_x().field_71441_e, offset, false) || state.state.func_177230_c() == Blocks.field_150350_a) continue;
            BlockArrayRenderHelper.TileEntityRenderData terd = state.renderData;
            if (terd != null && terd.tileEntity != null) {
                terd.tileEntity.func_145834_a((World)Minecraft.func_71410_x().field_71441_e);
                terd.tileEntity.func_174878_a(offset);
            }
            IBlockState actRenderState = state.state;
            actRenderState = actRenderState.func_177230_c().func_176221_a(actRenderState, (IBlockAccess)access, offset);
            brd.func_175018_a(actRenderState, offset, (IBlockAccess)access, vb);
        }
        vb.func_181674_a((float)TileEntityRendererDispatcher.field_147554_b, (float)TileEntityRendererDispatcher.field_147555_c, (float)TileEntityRendererDispatcher.field_147552_d);
        tes.func_78381_a();
        GlStateManager.func_187415_K();
        Blending.DEFAULT.applyStateManager();
    }

    @Nullable
    private RayTraceResult getLookBlock(Entity e, boolean stopTraceOnLiquids, boolean ignoreBlockWithoutBoundingBox, double range) {
        float pitch = e.field_70125_A;
        float yaw = e.field_70177_z;
        Vec3d entityVec = new Vec3d(e.field_70165_t, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v);
        float f2 = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        Vec3d vec3d1 = entityVec.func_72441_c((double)f6 * range, (double)f5 * range, (double)f7 * range);
        RayTraceResult rtr = e.func_130014_f_().func_147447_a(entityVec, vec3d1, stopTraceOnLiquids, ignoreBlockWithoutBoundingBox, false);
        if (rtr == null || rtr.field_72313_a != RayTraceResult.Type.BLOCK) {
            return null;
        }
        return rtr;
    }

    private void clearSelection() {
        this.renderHelper = null;
        this.attachedPosition = null;
        this.machine = null;
    }

    public void unloadWorld() {
        this.clearSelection();
    }
}

