/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.client;

import com.google.common.collect.Lists;
import hellfirepvp.modularmachinery.client.ClientMouseJEIGuiEventHandler;
import hellfirepvp.modularmachinery.client.ClientScheduler;
import hellfirepvp.modularmachinery.client.gui.GuiContainerEnergyHatch;
import hellfirepvp.modularmachinery.client.gui.GuiContainerFluidHatch;
import hellfirepvp.modularmachinery.client.gui.GuiContainerItemBus;
import hellfirepvp.modularmachinery.client.gui.GuiMachineController;
import hellfirepvp.modularmachinery.client.gui.GuiScreenBlueprint;
import hellfirepvp.modularmachinery.client.util.BlockArrayPreviewRenderHelper;
import hellfirepvp.modularmachinery.client.util.DebugOverlayHelper;
import hellfirepvp.modularmachinery.client.util.SelectionBoxRenderHelper;
import hellfirepvp.modularmachinery.common.CommonProxy;
import hellfirepvp.modularmachinery.common.block.BlockDynamicColor;
import hellfirepvp.modularmachinery.common.block.BlockVariants;
import hellfirepvp.modularmachinery.common.item.ItemBlueprint;
import hellfirepvp.modularmachinery.common.item.ItemDynamicColor;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.registry.RegistryBlocks;
import hellfirepvp.modularmachinery.common.registry.RegistryItems;
import hellfirepvp.modularmachinery.common.tiles.TileMachineController;
import hellfirepvp.modularmachinery.common.tiles.base.TileEnergyHatch;
import hellfirepvp.modularmachinery.common.tiles.base.TileFluidTank;
import hellfirepvp.modularmachinery.common.tiles.base.TileItemBus;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ClientProxy
extends CommonProxy {
    public static ClientScheduler clientScheduler = new ClientScheduler();
    public static BlockArrayPreviewRenderHelper renderHelper = new BlockArrayPreviewRenderHelper();
    private List<Block> blockModelsToRegister = Lists.newLinkedList();
    private List<Item> itemModelsToRegister = Lists.newLinkedList();

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)clientScheduler);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new DebugOverlayHelper());
        MinecraftForge.EVENT_BUS.register((Object)new SelectionBoxRenderHelper());
        if (Loader.isModLoaded((String)"jei")) {
            this.registerJEIEventHandler();
        }
        super.preInit();
    }

    @Optional.Method(modid="jei")
    private void registerJEIEventHandler() {
        MinecraftForge.EVENT_BUS.register((Object)new ClientMouseJEIGuiEventHandler());
    }

    @SubscribeEvent
    public void onModelRegister(ModelRegistryEvent event) {
        this.registerModels();
    }

    private void registerModels() {
        for (Block block : this.blockModelsToRegister) {
            Item i = Item.func_150898_a((Block)block);
            if (block instanceof BlockVariants) {
                for (IBlockState state : ((BlockVariants)block).getValidStates()) {
                    String unlocName = block.getClass().getSimpleName().toLowerCase();
                    String name = unlocName + "_" + ((BlockVariants)block).getBlockStateName(state);
                    ModelBakery.registerItemVariants((Item)i, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("modularmachinery", name)});
                    ModelLoader.setCustomModelResourceLocation((Item)i, (int)block.func_176201_c(state), (ModelResourceLocation)new ModelResourceLocation("modularmachinery:" + name, "inventory"));
                }
                continue;
            }
            ModelBakery.registerItemVariants((Item)i, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("modularmachinery", block.getClass().getSimpleName().toLowerCase())});
            ModelLoader.setCustomModelResourceLocation((Item)i, (int)0, (ModelResourceLocation)new ModelResourceLocation("modularmachinery:" + block.getClass().getSimpleName().toLowerCase(), "inventory"));
        }
        for (Item item : this.itemModelsToRegister) {
            String name = item.getClass().getSimpleName().toLowerCase();
            if (item instanceof ItemBlock) {
                name = ((ItemBlock)item).func_179223_d().getClass().getSimpleName().toLowerCase();
            }
            NonNullList list = NonNullList.func_191196_a();
            item.func_150895_a(item.func_77640_w(), list);
            if (list.size() > 0) {
                for (ItemStack i : list) {
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)i.func_77952_i(), (ModelResourceLocation)new ModelResourceLocation("modularmachinery:" + name, "inventory"));
                }
                continue;
            }
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("modularmachinery:" + name, "inventory"));
        }
    }

    private void registerPendingIBlockColorBlocks() {
        BlockColors colors = Minecraft.func_71410_x().func_184125_al();
        for (BlockDynamicColor b : RegistryBlocks.pendingIBlockColorBlocks) {
            colors.func_186722_a(b::getColorMultiplier, new Block[]{(Block)b});
        }
    }

    private void registerPendingIItemColorItems() {
        ItemColors colors = Minecraft.func_71410_x().getItemColors();
        for (ItemDynamicColor i : RegistryItems.pendingDynamicColorItems) {
            colors.func_186730_a(i::getColorFromItemstack, new Item[]{(Item)i});
        }
    }

    @Override
    public void init() {
        super.init();
        this.registerPendingIBlockColorBlocks();
        this.registerPendingIItemColorItems();
    }

    @Override
    public void postInit() {
        super.postInit();
    }

    @Override
    public void registerBlockModel(Block block) {
        this.blockModelsToRegister.add(block);
    }

    @Override
    public void registerItemModel(Item item) {
        this.itemModelsToRegister.add(item);
    }

    @Override
    @Nullable
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        CommonProxy.GuiType type = CommonProxy.GuiType.values()[MathHelper.func_76125_a((int)ID, (int)0, (int)(CommonProxy.GuiType.values().length - 1))];
        Class<? extends TileEntity> required = type.requiredTileEntity;
        TileEntity present = null;
        if (required != null) {
            TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
            if (te != null && required.isAssignableFrom(te.getClass())) {
                present = te;
            } else {
                return null;
            }
        }
        switch (type) {
            case CONTROLLER: {
                return new GuiMachineController((TileMachineController)present, player);
            }
            case BUS_INVENTORY: {
                return new GuiContainerItemBus((TileItemBus)present, player);
            }
            case TANK_INVENTORY: {
                return new GuiContainerFluidHatch((TileFluidTank)present, player);
            }
            case ENERGY_INVENTORY: {
                return new GuiContainerEnergyHatch((TileEnergyHatch)present, player);
            }
            case BLUEPRINT_PREVIEW: {
                ItemStack stack = x == 0 ? Minecraft.func_71410_x().field_71439_g.func_184614_ca() : Minecraft.func_71410_x().field_71439_g.func_184592_cb();
                DynamicMachine machine = ItemBlueprint.getAssociatedMachine(stack);
                if (machine == null) break;
                return new GuiScreenBlueprint(machine);
            }
        }
        return null;
    }
}

