/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.packet.server;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PktParticleDataEvent
implements IMessage,
IMessageHandler<PktParticleDataEvent, IMessage> {
    public double[] data;
    private double xCoord;
    private double yCoord;
    private double zCoord;
    public ParticleType effectType;

    public PktParticleDataEvent() {
    }

    public PktParticleDataEvent(ParticleType effectType, double xCoord, double yCoord, double zCoord, double ... data) {
        this.effectType = effectType;
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.zCoord = zCoord;
        this.data = data;
    }

    public void fromBytes(ByteBuf buf) {
        int amt = buf.readInt();
        this.data = new double[amt];
        for (int i = 0; i < amt; ++i) {
            this.data[i] = buf.readDouble();
        }
        this.xCoord = buf.readDouble();
        this.yCoord = buf.readDouble();
        this.zCoord = buf.readDouble();
        this.effectType = ParticleType.values()[MathHelper.func_76125_a((int)buf.readInt(), (int)0, (int)ParticleType.values().length)];
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.data.length);
        for (double d : this.data) {
            buf.writeDouble(d);
        }
        buf.writeDouble(this.xCoord);
        buf.writeDouble(this.yCoord);
        buf.writeDouble(this.zCoord);
        buf.writeDouble((double)this.effectType.ordinal());
    }

    public IMessage onMessage(PktParticleDataEvent message, MessageContext ctx) {
        try {
            EventAction trigger = message.effectType.getTrigger(ctx.side);
            if (trigger != null) {
                this.triggerClientside(trigger, message);
            }
        }
        catch (Exception exc) {
            AstralSorcery.log.warn("Error executing ParticleEventType " + message.effectType.name() + " at " + this.xCoord + ", " + this.yCoord + ", " + this.zCoord);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void triggerClientside(EventAction trigger, PktParticleDataEvent message) {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        AstralSorcery.proxy.scheduleClientside(() -> trigger.trigger(message));
    }

    public Vector3 getVec() {
        return new Vector3(this.xCoord, this.yCoord, this.zCoord);
    }

    private static interface EventAction {
        public void trigger(PktParticleDataEvent var1);
    }

    public static enum ParticleType {


        @SideOnly(value=Side.CLIENT)
        private static EventAction getClientTrigger(ParticleType type) {
            switch (type) {
                default: 
            }
            return null;
        }

        public EventAction getTrigger(Side side) {
            if (!side.isClient()) {
                return null;
            }
            return ParticleType.getClientTrigger(this);
        }
    }
}

