/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.tree.root;

import hellfirepvp.astralsorcery.common.constellation.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.root.RootPerk;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.event.AttributeEvent;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

public class AevitasRootPerk
extends RootPerk {
    private static final int trackLength = 20;
    private Map<UUID, Queue<BlockPos>> plInteractMap = new HashMap<UUID, Queue<BlockPos>>();
    private Map<UUID, Deque<IBlockState>> plDimReturns = new HashMap<UUID, Deque<IBlockState>>();

    public AevitasRootPerk(int x, int y) {
        super("aevitas", Constellations.aevitas, x, y);
    }

    @Override
    public void removePerkLogic(EntityPlayer player, Side side) {
        super.removePerkLogic(player, side);
        if (side == Side.SERVER) {
            this.plInteractMap.remove(player.func_110124_au());
            this.plDimReturns.remove(player.func_110124_au());
        }
    }

    @Override
    public void clearCaches(Side side) {
        super.clearCaches(side);
        if (side == Side.SERVER) {
            this.plInteractMap.clear();
            this.plDimReturns.clear();
        }
    }

    @SubscribeEvent
    public void onPlace(BlockEvent.PlaceEvent event) {
        Side side;
        EntityPlayer player = event.getPlayer();
        Side side2 = side = player.field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER;
        if (side != Side.SERVER) {
            return;
        }
        PlayerProgress prog = ResearchManager.getProgress(player, side);
        if (!prog.hasPerkEffect(this)) {
            return;
        }
        Deque dim = this.plDimReturns.computeIfAbsent(player.func_110124_au(), u -> new LinkedList());
        while (dim.size() >= 20) {
            dim.pollLast();
        }
        float used = 0.0f;
        for (IBlockState placed : dim) {
            if (!MiscUtils.matchStateExact(event.getPlacedBlock(), placed)) continue;
            used += 1.0f;
        }
        float same = dim.size() <= 0 ? 1.0f : 0.4f + (1.0f - used / 20.0f) * 0.6f;
        dim.addFirst(event.getPlacedBlock());
        BlockPos pos = event.getPos();
        Queue tracked = this.plInteractMap.computeIfAbsent(player.func_110124_au(), u -> new ArrayDeque(20));
        if (!tracked.contains(pos)) {
            tracked.add(pos);
            float xp = Math.max(event.getPlacedBlock().func_185887_b(event.getWorld(), event.getPos()) / 20.0f, 1.0f);
            xp *= this.expMultiplier;
            xp *= same;
            xp = PerkAttributeHelper.getOrCreateMap(player, side).modifyValue(player, prog, "astralsorcery.perkeffect", xp);
            xp = PerkAttributeHelper.getOrCreateMap(player, side).modifyValue(player, prog, "astralsorcery.expgain", xp);
            xp = AttributeEvent.postProcessModded(player, "astralsorcery.expgain", xp);
            ResearchManager.modifyExp(player, xp);
        }
    }

    @SubscribeEvent
    public void onBreak(BlockEvent.BreakEvent event) {
        Side side;
        EntityPlayer player = event.getPlayer();
        Side side2 = side = player.field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER;
        if (side != Side.SERVER) {
            return;
        }
        PlayerProgress prog = ResearchManager.getProgress(player, side);
        if (!prog.hasPerkEffect(this)) {
            return;
        }
        Queue tracked = this.plInteractMap.computeIfAbsent(player.func_110124_au(), u -> new ArrayDeque(20));
        if (tracked.contains(event.getPos())) {
            return;
        }
        while (tracked.size() >= 20) {
            tracked.poll();
        }
        tracked.add(event.getPos());
    }
}

