/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.gui.journal.GuiRenderBoundingBox;
import hellfirepvp.astralsorcery.client.gui.journal.GuiScreenJournal;
import hellfirepvp.astralsorcery.client.gui.journal.PerkTreeSizeHandler;
import hellfirepvp.astralsorcery.client.gui.journal.ScalingPoint;
import hellfirepvp.astralsorcery.client.gui.journal.SizeHandler;
import hellfirepvp.astralsorcery.client.gui.journal.overlay.GuiJournalOverlayPerkStats;
import hellfirepvp.astralsorcery.client.gui.journal.page.IGuiRenderablePage;
import hellfirepvp.astralsorcery.client.gui.perk.BatchPerkContext;
import hellfirepvp.astralsorcery.client.gui.perk.DynamicPerkRender;
import hellfirepvp.astralsorcery.client.gui.perk.PerkRenderGroup;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.BufferBatch;
import hellfirepvp.astralsorcery.client.util.GuiTextEntry;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.SpriteLibrary;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.client.util.resource.AbstractRenderableTexture;
import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.util.resource.BindableResource;
import hellfirepvp.astralsorcery.client.util.resource.SpriteSheetResource;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.constellation.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.PerkConverter;
import hellfirepvp.astralsorcery.common.constellation.perk.ProgressGatedPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.AttributeConverterPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.PerkTree;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.PerkTreePoint;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.GemSlotPerk;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.item.gem.ItemPerkGem;
import hellfirepvp.astralsorcery.common.item.useables.ItemPerkSeal;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.client.PktPerkGemModification;
import hellfirepvp.astralsorcery.common.network.packet.client.PktRequestPerkSealAction;
import hellfirepvp.astralsorcery.common.network.packet.client.PktUnlockPerk;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.SoundHelper;
import hellfirepvp.astralsorcery.common.util.data.NonDuplicateArrayList;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiJournalPerkTree
extends GuiScreenJournal {
    private static final AbstractRenderableTexture textureResBack = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "guiresbg2");
    private static final AbstractRenderableTexture texturePerkConnection = AssetLibrary.loadTexture(AssetLoader.TextureLocation.EFFECT, "connectionperks");
    private static final AbstractRenderableTexture textureSearchTextBG = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "guijtextarea");
    private static final AbstractRenderableTexture textureSlotContext = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "slotgemcontext");
    private static final AbstractRenderableTexture textureSearchMark = SpriteLibrary.spriteHalo4;
    private static Rectangle rectSealBox = new Rectangle(29, 16, 16, 16);
    private static Rectangle rectSearchTextEntry = new Rectangle(300, 16, 88, 15);
    private static final BufferBatch drawBufferConnections = BufferBatch.make();
    private static BatchPerkContext drawBuffer;
    private static BatchPerkContext.TextureObjectGroup searchContext;
    private static BatchPerkContext.TextureObjectGroup sealContext;
    private SizeHandler sizeHandler;
    private GuiRenderBoundingBox guiBox;
    private ScalingPoint mousePosition;
    private ScalingPoint previousMousePosition;
    private int mouseBufferX;
    private int mouseBufferY;
    private boolean mouseDragging = false;
    private AbstractPerk unlockPrimed = null;
    private AbstractPerk sealBreakPrimed = null;
    private int tickSealBreak = 0;
    private int guiOffsetX;
    private int guiOffsetY;
    public boolean expectReinit = false;
    private Map<AbstractPerk, Rectangle2D.Double> thisFramePerks = Maps.newHashMap();
    private Map<AbstractPerk, Long> unlockEffects = Maps.newHashMap();
    private Map<AbstractPerk, Long> breakEffects = Maps.newHashMap();
    private GuiTextEntry searchTextEntry = new GuiTextEntry();
    private List<AbstractPerk> searchMatches = Lists.newArrayList();
    private GemSlotPerk socketMenu = null;
    private Rectangle rSocketMenu = null;
    private Map<Rectangle, Integer> slotsSocketMenu = Maps.newHashMap();
    private Rectangle rStatStar = null;
    private ItemStack mouseSealStack = ItemStack.field_190927_a;
    private ItemStack foundSeals = ItemStack.field_190927_a;

    public GuiJournalPerkTree() {
        super(30);
        this.closeWithInventoryKey = false;
        this.searchTextEntry.setChangeCallback(this::updateSearchHighlight);
        this.buildTree();
    }

    private void buildTree() {
        this.guiBox = new GuiRenderBoundingBox(10.0, 10.0, this.guiWidth - 10, this.guiHeight - 10);
        this.sizeHandler = new PerkTreeSizeHandler(this.guiHeight - 40, this.guiWidth - 20);
        this.sizeHandler.setScaleSpeed(0.04f);
        this.sizeHandler.setMaxScale(1.0);
        this.sizeHandler.setMinScale(0.1f);
        this.sizeHandler.updateSize();
        this.mousePosition = ScalingPoint.createPoint(0.0, 0.0, this.sizeHandler.getScalingFactor(), false);
    }

    public static void initializeDrawBuffer() {
        drawBuffer = new BatchPerkContext();
        searchContext = drawBuffer.addContext(textureSearchMark, 300);
        sealContext = drawBuffer.addContext(SpriteLibrary.spritePerkSeal, 200);
        NonDuplicateArrayList<PerkRenderGroup> groups = new NonDuplicateArrayList<PerkRenderGroup>();
        for (PerkTreePoint<?> p : PerkTree.PERK_TREE.getPerkPoints()) {
            p.addGroups(groups);
        }
        for (PerkRenderGroup group : groups) {
            group.batchRegister(drawBuffer);
        }
    }

    @Override
    public void func_73866_w_() {
        AbstractPerk root;
        IMajorConstellation attunement;
        super.func_73866_w_();
        if (this.expectReinit) {
            this.expectReinit = false;
            return;
        }
        this.guiOffsetX = this.guiLeft + 10;
        this.guiOffsetY = this.guiTop + 10;
        boolean shifted = false;
        PlayerProgress progress = ResearchManager.clientProgress;
        if (progress != null && (attunement = progress.getAttunedConstellation()) != null && (root = PerkTree.PERK_TREE.getRootPerk(attunement)) != null) {
            Point2D.Double shift = this.sizeHandler.evRelativePos(root.getOffset());
            this.moveMouse(MathHelper.func_76128_c((double)shift.x), MathHelper.func_76128_c((double)shift.y));
            shifted = true;
        }
        if (!shifted) {
            this.moveMouse(MathHelper.func_76128_c((double)(this.sizeHandler.getTotalWidth() / 2.0)), MathHelper.func_76128_c((double)(this.sizeHandler.getTotalHeight() / 2.0)));
        }
        this.applyMovedMouseOffset();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.thisFramePerks.clear();
        int dWheelChange = Mouse.getDWheel();
        if (dWheelChange < 0) {
            this.sizeHandler.handleZoomOut();
            this.rescaleMouse();
        }
        if (dWheelChange > 0) {
            this.sizeHandler.handleZoomIn();
            this.rescaleMouse();
        }
        this.handleMouseMovement(mouseX, mouseY);
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GL11.glEnable((int)3042);
        Blending.DEFAULT.applyStateManager();
        Blending.DEFAULT.apply();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawDefault(textureResShell, new Point(mouseX, mouseY));
        this.drawBackground(this.field_73735_i - 50.0f);
        ScaledResolution res = new ScaledResolution(this.field_146297_k);
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((this.guiLeft + 27) * res.func_78325_e()), (int)((this.guiTop + 27) * res.func_78325_e()), (int)((this.guiWidth - 54) * res.func_78325_e()), (int)((this.guiHeight - 54) * res.func_78325_e()));
        this.drawPerkTree(partialTicks);
        GL11.glDisable((int)3089);
        this.drawSearchBox();
        this.drawMiscInfo(mouseX, mouseY, partialTicks);
        this.drawSocketContextMenu();
        this.drawSealBox();
        this.drawHoverTooltips(mouseX, mouseY);
        TextureHelper.refreshTextureBindState();
        TextureHelper.setActiveTextureToAtlasSprite();
        if (!this.mouseSealStack.func_190926_b()) {
            GlStateManager.func_179097_i();
            this.field_146296_j.func_180450_b(this.mouseSealStack, mouseX - 8, mouseY - 8);
            GlStateManager.func_179126_j();
        }
        GlStateManager.func_179121_F();
    }

    public void func_73876_c() {
        int count;
        super.func_73876_c();
        this.foundSeals = Minecraft.func_71410_x().field_71439_g != null ? ((count = ItemPerkSeal.getPlayerSealCount((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) > 0 ? new ItemStack((Item)ItemsAS.perkSeal, count) : ItemStack.field_190927_a) : ItemStack.field_190927_a;
        --this.tickSealBreak;
        if (this.tickSealBreak <= 0) {
            this.tickSealBreak = 0;
            this.sealBreakPrimed = null;
        }
    }

    private void drawSocketContextMenu() {
        this.rSocketMenu = null;
        this.slotsSocketMenu.clear();
        if (this.socketMenu != null) {
            int index;
            AbstractPerk sMenuPerk = (AbstractPerk)((Object)this.socketMenu);
            Map<Integer, ItemStack> found = ItemUtils.findItemsIndexedInPlayerInventory((EntityPlayer)Minecraft.func_71410_x().field_71439_g, s -> !s.func_190926_b() && s.func_77973_b() instanceof ItemPerkGem && !ItemPerkGem.getModifiers(s).isEmpty());
            if (found.isEmpty()) {
                this.closeSocketMenu();
                return;
            }
            Point offset = sMenuPerk.getPoint().getOffset();
            double x = this.sizeHandler.evRelativePosX(offset.x);
            double y = this.sizeHandler.evRelativePosY(offset.y);
            Point2D.Double scaledOffset = this.shift2DOffset(x, y);
            int offsetX = MathHelper.func_76128_c((double)scaledOffset.x);
            int offsetY = MathHelper.func_76128_c((double)scaledOffset.y);
            double scale = this.sizeHandler.getScalingFactor();
            int scaledSlotSize = (int)Math.round(18.0 * scale);
            int realWidth = Math.min(5, found.size());
            int realHeight = found.size() / 5 + (found.size() % 5 == 0 ? 0 : 1);
            int width = realWidth * scaledSlotSize;
            int height = realHeight * scaledSlotSize;
            this.rSocketMenu = new Rectangle((int)((double)offsetX + 12.0 * scale - 4.0), (int)((double)offsetY - 12.0 * scale - 4.0), width + 4, height + 4);
            if (!this.guiBox.isInBox(this.rSocketMenu.x - this.guiLeft, this.rSocketMenu.y - this.guiTop) || !this.guiBox.isInBox(this.rSocketMenu.x + this.rSocketMenu.width - this.guiLeft, this.rSocketMenu.y + this.rSocketMenu.height - this.guiTop)) {
                this.closeSocketMenu();
                return;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)offsetX, (float)offsetY, (float)0.0f);
            GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
            RenderingUtils.renderBlueTooltipBox(0, 0, realWidth * 18, realHeight * 18);
            GlStateManager.func_179121_F();
            offsetX = (int)((double)offsetX + 12.0 * scale);
            offsetY = (int)((double)offsetY - 12.0 * scale);
            textureSlotContext.bindTexture();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179147_l();
            GL11.glEnable((int)3042);
            GlStateManager.func_179097_i();
            GL11.glDisable((int)2929);
            for (index = 0; index < found.size(); ++index) {
                int addedX = index % 5 * scaledSlotSize;
                int addedY = index / 5 * scaledSlotSize;
                this.drawTexturedRect(offsetX + addedX, offsetY + addedY, scaledSlotSize, scaledSlotSize, 0.0f, 0.0f, 1.0f, 1.0f);
            }
            GlStateManager.func_179126_j();
            TextureHelper.refreshTextureBindState();
            RenderHelper.func_74520_c();
            index = 0;
            for (Integer slotId : found.keySet()) {
                ItemStack stack = found.get(slotId);
                int addedX = index % 5 * scaledSlotSize;
                int addedY = index / 5 * scaledSlotSize;
                Rectangle r = new Rectangle(offsetX + addedX, offsetY + addedY, scaledSlotSize, scaledSlotSize);
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(offsetX + addedX + 1), (float)(offsetY + addedY + 1), (float)0.0f);
                GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
                this.drawItemStack(stack, 0, 0);
                GlStateManager.func_179121_F();
                this.slotsSocketMenu.put(r, slotId);
                ++index;
            }
            GlStateManager.func_179084_k();
        }
    }

    private void drawItemStack(ItemStack stack, int x, int y) {
        FontRenderer fr = stack.func_77973_b().getFontRenderer(stack);
        if (fr == null) {
            fr = this.field_146289_q;
        }
        this.field_73735_i += 500.0f;
        this.field_146296_j.field_77023_b += 500.0f;
        this.field_146296_j.func_180450_b(stack, x, y);
        this.field_146296_j.func_180453_a(fr, stack, x, y, null);
        this.field_146296_j.field_77023_b -= 500.0f;
        this.field_73735_i -= 500.0f;
    }

    private void drawSealBox() {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179097_i();
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        BindableResource tex = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "gridslot");
        ((AbstractRenderableTexture)tex).bindTexture();
        this.drawTexturedRect((double)(this.guiLeft + GuiJournalPerkTree.rectSealBox.x - 1), (double)(this.guiTop + GuiJournalPerkTree.rectSealBox.y - 1), (double)(GuiJournalPerkTree.rectSealBox.width + 2), (double)(GuiJournalPerkTree.rectSealBox.height + 2), tex);
        GlStateManager.func_179141_d();
        GlStateManager.func_179126_j();
        TextureHelper.refreshTextureBindState();
        TextureHelper.setActiveTextureToAtlasSprite();
        if (!this.foundSeals.func_190926_b()) {
            this.field_146296_j.func_184391_a((EntityLivingBase)Minecraft.func_71410_x().field_71439_g, this.foundSeals, this.guiLeft + GuiJournalPerkTree.rectSealBox.x, this.guiTop + GuiJournalPerkTree.rectSealBox.y);
            this.field_146296_j.func_180453_a(this.field_146289_q, this.foundSeals, this.guiLeft + GuiJournalPerkTree.rectSealBox.x, this.guiTop + GuiJournalPerkTree.rectSealBox.y, null);
            GlStateManager.func_179140_f();
        }
    }

    private void drawMiscInfo(int mouseX, int mouseY, float pTicks) {
        int availablePerks;
        PlayerProgress prog = ResearchManager.clientProgress;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (prog.getAttunedConstellation() != null && (availablePerks = prog.getAvailablePerkPoints((EntityPlayer)player)) > 0) {
            GlStateManager.func_179097_i();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(this.guiLeft + 50), (float)(this.guiTop + 18), (float)0.0f);
            this.field_146289_q.func_175065_a(I18n.func_135052_a((String)"perk.info.points", (Object[])new Object[]{availablePerks}), 0.0f, 0.0f, new Color(0xCCCCCC).getRGB(), false);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            TextureHelper.refreshTextureBindState();
            GlStateManager.func_179121_F();
            GlStateManager.func_179141_d();
            GlStateManager.func_179126_j();
        }
        this.rStatStar = IGuiRenderablePage.GUI_INTERFACE.drawInfoStar(this.guiLeft + 288, this.guiTop + 20, this.field_73735_i + 100.0f, 16.0f, pTicks);
        if (this.rStatStar.contains(mouseX, mouseY)) {
            GlStateManager.func_179097_i();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)this.rStatStar.x + (float)this.rStatStar.width / 2.0f), (float)(this.rStatStar.y + this.rStatStar.height), (float)0.0f);
            RenderingUtils.renderBlueTooltip(0, 0, Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)"perk.reader.infostar", (Object[])new Object[0])}), this.field_146289_q);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            TextureHelper.refreshTextureBindState();
            GlStateManager.func_179121_F();
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GL11.glEnable((int)3042);
            GlStateManager.func_179126_j();
        }
    }

    private void drawSearchBox() {
        boolean addDots;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179118_c();
        GlStateManager.func_179097_i();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(this.guiLeft + 300), (float)(this.guiTop + 16), (float)0.0f);
        textureSearchTextBG.bindTexture();
        this.drawTexturedRectAtCurrentPos(88.5, 15.0);
        String text = this.searchTextEntry.getText();
        int length = this.field_146289_q.func_78256_a(text);
        boolean bl = addDots = length > 75;
        while (length > 75) {
            text = text.substring(1);
            length = this.field_146289_q.func_78256_a("..." + text);
        }
        if (addDots) {
            text = "..." + text;
        }
        if (ClientScheduler.getClientTick() % 20L > 10L) {
            text = text + "_";
        }
        GlStateManager.func_179109_b((float)4.0f, (float)4.0f, (float)0.0f);
        this.field_146289_q.func_175065_a(text, 0.0f, 0.0f, new Color(0xCCCCCC).getRGB(), false);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TextureHelper.refreshTextureBindState();
        GlStateManager.func_179121_F();
        GlStateManager.func_179141_d();
        GlStateManager.func_179126_j();
    }

    private void rescaleMouse() {
        this.mousePosition.rescale(this.sizeHandler.getScalingFactor());
        if (this.previousMousePosition != null) {
            this.previousMousePosition.rescale(this.sizeHandler.getScalingFactor());
        }
        this.moveMouse(0, 0);
    }

    private void drawHoverTooltips(int mouseX, int mouseY) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        for (Rectangle rectangle : this.slotsSocketMenu.keySet()) {
            if (!rectangle.contains(mouseX, mouseY)) continue;
            Integer slot = this.slotsSocketMenu.get(rectangle);
            ItemStack in = player.field_71071_by.func_70301_a(slot.intValue());
            if (!in.func_190926_b()) {
                this.func_146285_a(in, mouseX, mouseY);
            }
            return;
        }
        GlStateManager.func_179097_i();
        GL11.glDisable((int)2929);
        if (!this.foundSeals.func_190926_b() && rectSealBox.contains(mouseX - this.guiLeft, mouseY - this.guiTop)) {
            List toolTip = this.foundSeals.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
            toolTip.add("");
            toolTip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"perk.info.sealed.usage", (Object[])new Object[0]));
            RenderingUtils.renderBlueTooltip(mouseX, mouseY, toolTip, Minecraft.func_71410_x().field_71466_p);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            for (Map.Entry entry : this.thisFramePerks.entrySet()) {
                Collection<String> modInfo;
                String loc;
                if (!((Rectangle2D.Double)entry.getValue()).contains(mouseX, mouseY) || !this.guiBox.isInBox(mouseX - this.guiLeft, mouseY - this.guiTop)) continue;
                LinkedList<String> toolTip = new LinkedList<String>();
                AbstractPerk perk = (AbstractPerk)entry.getKey();
                PlayerProgress prog = ResearchManager.clientProgress;
                perk.getLocalizedTooltip().forEach(line -> toolTip.add(TextFormatting.GRAY.toString() + TextFormatting.ITALIC.toString() + line));
                if (prog.isPerkSealed(perk)) {
                    toolTip.add(TextFormatting.RED + I18n.func_135052_a((String)"perk.info.sealed", (Object[])new Object[0]));
                    toolTip.add(TextFormatting.RED + I18n.func_135052_a((String)"perk.info.sealed.break", (Object[])new Object[0]));
                } else if (prog.hasPerkUnlocked(perk)) {
                    toolTip.add(TextFormatting.GREEN + I18n.func_135052_a((String)"perk.info.active", (Object[])new Object[0]));
                } else if (perk.mayUnlockPerk(prog, (EntityPlayer)player)) {
                    toolTip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"perk.info.available", (Object[])new Object[0]));
                } else {
                    toolTip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"perk.info.locked", (Object[])new Object[0]));
                }
                if (Minecraft.func_71410_x().field_71474_y.field_82882_x && (loc = perk.getCategory().getLocalizedName()) != null) {
                    toolTip.add(TextFormatting.GRAY.toString() + TextFormatting.ITALIC.toString() + "[" + loc + "]");
                }
                if ((modInfo = perk.getSource()) != null) {
                    for (String line2 : modInfo) {
                        toolTip.add(TextFormatting.BLUE.toString() + TextFormatting.ITALIC.toString() + line2);
                    }
                }
                if (Minecraft.func_71410_x().field_71474_y.field_74330_P) {
                    toolTip.add("");
                    toolTip.add(TextFormatting.GRAY + perk.getRegistryName().toString());
                    toolTip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"misc.ctrlcopy", (Object[])new Object[0]));
                }
                RenderingUtils.renderBlueTooltip(mouseX, mouseY, toolTip, Minecraft.func_71410_x().field_71466_p);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                break;
            }
        }
        GlStateManager.func_179126_j();
        GL11.glEnable((int)3008);
        GlStateManager.func_179141_d();
    }

    private void drawPerkTree(float partialTicks) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179118_c();
        BufferBuilder connBuffer = drawBufferConnections.getBuffer();
        connBuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        texturePerkConnection.bindTexture();
        PlayerProgress progress = ResearchManager.getProgress((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Side.CLIENT);
        for (Tuple<AbstractPerk, AbstractPerk> perkConnection : PerkTree.PERK_TREE.getConnections()) {
            int alloc = 0;
            if (progress.hasPerkUnlocked((AbstractPerk)perkConnection.key)) {
                ++alloc;
            }
            if (progress.hasPerkUnlocked((AbstractPerk)perkConnection.value)) {
                ++alloc;
            }
            PerkTreePoint.AllocationStatus status = alloc == 2 ? PerkTreePoint.AllocationStatus.ALLOCATED : (alloc == 1 && progress.hasFreeAllocationPoint((EntityPlayer)player) ? PerkTreePoint.AllocationStatus.UNLOCKABLE : PerkTreePoint.AllocationStatus.UNALLOCATED);
            Point offsetOne = ((AbstractPerk)perkConnection.key).getPoint().getOffset();
            Point offsetTwo = ((AbstractPerk)perkConnection.value).getPoint().getOffset();
            Point2D.Double shiftOne = this.sizeHandler.evRelativePos(offsetOne);
            Point2D.Double shiftTwo = this.sizeHandler.evRelativePos(offsetTwo);
            this.drawConnection(connBuffer, status, shiftOne, shiftTwo, ClientScheduler.getClientTick() + (long)offsetOne.x + (long)offsetOne.y + (long)offsetTwo.x + (long)offsetTwo.y);
        }
        drawBufferConnections.draw();
        drawBuffer.beginDrawingPerks();
        ArrayList renderDynamic = Lists.newArrayList();
        for (PerkTreePoint<?> perkPoint : PerkTree.PERK_TREE.getPerkPoints()) {
            double y;
            Point offset = perkPoint.getOffset();
            double x = this.sizeHandler.evRelativePosX(offset.x);
            Rectangle2D.Double perkRect = this.drawPerk(drawBuffer, perkPoint, x, y = this.sizeHandler.evRelativePosY(offset.y), partialTicks, ClientScheduler.getClientTick() + (long)offset.x + (long)offset.y, progress.isPerkSealed((AbstractPerk)perkPoint.getPerk()), renderDynamic);
            if (perkRect == null) continue;
            this.thisFramePerks.put((AbstractPerk)perkPoint.getPerk(), perkRect);
        }
        drawBuffer.draw();
        renderDynamic.forEach(Runnable::run);
        GlStateManager.func_179141_d();
        this.unlockEffects.keySet().removeIf(perk -> !this.drawPerkUnlock((AbstractPerk)perk, this.unlockEffects.get(perk)));
        this.breakEffects.keySet().removeIf(perk -> !this.drawPerkSealBreak((AbstractPerk)perk, this.breakEffects.get(perk), partialTicks));
        TextureHelper.refreshTextureBindState();
    }

    private boolean drawPerkSealBreak(AbstractPerk perk, long tick, float pTicks) {
        SpriteSheetResource sprite;
        int count = (int)(ClientScheduler.getClientTick() - tick);
        if (count >= (sprite = SpriteLibrary.spriteBurstEffect3).getFrameCount()) {
            return false;
        }
        Point2D.Double oPos = this.sizeHandler.evRelativePos(perk.getOffset());
        Point2D.Double offset = this.shift2DOffset(oPos.x, oPos.y);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float sealFade = 1.0f - ((float)count + pTicks) / (float)sprite.getFrameCount();
        double width = 22.0;
        Rectangle2D.Double rct = this.thisFramePerks.get(perk);
        if (rct != null) {
            width = rct.width;
        }
        width *= 0.75;
        GlStateManager.func_179118_c();
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        SpriteLibrary.spritePerkSeal.bindTexture();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)offset.x, (double)offset.y, (double)0.0);
        Point pOffset = perk.getPoint().getOffset();
        this.drawSeal(vb, width, 0.0, 0.0, ClientScheduler.getClientTick() + (long)pOffset.x + (long)pOffset.y, sealFade * 0.75f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.85f);
        tes.func_78381_a();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        sprite.bindTexture();
        Vector3 starVec = new Vector3(-width, -width, 0.0);
        double uLength = sprite.getUWidth();
        double vLength = sprite.getVWidth();
        Tuple<Double, Double> off = sprite.getUVOffset(count);
        Point2D.Double frameUV = new Point2D.Double((Double)off.key, (Double)off.value);
        for (int i = 0; i < 4; ++i) {
            int u = (i + 1 & 2) >> 1;
            int v = (i + 2 & 2) >> 1;
            Vector3 pos = starVec.clone().addX(width * (double)u * 2.0).addY(width * (double)v * 2.0);
            vb.func_181662_b(pos.getX(), pos.getY(), pos.getZ()).func_187315_a(frameUV.x + uLength * (double)u, frameUV.y + vLength * (double)v).func_181675_d();
        }
        tes.func_78381_a();
        GlStateManager.func_179141_d();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TextureHelper.refreshTextureBindState();
        return true;
    }

    private boolean drawPerkUnlock(AbstractPerk perk, long tick) {
        SpriteSheetResource sprite;
        int count = (int)(ClientScheduler.getClientTick() - tick);
        if (count >= (sprite = SpriteLibrary.spritePerkActivate).getFrameCount()) {
            return false;
        }
        Point2D.Double oPos = this.sizeHandler.evRelativePos(perk.getOffset());
        Point2D.Double offset = this.shift2DOffset(oPos.x, oPos.y);
        double width = 22.0;
        Rectangle2D.Double rct = this.thisFramePerks.get(perk);
        if (rct != null) {
            width = rct.width;
        }
        width *= 2.5;
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        sprite.bindTexture();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)offset.x, (double)offset.y, (double)0.0);
        Vector3 starVec = new Vector3(-width, -width, 0.0);
        double uLength = sprite.getUWidth();
        double vLength = sprite.getVWidth();
        Tuple<Double, Double> off = sprite.getUVOffset(count);
        Point2D.Double frameUV = new Point2D.Double((Double)off.key, (Double)off.value);
        for (int i = 0; i < 4; ++i) {
            int u = (i + 1 & 2) >> 1;
            int v = (i + 2 & 2) >> 1;
            Vector3 pos = starVec.clone().addX(width * (double)u * 2.0).addY(width * (double)v * 2.0);
            vb.func_181662_b(pos.getX(), pos.getY(), pos.getZ()).func_187315_a(frameUV.x + uLength * (double)u, frameUV.y + vLength * (double)v).func_181675_d();
        }
        GlStateManager.func_179118_c();
        tes.func_78381_a();
        GlStateManager.func_179141_d();
        GlStateManager.func_179121_F();
        TextureHelper.refreshTextureBindState();
        return true;
    }

    private void drawConnection(BufferBuilder vb, PerkTreePoint.AllocationStatus status, Point2D.Double offset, Point2D.Double target, long effectTick) {
        Point2D.Double offsetSrc = this.shift2DOffset(offset.x, offset.y);
        Point2D.Double offsetDst = this.shift2DOffset(target.x, target.y);
        Color overlay = Color.WHITE;
        switch (status) {
            case UNALLOCATED: {
                overlay = new Color(0xBBBBFF);
                break;
            }
            case ALLOCATED: {
                overlay = new Color(0xEEEE00);
                break;
            }
            case UNLOCKABLE: {
                overlay = new Color(29183);
                break;
            }
        }
        double effectPart = (Math.sin(Math.toRadians((double)(effectTick * 8L) % 360.0)) + 1.0) / 4.0;
        float br = 0.1f + 0.4f * (2.0f - (float)effectPart);
        float rR = (float)overlay.getRed() / 255.0f * br;
        float rG = (float)overlay.getGreen() / 255.0f * br;
        float rB = (float)overlay.getBlue() / 255.0f * br;
        float rA = (float)overlay.getAlpha() / 255.0f * br;
        Vector3 fromStar = new Vector3(offsetSrc.x, offsetSrc.y, 0.0);
        Vector3 toStar = new Vector3(offsetDst.x, offsetDst.y, 0.0);
        double width = 4.0 * this.sizeHandler.getScalingFactor();
        Vector3 dir = toStar.clone().subtract(fromStar);
        Vector3 degLot = dir.clone().crossProduct(new Vector3(0, 0, 1)).normalize().multiply(width);
        Vector3 vec00 = fromStar.clone().add(degLot);
        Vector3 vecV = degLot.clone().multiply(-2);
        for (int i = 0; i < 4; ++i) {
            int u = (i + 1 & 2) >> 1;
            int v = (i + 2 & 2) >> 1;
            Vector3 pos = vec00.clone().add(dir.clone().multiply(u)).add(vecV.clone().multiply(v));
            vb.func_181662_b(pos.getX(), pos.getY(), pos.getZ()).func_187315_a((double)u, (double)v).func_181666_a(rR, rG, rB, rA).func_181675_d();
        }
    }

    @Nullable
    private Rectangle2D.Double drawPerk(BatchPerkContext ctx, PerkTreePoint perkPoint, double lowX, double lowY, float pTicks, long effectTick, boolean renderSeal, Collection<Runnable> outRenderDynamic) {
        Point2D.Double offset = this.shift2DOffset(lowX, lowY);
        double scale = this.sizeHandler.getScalingFactor();
        PerkTreePoint.AllocationStatus status = ((AbstractPerk)perkPoint.getPerk()).getPerkStatus((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Side.CLIENT);
        Rectangle2D.Double drawSize = perkPoint.renderPerkAtBatch(ctx, status, effectTick, pTicks, offset.x, offset.y, scale);
        if (perkPoint instanceof DynamicPerkRender) {
            outRenderDynamic.add(() -> ((DynamicPerkRender)((Object)perkPoint)).renderAt(status, effectTick, pTicks, offset.x, offset.y, scale));
        }
        if (drawSize == null) {
            return null;
        }
        if (renderSeal) {
            this.drawSeal(ctx, drawSize.width * 0.75, offset.x, offset.y, effectTick);
        }
        if (this.searchMatches.contains(perkPoint.getPerk())) {
            this.drawSearchMarkHalo(ctx, drawSize, offset.x, offset.y);
        }
        double mapDrawSize = 28.0;
        if (perkPoint.getPerk() instanceof AttributeConverterPerk) {
            for (PerkConverter converter : ((AttributeConverterPerk)perkPoint.getPerk()).getConverters()) {
                if (!(converter instanceof PerkConverter.Radius)) continue;
                double radius = ((PerkConverter.Radius)converter).getRadius();
                this.drawSearchHalo(ctx, mapDrawSize * radius * scale, offset.x, offset.y);
            }
        }
        return new Rectangle2D.Double(offset.x - drawSize.width / 2.0, offset.y - drawSize.height / 2.0, drawSize.width, drawSize.height);
    }

    private void drawSeal(BatchPerkContext ctx, double size, double x, double y, long spriteOffsetTick) {
        BufferBatch batch = ctx.getContext(sealContext);
        BufferBuilder vb = batch.getBuffer();
        this.drawSeal(vb, size, x, y, spriteOffsetTick, 1.0f);
    }

    private void drawSeal(BufferBuilder vb, double size, double x, double y, long spriteOffsetTick, float alpha) {
        SpriteSheetResource tex = SpriteLibrary.spritePerkSeal;
        if (tex == null) {
            return;
        }
        double uLength = tex.getULength();
        double vLength = tex.getVLength();
        Tuple<Double, Double> frameUV = tex.getUVOffset(spriteOffsetTick);
        Vector3 starVec = new Vector3(x - size, y - size, 0.0);
        for (int i = 0; i < 4; ++i) {
            int u = (i + 1 & 2) >> 1;
            int v = (i + 2 & 2) >> 1;
            Vector3 pos = starVec.clone().addX(size * (double)u * 2.0).addY(size * (double)v * 2.0);
            vb.func_181662_b(pos.getX(), pos.getY(), pos.getZ()).func_187315_a((Double)frameUV.key + uLength * (double)u, (Double)frameUV.value + vLength * (double)v).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        }
    }

    private void drawSearchMarkHalo(BatchPerkContext ctx, Rectangle2D.Double draw, double x, double y) {
        this.drawSearchHalo(ctx, draw.width, x, y);
    }

    private void drawSearchHalo(BatchPerkContext ctx, double size, double x, double y) {
        BufferBatch batch = ctx.getContext(searchContext);
        BufferBuilder vb = batch.getBuffer();
        Vector3 starVec = new Vector3(x - size, y - size, 0.0);
        double uLength = textureSearchMark.getUWidth();
        double vLength = textureSearchMark.getVWidth();
        Point2D.Double frameUV = textureSearchMark.getUVOffset();
        for (int i = 0; i < 4; ++i) {
            int u = (i + 1 & 2) >> 1;
            int v = (i + 2 & 2) >> 1;
            Vector3 pos = starVec.clone().addX(size * (double)u * 2.0).addY(size * (double)v * 2.0);
            vb.func_181662_b(pos.getX(), pos.getY(), pos.getZ()).func_187315_a(frameUV.x + uLength * (double)u, frameUV.y + vLength * (double)v).func_181666_a(0.8f, 0.1f, 0.1f, 1.0f).func_181675_d();
        }
    }

    private Point2D.Double shift2DOffset(double x, double y) {
        double scaledLeft = this.mousePosition.getScaledPosX() - this.sizeHandler.widthToBorder;
        double scaledTop = this.mousePosition.getScaledPosY() - this.sizeHandler.heightToBorder;
        double xAdd = x - scaledLeft;
        double yAdd = y - scaledTop;
        double offsetX = (double)this.guiOffsetX + xAdd;
        double offsetY = (double)this.guiOffsetY + yAdd;
        return new Point2D.Double(offsetX, offsetY);
    }

    private void handleMouseMovement(int mouseX, int mouseY) {
        int guiMouseX = mouseX - this.guiLeft;
        int guiMouseY = mouseY - this.guiTop;
        if (this.mouseSealStack.func_190926_b() && Mouse.isButtonDown((int)0) && this.guiBox.isInBox(guiMouseX, guiMouseY)) {
            if (this.mouseDragging) {
                this.moveMouse(-(guiMouseX - this.mouseBufferX), -(guiMouseY - this.mouseBufferY));
            } else {
                this.mouseBufferX = guiMouseX;
                this.mouseBufferY = guiMouseY;
                this.mouseDragging = true;
            }
        } else {
            this.applyMovedMouseOffset();
            this.mouseDragging = false;
        }
    }

    private void moveMouse(int changeX, int changeY) {
        if (this.previousMousePosition != null) {
            this.mousePosition.updateScaledPos(this.sizeHandler.clampX(this.previousMousePosition.getScaledPosX() + (double)changeX), this.sizeHandler.clampY(this.previousMousePosition.getScaledPosY() + (double)changeY), this.sizeHandler.getScalingFactor());
        } else {
            this.mousePosition.updateScaledPos(this.sizeHandler.clampX(changeX), this.sizeHandler.clampY(changeY), this.sizeHandler.getScalingFactor());
        }
    }

    private void applyMovedMouseOffset() {
        this.previousMousePosition = ScalingPoint.createPoint(this.mousePosition.getScaledPosX(), this.mousePosition.getScaledPosY(), this.sizeHandler.getScalingFactor(), true);
    }

    private void drawBackground(float zLevel) {
        float br = 0.8f;
        GlStateManager.func_179131_c((float)br, (float)br, (float)br, (float)1.0f);
        GlStateManager.func_179084_k();
        textureResBack.bindTexture();
        BufferBuilder vb = Tessellator.func_178181_a().func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_181662_b((double)(this.guiLeft + 10), (double)(this.guiTop - 10 + this.guiHeight), (double)zLevel).func_187315_a(0.0, 1.0).func_181675_d();
        vb.func_181662_b((double)(this.guiLeft - 10 + this.guiWidth), (double)(this.guiTop - 10 + this.guiHeight), (double)zLevel).func_187315_a(1.0, 1.0).func_181675_d();
        vb.func_181662_b((double)(this.guiLeft - 10 + this.guiWidth), (double)(this.guiTop + 10), (double)zLevel).func_187315_a(1.0, 0.0).func_181675_d();
        vb.func_181662_b((double)(this.guiLeft + 10), (double)(this.guiTop + 10), (double)zLevel).func_187315_a(0.0, 0.0).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void updateSearchHighlight() {
        this.searchMatches.clear();
        String matchText = this.searchTextEntry.getText().toLowerCase();
        if (matchText.length() < 3) {
            return;
        }
        block0: for (PerkTreePoint<?> point : PerkTree.PERK_TREE.getPerkPoints()) {
            Object perk = point.getPerk();
            if (perk instanceof ProgressGatedPerk && !((ProgressGatedPerk)perk).canSeeClient()) continue;
            String catStr = ((AbstractPerk)perk).getCategory().getLocalizedName();
            if (catStr != null && catStr.toLowerCase().contains(matchText)) {
                this.searchMatches.add((AbstractPerk)perk);
                continue;
            }
            for (String tooltip : ((AbstractPerk)perk).getLocalizedTooltip()) {
                if (!tooltip.toLowerCase().contains(matchText)) continue;
                this.searchMatches.add((AbstractPerk)perk);
                continue block0;
            }
        }
        if (I18n.func_135052_a((String)"perk.info.sealed", (Object[])new Object[0]).toLowerCase().contains(matchText)) {
            PlayerProgress prog = ResearchManager.clientProgress;
            for (AbstractPerk sealed : prog.getSealedPerks()) {
                if (this.searchMatches.contains(sealed)) continue;
                this.searchMatches.add(sealed);
            }
        }
    }

    private void closeSocketMenu() {
        this.socketMenu = null;
        this.rSocketMenu = null;
        this.slotsSocketMenu.clear();
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (!this.mouseSealStack.func_190926_b()) {
            this.mouseSealStack = ItemStack.field_190927_a;
            if (Minecraft.func_71410_x().field_71439_g == null) {
                return;
            }
            PlayerProgress prog = ResearchManager.clientProgress;
            for (Map.Entry<AbstractPerk, Rectangle2D.Double> rctPerk : this.thisFramePerks.entrySet()) {
                if (!rctPerk.getValue().contains(mouseX, mouseY) || !this.guiBox.isInBox(mouseX - this.guiLeft, mouseY - this.guiTop) || !prog.hasPerkUnlocked(rctPerk.getKey()) || prog.isPerkSealed(rctPerk.getKey()) || !ItemPerkSeal.useSeal((EntityPlayer)player, true)) continue;
                PktRequestPerkSealAction pkt = new PktRequestPerkSealAction(rctPerk.getKey(), true);
                PacketChannel.CHANNEL.sendToServer((IMessage)pkt);
                break;
            }
            return;
        }
        if (this.unlockPrimed == null) {
            return;
        }
        for (Map.Entry<AbstractPerk, Rectangle2D.Double> rctPerk : this.thisFramePerks.entrySet()) {
            if (!this.unlockPrimed.equals(rctPerk.getKey()) || !rctPerk.getValue().contains(mouseX, mouseY) || !this.guiBox.isInBox(mouseX - this.guiLeft, mouseY - this.guiTop) || !rctPerk.getKey().mayUnlockPerk(ResearchManager.clientProgress, (EntityPlayer)player)) continue;
            PktUnlockPerk pkt = new PktUnlockPerk(false, rctPerk.getKey());
            PacketChannel.CHANNEL.sendToServer((IMessage)pkt);
            break;
        }
        this.unlockPrimed = null;
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        this.unlockPrimed = null;
    }

    @Override
    protected boolean handleRightClickClose(int mouseX, int mouseY) {
        if (rectSearchTextEntry.contains(mouseX - this.guiLeft, mouseY - this.guiTop)) {
            this.searchTextEntry.setText("");
            return true;
        }
        if (this.socketMenu != null && this.rSocketMenu != null && !this.rSocketMenu.contains(mouseX, mouseY)) {
            this.closeSocketMenu();
            return true;
        }
        for (Map.Entry<AbstractPerk, Rectangle2D.Double> rctPerk : this.thisFramePerks.entrySet()) {
            AbstractPerk perk;
            if (!rctPerk.getValue().contains(mouseX, mouseY) || !this.guiBox.isInBox(mouseX - this.guiLeft, mouseY - this.guiTop) || !((perk = rctPerk.getKey()) instanceof GemSlotPerk)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        Point p = new Point(mouseX, mouseY);
        if (!(this.socketMenu == null || mouseButton != 0 && mouseButton != 1 || this.rSocketMenu == null || this.rSocketMenu.contains(p))) {
            this.closeSocketMenu();
        }
        if (mouseButton == 0) {
            if (this.socketMenu != null) {
                for (Rectangle r : this.slotsSocketMenu.keySet()) {
                    if (!r.contains(p) || this.socketMenu.hasItem((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Side.CLIENT)) continue;
                    int slotId = this.slotsSocketMenu.get(r);
                    ItemStack potentialStack = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70301_a(slotId);
                    if (!potentialStack.func_190926_b() && !ItemPerkGem.getModifiers(potentialStack).isEmpty()) {
                        PktPerkGemModification pkt = PktPerkGemModification.insertItem((AbstractPerk)((Object)this.socketMenu), slotId);
                        PacketChannel.CHANNEL.sendToServer((IMessage)pkt);
                        this.closeSocketMenu();
                        SoundHelper.playSoundClient(SoundEvents.field_187567_bP, 0.35f, 9.0f);
                    }
                    return;
                }
            }
            if (this.handleBookmarkClick(p)) {
                return;
            }
            if (rectSealBox.contains(mouseX - this.guiLeft, mouseY - this.guiTop)) {
                if (!this.foundSeals.func_190926_b()) {
                    this.mouseSealStack = new ItemStack((Item)ItemsAS.perkSeal);
                }
                return;
            }
            if (this.rStatStar.contains(mouseX, mouseY)) {
                this.expectReinit = true;
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiJournalOverlayPerkStats(this));
                return;
            }
        }
        PlayerProgress prog = ResearchManager.clientProgress;
        for (Map.Entry<AbstractPerk, Rectangle2D.Double> rctPerk : this.thisFramePerks.entrySet()) {
            if (!rctPerk.getValue().contains(mouseX, mouseY) || !this.guiBox.isInBox(mouseX - this.guiLeft, mouseY - this.guiTop)) continue;
            AbstractPerk perk = rctPerk.getKey();
            if (mouseButton == 0 && Minecraft.func_71410_x().field_71474_y.field_74330_P && GuiJournalPerkTree.func_146271_m()) {
                String perkKey = perk.getRegistryName().toString();
                GuiScreen.func_146275_d((String)perkKey);
                Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentTranslation("misc.ctrlcopy.copied", new Object[]{perkKey}));
                break;
            }
            if (mouseButton == 1) {
                if (!prog.hasPerkEffect(perk) || !(perk instanceof GemSlotPerk)) continue;
                if (((GemSlotPerk)((Object)perk)).hasItem((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Side.CLIENT)) {
                    PktPerkGemModification pkt = PktPerkGemModification.dropItem(perk);
                    PacketChannel.CHANNEL.sendToServer((IMessage)pkt);
                    AstralSorcery.proxy.scheduleClientside(() -> {
                        if (Minecraft.func_71410_x().field_71462_r == this) {
                            this.updateSearchHighlight();
                        }
                    }, 10);
                    SoundHelper.playSoundClient(SoundEvents.field_187567_bP, 0.35f, 9.0f);
                    return;
                }
                this.socketMenu = (GemSlotPerk)((Object)perk);
                return;
            }
            if (mouseButton != 0) continue;
            if (perk.handleMouseClick(this, mouseX, mouseY)) {
                return;
            }
            if (!prog.hasPerkUnlocked(perk) && perk.mayUnlockPerk(prog, (EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                this.unlockPrimed = perk;
                break;
            }
            if (this.sealBreakPrimed != null && this.tickSealBreak > 0) {
                PktRequestPerkSealAction pkt = new PktRequestPerkSealAction(perk, false);
                PacketChannel.CHANNEL.sendToServer((IMessage)pkt);
                return;
            }
            if (!prog.isPerkSealed(perk)) continue;
            this.sealBreakPrimed = perk;
            this.tickSealBreak = 4;
        }
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        if (keyCode != 1) {
            this.searchTextEntry.textboxKeyTyped(typedChar, keyCode);
        }
    }

    public void playUnlockAnimation(AbstractPerk perk) {
        this.unlockEffects.put(perk, ClientScheduler.getClientTick());
    }

    public void playSealBreakAnimation(AbstractPerk perk) {
        this.updateSearchHighlight();
        this.breakEffects.put(perk, ClientScheduler.getClientTick());
    }
}

