/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core.part;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetwork;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetworkIngredients;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.part.PartStateBase;
import org.cyclops.integratedtunnels.core.part.ContainerInterfaceSettings;
import org.cyclops.integratedtunnels.core.part.GuiInterfaceSettings;
import org.cyclops.integratedtunnels.core.part.PartTypeTunnel;

public abstract class PartTypeInterfacePositionedAddon<N extends IPositionedAddonsNetwork, T, P extends IPartType<P, S>, S extends State<P, N, T>>
extends PartTypeTunnel<P, S> {
    public PartTypeInterfacePositionedAddon(String name) {
        super(name);
    }

    @Override
    public Class<? extends GuiScreen> getGui() {
        return GuiInterfaceSettings.class;
    }

    @Override
    public Class<? extends Container> getContainer() {
        return ContainerInterfaceSettings.class;
    }

    protected abstract Capability<N> getNetworkCapability();

    protected abstract Capability<T> getTargetCapability();

    protected boolean isTargetCapabilityValid(T capability) {
        return capability != null;
    }

    public void afterNetworkReAlive(INetwork network, IPartNetwork partNetwork, PartTarget target, S state) {
        super.afterNetworkReAlive(network, partNetwork, target, state);
        this.addTargetToNetwork(network, target.getTarget(), state.getPriority(), ((State)((Object)state)).getChannelInterface(), state);
    }

    protected void scheduleNetworkObservation(PartTarget target, S state) {
        Object positionedAddonsNetwork = ((State)((Object)state)).getPositionedAddonsNetwork();
        if (positionedAddonsNetwork instanceof IPositionedAddonsNetworkIngredients) {
            ((IPositionedAddonsNetworkIngredients)positionedAddonsNetwork).scheduleObservationForced(((State)((Object)state)).getChannelInterface(), target.getCenter());
        }
    }

    public void onNetworkRemoval(INetwork network, IPartNetwork partNetwork, PartTarget target, S state) {
        super.onNetworkRemoval(network, partNetwork, target, state);
        this.scheduleNetworkObservation(target, state);
        this.removeTargetFromNetwork(network, target.getTarget(), state);
    }

    public void onNetworkAddition(INetwork network, IPartNetwork partNetwork, PartTarget target, S state) {
        super.onNetworkAddition(network, partNetwork, target, state);
        this.addTargetToNetwork(network, target.getTarget(), state.getPriority(), ((State)((Object)state)).getChannelInterface(), state);
        this.scheduleNetworkObservation(target, state);
    }

    public void onBlockNeighborChange(@Nullable INetwork network, @Nullable IPartNetwork partNetwork, PartTarget target, S state, IBlockAccess world, Block neighborBlock) {
        super.onBlockNeighborChange(network, partNetwork, target, state, world, neighborBlock);
        if (network != null) {
            this.updateTargetInNetwork(network, target.getTarget(), state.getPriority(), ((State)((Object)state)).getChannelInterface(), state);
        }
    }

    public void setPriorityAndChannel(INetwork network, IPartNetwork partNetwork, PartTarget target, S state, int priority, int channel) {
        this.removeTargetFromNetwork(network, target.getTarget(), state);
        super.setPriorityAndChannel(network, partNetwork, target, state, priority, channel);
        this.addTargetToNetwork(network, target.getTarget(), priority, ((State)((Object)state)).getChannelInterface(), state);
    }

    protected T getTargetCapabilityInstance(PartPos pos) {
        return (T)TileHelpers.getCapability((DimPos)pos.getPos(), (EnumFacing)pos.getSide(), this.getTargetCapability());
    }

    protected void addTargetToNetwork(INetwork network, PartPos pos, int priority, int channelInterface, S state) {
        if (network.hasCapability(this.getNetworkCapability())) {
            T capability = this.getTargetCapabilityInstance(pos);
            boolean validTargetCapability = this.isTargetCapabilityValid(capability);
            if (validTargetCapability) {
                IPositionedAddonsNetwork networkCapability = (IPositionedAddonsNetwork)network.getCapability(this.getNetworkCapability());
                networkCapability.addPosition(pos, priority, channelInterface);
            }
            ((State)((Object)state)).setPositionedAddonsNetwork((IPositionedAddonsNetwork)((IPositionedAddonsNetwork)network.getCapability(this.getNetworkCapability())));
            ((State)((Object)state)).setPos(pos);
            ((State)((Object)state)).setValidTargetCapability(validTargetCapability);
        }
    }

    protected void removeTargetFromNetwork(INetwork network, PartPos pos, S state) {
        if (network.hasCapability(this.getNetworkCapability())) {
            IPositionedAddonsNetwork networkCapability = (IPositionedAddonsNetwork)network.getCapability(this.getNetworkCapability());
            networkCapability.removePosition(pos);
        }
        ((State)((Object)state)).setPositionedAddonsNetwork(null);
        ((State)((Object)state)).setPos(null);
        ((State)((Object)state)).setValidTargetCapability(false);
    }

    protected void updateTargetInNetwork(INetwork network, PartPos pos, int priority, int channelInterface, S state) {
        boolean wasValidTargetCapability;
        T capability;
        boolean validTargetCapability;
        if (network.hasCapability(this.getNetworkCapability()) && (validTargetCapability = this.isTargetCapabilityValid(capability = this.getTargetCapabilityInstance(pos))) != (wasValidTargetCapability = ((State)((Object)state)).isValidTargetCapability())) {
            this.removeTargetFromNetwork(network, pos, state);
            this.addTargetToNetwork(network, pos, priority, channelInterface, state);
        }
    }

    public static abstract class State<P extends IPartType, N extends IPositionedAddonsNetwork, T>
    extends PartStateBase<P> {
        private N positionedAddonsNetwork = null;
        private PartPos pos = null;
        private boolean validTargetCapability = false;
        private int channelInterface = 0;

        public void readFromNBT(NBTTagCompound tag) {
            super.readFromNBT(tag);
            this.channelInterface = tag.func_150297_b("channelInterface", 3) ? tag.func_74762_e("channelInterface") : this.getChannel();
        }

        public void writeToNBT(NBTTagCompound tag) {
            super.writeToNBT(tag);
            tag.func_74768_a("channelInterface", this.channelInterface);
        }

        public void setChannelInterface(int channelInterface) {
            this.channelInterface = channelInterface;
            this.sendUpdate();
        }

        public int getChannelInterface() {
            return this.channelInterface;
        }

        protected abstract Capability<T> getTargetCapability();

        public N getPositionedAddonsNetwork() {
            return this.positionedAddonsNetwork;
        }

        public void setPositionedAddonsNetwork(N positionedAddonsNetwork) {
            this.positionedAddonsNetwork = positionedAddonsNetwork;
        }

        public boolean isValidTargetCapability() {
            return this.validTargetCapability;
        }

        public void setValidTargetCapability(boolean validTargetCapability) {
            this.validTargetCapability = validTargetCapability;
        }

        public PartPos getPos() {
            return this.pos;
        }

        public void setPos(PartPos pos) {
            this.pos = pos;
        }

        protected void disablePosition() {
            N positionedNetwork = this.getPositionedAddonsNetwork();
            PartPos pos = this.getPos();
            if (positionedNetwork != null) {
                positionedNetwork.disablePosition(pos);
            }
        }

        protected void enablePosition() {
            N positionedNetwork = this.getPositionedAddonsNetwork();
            PartPos pos = this.getPos();
            if (positionedNetwork != null) {
                positionedNetwork.enablePosition(pos);
            }
        }

        protected boolean isPositionEnabled() {
            N positionedNetwork = this.getPositionedAddonsNetwork();
            PartPos pos = this.getPos();
            if (positionedNetwork != null) {
                return !positionedNetwork.isPositionDisabled(pos);
            }
            return true;
        }

        public boolean hasCapability(Capability<?> capability, IPartNetwork network, PartTarget target) {
            return this.getPositionedAddonsNetwork() != null && capability == this.getTargetCapability() && this.isPositionEnabled() || super.hasCapability(capability, network, target);
        }

        public <T2> T2 getCapability(Capability<T2> capability, IPartNetwork network, PartTarget target) {
            if (this.getPositionedAddonsNetwork() != null && capability == this.getTargetCapability()) {
                if (!this.isPositionEnabled()) {
                    return null;
                }
                return (T2)((Object)this);
            }
            return (T2)super.getCapability(capability, network, target);
        }
    }
}

