/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.mmec.common.entity;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import me.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import me.ichun.mods.ichunutil.common.core.util.EntityHelper;
import me.ichun.mods.mmec.client.entity.EntityChickenNode;
import me.ichun.mods.mmec.client.entity.IEntityRenderParent;
import me.ichun.mods.mmec.client.sound.ChickenBossMusic;
import me.ichun.mods.mmec.client.sound.ChickenLaserLoop;
import me.ichun.mods.mmec.common.MightyEnderChicken;
import me.ichun.mods.mmec.common.core.ChunkLoadHandler;
import me.ichun.mods.mmec.common.core.SoundIndex;
import me.ichun.mods.mmec.common.entity.ai.EntityAIBreakEgg;
import me.ichun.mods.mmec.common.entity.ai.EntityAICharging;
import me.ichun.mods.mmec.common.entity.ai.EntityAIClearArea;
import me.ichun.mods.mmec.common.entity.ai.EntityAIClearSurroundingsOfEntities;
import me.ichun.mods.mmec.common.entity.ai.EntityAIDoIntro;
import me.ichun.mods.mmec.common.entity.ai.EntityAIForcefieldRetaliation;
import me.ichun.mods.mmec.common.entity.ai.EntityAILaser;
import me.ichun.mods.mmec.common.entity.ai.EntityAILookAtTarget;
import me.ichun.mods.mmec.common.entity.ai.EntityAINearestAttackableTargetCustomYRange;
import me.ichun.mods.mmec.common.entity.ai.EntityAIRegenerateForcefield;
import me.ichun.mods.mmec.common.entity.ai.EntityAISpinningAttack;
import me.ichun.mods.mmec.common.entity.ai.EntityAIStrafingRun;
import me.ichun.mods.mmec.common.entity.ai.EntityAITargetPlayer;
import me.ichun.mods.mmec.common.entity.ai.EntityAIWander;
import me.ichun.mods.mmec.common.packet.PacketAttackForcefield;
import me.ichun.mods.mmec.common.packet.PacketBreakEggEffects;
import me.ichun.mods.mmec.common.world.ExplosionChicken;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.command.CommandKill;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityFlyHelper;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketExplosion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityEnderChicken
extends EntityMob
implements IEntityMultiPart,
IEntityRenderParent {
    public static final DataParameter<Float> SCALE = EntityDataManager.func_187226_a(EntityEnderChicken.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Boolean> FIRING = EntityDataManager.func_187226_a(EntityEnderChicken.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Integer> EGG_STATE = EntityDataManager.func_187226_a(EntityEnderChicken.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Boolean> CHARGING = EntityDataManager.func_187226_a(EntityEnderChicken.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> FLAPPING = EntityDataManager.func_187226_a(EntityEnderChicken.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> CLEAR_AREA = EntityDataManager.func_187226_a(EntityEnderChicken.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> SPINNING = EntityDataManager.func_187226_a(EntityEnderChicken.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> FORCEFIELD = EntityDataManager.func_187226_a(EntityEnderChicken.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Integer> INTRO_STATE = EntityDataManager.func_187226_a(EntityEnderChicken.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final String[] LOOK_HELPER_NAME = new String[]{"field_70749_g", "lookHelper"};
    public MultiPartEntityPart[] partArray;
    public MultiPartEntityPart partFootL = new MultiPartEntityPartCustom(this, "footL", 0.1875f, 0.0625f);
    public MultiPartEntityPart partFootR = new MultiPartEntityPartCustom(this, "footR", 0.1875f, 0.0625f);
    public MultiPartEntityPart partLegL = new MultiPartEntityPartCustom(this, "legL", 0.0625f, 0.3125f);
    public MultiPartEntityPart partLegR = new MultiPartEntityPartCustom(this, "legR", 0.0625f, 0.3125f);
    public MultiPartEntityPart partBody = new MultiPartEntityPartCustom(this, "body", 0.375f, 0.375f);
    public MultiPartEntityPart partWingL = new MultiPartEntityPartCustom(this, "wingL", 0.25f, 0.1875f);
    public MultiPartEntityPart partWingR = new MultiPartEntityPartCustom(this, "wingR", 0.25f, 0.1875f);
    public MultiPartEntityPart partHead = new MultiPartEntityPartCustom(this, "head", 0.21875f, 0.375f);
    public MultiPartEntityPart partBill = new MultiPartEntityPartCustom(this, "bill", 0.1875f, 0.25f);
    public MultiPartEntityPart partForcefield = new MultiPartEntityPartCustom(this, "forcefield", 0.9375f, 0.9375f);
    public BossInfoServer bossInfo = new BossInfoServer(this.func_145748_c_(), BossInfo.Color.PINK, BossInfo.Overlay.NOTCHED_10);
    public final Predicate<Entity> predicateTargets = Predicates.and((Predicate)EntitySelectors.field_180132_d, ent -> ent.func_70067_L() && ent.field_70173_aa > 60);
    public boolean isPecking;
    public int peckProgress;
    public boolean flapping;
    public float wingRotation;
    public float destPos;
    public float oFlapSpeed;
    public float oFlap;
    public float wingRotDelta = 1.0f;
    public float lastScale = -1.0f;
    public int abilityInUse;
    public EntityDragon dragonDummy;
    public int firingProgress;
    public int breathCooldown;
    public int explosionCooldown;
    public double laserDist;
    public int maxStrafingRunTime;
    public boolean clearArea;
    public int clearAreaTime;
    public EntityLivingBase forcefieldAttacker;
    public boolean doingIntro = false;
    public boolean doneIntro = false;
    public int deathTicks;
    public HashSet<String> ffInform = new HashSet();
    public ArrayList<EntityChickenNode> renderNodes = new ArrayList();
    public float lastPartialTickRender = 0.0f;
    @SideOnly(value=Side.CLIENT)
    public ChickenLaserLoop soundLaserLoop;
    @SideOnly(value=Side.CLIENT)
    public ChickenBossMusic soundBossMusic;
    @SideOnly(value=Side.CLIENT)
    public boolean ffState;
    @SideOnly(value=Side.CLIENT)
    public int ffTime;
    public int lastIntroState = 0;
    public int spinTime;
    public int healTime;
    public DamageSource deathCause;
    private static final Pattern FAKE_PLAYER_PATTERN = Pattern.compile("^(?:\\[.*\\])|(?:ComputerCraft)$");

    public EntityEnderChicken(World worldIn) {
        super(worldIn);
        this.partArray = new MultiPartEntityPart[]{this.partFootL, this.partFootR, this.partLegL, this.partLegR, this.partBody, this.partWingL, this.partWingR, this.partHead, this.partBill, this.partForcefield};
        this.field_70178_ae = MightyEnderChicken.config.chickensImmuneToFire == 1;
        this.field_70158_ak = true;
        float scale = this.getScale();
        this.func_70105_a(0.4f * scale * 2.5f, 0.9f * scale * 1.05f);
        this.field_70138_W = 0.9f * scale * 0.34f;
        this.field_70765_h = new EntityFlyHelper((EntityLiving)this);
        this.doneIntro = true;
        ObfuscationReflectionHelper.setPrivateValue(EntityLiving.class, (Object)this, (Object)((Object)new EntityLookHelperChicken(this)), (String[])LOOK_HELPER_NAME);
    }

    public EntityEnderChicken(World world, float rotation, float scale, BossInfoServer info) {
        this(world);
        this.field_70758_at = this.field_70759_as = rotation;
        this.field_70177_z = this.field_70759_as;
        this.field_70126_B = this.field_70759_as;
        this.field_70761_aq = this.field_70759_as;
        this.field_70760_ar = this.field_70759_as;
        this.setScale(scale);
        this.func_70105_a(0.4f * scale * 2.5f, 0.9f * scale * 1.05f);
        this.field_70138_W = 0.9f * scale * 0.34f;
        this.bossInfo = info;
        this.bossInfo.func_186739_a(this.func_145748_c_());
        if (this.getIsChaos()) {
            this.bossInfo.func_186745_a(BossInfo.Color.GREEN);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)((float)MightyEnderChicken.config.healthChaosChicken * this.getScale()));
            this.func_70606_j(this.func_110138_aP());
            this.field_70714_bg.field_75782_a.clear();
            this.field_70715_bh.field_75782_a.clear();
            this.func_184651_r();
            this.func_184212_Q().func_187227_b(INTRO_STATE, (Object)1);
            this.bossInfo.func_186741_a(true);
            this.doneIntro = false;
        }
    }

    public void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIBreakEgg(this, 0.0075f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.addAttackSkills();
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookAtTarget(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetPlayer(this));
        if (MightyEnderChicken.config.targetAllLiving == 1) {
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTargetCustomYRange((EntityCreature)this, EntityLiving.class, true, 4.0 + 0.3 * (double)this.getScale()));
        }
    }

    private void addAttackSkills() {
        int priority = 3;
        float multiplier = 1.0f;
        String[] skillSet = MightyEnderChicken.config.enderChickenSkillSet;
        if (this.getIsChaos()) {
            multiplier = (float)MightyEnderChicken.config.chaosChickenSkillChanceMultiplier / 100.0f;
            skillSet = MightyEnderChicken.config.chaosChickenSkillSet;
            this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIDoIntro(this));
        }
        String[] stringArray = skillSet;
        int n = stringArray.length;
        block20: for (int i = 0; i < n; ++i) {
            String s;
            switch (s = stringArray[i]) {
                case "charging": {
                    this.field_70714_bg.func_75776_a(priority, (EntityAIBase)new EntityAICharging(this, (float)MightyEnderChicken.config.chargingChance / 1000.0f * multiplier));
                    continue block20;
                }
                case "clearArea": {
                    this.field_70714_bg.func_75776_a(priority, (EntityAIBase)new EntityAIClearArea(this, (float)MightyEnderChicken.config.clearAreaChance / 1000.0f * multiplier));
                    continue block20;
                }
                case "clearEntities": {
                    this.field_70714_bg.func_75776_a(priority, (EntityAIBase)new EntityAIClearSurroundingsOfEntities(this, (float)MightyEnderChicken.config.flapChance / 1000.0f * multiplier));
                    continue block20;
                }
                case "laser": {
                    this.field_70714_bg.func_75776_a(priority, (EntityAIBase)new EntityAILaser(this, (float)MightyEnderChicken.config.laserChance / 1000.0f * multiplier));
                    continue block20;
                }
                case "regenForcefield": {
                    this.field_70714_bg.func_75776_a(priority, (EntityAIBase)new EntityAIRegenerateForcefield(this, (float)MightyEnderChicken.config.regenerateForcefieldChance / 1000.0f * multiplier));
                    continue block20;
                }
                case "strafingRun": {
                    this.field_70714_bg.func_75776_a(priority, (EntityAIBase)new EntityAIStrafingRun(this, (float)MightyEnderChicken.config.strafingRunChance / 1000.0f * multiplier));
                    continue block20;
                }
                case "ffRetaliate": {
                    this.field_70714_bg.func_75776_a(priority, (EntityAIBase)new EntityAIForcefieldRetaliation(this));
                    continue block20;
                }
                case "spinning": {
                    this.field_70714_bg.func_75776_a(priority, (EntityAIBase)new EntityAISpinningAttack(this, (float)MightyEnderChicken.config.spinningChance / 1000.0f * multiplier));
                    continue block20;
                }
            }
        }
    }

    public void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)((float)MightyEnderChicken.config.healthEnderChicken * this.getScale()));
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0 + (double)this.getScale() * 2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a((double)0.9f);
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(SCALE, (Object)Float.valueOf((float)(this.getIsChaos() ? MightyEnderChicken.config.scaleChaosChicken : MightyEnderChicken.config.scaleEnderChicken) * 0.1f));
        this.func_184212_Q().func_187214_a(FIRING, (Object)false);
        this.func_184212_Q().func_187214_a(EGG_STATE, (Object)0);
        this.func_184212_Q().func_187214_a(CHARGING, (Object)false);
        this.func_184212_Q().func_187214_a(FLAPPING, (Object)false);
        this.func_184212_Q().func_187214_a(CLEAR_AREA, (Object)false);
        this.func_184212_Q().func_187214_a(SPINNING, (Object)false);
        this.func_184212_Q().func_187214_a(FORCEFIELD, (Object)false);
        this.func_184212_Q().func_187214_a(INTRO_STATE, (Object)0);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return true;
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    public float func_70047_e() {
        return 0.85f * this.getScale();
    }

    public void func_70106_y() {
        super.func_70106_y();
        for (EntityChickenNode node : this.renderNodes) {
            node.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K) {
            this.stopClientSound();
        } else {
            ChunkLoadHandler.removeTicket(this);
        }
    }

    public void func_70623_bb() {
        this.field_70708_bq = 0;
    }

    public Entity[] func_70021_al() {
        return this.partArray;
    }

    public void func_174812_G() {
        StackTraceElement[] stacks;
        boolean illegitimateKill = true;
        for (StackTraceElement stack : stacks = Thread.currentThread().getStackTrace()) {
            try {
                Class<?> clz = Class.forName(stack.getClassName());
                if (!CommandKill.class.isAssignableFrom(clz)) continue;
                illegitimateKill = false;
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (illegitimateKill) {
            this.healTime = 20;
        } else {
            this.doneIntro = true;
            while (this.getEggState() >= 0) {
                this.breakEgg();
            }
            if (this.getForcefield()) {
                this.setForcefield(false);
            }
            this.bossInfo.func_186735_a(0.0f);
            super.func_174812_G();
        }
    }

    public boolean shouldIgnoreDamage(DamageSource source) {
        return source.equals(DamageSource.field_188407_q) || source.func_76346_g() == this || source.func_76346_g() instanceof EntityEnderChicken || source.func_76346_g() instanceof EntityPlayer && !this.isTruePlayer((EntityPlayer)source.func_76346_g()) || source.func_94541_c() || this.getEggState() >= 0 || this.getForcefield() || this.doingIntro;
    }

    public boolean isTruePlayer(EntityPlayer player) {
        return !(player instanceof FakePlayer) && !FAKE_PLAYER_PATTERN.matcher(player.func_70005_c_()).matches();
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.shouldIgnoreDamage(source)) {
            return false;
        }
        if (source.equals(DamageSource.field_76368_d)) {
            this.clearArea = true;
            return false;
        }
        if (source != DamageSource.field_76380_i && MightyEnderChicken.config.minHitsRequired > 1 && damage > (float)MathHelper.func_76123_f((float)(this.func_110138_aP() / (float)MightyEnderChicken.config.minHitsRequired))) {
            damage = MathHelper.func_76123_f((float)(this.func_110138_aP() / (float)MightyEnderChicken.config.minHitsRequired));
        }
        return super.func_70097_a(source, damage);
    }

    public boolean func_70965_a(MultiPartEntityPart part, DamageSource source, float damage) {
        if (this.getEggState() >= 0) {
            if (damage > this.func_110138_aP() / 10.0f) {
                if (!this.field_70170_p.field_72995_K) {
                    this.breakEgg();
                }
                return true;
            }
            return false;
        }
        if (this.getForcefield() && this.getEggState() < 0) {
            if (part.field_146032_b.equals("forcefield") && source.func_76355_l().equals("player") && source.func_76346_g() instanceof EntityLivingBase && source instanceof EntityDamageSource && !((EntityDamageSource)source).func_180139_w() && (MightyEnderChicken.config.forcefieldBreakItem.equals("null") || new ResourceLocation(MightyEnderChicken.config.forcefieldBreakItem).equals((Object)((EntityLivingBase)source.func_76346_g()).func_184614_ca().func_77973_b().getRegistryName()))) {
                EntityPlayer player;
                if (!this.field_70170_p.field_72995_K) {
                    this.setForcefield(false);
                    this.forcefieldAttacker = (EntityLivingBase)source.func_76346_g();
                    this.func_70624_b(this.forcefieldAttacker);
                } else if (source.func_76346_g() instanceof EntityPlayer && (player = (EntityPlayer)source.func_76346_g()).func_70068_e((Entity)part) > 36.0) {
                    MightyEnderChicken.channel.sendToServer((AbstractPacket)new PacketAttackForcefield(this));
                }
                return true;
            }
            if (!this.field_70170_p.field_72995_K && source.func_76346_g() instanceof EntityPlayer) {
                Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(MightyEnderChicken.config.forcefieldBreakItem));
                EntityPlayer player = (EntityPlayer)source.func_76346_g();
                if (!this.ffInform.contains(player.func_70005_c_())) {
                    this.ffInform.add(player.func_70005_c_());
                    if (MightyEnderChicken.config.forcefieldBreakItem.equals("null") || item != null) {
                        String name = MightyEnderChicken.config.forcefieldBreakItem.equals("null") ? I18n.func_74838_a((String)"text.chicken.attack_melee") : item.func_77653_i(new ItemStack(item));
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("text.chicken.attack_with_stick", new Object[]{name}));
                    } else {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("text.chicken.attack_misconfigured", new Object[0]));
                    }
                }
                return false;
            }
        } else if (!part.field_146032_b.equals("forcefield")) {
            return this.func_70097_a(source, damage);
        }
        return false;
    }

    public void setScale(float f) {
        this.func_184212_Q().func_187227_b(SCALE, (Object)Float.valueOf(f));
    }

    public float getScale() {
        return ((Float)this.func_184212_Q().func_187225_a(SCALE)).floatValue();
    }

    public void setFiring(boolean flag) {
        this.func_184212_Q().func_187227_b(FIRING, (Object)flag);
    }

    public boolean getFiring() {
        return (Boolean)this.func_184212_Q().func_187225_a(FIRING);
    }

    public void setEggState(int state) {
        this.func_184212_Q().func_187227_b(EGG_STATE, (Object)state);
    }

    public int getEggState() {
        return (Integer)this.func_184212_Q().func_187225_a(EGG_STATE);
    }

    public boolean getIsChaos() {
        return false;
    }

    public void setCharging(boolean flag) {
        this.func_184212_Q().func_187227_b(CHARGING, (Object)flag);
    }

    public boolean getCharging() {
        return (Boolean)this.func_184212_Q().func_187225_a(CHARGING);
    }

    public void setFlapping(boolean flag) {
        this.func_184212_Q().func_187227_b(FLAPPING, (Object)flag);
    }

    public boolean getFlapping() {
        return (Boolean)this.func_184212_Q().func_187225_a(FLAPPING);
    }

    public void setClearingArea(boolean flag) {
        this.func_184212_Q().func_187227_b(CLEAR_AREA, (Object)flag);
    }

    public boolean getClearingArea() {
        return (Boolean)this.func_184212_Q().func_187225_a(CLEAR_AREA);
    }

    public void setSpinning(boolean flag) {
        this.func_184212_Q().func_187227_b(SPINNING, (Object)flag);
    }

    public boolean getSpinning() {
        return (Boolean)this.func_184212_Q().func_187225_a(SPINNING);
    }

    public void setForcefield(boolean flag) {
        if (this.getForcefield() != flag) {
            this.func_184185_a(flag ? SoundIndex.ff_on : SoundIndex.ff_off, 0.3f * this.getScale(), 0.9f + this.field_70146_Z.nextFloat() * 0.2f);
            this.ffInform.clear();
        }
        this.func_184212_Q().func_187227_b(FORCEFIELD, (Object)flag);
    }

    public boolean getForcefield() {
        return (Boolean)this.func_184212_Q().func_187225_a(FORCEFIELD);
    }

    public void func_82142_c(boolean invisible) {
    }

    public boolean canUseAbility() {
        if (this.doingIntro || !this.func_70089_S()) {
            return false;
        }
        return this.abilityInUse < MightyEnderChicken.config.maxSkillsAtOnce || this.getIsChaos();
    }

    public void useAbility() {
        ++this.abilityInUse;
    }

    public void endAbility() {
        --this.abilityInUse;
    }

    public void peck() {
        if (!this.isPecking) {
            this.isPecking = true;
            this.peckProgress = 0;
        }
    }

    public boolean shouldClearArea() {
        if (this.clearArea) {
            this.clearArea = false;
            return true;
        }
        return this.isHeadAvailable() && this.partInOpaque(this.partHead) || this.partInOpaque(this.partWingL) || this.partInOpaque(this.partWingR);
    }

    public boolean partInOpaque(MultiPartEntityPart part) {
        float width = part.field_70130_N * 0.8f;
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (int i = 0; i < 8; ++i) {
            int j = MathHelper.func_76128_c((double)(part.field_70163_u + (double)(((float)((i >> 0) % 2) - 0.5f) * 0.1f) + (double)part.field_70131_O * 0.85));
            int k = MathHelper.func_76128_c((double)(part.field_70165_t + (double)(((float)((i >> 1) % 2) - 0.5f) * width * 0.8f)));
            int l = MathHelper.func_76128_c((double)(part.field_70161_v + (double)(((float)((i >> 2) % 2) - 0.5f) * width * 0.8f)));
            if (blockpos$pooledmutableblockpos.func_177958_n() == k && blockpos$pooledmutableblockpos.func_177956_o() == j && blockpos$pooledmutableblockpos.func_177952_p() == l) continue;
            blockpos$pooledmutableblockpos.func_181079_c(k, j, l);
            if (!this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos).func_191058_s()) continue;
            blockpos$pooledmutableblockpos.func_185344_t();
            return true;
        }
        blockpos$pooledmutableblockpos.func_185344_t();
        return false;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.oFlap = this.wingRotation;
        this.oFlapSpeed = this.destPos;
        if (this.getEggState() < 0) {
            if (this.getFlapping()) {
                this.destPos = 1.0f;
                this.wingRotDelta = 0.6f;
            } else {
                this.destPos = (float)((double)this.destPos + (double)(this.field_70122_E ? -1 : 4) * 0.3);
                this.destPos = MathHelper.func_76131_a((float)this.destPos, (float)0.0f, (float)1.0f);
            }
            if (!this.field_70122_E && this.wingRotDelta < 1.0f) {
                this.wingRotDelta = 1.0f;
            }
            this.wingRotDelta = (float)((double)this.wingRotDelta * 0.9);
            if (!this.field_70122_E && this.field_70181_x < 0.0) {
                this.field_70181_x *= 0.6 + 0.3 * (double)this.getScale() / 10.0;
            }
        }
        this.wingRotation += this.wingRotDelta * 2.0f;
        if (this.func_70089_S()) {
            float scale = this.getScale();
            if (scale > 4.0f) {
                if (MathHelper.func_76126_a((float)this.oFlap) > MathHelper.func_76126_a((float)this.wingRotation) && this.destPos > 0.0f) {
                    if (!this.flapping) {
                        this.flapping = true;
                        this.func_184185_a(SoundEvents.field_187524_aN, MathHelper.func_76131_a((float)(0.2f * MathHelper.func_76129_c((float)scale)), (float)0.0f, (float)1.0f), 0.8f + this.field_70146_Z.nextFloat() * 0.3f);
                    }
                    AxisAlignedBB aabb = this.func_174813_aQ().func_72317_d(0.0, (double)(-this.field_70131_O * 0.2f), 0.0).func_72314_b((double)(this.field_70130_N * 0.2f), 0.0, (double)(this.field_70130_N * 0.2f));
                    List entities = this.field_70170_p.func_175674_a((Entity)this, aabb, this.predicateTargets);
                    for (Entity ent : entities) {
                        double d2;
                        double d1;
                        double d;
                        double dist2;
                        if (!(ent instanceof EntityLivingBase) && !(ent instanceof IProjectile) || !((dist2 = (d = ent.field_70165_t - this.field_70165_t) * d + (d1 = (ent.func_174813_aQ().field_72337_e - ent.func_174813_aQ().field_72338_b) / 2.0 - (this.field_70163_u + (double)(this.func_70047_e() * 0.1f))) * d1 + (d2 = ent.field_70161_v - this.field_70161_v) * d2 + this.field_70146_Z.nextGaussian() * 1.0E-5) < (double)(this.field_70130_N * this.field_70130_N))) continue;
                        int amp = MathHelper.func_76123_f((float)(0.8f * this.getScale()));
                        ent.field_70159_w = ent.field_70159_w + (double)amp / dist2 * (d * d / dist2) * (d > 0.0 ? 1.0 : -1.0);
                        ent.field_70181_x = ent.field_70181_x + (double)amp / dist2 * (d1 * d1 / dist2) * (d1 > 0.0 ? 1.0 : -1.0);
                        ent.field_70179_y = ent.field_70179_y + (double)amp / dist2 * (d2 * d2 / dist2) * (d2 > 0.0 ? 1.0 : -1.0);
                    }
                    if (this.field_70170_p.field_72995_K) {
                        for (int i = MathHelper.func_76128_c((double)aabb.field_72340_a); i <= MathHelper.func_76128_c((double)aabb.field_72336_d); ++i) {
                            for (int k = MathHelper.func_76128_c((double)aabb.field_72339_c); k <= MathHelper.func_76128_c((double)aabb.field_72334_f); ++k) {
                                double d2;
                                IBlockState state;
                                BlockPos pos = this.field_70170_p.func_175672_r(new BlockPos(i, 64, k)).func_177977_b();
                                if (!((double)pos.func_177956_o() > aabb.field_72338_b - 1.0) || !((double)pos.func_177956_o() < aabb.field_72337_e) || !(this.field_70146_Z.nextFloat() < 0.15f) || (state = this.field_70170_p.func_180495_p(pos)).func_177230_c() instanceof IFluidBlock) continue;
                                pos = pos.func_177984_a();
                                double x = (double)pos.func_177958_n() + this.field_70146_Z.nextDouble();
                                double y = (double)pos.func_177956_o() + this.field_70146_Z.nextDouble() * 0.4;
                                double z = (double)pos.func_177952_p() + this.field_70146_Z.nextDouble();
                                double d = x - this.field_70165_t;
                                double d1 = y - (this.field_70163_u + (double)(this.func_70047_e() * 0.1f));
                                double dist2 = d * d + d1 * d1 + (d2 = z - this.field_70161_v) * d2 + this.field_70146_Z.nextGaussian() * 1.0E-5;
                                if (!(dist2 > (double)this.field_70130_N) || !(dist2 < (double)(this.field_70130_N * this.field_70130_N / 4.0f))) continue;
                                int amp = 8;
                                if (this.field_70146_Z.nextFloat() < 0.3f) {
                                    this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_DUST, x, y, z, (double)amp / dist2 * (d * d / dist2) * (d > 0.0 ? 1.0 : -1.0), 0.1, (double)amp / dist2 * (d2 * d2 / dist2) * (d2 > 0.0 ? 1.0 : -1.0), new int[]{Block.func_176210_f((IBlockState)state)});
                                    continue;
                                }
                                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, y, z, (double)amp / dist2 * (d * d / dist2) * (d > 0.0 ? 1.0 : -1.0), 0.0, (double)amp / dist2 * (d2 * d2 / dist2) * (d2 > 0.0 ? 1.0 : -1.0), new int[0]);
                            }
                        }
                    }
                } else {
                    this.flapping = false;
                }
            }
            int PECK_DURATION = 10;
            if (this.isPecking) {
                ++this.peckProgress;
                float progress = (float)this.peckProgress / (float)PECK_DURATION;
                if (progress <= 0.5f) {
                    this.field_70125_A = (float)((double)this.field_70125_A + 160.0 * Math.pow(progress, 2.0));
                }
                if (this.peckProgress == PECK_DURATION / 2 && !this.field_70170_p.field_72995_K) {
                    Vec3d headPos = this.getHeadPos(0.22, 0.22);
                    RayTraceResult rtr = this.aabbTrace(new AxisAlignedBB(headPos.field_72450_a, headPos.field_72448_b, headPos.field_72449_c, headPos.field_72450_a, headPos.field_72448_b, headPos.field_72449_c).func_186662_g((double)(0.055f * this.getScale())), 128.0, 0.22, 0.22);
                    if (rtr != null) {
                        AxisAlignedBB aabb = new AxisAlignedBB(rtr.field_72307_f.field_72450_a, rtr.field_72307_f.field_72448_b, rtr.field_72307_f.field_72449_c, rtr.field_72307_f.field_72450_a, rtr.field_72307_f.field_72448_b, rtr.field_72307_f.field_72449_c);
                        aabb = aabb.func_186662_g((double)scale / 12.0);
                        for (int i = MathHelper.func_76128_c((double)aabb.field_72340_a); i <= MathHelper.func_76128_c((double)aabb.field_72336_d); ++i) {
                            for (int j = MathHelper.func_76128_c((double)aabb.field_72338_b); j <= MathHelper.func_76128_c((double)aabb.field_72337_e); ++j) {
                                for (int k = MathHelper.func_76128_c((double)aabb.field_72339_c); k <= MathHelper.func_76128_c((double)aabb.field_72334_f); ++k) {
                                    BlockPos pos = new BlockPos(i, j, k);
                                    if (this.field_70170_p.func_175623_d(pos) || !(this.field_70146_Z.nextFloat() < 0.3f)) continue;
                                    IBlockState iblockstate = this.field_70170_p.func_180495_p(pos);
                                    this.func_82194_d().func_175718_b(2001, pos, Block.func_176210_f((IBlockState)iblockstate));
                                }
                            }
                        }
                        List entities = this.field_70170_p.func_175674_a((Entity)this, aabb, this.predicateTargets);
                        for (Entity ent : entities) {
                            if (!(ent instanceof EntityLivingBase)) continue;
                            EntityLivingBase living = (EntityLivingBase)ent;
                            living.func_70097_a(new EntityDamageSource("chicken_peck", (Entity)this).func_76351_m(), (this.getIsChaos() ? 0.85f : 0.4f) * this.getScale());
                        }
                    }
                }
                if (this.peckProgress > PECK_DURATION) {
                    this.isPecking = false;
                    this.peckProgress = 0;
                }
            }
            ++this.firingProgress;
            if (this.getFiring()) {
                --this.breathCooldown;
                if (this.firingProgress == 1) {
                    this.func_184185_a(SoundIndex.laser_start, 1.0f + 0.2f * scale, 1.0f);
                    if (this.field_70170_p.field_72995_K) {
                        this.playClientSound();
                    }
                } else if (this.firingProgress > 50 && this.firingProgress <= 60) {
                    if (this.field_70170_p.field_72995_K) {
                        this.updateClientSound((float)(this.firingProgress - 50) / 10.0f * MathHelper.func_76131_a((float)(0.2f * MathHelper.func_76129_c((float)scale)), (float)0.0f, (float)1.0f) * 2.0f);
                    }
                } else if (this.firingProgress > 60 && this.firingProgress < 160) {
                    Vec3d headPos = this.getHeadPos(0.07, 0.07);
                    RayTraceResult rtr = this.aabbTrace(new AxisAlignedBB(headPos.field_72450_a, headPos.field_72448_b, headPos.field_72449_c, headPos.field_72450_a, headPos.field_72448_b, headPos.field_72449_c).func_186662_g((double)(0.055f * this.getScale())), 128.0, 0.07, 0.07);
                    if (!this.field_70170_p.field_72995_K) {
                        --this.explosionCooldown;
                        if (this.getEggState() >= 0 && !this.isHeadAvailable() && this.field_70146_Z.nextFloat() < 0.04f) {
                            this.breakEgg();
                        }
                        if (rtr != null && rtr.field_72313_a != RayTraceResult.Type.MISS) {
                            if (MightyEnderChicken.config.laserSpawnsDragonsBreath == 1 && this.breathCooldown <= 0) {
                                if (this.dragonDummy == null) {
                                    this.dragonDummy = new EntityDragon(this.field_70170_p);
                                }
                                this.breathCooldown = 8;
                                EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(this.field_70170_p, rtr.field_72307_f.field_72450_a, rtr.field_72307_f.field_72448_b, rtr.field_72307_f.field_72449_c);
                                entityareaeffectcloud.func_184481_a((EntityLivingBase)this.dragonDummy);
                                entityareaeffectcloud.func_184491_a(EnumParticleTypes.DRAGON_BREATH);
                                entityareaeffectcloud.func_184483_a(0.15f * scale);
                                entityareaeffectcloud.func_184486_b(160);
                                entityareaeffectcloud.func_184487_c(-0.01f * entityareaeffectcloud.func_184490_j());
                                entityareaeffectcloud.func_184496_a(new PotionEffect(MobEffects.field_76433_i, 1, 1));
                                this.field_70170_p.func_72838_d((Entity)entityareaeffectcloud);
                            }
                            if (this.explosionCooldown <= 0) {
                                if (this.getIsChaos()) {
                                    float f3 = 0.1f * this.getScale() * 2.0f;
                                    int k1 = MathHelper.func_76128_c((double)(rtr.field_72307_f.field_72450_a - (double)f3 - 1.0));
                                    int l1 = MathHelper.func_76128_c((double)(rtr.field_72307_f.field_72450_a + (double)f3 + 1.0));
                                    int i2 = MathHelper.func_76128_c((double)(rtr.field_72307_f.field_72448_b - (double)f3 - 1.0));
                                    int i1 = MathHelper.func_76128_c((double)(rtr.field_72307_f.field_72448_b + (double)f3 + 1.0));
                                    int j2 = MathHelper.func_76128_c((double)(rtr.field_72307_f.field_72449_c - (double)f3 - 1.0));
                                    int j1 = MathHelper.func_76128_c((double)(rtr.field_72307_f.field_72449_c + (double)f3 + 1.0));
                                    List list = this.field_70170_p.func_72839_b((Entity)this, new AxisAlignedBB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
                                    for (int k2 = 0; k2 < list.size(); ++k2) {
                                        double d12;
                                        Entity entity = (Entity)list.get(k2);
                                        if (entity.func_180427_aV() || entity instanceof EntityEnderChicken || !((d12 = entity.func_70011_f(rtr.field_72307_f.field_72450_a, rtr.field_72307_f.field_72448_b, rtr.field_72307_f.field_72449_c) / (double)f3) <= 1.0)) continue;
                                        entity.func_70097_a(new EntityDamageSource("laser", (Entity)this).func_76348_h(), (float)((double)(2.4f * this.getScale()) * (1.0 - d12) * (double)((float)MightyEnderChicken.config.chaosChickenDamageMultiplier / 100.0f)));
                                    }
                                }
                                this.field_70170_p.func_72876_a((Entity)this, rtr.field_72307_f.field_72450_a, rtr.field_72307_f.field_72448_b, rtr.field_72307_f.field_72449_c, (rtr.field_72307_f.field_72448_b < 3.0 ? 0.1f : 0.25f) * scale, ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this));
                                this.explosionCooldown = 4;
                            }
                        }
                    } else {
                        this.laserDist = rtr != null && rtr.field_72313_a != RayTraceResult.Type.MISS ? rtr.field_72307_f.func_72438_d(headPos) - 0.5 : 128.0;
                    }
                } else if (this.firingProgress == 161 && !this.field_70170_p.field_72995_K) {
                    this.setFiring(false);
                }
            } else if (this.firingProgress > 5) {
                this.firingProgress = -20;
                this.func_184185_a(SoundIndex.laser_end, 1.0f + 0.2f * scale, 1.0f);
            } else if (this.firingProgress > 0) {
                this.firingProgress = 0;
            } else if (this.firingProgress > -20 && this.field_70170_p.field_72995_K) {
                this.updateClientSound((1.0f - (float)(this.firingProgress + 20) / 10.0f) * MathHelper.func_76131_a((float)(0.2f * MathHelper.func_76129_c((float)scale)), (float)0.0f, (float)1.0f) * 2.0f);
            }
            if (this.getSpinning()) {
                ++this.spinTime;
                float prog1 = MathHelper.func_76131_a((float)((float)this.spinTime / 100.0f), (float)0.0f, (float)1.0f);
                float prog2 = MathHelper.func_76131_a((float)((float)(this.spinTime - 100) / 100.0f), (float)0.0f, (float)1.0f);
                this.field_70177_z = this.field_70761_aq = this.field_70761_aq + prog1 * 20.0f + prog2 * 65.0f;
                this.field_70759_as = this.field_70761_aq;
                AxisAlignedBB aabb = this.func_174813_aQ().func_72317_d(0.0, (double)(-this.field_70131_O * 0.2f), 0.0).func_72314_b((double)(this.field_70130_N * 0.2f), 0.0, (double)(this.field_70130_N * 0.2f));
                List entities = this.field_70170_p.func_175674_a((Entity)this, aabb, this.predicateTargets);
                for (Entity ent : entities) {
                    double d2;
                    double d1;
                    double d;
                    double dist2;
                    if (!(ent instanceof EntityLivingBase) && !(ent instanceof IProjectile) || !((dist2 = (d = ent.field_70165_t - this.field_70165_t) * d + (d1 = (ent.func_174813_aQ().field_72337_e - ent.func_174813_aQ().field_72338_b) / 2.0 - (this.field_70163_u + (double)(this.func_70047_e() * 0.1f))) * d1 + (d2 = ent.field_70161_v - this.field_70161_v) * d2 + this.field_70146_Z.nextGaussian() * 1.0E-5) < (double)(this.field_70130_N * this.field_70130_N))) continue;
                    double amp = (float)this.spinTime / 100.0f * 14.0f;
                    ent.field_70159_w = ent.field_70159_w + amp / dist2 * (d * d / dist2) * (d > 0.0 ? 1.0 : -1.0);
                    ent.field_70181_x = ent.field_70181_x + amp / dist2 * (d1 * d1 / dist2) * (d1 > 0.0 ? 1.0 : -1.0);
                    ent.field_70179_y = ent.field_70179_y + amp / dist2 * (d2 * d2 / dist2) * (d2 > 0.0 ? 1.0 : -1.0);
                }
                if (this.field_70170_p.field_72995_K) {
                    for (int i = MathHelper.func_76128_c((double)aabb.field_72340_a); i <= MathHelper.func_76128_c((double)aabb.field_72336_d); ++i) {
                        for (int k = MathHelper.func_76128_c((double)aabb.field_72339_c); k <= MathHelper.func_76128_c((double)aabb.field_72334_f); ++k) {
                            double d2;
                            IBlockState state;
                            BlockPos pos = this.field_70170_p.func_175672_r(new BlockPos(i, 64, k)).func_177977_b();
                            if (!((double)pos.func_177956_o() > aabb.field_72338_b - 1.0) || !((double)pos.func_177956_o() < aabb.field_72337_e) || !(this.field_70146_Z.nextFloat() < 0.15f) || (state = this.field_70170_p.func_180495_p(pos)).func_177230_c() instanceof IFluidBlock) continue;
                            pos = pos.func_177984_a();
                            double x = (double)pos.func_177958_n() + this.field_70146_Z.nextDouble();
                            double y = (double)pos.func_177956_o() + this.field_70146_Z.nextDouble() * 0.4;
                            double z = (double)pos.func_177952_p() + this.field_70146_Z.nextDouble();
                            double d = x - this.field_70165_t;
                            double d1 = y - (this.field_70163_u + (double)(this.func_70047_e() * 0.1f));
                            double dist2 = d * d + d1 * d1 + (d2 = z - this.field_70161_v) * d2 + this.field_70146_Z.nextGaussian() * 1.0E-5;
                            if (!(dist2 > (double)this.field_70130_N) || !(dist2 < (double)(this.field_70130_N * this.field_70130_N / 4.0f))) continue;
                            int amp = 8;
                            if (this.field_70146_Z.nextFloat() < 0.3f) {
                                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_DUST, x, y, z, (double)amp / dist2 * (d * d / dist2) * (d > 0.0 ? 1.0 : -1.0), 0.1, (double)amp / dist2 * (d2 * d2 / dist2) * (d2 > 0.0 ? 1.0 : -1.0), new int[]{Block.func_176210_f((IBlockState)state)});
                                continue;
                            }
                            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, y, z, (double)amp / dist2 * (d * d / dist2) * (d > 0.0 ? 1.0 : -1.0), 0.0, (double)amp / dist2 * (d2 * d2 / dist2) * (d2 > 0.0 ? 1.0 : -1.0), new int[0]);
                        }
                    }
                }
            } else {
                this.spinTime = 0;
            }
            if (this.healTime > 0) {
                if (this.healTime == 20) {
                    float totalHeal = this.func_110138_aP() / 2.0f;
                    if (this.func_110143_aJ() + totalHeal > this.func_110138_aP()) {
                        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(this.func_110143_aJ() + totalHeal));
                    }
                }
                this.func_70691_i(this.func_110138_aP() / 40.0f);
                this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
                --this.healTime;
            }
        } else if (!this.field_70170_p.field_72995_K) {
            if (this.getFiring()) {
                this.setFiring(false);
            }
            if (this.getClearingArea()) {
                this.setClearingArea(false);
            }
            if (this.getSpinning()) {
                this.setSpinning(false);
            }
            if (this.getFlapping()) {
                this.setFlapping(false);
            }
        }
        if (this.getClearingArea() || this.getSpinning() || this.getIsChaos() && !this.func_70089_S() && this.deathTicks < 190) {
            ++this.clearAreaTime;
            if (this.clearAreaTime > 10) {
                this.clearAreaTime = 10;
            }
        } else {
            --this.clearAreaTime;
            if (this.clearAreaTime < 0) {
                this.clearAreaTime = 0;
            }
        }
        this.updateHitboxLocation();
        if (this.func_184207_aI()) {
            this.field_70761_aq = this.field_70759_as = this.field_70177_z;
            this.field_70125_A = 0.0f;
        }
        if (this.field_70170_p.field_72995_K) {
            this.updateRenderNodes();
            ++this.ffTime;
            if (this.getForcefield() != this.ffState) {
                this.ffState = this.getForcefield();
                this.ffTime = 0;
            }
            if (this.getIsChaos()) {
                this.updateBossMusicState();
            }
        }
    }

    public void func_70609_aI() {
        this.field_70737_aN = 0;
        ++this.deathTicks;
        float prog1 = MathHelper.func_76131_a((float)((float)this.deathTicks / 100.0f), (float)0.0f, (float)1.0f);
        float prog2 = MathHelper.func_76131_a((float)((float)(this.deathTicks - 100) / 100.0f), (float)0.0f, (float)1.0f);
        this.field_70177_z = this.field_70761_aq = this.field_70761_aq + prog1 * 40.0f + prog2 * 135.0f;
        this.field_70759_as = this.field_70761_aq;
        if (!this.field_70170_p.field_72995_K) {
            if (this.deathTicks == 1) {
                this.func_184185_a(SoundIndex.ender_death, 0.3f * this.getScale(), 1.0f);
            } else if (this.deathTicks == 141) {
                this.func_184185_a(SoundEvents.field_187539_bB, 0.7f * this.getScale(), 0.7f + this.func_70681_au().nextFloat() * 0.6f);
            }
            if (this.deathTicks >= 141 && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                int xpAmount = MightyEnderChicken.eventHandlerServer.hasKilled(false) ? 500 : 12000;
                this.dropExperience(MathHelper.func_76141_d((float)((float)xpAmount * 0.016949153f)));
            }
            if (this.deathTicks == 200) {
                MightyEnderChicken.eventHandlerServer.setHasKilled(false);
                this.dropDeathItems(this.deathCause);
            }
        }
        if (this.deathTicks == 141) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        } else if (this.deathTicks == 200) {
            this.func_70106_y();
        }
    }

    public void func_70074_a(EntityLivingBase entityLivingIn) {
        if (!this.field_70170_p.field_72995_K) {
            this.ffInform.remove(entityLivingIn.func_70005_c_());
            if (entityLivingIn instanceof EntityPlayer && !this.getForcefield()) {
                this.setForcefield(true);
            }
        }
    }

    public void dropDeathItems(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K) {
            Entity entity;
            if (cause == null) {
                cause = DamageSource.field_76377_j;
            }
            if ((entity = cause.func_76346_g()) != null) {
                entity.func_70074_a((EntityLivingBase)this);
            }
            int i = ForgeHooks.getLootingLevel((Entity)this, (Entity)entity, (DamageSource)cause);
            this.captureDrops = true;
            this.capturedDrops.clear();
            if (this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                boolean flag = this.field_70718_bc > 0;
                this.func_184610_a(flag, i, cause);
            }
            this.captureDrops = false;
            if (!ForgeHooks.onLivingDrops((EntityLivingBase)this, (DamageSource)cause, (ArrayList)this.capturedDrops, (int)i, (this.field_70718_bc > 0 ? 1 : 0) != 0)) {
                for (EntityItem item : this.capturedDrops) {
                    this.field_70170_p.func_72838_d((Entity)item);
                }
            }
        }
    }

    public void dropExperience(int amount) {
        while (amount > 0) {
            int i = EntityXPOrb.func_70527_a((int)amount);
            amount -= i;
            EntityXPOrb orb = new EntityXPOrb(this.field_70170_p, this.field_70165_t + this.field_70146_Z.nextGaussian() * (double)0.05f, this.field_70163_u, this.field_70161_v + this.field_70146_Z.nextGaussian() * (double)0.05f, i);
            orb.field_70181_x = (double)(this.getScale() * 0.05f) + this.field_70146_Z.nextGaussian() * (double)0.0125f;
            orb.field_70159_w = (double)(this.getScale() * 0.0125f) * this.field_70146_Z.nextGaussian();
            orb.field_70179_y = (double)(this.getScale() * 0.0125f) * this.field_70146_Z.nextGaussian();
            this.field_70170_p.func_72838_d((Entity)orb);
        }
    }

    public void func_70645_a(DamageSource cause) {
        if (cause.func_76355_l().equals("infinity") && cause instanceof EntityDamageSource && Loader.isModLoaded((String)"avaritia")) {
            this.healTime = 20;
            this.func_70606_j(this.func_110138_aP());
            this.bossInfo.func_186735_a(1.0f);
            Entity ent = cause.func_76346_g();
            if (ent != null) {
                ent.func_145747_a((ITextComponent)new TextComponentTranslation("text.chicken.no_infinity", new Object[]{I18n.func_74838_a((String)"item.avaritia:infinity_sword.name")}));
            }
            return;
        }
        if (ForgeHooks.onLivingDeath((EntityLivingBase)this, (DamageSource)cause)) {
            return;
        }
        if (!this.field_70729_aU) {
            this.bossInfo.func_186735_a(0.0f);
            EntityLivingBase entitylivingbase = this.func_94060_bK();
            if (this.field_70744_aE >= 0 && entitylivingbase != null) {
                entitylivingbase.func_191956_a((Entity)this, this.field_70744_aE, cause);
            }
            this.field_70729_aU = true;
            this.func_110142_aN().func_94549_h();
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            if (!this.field_70170_p.field_72995_K) {
                this.deathCause = cause;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void playClientSound() {
        if (this.soundLaserLoop == null) {
            this.soundLaserLoop = new ChickenLaserLoop(SoundIndex.laser_loop, this.func_184176_by(), 0.001f, 1.0f);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.soundLaserLoop);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateClientSound(float volume) {
        if (this.soundLaserLoop != null) {
            if (volume < 0.001f) {
                volume = 0.001f;
            }
            this.soundLaserLoop.setVolume(volume);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateBossMusicState() {
        if (MightyEnderChicken.config.chaosChickenBossMusic == 1 && (Integer)this.func_184212_Q().func_187225_a(INTRO_STATE) != this.lastIntroState) {
            this.lastIntroState = (Integer)this.func_184212_Q().func_187225_a(INTRO_STATE);
            if (this.lastIntroState == 1) {
                MusicTicker ticker = Minecraft.func_71410_x().func_181535_r();
                if (ticker.field_147678_c != null) {
                    Minecraft.func_71410_x().func_147118_V().func_147683_b(ticker.field_147678_c);
                    ticker.field_147678_c = null;
                }
                ticker.field_147676_d = 6000;
                this.soundBossMusic = new ChickenBossMusic(this, SoundIndex.chaos_music_intro, this.func_184176_by(), 1.0f, 1.0f, false);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.soundBossMusic);
            } else if (this.lastIntroState == 2) {
                if (this.soundBossMusic != null) {
                    this.soundBossMusic.setDonePlaying();
                }
                this.soundBossMusic = new ChickenBossMusic(this, SoundIndex.chaos_music, this.func_184176_by(), 1.0f, 1.0f, true);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.soundBossMusic);
            }
        }
        if (!this.func_70089_S() && this.soundBossMusic != null) {
            float vol = 1.0f - MathHelper.func_76131_a((float)(((float)this.deathTicks - 170.0f) / 200.0f), (float)0.0f, (float)1.0f);
            this.soundBossMusic.setVolume(vol);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void stopClientSound() {
        if (this.soundLaserLoop != null) {
            this.soundLaserLoop.setDonePlaying();
        }
        if (this.soundBossMusic != null) {
            this.soundBossMusic.setDonePlaying();
            MusicTicker ticker = Minecraft.func_71410_x().func_181535_r();
            if (ticker.field_147678_c == null) {
                ticker.field_147676_d = 100;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateRenderTick(float partialTick) {
        this.lastPartialTickRender = partialTick;
        if (this.soundLaserLoop != null) {
            this.soundLaserLoop.updateXYZ(EntityHelper.interpolateValues((float)((float)this.field_70169_q), (float)((float)this.field_70165_t), (float)partialTick), EntityHelper.interpolateValues((float)((float)this.field_70167_r), (float)((float)this.field_70163_u), (float)partialTick), EntityHelper.interpolateValues((float)((float)this.field_70166_s), (float)((float)this.field_70161_v), (float)partialTick));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateRenderNodes() {
        RayTraceResult rtr;
        int index = 0;
        if (this.field_70131_O > 6.0f) {
            EntityChickenNode node;
            EntityChickenNode entityChickenNode = node = index < this.renderNodes.size() ? this.renderNodes.get(index) : null;
            if (node == null) {
                node = new EntityChickenNode(this.field_70170_p, this);
                this.field_70170_p.func_72838_d((Entity)node);
                this.renderNodes.add(node);
            }
            ++index;
            node.func_70012_b(this.field_70165_t, this.field_70163_u + 16.0, this.field_70161_v, 0.0f, 0.0f);
        }
        if (this.getFiring() && (rtr = this.getEntityLook((Entity)this, 128.0, false, false, false, 1.0f, 0.07, 0.07)) != null) {
            Vec3d head = this.getHeadPos(0.07, 0.07);
            double x = head.field_72450_a - rtr.field_72307_f.field_72450_a;
            double y = head.field_72448_b - rtr.field_72307_f.field_72448_b;
            double z = head.field_72449_c - rtr.field_72307_f.field_72449_c;
            double dist = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
            Vec3d look = this.func_70676_i(1.0f);
            int i = 1;
            while ((double)i < dist) {
                EntityChickenNode node;
                EntityChickenNode entityChickenNode = node = index < this.renderNodes.size() ? this.renderNodes.get(index) : null;
                if (node == null) {
                    node = new EntityChickenNode(this.field_70170_p, this);
                    this.field_70170_p.func_72838_d((Entity)node);
                    this.renderNodes.add(node);
                }
                ++index;
                node.func_70012_b(head.field_72450_a + look.field_72450_a * (double)i, head.field_72448_b + look.field_72448_b * (double)i, head.field_72449_c + look.field_72449_c * (double)i, 0.0f, 0.0f);
                ++i;
            }
        }
        for (int i = this.renderNodes.size() - 1; i >= index; --i) {
            this.renderNodes.get(i).func_70106_y();
            this.renderNodes.remove(i);
        }
    }

    public void explode(double x, double y, double z, float strength, boolean fire, boolean damageTerrain) {
        if (!this.field_70170_p.field_72995_K) {
            ExplosionChicken explosion = new ExplosionChicken(this.field_70170_p, (Entity)this, x, y, z, strength, fire, damageTerrain);
            if (ForgeEventFactory.onExplosionStart((World)this.field_70170_p, (Explosion)explosion)) {
                return;
            }
            explosion.func_77278_a();
            explosion.func_77279_a(false);
            if (!damageTerrain) {
                explosion.func_180342_d();
            }
            for (EntityPlayer entityplayer : this.field_70170_p.field_73010_i) {
                if (!(entityplayer.func_70092_e(x, y, z) < 4096.0)) continue;
                ((EntityPlayerMP)entityplayer).field_71135_a.func_147359_a((Packet)new SPacketExplosion(x, y, z, strength, explosion.func_180343_e(), (Vec3d)explosion.func_77277_b().get(entityplayer)));
            }
        }
    }

    public void breakEgg() {
        if (this.getEggState() >= 0) {
            if (!this.getIsChaos() || !this.isHeadAvailable() || this.doneIntro || this.doingIntro) {
                this.setEggState(this.getEggState() + 1);
            }
            if (this.getEggState() >= MightyEnderChicken.config.eggBreaksRequired) {
                this.setEggState(-1);
                this.func_184185_a(SoundIndex.crack_open, 0.2f * this.getScale(), 0.8f + this.field_70146_Z.nextFloat() * 0.3f);
                MightyEnderChicken.channel.sendToAllAround((AbstractPacket)new PacketBreakEggEffects(this), new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 128.0));
                this.setForcefield(true);
            } else {
                this.func_184185_a(SoundIndex.crack, 0.2f * this.getScale(), 0.8f + this.field_70146_Z.nextFloat() * 0.3f);
            }
        }
    }

    public boolean func_70685_l(Entity entityIn) {
        return this.field_70170_p.func_147447_a(this.getHeadPos(0.08, 0.27), new Vec3d(entityIn.field_70165_t, entityIn.field_70163_u + (double)entityIn.func_70047_e(), entityIn.field_70161_v), false, true, false) == null;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (distance > this.getScale()) {
            this.breakEgg();
        }
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        float scale = this.getScale();
        this.field_70130_N = 0.4f * scale * 0.77f;
        this.field_70131_O = 0.9f * scale * 0.75f;
        double d0 = (double)this.field_70130_N / 2.0;
        this.func_174826_a(new AxisAlignedBB(this.field_70165_t - d0, this.field_70163_u, this.field_70161_v - d0, this.field_70165_t + d0, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v + d0));
        super.func_70091_d(type, x, y, z);
        this.field_70130_N = 0.4f * scale * 2.5f;
        this.field_70131_O = 0.9f * scale * 1.05f;
        d0 = (double)this.field_70130_N / 2.0;
        this.func_174826_a(new AxisAlignedBB(this.field_70165_t - d0, this.field_70163_u, this.field_70161_v - d0, this.field_70165_t + d0, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v + d0));
    }

    public boolean func_70094_T() {
        if (this.field_70145_X) {
            return false;
        }
        float width = 0.4f * this.getScale() * 0.85f;
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (int i = 0; i < 8; ++i) {
            int j = MathHelper.func_76128_c((double)(this.field_70163_u + (double)(((float)((i >> 0) % 2) - 0.5f) * 0.1f) + (double)this.func_70047_e()));
            int k = MathHelper.func_76128_c((double)(this.field_70165_t + (double)(((float)((i >> 1) % 2) - 0.5f) * width * 0.8f)));
            int l = MathHelper.func_76128_c((double)(this.field_70161_v + (double)(((float)((i >> 2) % 2) - 0.5f) * width * 0.8f)));
            if (blockpos$pooledmutableblockpos.func_177958_n() == k && blockpos$pooledmutableblockpos.func_177956_o() == j && blockpos$pooledmutableblockpos.func_177952_p() == l) continue;
            blockpos$pooledmutableblockpos.func_181079_c(k, j, l);
            if (!this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos).func_191058_s()) continue;
            blockpos$pooledmutableblockpos.func_185344_t();
            return true;
        }
        blockpos$pooledmutableblockpos.func_185344_t();
        return false;
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        String s = EntityList.func_75621_b((Entity)this);
        if (s == null) {
            s = "generic";
        }
        return I18n.func_74838_a((String)("entity." + (this.getIsChaos() ? "ent_ChaosChicken" : "ent_EnderChicken") + ".name"));
    }

    protected void func_82167_n(Entity entityIn) {
    }

    public void func_70108_f(Entity entityIn) {
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!super.func_184645_a(player, hand)) {
            if (!this.func_184207_aI()) {
                if (!this.field_70170_p.field_72995_K) {
                    player.func_184220_m((Entity)this);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float scale = this.getScale();
            double ryoSin = Math.sin(Math.toRadians(this.field_70761_aq));
            double ryoCos = Math.cos(Math.toRadians(this.field_70761_aq));
            double offset = 0.395;
            passenger.func_70107_b(this.field_70165_t - ryoSin * offset * (double)scale, this.field_70163_u + this.func_70042_X() + passenger.func_70033_W(), this.field_70161_v + ryoCos * offset * (double)scale);
        }
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    public double func_70042_X() {
        return (double)(0.67f * this.getScale()) * 1.18;
    }

    protected SoundEvent func_184639_G() {
        return this.getEggState() >= 0 ? null : SoundEvents.field_187660_W;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187666_Z;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187663_X;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getScale() > 4.0f ? SoundEvents.field_190030_ev : SoundEvents.field_187538_aa, this.func_184176_by(), 0.15f * this.getScale() * 2.0f, 1.0f - MathHelper.func_76131_a((float)(0.08f * MathHelper.func_76129_c((float)this.getScale())), (float)0.0f, (float)0.85f));
    }

    public void func_184185_a(SoundEvent soundIn, float volume, float pitch) {
        if (!this.func_174814_R()) {
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, soundIn, this.func_184176_by(), volume * 2.0f, pitch);
        }
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    public float func_70647_i() {
        return this.func_70631_g_() ? (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.5f : ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) * (1.1f - MathHelper.func_76131_a((float)((float)Math.pow((double)this.getScale() / 30.0, 0.5)), (float)0.0f, (float)1.0f));
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return new ResourceLocation("mightyenderchicken", this.getIsChaos() ? "chaos_chicken" : "ender_chicken");
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74776_a("scale", this.getScale());
        tag.func_74768_a("eggState", this.getEggState());
        tag.func_74757_a("charging", this.getCharging());
        tag.func_74768_a("maxStrafingRunTime", this.maxStrafingRunTime);
        tag.func_74757_a("forcefield", this.getForcefield());
        tag.func_74757_a("doneIntro", this.doneIntro);
        tag.func_74768_a("deathTicks", this.deathTicks);
        tag.func_74768_a("introState", ((Integer)this.func_184212_Q().func_187225_a(INTRO_STATE)).intValue());
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("scale")) {
            this.setScale(tag.func_74760_g("scale"));
        }
        if (tag.func_74764_b("eggState")) {
            this.setEggState(tag.func_74762_e("eggState"));
        }
        if (tag.func_74764_b("charging")) {
            this.setCharging(tag.func_74767_n("charging"));
        }
        if (tag.func_74764_b("maxStrafingRunTime")) {
            this.maxStrafingRunTime = tag.func_74762_e("maxStrafingRunTime");
        }
        if (tag.func_74764_b("forcefield")) {
            this.setForcefield(tag.func_74767_n("forcefield"));
        }
        if (tag.func_74764_b("doneIntro")) {
            this.doneIntro = tag.func_74767_n("doneIntro");
        }
        if (tag.func_74764_b("introState")) {
            this.func_184212_Q().func_187227_b(INTRO_STATE, (Object)tag.func_74762_e("introState"));
        }
        this.deathTicks = tag.func_74762_e("deathTicks");
        this.bossInfo.func_186739_a(this.func_145748_c_());
        this.bossInfo.func_186745_a(this.getIsChaos() ? BossInfo.Color.GREEN : BossInfo.Color.PINK);
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public void func_70619_bc() {
        super.func_70619_bc();
        if (this.func_70089_S()) {
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        }
    }

    public void updateHitboxLocation() {
        float scale = this.getScale();
        if (this.lastScale != scale) {
            this.lastScale = scale;
            this.partFootL.field_70130_N = 0.1875f * scale;
            this.partFootL.field_70131_O = 0.0625f * scale;
            this.partFootR.field_70130_N = 0.1875f * scale;
            this.partFootR.field_70131_O = 0.0625f * scale;
            this.partLegL.field_70130_N = 0.0625f * scale;
            this.partLegL.field_70131_O = 0.3125f * scale;
            this.partLegR.field_70130_N = 0.0625f * scale;
            this.partLegR.field_70131_O = 0.3125f * scale;
            this.partBody.field_70130_N = 0.375f * scale;
            this.partBody.field_70131_O = 0.375f * scale;
            this.partWingL.field_70130_N = 0.25f * scale;
            this.partWingL.field_70131_O = 0.1875f * scale;
            this.partWingR.field_70130_N = 0.25f * scale;
            this.partWingR.field_70131_O = 0.1875f * scale;
            this.partHead.field_70130_N = 0.21875f * scale;
            this.partHead.field_70131_O = 0.375f * scale;
            this.partBill.field_70130_N = 0.1875f * scale;
            this.partBill.field_70131_O = 0.25f * scale;
            this.partForcefield.field_70130_N = 0.9375f * scale;
            this.partForcefield.field_70131_O = 0.9375f * scale;
            this.func_70105_a(0.4f * scale * 2.5f, 0.9f * scale * 1.05f);
        }
        double ryoSin = Math.sin(Math.toRadians(this.field_70761_aq));
        double ryoCos = Math.cos(Math.toRadians(this.field_70761_aq));
        float f5 = this.field_184618_aE + (this.field_70721_aZ - this.field_184618_aE);
        float f6 = this.field_184619_aG;
        if (f5 > 1.0f) {
            f5 = 1.0f;
        }
        double rLegX = MathHelper.func_76134_b((float)(f6 * 0.6662f)) * 1.4f * f5;
        double lLegX = MathHelper.func_76134_b((float)(f6 * 0.6662f + (float)Math.PI)) * 1.4f * f5;
        this.partFootL.func_70071_h_();
        this.partFootL.func_70012_b(this.field_70165_t + ryoCos * 0.09375 * (double)scale - ryoSin * (0.03 - lLegX * 0.5) * (double)scale, this.field_70163_u - (double)this.partFootL.field_70131_O / 2.0 + Math.abs(lLegX * 0.2 * (double)scale), this.field_70161_v + ryoSin * 0.09375 * (double)scale + ryoCos * (0.03 - lLegX * 0.5) * (double)scale, 0.0f, 0.0f);
        this.partFootR.func_70071_h_();
        this.partFootR.func_70012_b(this.field_70165_t - ryoCos * 0.09375 * (double)scale - ryoSin * (0.03 - rLegX * 0.5) * (double)scale, this.field_70163_u - (double)this.partFootL.field_70131_O / 2.0 + Math.abs(rLegX * 0.2 * (double)scale), this.field_70161_v - ryoSin * 0.09375 * (double)scale + ryoCos * (0.03 - rLegX * 0.5) * (double)scale, 0.0f, 0.0f);
        this.partLegL.func_70071_h_();
        this.partLegL.func_70012_b(this.field_70165_t + ryoCos * 0.09375 * (double)scale - ryoSin * (-0.0625 - lLegX * 0.25) * (double)scale, this.field_70163_u, this.field_70161_v + ryoSin * 0.09375 * (double)scale + ryoCos * (-0.0625 - lLegX * 0.25) * (double)scale, 0.0f, 0.0f);
        this.partLegR.func_70071_h_();
        this.partLegR.func_70012_b(this.field_70165_t - ryoCos * 0.09375 * (double)scale - ryoSin * (-0.0625 - rLegX * 0.25) * (double)scale, this.field_70163_u, this.field_70161_v - ryoSin * 0.09375 * (double)scale + ryoCos * (-0.0625 - rLegX * 0.25) * (double)scale, 0.0f, 0.0f);
        this.partBody.func_70071_h_();
        this.partBody.func_70012_b(this.field_70165_t, this.field_70163_u + 0.3125 * (double)scale, this.field_70161_v, 0.0f, 0.0f);
        double wing = (MathHelper.func_76126_a((float)this.oFlap) + 1.0f) * this.oFlapSpeed;
        this.partWingL.func_70071_h_();
        this.partWingL.func_70012_b(this.field_70165_t + ryoCos * (0.125 + wing * 0.125) * (double)scale, this.field_70163_u + (0.46875 + wing * 0.0625) * (double)scale, this.field_70161_v + ryoSin * (0.125 + wing * 0.125) * (double)scale, 0.0f, 0.0f);
        this.partWingR.func_70071_h_();
        this.partWingR.func_70012_b(this.field_70165_t - ryoCos * (0.125 + wing * 0.125) * (double)scale, this.field_70163_u + (0.46875 + wing * 0.0625) * (double)scale, this.field_70161_v - ryoSin * (0.125 + wing * 0.125) * (double)scale, 0.0f, 0.0f);
        double hPitchCos = Math.cos(Math.toRadians(this.field_70125_A));
        double hPitchSin = Math.sin(Math.toRadians(this.field_70125_A));
        this.partHead.func_70071_h_();
        this.partBill.func_70071_h_();
        if (this.isHeadAvailable()) {
            this.partHead.func_70012_b(this.field_70165_t - ryoSin * (0.28 + hPitchSin * 0.2) * (double)scale, this.field_70163_u + (0.375 + hPitchCos * 0.1875) * (double)scale, this.field_70161_v + ryoCos * (0.28 + hPitchSin * 0.2) * (double)scale, 0.0f, 0.0f);
            this.partBill.func_70012_b(this.field_70165_t - ryoSin * (0.40625 + hPitchSin * 0.2) * (double)scale, this.field_70163_u + (0.375 + hPitchCos * 0.1875) * (double)scale, this.field_70161_v + ryoCos * (0.40625 + hPitchSin * 0.2) * (double)scale, 0.0f, 0.0f);
        } else {
            this.partHead.func_70012_b(this.field_70165_t, this.field_70163_u - 500.0, this.field_70161_v, 0.0f, 0.0f);
            this.partBill.func_70012_b(this.field_70165_t, this.field_70163_u - 500.0, this.field_70161_v, 0.0f, 0.0f);
        }
        this.partForcefield.func_70071_h_();
        if (this.getForcefield() && this.getEggState() < 0) {
            this.partForcefield.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
        } else {
            this.partForcefield.func_70012_b(this.field_70165_t, this.field_70163_u - 500.0, this.field_70161_v, 0.0f, 0.0f);
        }
    }

    public Vec3d getHeadPos(double horiOffset, double vertOffset) {
        float scale = this.getScale();
        double ryoSin = Math.sin(Math.toRadians(this.field_70761_aq));
        double ryoCos = Math.cos(Math.toRadians(this.field_70761_aq));
        double offset = this.isHeadAvailable() ? 0.25 : 0.0;
        return new Vec3d(this.field_70165_t - ryoSin * (offset + horiOffset) * (double)scale, this.field_70163_u + (double)scale / 1.8 + vertOffset * (double)scale, this.field_70161_v + ryoCos * (offset + horiOffset) * (double)scale);
    }

    public boolean isHeadAvailable() {
        return (float)this.getEggState() > (float)MightyEnderChicken.config.eggBreaksRequired / 2.0f || this.getEggState() < 0;
    }

    public RayTraceResult aabbTrace(AxisAlignedBB aabb, double d, double horiOffset, double vertOffset) {
        Vec3d vec3 = this.getHeadPos(horiOffset, vertOffset);
        Vec3d vec31 = this.func_70676_i(1.0f);
        Vec3d vec32 = vec3.func_72441_c(vec31.field_72450_a * d, vec31.field_72448_b * d, vec31.field_72449_c * d);
        RayTraceResult rayTrace = EntityHelper.rayTraceBlocks((World)this.field_70170_p, (double)d, (Vec3d)vec3, (Vec3d)vec32, (boolean)true, (boolean)false, (boolean)false, (boolean)true);
        double dist = d;
        if (rayTrace != null) {
            dist = rayTrace.field_72307_f.func_72438_d(vec3);
        }
        double aabbMin = Math.min(aabb.field_72336_d - aabb.field_72340_a, Math.min(aabb.field_72337_e - aabb.field_72338_b, aabb.field_72334_f - aabb.field_72339_c));
        int tries = MathHelper.func_76143_f((double)(dist / aabbMin));
        Entity entityTrace = null;
        for (int i = 0; i < tries; ++i) {
            List list = this.field_70170_p.func_175674_a((Entity)this, aabb.func_72317_d(vec31.field_72450_a * aabbMin * (double)i, vec31.field_72448_b * aabbMin * (double)i, vec31.field_72449_c * aabbMin * (double)i), this.predicateTargets);
            if (list.isEmpty()) continue;
            double dist1 = 100000.0;
            for (Entity ent : list) {
                double entDist = ent.func_70011_f(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c);
                if (!(entDist < dist1)) continue;
                entityTrace = ent;
                dist1 = entDist;
            }
            break;
        }
        if (entityTrace != null) {
            rayTrace = new RayTraceResult(entityTrace, new Vec3d(entityTrace.field_70165_t, entityTrace.field_70163_u + (entityTrace.func_174813_aQ().field_72337_e - entityTrace.func_174813_aQ().field_72338_b) / 2.0, entityTrace.field_70161_v));
        }
        return rayTrace;
    }

    public RayTraceResult getEntityLook(Entity ent, double d, boolean ignoreEntities, boolean ignoreTransparentBlocks, boolean ignoreLiquid, float renderTick, double horiOffset, double vertOffset) {
        Vec3d vec3 = this.getHeadPos(horiOffset, vertOffset);
        Vec3d vec31 = ent.func_70676_i(renderTick);
        Vec3d vec32 = vec3.func_72441_c(vec31.field_72450_a * d, vec31.field_72448_b * d, vec31.field_72449_c * d);
        RayTraceResult rayTrace = EntityHelper.rayTraceBlocks((World)ent.func_130014_f_(), (double)d, (Vec3d)vec3, (Vec3d)vec32, (!ignoreLiquid ? 1 : 0) != 0, (boolean)ignoreTransparentBlocks, (boolean)false, (boolean)true);
        if (!ignoreEntities) {
            double dist = d;
            if (rayTrace != null) {
                dist = rayTrace.field_72307_f.func_72438_d(vec3);
            }
            Entity entityTrace = null;
            Vec3d vec33 = null;
            float f = 1.0f;
            List list = ent.func_130014_f_().func_175674_a(ent, ent.func_174813_aQ().func_72321_a(vec31.field_72450_a * dist, vec31.field_72448_b * dist, vec31.field_72449_c * dist).func_186662_g((double)f), this.predicateTargets);
            double d2 = dist;
            for (int j = 0; j < list.size(); ++j) {
                double d3;
                Entity entity1 = (Entity)list.get(j);
                float f1 = entity1.func_70111_Y();
                AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)f1);
                RayTraceResult movingobjectposition = axisalignedbb.func_72327_a(vec3, vec32);
                if (axisalignedbb.func_72318_a(vec3)) {
                    if (!(d2 >= 0.0)) continue;
                    entityTrace = entity1;
                    vec33 = movingobjectposition == null ? vec3 : movingobjectposition.field_72307_f;
                    d2 = 0.0;
                    continue;
                }
                if (movingobjectposition == null || !((d3 = vec3.func_72438_d(movingobjectposition.field_72307_f)) < d2) && d2 != 0.0) continue;
                if (entity1 == ent.func_184187_bx() && !ent.canRiderInteract()) {
                    if (d2 != 0.0) continue;
                    entityTrace = entity1;
                    vec33 = movingobjectposition.field_72307_f;
                    continue;
                }
                entityTrace = entity1;
                vec33 = movingobjectposition.field_72307_f;
                d2 = d3;
            }
            if (entityTrace != null && (d2 < dist || rayTrace == null)) {
                rayTrace = new RayTraceResult(entityTrace, vec33);
            }
        }
        return rayTrace;
    }

    public boolean func_180427_aV() {
        return true;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    @Override
    public Entity getSelf() {
        return this;
    }

    @Override
    public float getLastPartialTickRender() {
        return this.lastPartialTickRender;
    }

    public static class MultiPartEntityPartCustom
    extends MultiPartEntityPart {
        public MultiPartEntityPartCustom(IEntityMultiPart parent, String partName, float width, float height) {
            super(parent, partName, width, height);
        }

        @Nullable
        public AxisAlignedBB func_70114_g(Entity entityIn) {
            return entityIn.func_70104_M() ? entityIn.func_174813_aQ() : null;
        }

        @Nullable
        public AxisAlignedBB func_70046_E() {
            return this.func_174813_aQ();
        }

        public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
            return super.func_184230_a(player, hand);
        }

        public boolean func_70104_M() {
            return true;
        }

        public String func_70005_c_() {
            return I18n.func_74838_a((String)("entity.mmec." + this.field_146032_b + ".name"));
        }
    }

    public static class EntityLookHelperChicken
    extends EntityLookHelper {
        public EntityEnderChicken chicken;

        public EntityLookHelperChicken(EntityEnderChicken chicken) {
            super((EntityLiving)chicken);
            this.chicken = chicken;
        }

        public void func_75649_a() {
            if (this.field_75655_d) {
                Vec3d headPos = this.chicken.getHeadPos(0.07, 0.07);
                this.field_75655_d = false;
                double d0 = this.field_75656_e - headPos.field_72450_a;
                double d1 = this.field_75653_f - headPos.field_72448_b;
                double d2 = this.field_75654_g - headPos.field_72449_c;
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
                float f1 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.29577951308232));
                this.field_75659_a.field_70125_A = EntityHelper.updateRotation((float)this.field_75659_a.field_70125_A, (float)f1, (float)this.field_75658_c);
                this.field_75659_a.field_70759_as = EntityHelper.updateRotation((float)this.field_75659_a.field_70759_as, (float)f, (float)this.field_75657_b);
            } else {
                this.field_75659_a.field_70759_as = EntityHelper.updateRotation((float)this.field_75659_a.field_70759_as, (float)this.field_75659_a.field_70761_aq, (float)10.0f);
            }
            float f2 = MathHelper.func_76142_g((float)(this.field_75659_a.field_70759_as - this.field_75659_a.field_70761_aq));
            if (!this.field_75659_a.func_70661_as().func_75500_f()) {
                if (f2 < -75.0f) {
                    this.field_75659_a.field_70759_as = this.field_75659_a.field_70761_aq - 75.0f;
                }
                if (f2 > 75.0f) {
                    this.field_75659_a.field_70759_as = this.field_75659_a.field_70761_aq + 75.0f;
                }
            }
        }
    }
}

