/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.mmec.common.entity;

import java.util.ArrayList;
import java.util.List;
import me.ichun.mods.mmec.client.entity.EntityChickenNode;
import me.ichun.mods.mmec.client.entity.IEntityRenderParent;
import me.ichun.mods.mmec.client.sound.ChickenSpawnLoop;
import me.ichun.mods.mmec.common.core.SoundIndex;
import me.ichun.mods.mmec.common.entity.EntityChaosChicken;
import me.ichun.mods.mmec.common.entity.EntityEnderChicken;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityChickenSpawner
extends Entity
implements IEntityRenderParent {
    public static final DataParameter<ItemStack> ITEMSTACK = EntityDataManager.func_187226_a(EntityChickenSpawner.class, (DataSerializer)DataSerializers.field_187196_f);
    public static final DataParameter<BlockPos> POS = EntityDataManager.func_187226_a(EntityChickenSpawner.class, (DataSerializer)DataSerializers.field_187200_j);
    public static final DataParameter<Float> SCALE = EntityDataManager.func_187226_a(EntityChickenSpawner.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Boolean> IS_CHAOS = EntityDataManager.func_187226_a(EntityChickenSpawner.class, (DataSerializer)DataSerializers.field_187198_h);
    private BossInfoServer bossInfo = new BossInfoServer((ITextComponent)new TextComponentString(ScorePlayerTeam.func_96667_a((Team)this.func_96124_cp(), (String)I18n.func_74838_a((String)"entity.ent_EnderChicken.name"))), BossInfo.Color.PINK, BossInfo.Overlay.NOTCHED_10);
    public int transformProgress;
    public float rotation;
    public float oldRotation;
    public float rotationSpeed;
    public ArrayList<EntityChickenNode> renderNodes = new ArrayList();
    public float lastPartialTickRender = 0.0f;
    @SideOnly(value=Side.CLIENT)
    public ChickenSpawnLoop soundAmbience;

    public EntityChickenSpawner(World world) {
        super(world);
        this.func_70105_a(0.25f, 0.25f);
        this.func_184224_h(true);
        this.rotationSpeed = 0.0f;
        this.oldRotation = 0.0f;
        this.rotation = 0.0f;
        this.field_70158_ak = true;
    }

    public EntityChickenSpawner(World world, BlockPos pos, EntityItem item, float scale, boolean isChaos) {
        this(world);
        this.func_70012_b(item.field_70165_t, item.field_70163_u, item.field_70161_v, item.field_70177_z, item.field_70125_A);
        this.field_70177_z = item.field_70290_d + (float)item.field_70173_aa / 20.0f;
        this.setItemstack(item.func_92059_d());
        this.setBlockPos(pos);
        this.setScale(scale);
        this.setIsChaos(isChaos);
        this.bossInfo.func_186735_a(0.0f);
        if (this.getIsChaos()) {
            this.bossInfo.func_186739_a((ITextComponent)new TextComponentString(ScorePlayerTeam.func_96667_a((Team)this.func_96124_cp(), (String)I18n.func_74838_a((String)"entity.ent_ChaosChicken.name"))));
            this.bossInfo.func_186745_a(BossInfo.Color.GREEN);
            this.bossInfo.func_186741_a(true);
        }
    }

    public void func_70088_a() {
        this.func_184212_Q().func_187214_a(ITEMSTACK, (Object)new ItemStack(Items.field_151110_aK));
        this.func_184212_Q().func_187214_a(POS, (Object)BlockPos.field_177992_a);
        this.func_184212_Q().func_187214_a(SCALE, (Object)Float.valueOf(10.0f));
        this.func_184212_Q().func_187214_a(IS_CHAOS, (Object)false);
    }

    public void setItemstack(ItemStack is) {
        this.func_184212_Q().func_187227_b(ITEMSTACK, (Object)is);
    }

    public ItemStack getItemStack() {
        return (ItemStack)this.func_184212_Q().func_187225_a(ITEMSTACK);
    }

    public void setBlockPos(BlockPos pos) {
        this.func_184212_Q().func_187227_b(POS, (Object)pos);
    }

    public BlockPos getBlockPos() {
        return (BlockPos)this.func_184212_Q().func_187225_a(POS);
    }

    public void setScale(float f) {
        this.func_184212_Q().func_187227_b(SCALE, (Object)Float.valueOf(f));
    }

    public float getScale() {
        return ((Float)this.func_184212_Q().func_187225_a(SCALE)).floatValue();
    }

    public void setIsChaos(boolean flag) {
        this.func_184212_Q().func_187227_b(IS_CHAOS, (Object)flag);
    }

    public boolean getIsChaos() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_CHAOS);
    }

    public void func_70071_h_() {
        int id;
        super.func_70071_h_();
        ++this.transformProgress;
        float lifetime = this.getLifetime();
        float progress = (float)this.transformProgress / lifetime;
        float oldProgress = (float)(this.transformProgress - 1) / lifetime;
        if (this.transformProgress == 1 && !this.getIsChaos() && (id = Item.func_150891_b((Item)this.getItemStack().func_77973_b())) != 0) {
            for (int i = 0; i < 16; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.ITEM_CRACK, this.field_70165_t, this.field_70163_u, this.field_70161_v, ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1, (double)this.field_70146_Z.nextFloat() * 0.3, ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1, new int[]{id});
            }
            this.func_184185_a(SoundIndex.crack_open, 0.7f, 0.8f + this.field_70146_Z.nextFloat() * 0.3f);
        }
        if (oldProgress < 0.3f && progress >= 0.3f) {
            BlockPos spawnPos = this.getBlockPos();
            this.field_70169_q = this.field_70142_S = (double)spawnPos.func_177958_n() + 0.5;
            this.field_70165_t = this.field_70142_S;
            this.field_70167_r = this.field_70137_T = (double)spawnPos.func_177956_o() + 0.25;
            this.field_70163_u = this.field_70137_T;
            this.field_70166_s = this.field_70136_U = (double)spawnPos.func_177952_p() + 0.5;
            this.field_70161_v = this.field_70136_U;
        }
        this.oldRotation = this.rotation;
        float MAX_SPEED = 40.0f;
        this.rotationSpeed = progress < 0.2f ? MAX_SPEED * (progress / 0.2f) : (progress < 0.6f ? MAX_SPEED : MAX_SPEED * (1.0f - MathHelper.func_76131_a((float)((progress - 0.6f) / 0.2f), (float)0.0f, (float)1.0f)));
        this.rotation += this.rotationSpeed;
        if (this.field_70170_p.field_72995_K) {
            this.updateRenderNodes();
            this.updateClientSound(progress);
        }
        this.clearArea();
        if (!this.field_70170_p.field_72995_K) {
            if (this.bossInfo != null) {
                this.bossInfo.func_186735_a(MathHelper.func_76131_a((float)(progress / 0.9f), (float)0.0f, (float)1.0f));
            }
            if (this.transformProgress == (int)lifetime) {
                this.bossInfo.func_186735_a(1.0f);
                EntityEnderChicken chicken = this.getIsChaos() ? new EntityChaosChicken(this.field_70170_p, this.rotation % 360.0f, this.getScale(), this.bossInfo) : new EntityEnderChicken(this.field_70170_p, this.rotation % 360.0f, this.getScale(), this.bossInfo);
                chicken.func_70107_b(this.field_70165_t, this.field_70163_u - 0.24, this.field_70161_v);
                this.field_70170_p.func_72838_d((Entity)chicken);
                this.func_184185_a(SoundIndex.crack_open, 3.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.3f);
                this.bossInfo = null;
            }
            if ((float)this.transformProgress > lifetime) {
                this.func_70106_y();
            }
        }
    }

    public void clearArea() {
        double d2;
        double d1;
        double d;
        float scale = this.getScale();
        float progress = MathHelper.func_76131_a((float)((float)this.transformProgress / this.getLifetime()), (float)0.0f, (float)1.0f);
        float scaleProg = MathHelper.func_76126_a((float)((float)Math.pow(MathHelper.func_76131_a((float)((progress - 0.1f) / 0.6f), (float)0.0f, (float)1.0f), 2.0) * 1.5708f));
        float eggScale = scaleProg * (scale * 0.7f);
        if (!this.field_70170_p.field_72995_K) {
            int i = -((int)eggScale);
            while ((float)i <= eggScale) {
                int j = -((int)eggScale);
                while ((float)j <= eggScale) {
                    int k = -((int)eggScale);
                    while ((float)k <= eggScale) {
                        BlockPos pos;
                        double dist;
                        if (this.field_70163_u + (double)(scale / 2.0f * scaleProg) + (double)j >= this.field_70163_u && this.field_70146_Z.nextFloat() < 0.1f && (dist = (double)MathHelper.func_76133_a((double)((d = (double)(pos = new BlockPos(this.field_70165_t + (double)i, this.field_70163_u + (double)(scale / 2.0f * scaleProg) + (double)j, this.field_70161_v + (double)k)).func_177958_n() + 0.5 - this.field_70165_t) * d + (d1 = (double)pos.func_177956_o() + 0.5 - (this.field_70163_u + (double)(scale / 2.0f * scaleProg))) * d1 + (d2 = (double)pos.func_177952_p() + 0.5 - this.field_70161_v) * d2))) < (double)eggScale && !this.field_70170_p.func_175623_d(pos)) {
                            float chance = 0.04f * (scale * 0.7f) / eggScale;
                            if (this.getIsChaos()) {
                                chance *= 1.25f;
                            }
                            if (this.field_70146_Z.nextFloat() < chance) {
                                this.field_70170_p.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)this.field_70170_p.func_180495_p(pos)));
                            }
                            this.field_70170_p.func_175698_g(pos);
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        AxisAlignedBB aabb = this.func_174813_aQ().func_72317_d(0.0, (double)(scale / 2.0f * scaleProg), 0.0).func_72314_b((double)(eggScale * 0.5f), (double)(eggScale * 0.5f), (double)(eggScale * 0.5f));
        List entities = this.field_70170_p.func_72839_b((Entity)this, aabb);
        for (Entity ent : entities) {
            double dist2;
            if (!(ent instanceof EntityLivingBase) && !(ent instanceof IProjectile) || !((dist2 = (d = ent.field_70165_t - this.field_70165_t) * d + (d1 = ent.field_70163_u - (this.field_70163_u + (double)(scale / 2.0f * scaleProg))) * d1 + (d2 = ent.field_70161_v - this.field_70161_v) * d2 + this.field_70146_Z.nextGaussian() * 1.0E-5) < (double)(eggScale * eggScale))) continue;
            int amp = 2;
            ent.field_70159_w = ent.field_70159_w + (double)amp / dist2 * (d * d / dist2) * (d > 0.0 ? 1.0 : -1.0);
            ent.field_70181_x = ent.field_70181_x + (double)amp / dist2 * (d1 * d1 / dist2) * (d1 > 0.0 ? 1.0 : -1.0);
            ent.field_70179_y = ent.field_70179_y + (double)amp / dist2 * (d2 * d2 / dist2) * (d2 > 0.0 ? 1.0 : -1.0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateClientSound(float progress) {
        if (this.soundAmbience == null) {
            this.soundAmbience = new ChickenSpawnLoop(SoundIndex.egg_ambience, this.func_184176_by(), this, 0.01f, 1.0f);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.soundAmbience);
        }
        float MAX_VOL = (this.getIsChaos() ? 1.2f : 0.6f) * this.getScale();
        float volume = progress < 0.35f ? MAX_VOL * (progress / 0.35f) : (progress < 0.8f ? MAX_VOL : MAX_VOL * (1.0f - MathHelper.func_76131_a((float)((progress - 0.8f) / 0.2f), (float)0.0f, (float)1.0f)));
        this.soundAmbience.setVolume(volume);
    }

    @SideOnly(value=Side.CLIENT)
    public void stopClientSound() {
        if (this.soundAmbience != null) {
            this.soundAmbience.setDonePlaying();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateRenderNodes() {
        int index = 0;
        if (this.getScale() > 6.0f) {
            EntityChickenNode node;
            EntityChickenNode entityChickenNode = node = index < this.renderNodes.size() ? this.renderNodes.get(index) : null;
            if (node == null) {
                node = new EntityChickenNode(this.field_70170_p, this);
                this.field_70170_p.func_72838_d((Entity)node);
                this.renderNodes.add(node);
            }
            ++index;
            node.func_70012_b(this.field_70165_t, this.field_70163_u + 16.0, this.field_70161_v, 0.0f, 0.0f);
        }
        for (int i = this.renderNodes.size() - 1; i >= index; --i) {
            this.renderNodes.get(i).func_70106_y();
            this.renderNodes.remove(i);
        }
    }

    public float getLifetime() {
        float scale = this.getScale();
        float lifetime = 40.0f * scale;
        if (this.getIsChaos()) {
            lifetime = lifetime * 0.15f * scale;
        }
        return lifetime;
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        if (this.bossInfo != null) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        if (this.bossInfo != null) {
            this.bossInfo.func_186760_a(player);
        }
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        if (this.bossInfo != null) {
            this.bossInfo.func_186761_b(player);
        }
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    public void func_70037_a(NBTTagCompound tag) {
        if (tag.func_74764_b("item")) {
            this.setItemstack(new ItemStack(tag.func_74775_l("item")));
        } else {
            this.setItemstack(new ItemStack(Items.field_151110_aK));
        }
        if (tag.func_74764_b("pos")) {
            this.setBlockPos(BlockPos.func_177969_a((long)tag.func_74763_f("pos")));
        }
        if (tag.func_74764_b("scale")) {
            this.setScale(tag.func_74760_g("scale"));
        }
        if (tag.func_74764_b("isChaos")) {
            this.setIsChaos(tag.func_74767_n("isChaos"));
        }
        this.transformProgress = tag.func_74762_e("transformProgress");
        if (this.getIsChaos() && this.bossInfo != null) {
            this.bossInfo.func_186739_a((ITextComponent)new TextComponentString(ScorePlayerTeam.func_96667_a((Team)this.func_96124_cp(), (String)I18n.func_74838_a((String)"entity.ent_ChaosChicken.name"))));
            this.bossInfo.func_186745_a(BossInfo.Color.GREEN);
        }
    }

    public void func_70014_b(NBTTagCompound tag) {
        ItemStack item = this.getItemStack();
        if (!item.func_190926_b()) {
            NBTTagCompound itemTag = new NBTTagCompound();
            item.func_77955_b(itemTag);
            tag.func_74782_a("item", (NBTBase)itemTag);
        }
        tag.func_74772_a("pos", this.getBlockPos().func_177986_g());
        tag.func_74776_a("scale", this.getScale());
        tag.func_74757_a("isChaos", this.getIsChaos());
        tag.func_74768_a("transformProgress", this.transformProgress);
    }

    public void func_70106_y() {
        super.func_70106_y();
        for (EntityChickenNode node : this.renderNodes) {
            node.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K) {
            this.stopClientSound();
        }
    }

    @Override
    public Entity getSelf() {
        return this;
    }

    @Override
    public float getLastPartialTickRender() {
        return this.lastPartialTickRender;
    }
}

