/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.world;

import com.buuz135.industrial.api.recipe.LaserDrillEntry;
import com.buuz135.industrial.item.LaserLensItem;
import com.buuz135.industrial.proxy.BlockRegistry;
import com.buuz135.industrial.proxy.client.infopiece.ArrowInfoPiece;
import com.buuz135.industrial.proxy.client.infopiece.IHasDisplayString;
import com.buuz135.industrial.proxy.client.infopiece.LaserBaseInfoPiece;
import com.buuz135.industrial.proxy.client.infopiece.TextInfoPiece;
import com.buuz135.industrial.tile.CustomColoredItemHandler;
import com.buuz135.industrial.tile.CustomSidedTileEntity;
import com.buuz135.industrial.utils.ItemStackWeightedItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.TeslaCoreLib;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.inventory.SyncProviderLevel;
import net.ndrei.teslacorelib.netsync.SimpleNBTMessage;
import org.jetbrains.annotations.Nullable;

public class LaserBaseTile
extends CustomSidedTileEntity
implements IHasDisplayString {
    private static String NBT_CURRENT = "currentWork";
    private int depth = 0;
    private int currentWork = 0;
    private ItemStackHandler outItems;
    private ItemStackHandler lensItems;

    public LaserBaseTile() {
        super(LaserBaseTile.class.getName().hashCode());
        this.registerSyncIntPart("Depth", nbtTagInt -> {
            this.depth = nbtTagInt.func_150287_d();
        }, () -> new NBTTagInt(this.depth), SyncProviderLevel.GUI);
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.lensItems = new ItemStackHandler(6){

            protected void onContentsChanged(int slot) {
                LaserBaseTile.this.func_70296_d();
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.lensItems, EnumDyeColor.GREEN, "Lens items", 36, 25, 2, 3){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return stack.func_77973_b() instanceof LaserLensItem;
            }

            public boolean canExtractItem(int slot) {
                return super.canExtractItem(slot);
            }
        });
        this.addInventoryToStorage(this.lensItems, "lensItems");
        this.outItems = new ItemStackHandler(18){

            protected void onContentsChanged(int slot) {
                LaserBaseTile.this.func_70296_d();
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.outItems, EnumDyeColor.ORANGE, "Output items", 78, 25, 6, 3){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return false;
            }

            public boolean canExtractItem(int slot) {
                return true;
            }
        });
        this.addInventoryToStorage(this.outItems, "outItems");
        this.registerSyncIntPart(NBT_CURRENT, nbtTagInt -> {
            this.currentWork = nbtTagInt.func_150287_d();
        }, () -> new NBTTagInt(this.currentWork), SyncProviderLevel.GUI);
    }

    public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
        List pieces = super.getGuiContainerPieces(container);
        pieces.add(new LaserBaseInfoPiece(this, 10, 25));
        pieces.add(new ArrowInfoPiece(153, 85, 1, 104, "text.industrialforegoing.button.increase_depth"){

            protected void clicked() {
                if (TeslaCoreLib.INSTANCE.isClientSide()) {
                    if (GuiScreen.func_146272_n()) {
                        LaserBaseTile.this.sendToServer(LaserBaseTile.this.setupSpecialNBTMessage("DEPTH_INCREASE_10"));
                    } else {
                        LaserBaseTile.this.sendToServer(LaserBaseTile.this.setupSpecialNBTMessage("DEPTH_INCREASE"));
                    }
                }
            }
        });
        pieces.add(new ArrowInfoPiece(117, 85, 16, 104, "text.industrialforegoing.button.decrease_depth"){

            protected void clicked() {
                if (TeslaCoreLib.INSTANCE.isClientSide()) {
                    if (GuiScreen.func_146272_n()) {
                        LaserBaseTile.this.sendToServer(LaserBaseTile.this.setupSpecialNBTMessage("DEPTH_DECREASE_10"));
                    } else {
                        LaserBaseTile.this.sendToServer(LaserBaseTile.this.setupSpecialNBTMessage("DEPTH_DECREASE"));
                    }
                }
            }
        });
        pieces.add(new TextInfoPiece(this, 1, 132, 87));
        return pieces;
    }

    @Nullable
    protected SimpleNBTMessage processClientMessage(String messageType, NBTTagCompound compound) {
        super.processClientMessage(messageType, compound);
        if (messageType.equals("DEPTH_INCREASE_10")) {
            this.depth = Math.min(this.depth + 10, 255);
            this.partialSync("Depth", true);
        }
        if (messageType.equals("DEPTH_INCREASE")) {
            this.depth = Math.min(this.depth + 1, 255);
            this.partialSync("Depth", true);
        }
        if (messageType.equals("DEPTH_DECREASE_10")) {
            this.depth = Math.max(this.depth - 10, 0);
            this.partialSync("Depth", true);
        }
        if (messageType.equals("DEPTH_DECREASE")) {
            this.depth = Math.max(this.depth - 1, 0);
            this.partialSync("Depth", true);
        }
        return null;
    }

    protected void innerUpdate() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.currentWork >= this.getMaxWork()) {
            ItemStack stack;
            ArrayList items = new ArrayList();
            LaserDrillEntry.LASER_DRILL_ENTRIES[this.depth].forEach(entry -> {
                if ((entry.getWhitelist().isEmpty() || entry.getWhitelist().contains(this.func_145831_w().func_180494_b(this.func_174877_v()))) && !entry.getBlacklist().contains(this.func_145831_w().func_180494_b(this.func_174877_v()))) {
                    int increase = 0;
                    for (int i = 0; i < this.lensItems.getSlots(); ++i) {
                        if (!this.lensItems.getStackInSlot(i).func_190926_b() && this.lensItems.getStackInSlot(i).func_77960_j() == entry.getLaserMeta() && this.lensItems.getStackInSlot(i).func_77973_b() instanceof LaserLensItem) {
                            increase = ((LaserLensItem)this.lensItems.getStackInSlot(i).func_77973_b()).isInverted() ? (increase -= BlockRegistry.laserBaseBlock.getLenseChanceIncrease()) : (increase += BlockRegistry.laserBaseBlock.getLenseChanceIncrease());
                        }
                        items.add(new ItemStackWeightedItem(entry.getStack(), entry.getWeight() + increase));
                    }
                }
            });
            if (!items.isEmpty() && ItemHandlerHelper.insertItem((IItemHandler)this.outItems, (ItemStack)(stack = ((ItemStackWeightedItem)WeightedRandom.func_76271_a((Random)this.field_145850_b.field_73012_v, items)).getStack().func_77946_l()), (boolean)true).func_190926_b()) {
                ItemHandlerHelper.insertItem((IItemHandler)this.outItems, (ItemStack)stack, (boolean)false);
            }
            this.currentWork = 0;
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.currentWork = 0;
        this.depth = 0;
        if (compound.func_74764_b(NBT_CURRENT)) {
            this.currentWork = compound.func_74762_e(NBT_CURRENT);
        }
        if (compound.func_74764_b("Depth")) {
            this.depth = compound.func_74762_e("Depth");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a(NBT_CURRENT, this.currentWork);
        compound.func_74768_a("Depth", this.depth);
        return super.func_189515_b(compound);
    }

    public int getCurrentWork() {
        return this.currentWork;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getMaxWork() {
        return BlockRegistry.laserBaseBlock.getWorkNeeded();
    }

    public void increaseWork() {
        ++this.currentWork;
        this.partialSync(NBT_CURRENT, true);
    }

    protected boolean getShowPauseDrawerPiece() {
        return false;
    }

    protected boolean getShowRedstoneControlPiece() {
        return false;
    }

    protected boolean supportsAddons() {
        return false;
    }

    @Override
    public String getString(int id) {
        return "" + TextFormatting.DARK_GRAY + this.getDepth();
    }
}

