/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.network;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.api.utils.BlockCoords;
import sonar.flux.FluxNetworks;
import sonar.flux.api.AdditionType;
import sonar.flux.api.FluxError;
import sonar.flux.api.RemovalType;
import sonar.flux.api.network.FluxPlayer;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.client.gui.EnumGuiTab;
import sonar.flux.common.tileentity.TileFlux;
import sonar.flux.network.ListenerHelper;
import sonar.flux.network.PacketError;
import sonar.flux.network.PacketTile;
import sonar.flux.network.PacketTileType;

public class PacketTileHelper {
    public static void sendPacketToServer(PacketTileType type, TileFlux source, NBTTagCompound packetTag) {
        BlockCoords coords = source.getCoords();
        FluxNetworks.network.sendToServer((IMessage)new PacketTile(type, coords.getBlockPos(), packetTag, coords.getDimension()));
    }

    public static void sendPacketToServer(PacketTileType type, BlockCoords coords, NBTTagCompound packetTag) {
        FluxNetworks.network.sendToServer((IMessage)new PacketTile(type, coords.getBlockPos(), packetTag, coords.getDimension()));
    }

    public static NBTTagCompound createNetworkSetPacket(int networkID) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("networkID", networkID);
        return tag;
    }

    public static IMessage doNetworkSetPacket(TileFlux source, EntityPlayer player, NBTTagCompound packetTag) {
        int networkID = packetTag.func_74762_e("networkID");
        if (source.getNetwork().getNetworkID() == networkID) {
            return null;
        }
        IFluxNetwork network = FluxNetworks.getServerCache().getNetwork(networkID);
        if (!network.isFakeNetwork()) {
            if (network.getPlayerAccess(player).canConnect()) {
                source.getNetwork().queueConnectionRemoval(source, RemovalType.REMOVE);
                network.queueConnectionAddition(source, AdditionType.ADD);
            } else {
                return new PacketError(FluxError.ACCESS_DENIED);
            }
        }
        return null;
    }

    public static NBTTagCompound createSetPriorityPacket(int priority) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("priority", priority);
        return tag;
    }

    public static IMessage doSetPriorityPacket(TileFlux source, EntityPlayer player, NBTTagCompound packetTag) {
        int priority = packetTag.func_74762_e("priority");
        if (!source.canAccess(player).canEdit()) {
            return new PacketError(FluxError.ACCESS_DENIED);
        }
        source.priority.setValue((Object)priority);
        return null;
    }

    public static NBTTagCompound createSetTransferLimitPacket(int transferLimit) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74772_a("transferLimit", (long)transferLimit);
        return tag;
    }

    public static IMessage doSetTransferLimitPacket(TileFlux source, EntityPlayer player, NBTTagCompound packetTag) {
        long priority = packetTag.func_74763_f("transferLimit");
        if (!source.canAccess(player).canEdit()) {
            return new PacketError(FluxError.ACCESS_DENIED);
        }
        source.limit.setValue((Object)priority);
        return null;
    }

    public static NBTTagCompound createDisconnectPacket(int networkID) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("networkID", networkID);
        return tag;
    }

    public static IMessage doDisconnectPacket(TileFlux source, EntityPlayer player, NBTTagCompound packetTag) {
        IFluxNetwork network;
        int networkID = packetTag.func_74762_e("networkID");
        if (networkID == (network = source.getNetwork()).getNetworkID() && network.getPlayerAccess(player).canConnect() && ((UUID)source.playerUUID.getValue()).equals(FluxPlayer.getOnlineUUID(player))) {
            network.queueConnectionRemoval(source, RemovalType.REMOVE);
        }
        return null;
    }

    public static NBTTagCompound createStateChangePacket(EnumGuiTab oldTab, @Nullable EnumGuiTab newTab) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("oldTab", oldTab.ordinal());
        if (newTab != null) {
            tag.func_74768_a("newTab", newTab.ordinal());
        }
        return tag;
    }

    public static IMessage doStateChangePacket(TileFlux source, EntityPlayer player, NBTTagCompound packetTag) {
        EnumGuiTab oldTab = EnumGuiTab.values()[packetTag.func_74762_e("oldTab")];
        ListenerHelper.onPlayerCloseTileTab(source, player, oldTab);
        if (packetTag.func_74764_b("newTab")) {
            EnumGuiTab newTab = EnumGuiTab.values()[packetTag.func_74762_e("newTab")];
            ListenerHelper.onPlayerOpenTileTab(source, player, newTab);
        }
        return null;
    }
}

