/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.connection;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import sonar.core.api.energy.EnergyType;
import sonar.core.api.utils.ActionType;
import sonar.core.listener.ISonarListenable;
import sonar.flux.FluxNetworks;
import sonar.flux.api.AdditionType;
import sonar.flux.api.RemovalType;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.api.tiles.IFlux;
import sonar.flux.api.tiles.IFluxController;
import sonar.flux.api.tiles.IFluxListenable;
import sonar.flux.api.tiles.IFluxPlug;
import sonar.flux.api.tiles.IFluxPoint;
import sonar.flux.network.FluxNetworkCache;

public class FluxHelper {
    public static void addConnection(IFluxListenable flux, AdditionType type) {
        IFluxNetwork network;
        FluxNetworkCache.instance().getListenerList().addSubListenable((ISonarListenable)flux);
        if (flux.getNetworkID() != -1 && !(network = FluxNetworks.getServerCache().getNetwork(flux.getNetworkID())).isFakeNetwork()) {
            network.queueConnectionAddition(flux, type);
            return;
        }
        FluxNetworkCache.instance().onTileDisconnected(flux);
    }

    public static void removeConnection(IFluxListenable flux, RemovalType type) {
        IFluxNetwork network;
        FluxNetworkCache.instance().getListenerList().removeSubListenable((ISonarListenable)flux);
        if (type != RemovalType.REMOVE) {
            FluxNetworkCache.instance().onTileRemoved(flux);
        }
        if (flux.getNetworkID() != -1 && !(network = FluxNetworks.getServerCache().getNetwork(flux.getNetworkID())).isFakeNetwork()) {
            network.queueConnectionRemoval(flux, type);
            return;
        }
    }

    public static boolean isPlayerAdmin(EntityPlayer player) {
        return player.func_184812_l_();
    }

    public static long transferEnergy(long max, List<IFluxPoint> points, EnergyType type, IFluxController.TransferMode mode) {
        long currentLimit = max;
        for (IFluxPoint point : points) {
            if ((currentLimit -= FluxHelper.removeEnergyFromNetwork(point, type, currentLimit, ActionType.PERFORM)) <= 0L) break;
        }
        return max - currentLimit;
    }

    public static long transferEnergy(IFluxPlug plug, List<IFluxPoint> points, EnergyType type, IFluxController.TransferMode mode) {
        long currentLimit = Long.MAX_VALUE;
        for (IFluxPoint point : points) {
            long toTransfer;
            if (currentLimit <= 0L) break;
            if (point.getConnectionType() == plug.getConnectionType() || (toTransfer = FluxHelper.addEnergyToNetwork(plug, type, FluxHelper.removeEnergyFromNetwork(point, type, currentLimit, ActionType.SIMULATE), ActionType.SIMULATE)) <= 0L) continue;
            long pointRec = FluxHelper.removeEnergyFromNetwork(point, type, toTransfer, ActionType.PERFORM);
            currentLimit -= FluxHelper.addEnergyToNetwork(plug, type, pointRec, ActionType.PERFORM);
        }
        return Long.MAX_VALUE - currentLimit;
    }

    public static long addEnergyToNetwork(IFlux from, EnergyType type, long maxTransferRF, ActionType actionType) {
        return from.getTransferHandler().addToNetwork(maxTransferRF, type, actionType);
    }

    public static long removeEnergyFromNetwork(IFlux from, EnergyType type, long maxTransferRF, ActionType actionType) {
        return from.getTransferHandler().removeFromNetwork(maxTransferRF, type, actionType);
    }
}

