/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.common.block;

import cofh.redstoneflux.api.IEnergyConnection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import sonar.core.common.block.SonarBlock;
import sonar.core.common.block.SonarMaterials;
import sonar.core.integration.SonarLoader;
import sonar.core.utils.ISpecialTooltip;
import sonar.flux.FluxNetworks;
import sonar.flux.api.tiles.IFlux;
import sonar.flux.common.tileentity.TileCable;

public class FluxCable
extends SonarBlock
implements ITileEntityProvider,
ISpecialTooltip {
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");

    public FluxCable() {
        super(SonarMaterials.machine, false);
        this.bounding_box = new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 0.75, 0.75);
    }

    public TileEntity func_149915_a(@Nonnull World world, int i) {
        return new TileCable();
    }

    public boolean checkBlockInDirection(IBlockAccess world, BlockPos pos, EnumFacing dir) {
        TileEntity tile = world.func_175625_s(pos.func_177972_a(dir));
        if (tile != null) {
            if (tile instanceof IFlux || tile instanceof TileCable || SonarLoader.rfLoaded && tile instanceof IEnergyConnection) {
                return true;
            }
            return FluxNetworks.TRANSFER_HANDLER.getTileHandler(tile, dir) != null;
        }
        return false;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, SOUTH, WEST, DOWN, UP});
    }

    public void addSpecialToolTip(ItemStack stack, World world, List<String> list, @Nullable NBTTagCompound tag) {
    }
}

