/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.api.tiles;

import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import sonar.core.api.utils.BlockCoords;
import sonar.core.helpers.FontHelper;
import sonar.flux.FluxNetworks;
import sonar.flux.api.EnumActivationType;
import sonar.flux.api.EnumPriorityType;
import sonar.flux.api.energy.internal.ITransferHandler;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.api.network.PlayerAccess;

public interface IFlux {
    public ItemStack getDisplayStack();

    public int getNetworkID();

    public IFluxNetwork getNetwork();

    public UUID getConnectionOwner();

    public PlayerAccess canAccess(EntityPlayer var1);

    public World getDimension();

    public BlockCoords getCoords();

    public ConnectionType getConnectionType();

    public long getTransferLimit();

    public long getCurrentLimit();

    public boolean getDisableLimit();

    public EnumActivationType getActivationType();

    public EnumPriorityType getPriorityType();

    public int getCurrentPriority();

    public int getFolderID();

    public boolean isChunkLoaded();

    public boolean isActive();

    public String getCustomName();

    public ITransferHandler getTransferHandler();

    public void connect(IFluxNetwork var1);

    public void disconnect(IFluxNetwork var1);

    public static enum ConnectionType {
        POINT(FontHelper.getIntFromColor((int)136, (int)40, (int)40)),
        PLUG(FontHelper.getIntFromColor((int)96, (int)151, (int)50)),
        STORAGE(FontHelper.getIntFromColor((int)41, (int)94, (int)138)),
        CONTROLLER(FontHelper.getIntFromColor((int)100, (int)100, (int)120));

        public int gui_colour;

        private ConnectionType(int gui_colour) {
            this.gui_colour = gui_colour;
        }

        public boolean canAdd() {
            return this == PLUG || this == STORAGE;
        }

        public boolean canRemove() {
            return this == POINT || this == STORAGE || this == CONTROLLER;
        }

        public boolean canAddPhantomPower() {
            return this == PLUG;
        }

        public boolean canRemovePhantomPower() {
            return this == POINT;
        }

        public ItemStack getRepresentiveStack() {
            switch (this) {
                case CONTROLLER: {
                    return new ItemStack(FluxNetworks.fluxController);
                }
                case PLUG: {
                    return new ItemStack(FluxNetworks.fluxPlug);
                }
                case POINT: {
                    return new ItemStack(FluxNetworks.fluxPoint);
                }
                case STORAGE: {
                    return new ItemStack(FluxNetworks.fluxStorage);
                }
            }
            return ItemStack.field_190927_a;
        }
    }
}

