/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common.zenscript.adders;

import com.google.gson.JsonElement;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.data.IData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import leviathan143.loottweaker.common.lib.DataToJSONConverter;
import leviathan143.loottweaker.common.lib.LootUtils;
import leviathan143.loottweaker.common.zenscript.ZenLootConditionWrapper;
import leviathan143.loottweaker.common.zenscript.ZenLootPoolWrapper;
import leviathan143.loottweaker.common.zenscript.actions.AddLootEntry;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import stanhebben.zenscript.annotations.ZenMethod;

public abstract class AbstractEntryAdder<T extends LootEntry> {
    private ZenLootPoolWrapper wrapper;
    protected int weight;
    protected int quality;
    protected Collection<LootCondition> conditions = new ArrayList<LootCondition>();
    protected String name;

    public AbstractEntryAdder(ZenLootPoolWrapper wrapper) {
        this.wrapper = wrapper;
        this.name = this.getDefaultName();
    }

    protected abstract String getDefaultName();

    @ZenMethod
    public AbstractEntryAdder<T> weight(int weight) {
        this.weight = weight;
        return this;
    }

    @ZenMethod
    public AbstractEntryAdder<T> quality(int quality) {
        this.quality = quality;
        return this;
    }

    @ZenMethod
    public AbstractEntryAdder<T> conditionsJson(IData[] conditions) {
        Object[] json = (JsonElement[])Arrays.stream(conditions).map(DataToJSONConverter::from).toArray(JsonElement[]::new);
        Collections.addAll(this.conditions, LootUtils.parseConditions(json));
        return this;
    }

    @ZenMethod
    public AbstractEntryAdder<T> conditionsHelper(ZenLootConditionWrapper[] conditions) {
        Collections.addAll(this.conditions, LootUtils.parseConditions(conditions));
        return this;
    }

    @ZenMethod
    public AbstractEntryAdder<T> name(String name) {
        this.name = name;
        return this;
    }

    @ZenMethod
    public void add() {
        CraftTweakerAPI.apply((IAction)new AddLootEntry(this.wrapper, (LootEntry)this.createLootEntry()));
    }

    protected abstract T createLootEntry();
}

