/*
 * Decompiled with CFR 0.152.
 */
package quaternary.botaniatweaks.modules.shared.tile;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.tile.TileOpenCrate;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.item.ModItems;

public abstract class AbstractTileCompatCrate<T>
extends TileOpenCrate {
    int oldItemCount = 0;

    public abstract int getCrateWidth();

    public abstract int getCrateHeight();

    protected abstract Iterable<T> getAllRecipes();

    protected abstract boolean doesRecipeMatch(T var1, InventoryCrafting var2);

    protected abstract ItemStack getCraftingResult(T var1, InventoryCrafting var2);

    protected int getCrateSize() {
        return this.getCrateWidth() * this.getCrateHeight();
    }

    public int getSizeInventory() {
        return this.getCrateSize() + 1;
    }

    protected TileSimpleInventory.SimpleItemStackHandler createItemHandler() {
        return new TileSimpleInventory.SimpleItemStackHandler((TileSimpleInventory)this, true){

            protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
                return 1;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return slot == AbstractTileCompatCrate.this.getCrateWidth() * AbstractTileCompatCrate.this.getCrateHeight() ? stack : super.insertItem(slot, stack, simulate);
            }
        };
    }

    public void func_73660_a() {
        int newItemCount;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.canEject() && this.isCrateFull() && this.craft(true)) {
            this.ejectAll();
        }
        if (this.oldItemCount != (newItemCount = this.countItems())) {
            this.oldItemCount = newItemCount;
            this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
            this.func_70296_d();
        }
    }

    boolean craft(boolean fullCheck) {
        if (fullCheck && !this.isCrateFull()) {
            return false;
        }
        InventoryCrafting inv = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer entityPlayer) {
                return false;
            }
        }, this.getCrateWidth(), this.getCrateHeight());
        for (int i = 0; i < this.getCrateSize(); ++i) {
            ItemStack crateStack = this.itemHandler.getStackInSlot(i);
            if (crateStack.func_190926_b() || crateStack.func_77973_b() == ModItems.manaResource && crateStack.func_77952_i() == 11) continue;
            inv.func_70299_a(i, crateStack);
        }
        for (T recipe : this.getAllRecipes()) {
            if (!this.doesRecipeMatch(recipe, inv)) continue;
            ItemStack output = this.getCraftingResult(recipe, inv);
            this.itemHandler.setStackInSlot(this.getCrateSize(), output);
            for (int i = 0; i < this.getCrateSize(); ++i) {
                ItemStack stack = this.itemHandler.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                this.itemHandler.setStackInSlot(i, stack.func_77973_b().getContainerItem(stack));
            }
            return true;
        }
        return false;
    }

    boolean isCrateFull() {
        for (int i = 0; i < this.getCrateSize(); ++i) {
            if (!this.itemHandler.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    int countItems() {
        int count = 0;
        for (int i = 0; i < this.getCrateSize(); ++i) {
            count += this.itemHandler.getStackInSlot(i).func_190926_b() ? 0 : 1;
        }
        return count;
    }

    void ejectAll() {
        for (int i = 0; i < this.getCrateSize() + 1; ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (!stack.func_190926_b()) {
                this.eject(stack, false);
            }
            this.itemHandler.setStackInSlot(i, ItemStack.field_190927_a);
        }
        this.func_70296_d();
    }

    public boolean onWanded(World world, EntityPlayer player, ItemStack stack) {
        if (!world.field_72995_K && this.canEject()) {
            this.craft(false);
            this.ejectAll();
        }
        return true;
    }

    public void func_70296_d() {
        super.func_70296_d();
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers((TileEntity)this);
    }
}

