/*
 * Decompiled with CFR 0.152.
 */
package quaternary.botaniatweaks.modules.crafttweaker;

import com.blamejared.mtlib.helpers.InputHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.mc1120.item.MCItemStack;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import quaternary.botaniatweaks.modules.botania.recipe.AgglomerationRecipe;
import quaternary.botaniatweaks.modules.botania.recipe.AgglomerationRecipes;
import quaternary.botaniatweaks.modules.crafttweaker.ModuleCrafttweaker;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenProperty;
import vazkii.botania.common.block.ModBlocks;

@ZenClass(value="mods.botaniatweaks.Agglomeration")
@ZenRegister
public class CTAgglomeration {
    public static final String NAME = "Botania Tweaks Agglomeration";

    @ZenMethod
    public static void removeDefaultRecipe() {
        ModuleCrafttweaker.REMOVE_ACTIONS.add(new RemoveAction(AgglomerationRecipes.defaultRecipe));
    }

    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient[] inputs, @Optional Integer manaCost, @Optional Integer color1, @Optional Integer color2, @Optional IIngredient center, @Optional IIngredient edge, @Optional IIngredient corner, @Optional IIngredient centerReplace, @Optional IIngredient edgeReplace, @Optional IIngredient cornerReplace) {
        ModuleCrafttweaker.ADD_ACTIONS.add(new AddAction(CTAgglomeration.buildAgglomerationRecipe(output, inputs, manaCost, color1, color2, center, edge, corner, centerReplace, edgeReplace, cornerReplace)));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output, IIngredient[] inputs, @Optional Integer manaCost, @Optional Integer color1, @Optional Integer color2, @Optional IIngredient center, @Optional IIngredient edge, @Optional IIngredient corner, @Optional IIngredient centerReplace, @Optional IIngredient edgeReplace, @Optional IIngredient cornerReplace) {
        ModuleCrafttweaker.REMOVE_ACTIONS.add(new RemoveAction(CTAgglomeration.buildAgglomerationRecipe(output, inputs, manaCost, color1, color2, center, edge, corner, centerReplace, edgeReplace, cornerReplace)));
    }

    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient[] inputs, Integer manaCost, Integer color1, Integer color2, CTAgglomerationMultiblock multiblock) {
        CTAgglomeration.addRecipe(output, inputs, manaCost, color1, color2, multiblock.center, multiblock.edge, multiblock.corner, multiblock.centerReplace, multiblock.edgeReplace, multiblock.cornerReplace);
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output, IIngredient[] inputs, Integer manaCost, Integer color1, Integer color2, CTAgglomerationMultiblock multiblock) {
        CTAgglomeration.removeRecipe(output, inputs, manaCost, color1, color2, multiblock.center, multiblock.edge, multiblock.corner, multiblock.centerReplace, multiblock.edgeReplace, multiblock.cornerReplace);
    }

    @ZenMethod
    public static void addRecipe(CTAgglomerationRecipe recipe) {
        ModuleCrafttweaker.ADD_ACTIONS.add(new AddAction(recipe.toAgglomerationRecipe()));
    }

    @ZenMethod
    public static void removeRecipe(CTAgglomerationRecipe recipe) {
        ModuleCrafttweaker.REMOVE_ACTIONS.add(new RemoveAction(recipe.toAgglomerationRecipe()));
    }

    private static IBlockState toMinecraftBlockstate(IIngredient ing) {
        if (ing == null) {
            return null;
        }
        Object obj = InputHelper.toObject((IIngredient)ing);
        if (obj instanceof ItemStack) {
            ItemStack stack = (ItemStack)obj;
            return Block.func_149634_a((Item)stack.func_77973_b()).func_176203_a(stack.func_77960_j());
        }
        if (obj instanceof ILiquidStack) {
            return InputHelper.toFluid((ILiquidStack)((ILiquidStack)obj)).getFluid().getBlock().func_176223_P();
        }
        throw new IllegalArgumentException("Invalid multiblock item: " + ing);
    }

    private static MCItemStack mcStackFromBlock(Block b) {
        return new MCItemStack(new ItemStack(Item.func_150898_a((Block)b)));
    }

    static AgglomerationRecipe buildAgglomerationRecipe(IItemStack output, IIngredient[] inputs, @Nullable Integer manaCostIn, @Nullable Integer color1In, @Nullable Integer color2In, @Nullable IIngredient center, @Nullable IIngredient edge, @Nullable IIngredient corner, @Nullable IIngredient centerReplace, @Nullable IIngredient edgeReplace, @Nullable IIngredient cornerReplace) {
        IBlockState cornerState;
        IBlockState edgeState;
        IBlockState centerState;
        Preconditions.checkNotNull((Object)output, (Object)"Recipe output must be defined!");
        Preconditions.checkNotNull((Object)inputs, (Object)"Recipe inputs must be defined!");
        int providedMultiblockStates = 0;
        providedMultiblockStates += center == null ? 0 : 1;
        providedMultiblockStates += edge == null ? 0 : 1;
        Preconditions.checkArgument(((providedMultiblockStates += corner == null ? 0 : 1) == 0 || providedMultiblockStates == 3 ? 1 : 0) != 0, (Object)"The multiblock must be completely defined or not defined at all!");
        ImmutableList ins = ImmutableList.copyOf((Object[])InputHelper.toObjects((IIngredient[])inputs));
        ItemStack out = InputHelper.toStack((IItemStack)output);
        int manaCost = 500000;
        if (manaCostIn != null) {
            manaCost = manaCostIn;
        }
        int color1 = 255;
        if (color1In != null) {
            color1 = color1In;
        }
        int color2 = 65280;
        if (color2In != null) {
            color2 = color2In;
        }
        if (providedMultiblockStates == 0) {
            centerState = ModBlocks.livingrock.func_176223_P();
            edgeState = Blocks.field_150368_y.func_176223_P();
            cornerState = ModBlocks.livingrock.func_176223_P();
        } else {
            centerState = CTAgglomeration.toMinecraftBlockstate(center);
            edgeState = CTAgglomeration.toMinecraftBlockstate(edge);
            cornerState = CTAgglomeration.toMinecraftBlockstate(corner);
        }
        IBlockState centerStateReplace = CTAgglomeration.toMinecraftBlockstate(centerReplace);
        IBlockState edgeStateReplace = CTAgglomeration.toMinecraftBlockstate(edgeReplace);
        IBlockState cornerStateReplace = CTAgglomeration.toMinecraftBlockstate(cornerReplace);
        return new AgglomerationRecipe((ImmutableList<Object>)ins, out, manaCost, color1, color2, centerState, edgeState, cornerState, centerStateReplace, edgeStateReplace, cornerStateReplace);
    }

    static /* synthetic */ MCItemStack access$000(Block x0) {
        return CTAgglomeration.mcStackFromBlock(x0);
    }

    public static class RemoveAction
    implements IAction {
        AgglomerationRecipe recipe;

        public RemoveAction(AgglomerationRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            AgglomerationRecipes.unregister(this.recipe);
        }

        public String describe() {
            return "Removing an agglomeration recipe: " + this.recipe.toString();
        }
    }

    public static class AddAction
    implements IAction {
        AgglomerationRecipe recipe;

        public AddAction(AgglomerationRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            AgglomerationRecipes.register(this.recipe);
        }

        public String describe() {
            return "Adding an agglomeration recipe: " + this.recipe.toString();
        }
    }

    @ZenClass(value="mods.botaniatweaks.AgglomerationMultiblock")
    @ZenRegister
    public static class CTAgglomerationMultiblock {
        @ZenProperty
        public IIngredient center = CTAgglomeration.access$000(ModBlocks.livingrock);
        @ZenProperty
        public IIngredient edge = CTAgglomeration.access$000(Blocks.field_150368_y);
        @ZenProperty
        public IIngredient corner = CTAgglomeration.access$000(ModBlocks.livingrock);
        @ZenProperty
        public IIngredient centerReplace = null;
        @ZenProperty
        public IIngredient edgeReplace = null;
        @ZenProperty
        public IIngredient cornerReplace = null;

        @ZenMethod
        public static CTAgglomerationMultiblock create() {
            return new CTAgglomerationMultiblock();
        }

        @ZenMethod
        public CTAgglomerationMultiblock center(IIngredient center) {
            this.center = center;
            return this;
        }

        @ZenMethod
        public CTAgglomerationMultiblock edge(IIngredient edge) {
            this.edge = edge;
            return this;
        }

        @ZenMethod
        public CTAgglomerationMultiblock corner(IIngredient corner) {
            this.corner = corner;
            return this;
        }

        @ZenMethod
        public CTAgglomerationMultiblock all(IIngredient all) {
            this.corner = this.edge = all;
            this.center = this.edge;
            return this;
        }

        @ZenMethod
        public CTAgglomerationMultiblock checker(IIngredient five, IIngredient four) {
            this.center = this.corner = five;
            this.edge = four;
            return this;
        }

        @ZenMethod
        public CTAgglomerationMultiblock centerReplace(IIngredient centerReplace) {
            this.centerReplace = centerReplace;
            return this;
        }

        @ZenMethod
        public CTAgglomerationMultiblock edgeReplace(IIngredient edgeReplace) {
            this.edgeReplace = edgeReplace;
            return this;
        }

        @ZenMethod
        public CTAgglomerationMultiblock cornerReplace(IIngredient cornerReplace) {
            this.cornerReplace = cornerReplace;
            return this;
        }

        @ZenMethod
        public CTAgglomerationMultiblock allReplace(IIngredient allReplace) {
            this.cornerReplace = this.edgeReplace = allReplace;
            this.centerReplace = this.edgeReplace;
            return this;
        }

        @ZenMethod
        public CTAgglomerationMultiblock checkerReplace(IIngredient fiveReplace, IIngredient fourReplace) {
            this.centerReplace = this.cornerReplace = fiveReplace;
            this.edgeReplace = fourReplace;
            return this;
        }

        @ZenMethod
        public CTAgglomerationMultiblock consumeCenter() {
            this.centerReplace = MCItemStack.EMPTY;
            return this;
        }

        @ZenMethod
        public CTAgglomerationMultiblock consumeEdge() {
            this.edgeReplace = MCItemStack.EMPTY;
            return this;
        }

        @ZenMethod
        public CTAgglomerationMultiblock consumeCorner() {
            this.cornerReplace = MCItemStack.EMPTY;
            return this;
        }
    }

    @ZenClass(value="mods.botaniatweaks.AgglomerationRecipe")
    @ZenRegister
    public static class CTAgglomerationRecipe {
        @ZenProperty
        public IItemStack output;
        @ZenProperty
        public IIngredient[] inputs;
        @ZenProperty
        public int manaCost = 500000;
        @ZenProperty
        public int color1 = 255;
        @ZenProperty
        public int color2 = 65280;
        @ZenProperty
        public CTAgglomerationMultiblock multiblock = new CTAgglomerationMultiblock();

        @ZenMethod
        public static CTAgglomerationRecipe create() {
            return new CTAgglomerationRecipe();
        }

        @ZenMethod
        public CTAgglomerationRecipe output(IItemStack output) {
            this.output = output;
            return this;
        }

        @ZenMethod
        public CTAgglomerationRecipe inputs(IIngredient[] inputs) {
            this.inputs = inputs;
            return this;
        }

        @ZenMethod
        public CTAgglomerationRecipe manaCost(int manaCost) {
            this.manaCost = manaCost;
            return this;
        }

        @ZenMethod
        public CTAgglomerationRecipe color1(int color1) {
            this.color1 = color1;
            return this;
        }

        @ZenMethod
        public CTAgglomerationRecipe colo2(int color2) {
            this.color2 = color2;
            return this;
        }

        @ZenMethod
        public CTAgglomerationRecipe multiblock(CTAgglomerationMultiblock multiblock) {
            this.multiblock = multiblock;
            return this;
        }

        AgglomerationRecipe toAgglomerationRecipe() {
            return CTAgglomeration.buildAgglomerationRecipe(this.output, this.inputs, this.manaCost, this.color1, this.color2, this.multiblock.center, this.multiblock.edge, this.multiblock.corner, this.multiblock.centerReplace, this.multiblock.edgeReplace, this.multiblock.cornerReplace);
        }
    }
}

