/*
 * Decompiled with CFR 0.152.
 */
package quaternary.botaniatweaks.modules.botania.tile;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.energy.IEnergyStorage;
import quaternary.botaniatweaks.modules.botania.config.BotaniaConfig;
import vazkii.botania.api.mana.IManaReceiver;

public class TileNerfedManaFluxfield
extends TileEntity
implements IManaReceiver,
ITickable {
    static int energyBufferSize = 10000;
    static final int MAX_EXTRACTION_RATE = 1600;
    int manaBuffer = 0;
    static final int MAX_MANA_BUFFER = 10000;
    public EnergyHandler handler = new EnergyHandler();
    @CapabilityInject(value=IEnergyStorage.class)
    public static final Capability<IEnergyStorage> ENERGY_CAP = null;

    public void func_73660_a() {
        int leftover;
        int manaThreshold = BotaniaConfig.MANA_SHOTS_PER_ENERGY_BURST * 160;
        energyBufferSize = BotaniaConfig.FE_PER_ENERGY_BURST * 10;
        while (this.manaBuffer >= manaThreshold && (leftover = this.handler.sneakyReceiveEnergy(BotaniaConfig.FE_PER_ENERGY_BURST, true)) == 0) {
            this.handler.sneakyReceiveEnergy(BotaniaConfig.FE_PER_ENERGY_BURST, false);
            this.manaBuffer -= manaThreshold;
        }
        ArrayList<IEnergyStorage> nearbyCaps = new ArrayList<IEnergyStorage>();
        for (EnumFacing whichWay : EnumFacing.values()) {
            BlockPos checkPos = this.field_174879_c.func_177972_a(whichWay);
            TileEntity tile = this.field_145850_b.func_175625_s(checkPos);
            if (tile == null) continue;
            IEnergyStorage cap = null;
            if (tile.hasCapability(ENERGY_CAP, null)) {
                cap = (IEnergyStorage)tile.getCapability(ENERGY_CAP, null);
            }
            if (tile.hasCapability(ENERGY_CAP, whichWay.func_176734_d())) {
                cap = (IEnergyStorage)tile.getCapability(ENERGY_CAP, whichWay.func_176734_d());
            }
            if (cap == null) continue;
            nearbyCaps.add(cap);
        }
        if (nearbyCaps.size() == 0) {
            return;
        }
        int powerToDistribute = this.handler.getEnergyStored() / nearbyCaps.size();
        for (IEnergyStorage cap : nearbyCaps) {
            int wouldReceivedPower = cap.receiveEnergy(powerToDistribute, true);
            if (wouldReceivedPower == 0) continue;
            cap.receiveEnergy(wouldReceivedPower, false);
            this.handler.extractEnergy(wouldReceivedPower, false);
        }
    }

    public boolean isFull() {
        return this.handler.getEnergyStored() >= energyBufferSize;
    }

    public void recieveMana(int mana) {
        this.manaBuffer += mana;
    }

    public boolean canRecieveManaFromBursts() {
        return this.manaBuffer <= 10000;
    }

    public int getCurrentMana() {
        return this.manaBuffer;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74768_a("ManaBuffer", this.manaBuffer);
        nbt.func_74768_a("EnergyBuffer", this.handler.getEnergyStored());
        return super.func_189515_b(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.manaBuffer = nbt.func_74762_e("ManaBuffer");
        this.handler.setEnergyStored(nbt.func_74762_e("EnergyBuffer"));
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == ENERGY_CAP) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == ENERGY_CAP) {
            return (T)ENERGY_CAP.cast((Object)this.handler);
        }
        return (T)super.getCapability(capability, facing);
    }

    class EnergyHandler
    implements IEnergyStorage {
        int energy = 0;

        EnergyHandler() {
        }

        public int getEnergyStored() {
            return this.energy;
        }

        void setEnergyStored(int energy) {
            this.energy = energy;
        }

        public int getMaxEnergyStored() {
            return energyBufferSize;
        }

        public boolean canExtract() {
            return true;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int toExtract = Math.min(1600, Math.min(this.energy, maxExtract));
            if (!simulate) {
                this.energy -= toExtract;
            }
            return toExtract;
        }

        public boolean canReceive() {
            return false;
        }

        int sneakyReceiveEnergy(int maxReceive, boolean simulate) {
            int freeSpace = this.getMaxEnergyStored() - this.energy;
            if (maxReceive <= freeSpace) {
                if (!simulate) {
                    this.energy += maxReceive;
                }
                return 0;
            }
            if (!simulate) {
                this.energy = energyBufferSize;
            }
            return maxReceive - freeSpace;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }
    }
}

