/*
 * Decompiled with CFR 0.152.
 */
package quaternary.botaniatweaks.modules.botania.tile;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;
import quaternary.botaniatweaks.modules.botania.config.BotaniaConfig;
import quaternary.botaniatweaks.modules.botania.net.PacketCustomTerraPlate;
import quaternary.botaniatweaks.modules.botania.recipe.AgglomerationRecipe;
import quaternary.botaniatweaks.modules.botania.recipe.AgglomerationRecipes;
import quaternary.botaniatweaks.modules.shared.net.BotaniaTweaksPacketHandler;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.ISparkEntity;
import vazkii.botania.api.mana.spark.SparkHelper;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.entity.EntitySpark;

public class TileCustomAgglomerationPlate
extends TileEntity
implements ISparkAttachable,
ITickable {
    int currentMana;
    int maxMana;

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.field_145850_b.field_72984_F.func_76320_a("botaniatweaks_agglo_plate");
        this.field_145850_b.field_72984_F.func_76320_a("discoverStacks");
        List itemEntities = this.field_145850_b.func_72872_a(EntityItem.class, new AxisAlignedBB(this.field_174879_c));
        if (itemEntities.isEmpty()) {
            this.field_145850_b.field_72984_F.func_76319_b();
            this.field_145850_b.field_72984_F.func_76319_b();
            return;
        }
        List<ItemStack> itemStacks = itemEntities.stream().map(EntityItem::func_92059_d).collect(Collectors.toList());
        this.field_145850_b.field_72984_F.func_76319_b();
        if (BotaniaConfig.PROCESS_CUSTOM_AGGLO_STACKS) {
            this.field_145850_b.field_72984_F.func_76320_a("collectStacks");
            ArrayList collectedStacks = new ArrayList();
            for (ItemStack stack : itemStacks) {
                boolean matched = false;
                for (ItemStack collect : collectedStacks) {
                    if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)collect)) continue;
                    collect.func_190917_f(stack.func_190916_E());
                    matched = true;
                    break;
                }
                if (matched) continue;
                collectedStacks.add(stack.func_77946_l());
            }
            itemStacks = collectedStacks;
            this.field_145850_b.field_72984_F.func_76319_b();
        }
        this.field_145850_b.field_72984_F.func_76320_a("recipeMatching");
        BlockPos belowPos = this.field_174879_c.func_177977_b();
        IBlockState below = this.field_145850_b.func_180495_p(belowPos);
        IBlockState side = this.field_145850_b.func_180495_p(belowPos.func_177978_c());
        IBlockState corner = this.field_145850_b.func_180495_p(belowPos.func_177978_c().func_177974_f());
        Optional<AgglomerationRecipe> optionalRecipe = AgglomerationRecipes.findMatchingRecipe(this.field_145850_b, this.field_174879_c, itemStacks, below, side, corner);
        this.field_145850_b.field_72984_F.func_76319_b();
        if (optionalRecipe.isPresent()) {
            AgglomerationRecipe recipe = optionalRecipe.get();
            this.maxMana = recipe.getManaCost();
            ISparkEntity mySpork = this.getAttachedSpark();
            if (mySpork != null) {
                for (ISparkEntity otherSpork : SparkHelper.getSparksAround((World)this.field_145850_b, (double)((double)this.field_174879_c.func_177958_n() + 0.5), (double)((double)this.field_174879_c.func_177956_o() + 0.5), (double)((double)this.field_174879_c.func_177952_p() + 0.5))) {
                    if (mySpork == otherSpork || !(otherSpork.getAttachedTile() instanceof IManaPool)) continue;
                    otherSpork.registerTransfer(mySpork);
                }
            }
            if (this.currentMana > 0) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers((TileEntity)this);
                PacketCustomTerraPlate packet = new PacketCustomTerraPlate(this.field_174879_c, recipe.color1, recipe.color2, (float)this.currentMana / (float)this.maxMana);
                BotaniaTweaksPacketHandler.sendToAllAround(packet, this.field_145850_b, this.field_174879_c);
            }
            if (this.currentMana >= this.maxMana) {
                itemEntities.forEach(Entity::func_70106_y);
                ItemStack output = recipe.getRecipeOutputCopy();
                EntityItem outputItem = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.3, (double)this.field_174879_c.func_177952_p() + 0.5, output);
                outputItem.field_70159_w = 0.0;
                outputItem.field_70181_x = 0.0;
                outputItem.field_70179_y = 0.0;
                this.field_145850_b.func_72838_d((Entity)outputItem);
                if (recipe.multiblockCenterReplace != null) {
                    this.replaceBlock(this.field_145850_b, this.field_174879_c.func_177977_b(), recipe.multiblockCenterReplace);
                }
                if (recipe.multiblockEdgeReplace != null) {
                    for (EnumFacing horiz : EnumFacing.field_176754_o) {
                        this.replaceBlock(this.field_145850_b, this.field_174879_c.func_177977_b().func_177972_a(horiz), recipe.multiblockEdgeReplace);
                    }
                }
                if (recipe.multiblockCornerReplace != null) {
                    for (EnumFacing horiz : EnumFacing.field_176754_o) {
                        this.replaceBlock(this.field_145850_b, this.field_174879_c.func_177977_b().func_177972_a(horiz).func_177972_a(horiz.func_176746_e()), recipe.multiblockCornerReplace);
                    }
                }
                this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, ModSounds.terrasteelCraft, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.currentMana = 0;
                this.maxMana = 0;
            }
        } else {
            this.maxMana = 0;
        }
        if (this.maxMana == 0) {
            this.recieveMana(0);
        }
        this.field_145850_b.field_72984_F.func_76319_b();
    }

    public boolean isCrafting() {
        return this.maxMana != 0;
    }

    public double getCraftingPercentage() {
        if (!this.isCrafting()) {
            return 0.0;
        }
        return Math.min(1.0, (double)this.currentMana / (double)this.maxMana);
    }

    private void replaceBlock(World w, BlockPos pos, IBlockState replace) {
        w.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)this.field_145850_b.func_180495_p(pos)));
        w.func_180501_a(pos, replace, 3);
    }

    private void updateComparator() {
        this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
    }

    public boolean canAttachSpark(ItemStack spork) {
        return true;
    }

    public void attachSpark(ISparkEntity spork) {
    }

    public int getAvailableSpaceForMana() {
        return Math.max(0, this.maxMana - this.currentMana);
    }

    public ISparkEntity getAttachedSpark() {
        List sporks = this.field_145850_b.func_72872_a(EntitySpark.class, new AxisAlignedBB(this.field_174879_c.func_177984_a()));
        return sporks.size() == 1 ? (ISparkEntity)sporks.get(0) : null;
    }

    public boolean areIncomingTranfersDone() {
        return this.maxMana == 0;
    }

    public boolean isFull() {
        return this.currentMana >= this.maxMana;
    }

    public void recieveMana(int i) {
        this.currentMana = MathHelper.func_76125_a((int)(this.currentMana + i), (int)0, (int)this.maxMana);
        this.updateComparator();
    }

    public boolean canRecieveManaFromBursts() {
        return this.maxMana != 0;
    }

    public int getCurrentMana() {
        return this.currentMana;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74768_a("Mana", this.currentMana);
        return super.func_189515_b(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        this.currentMana = nbt.func_74762_e("Mana");
        super.func_145839_a(nbt);
    }
}

