/*
 * Decompiled with CFR 0.152.
 */
package quaternary.botaniatweaks.modules.botania.block;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import quaternary.botaniatweaks.BotaniaTweaks;
import quaternary.botaniatweaks.modules.botania.block.BlockCustomAgglomerationPlate;
import quaternary.botaniatweaks.modules.botania.block.BlockCustomOpenCrate;
import quaternary.botaniatweaks.modules.botania.block.BlockNerfedManaFluxfield;
import quaternary.botaniatweaks.modules.shared.helper.MiscHelpers;
import vazkii.botania.common.block.ModBlocks;

public class BotaniaRegistryReplacements {
    public static void registerOverrides() {
        BotaniaTweaks.LOG.info("Creating Botania Tweaks registry replacement blocks. Forge will print some safe-to-ignore warnings.");
        HashMap<String, Object> botaniaRegistryReplacements = new HashMap<String, Object>();
        botaniaRegistryReplacements.put("rfGenerator", new BlockNerfedManaFluxfield());
        botaniaRegistryReplacements.put("terraPlate", new BlockCustomAgglomerationPlate());
        botaniaRegistryReplacements.put("openCrate", new BlockCustomOpenCrate());
        Loader loader = Loader.instance();
        ModContainer myContainer = loader.activeModContainer();
        ModContainer botaniaContainer = MiscHelpers.getBotaniaModContainer();
        loader.setActiveModContainer(botaniaContainer);
        ModBlocks.cacophonium.func_176223_P();
        loader.setActiveModContainer(myContainer);
        for (Map.Entry entry : botaniaRegistryReplacements.entrySet()) {
            try {
                String fieldName = (String)entry.getKey();
                Block patchedBlock = (Block)entry.getValue();
                Field f = ReflectionHelper.findField(ModBlocks.class, (String[])new String[]{fieldName});
                MiscHelpers.makeNonFinal(f);
                f.set(null, patchedBlock);
            }
            catch (Exception e) {
                throw new RuntimeException("There was a problem patching a Botania ModBlocks field", e);
            }
        }
    }
}

