/*
 * Decompiled with CFR 0.152.
 */
package quaternary.botaniatweaks.modules.botania.advancement;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.critereon.AbstractCriterionInstance;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import quaternary.botaniatweaks.modules.botania.wsd.ManaStatisticsWsd;
import quaternary.botaniatweaks.modules.shared.lib.GeneratingFlowers;

public class FlowerGeneratedManaCriterionTrigger
implements ICriterionTrigger<Instance> {
    private static final ResourceLocation RESLOC = new ResourceLocation("botania_tweaks", "flower_generated_mana");
    private final Map<PlayerAdvancements, Listeners> listeners = new HashMap<PlayerAdvancements, Listeners>();

    public ResourceLocation func_192163_a() {
        return RESLOC;
    }

    public void func_192165_a(PlayerAdvancements adv, ICriterionTrigger.Listener<Instance> listener) {
        Listeners l = this.listeners.computeIfAbsent(adv, Listeners::new);
        l.add(listener);
    }

    public void func_192164_b(PlayerAdvancements adv, ICriterionTrigger.Listener<Instance> listener) {
        Listeners l = this.listeners.get(adv);
        if (l != null) {
            this.listeners.remove(l);
            if (l.isEmpty()) {
                this.listeners.remove(adv);
            }
        }
    }

    public void func_192167_a(PlayerAdvancements adv) {
        this.listeners.remove(adv);
    }

    public Instance deserializeInstance(JsonObject json, JsonDeserializationContext ctx) {
        String flowerName = JsonUtils.func_151200_h((JsonObject)json, (String)"flower");
        long neededMana = (int)(JsonUtils.func_151217_k((JsonObject)json, (String)"pools") * 1000000.0f);
        if (!GeneratingFlowers.hasFlowerNamed(flowerName)) {
            throw new JsonSyntaxException("I don't know of any generating flower with the name '" + flowerName + "' !");
        }
        if (neededMana < 0L) {
            throw new JsonSyntaxException("Advancement with negative mana??????? what????");
        }
        return new Instance(flowerName, neededMana);
    }

    public void trigger(EntityPlayerMP player, ManaStatisticsWsd wsd) {
        Listeners l = this.listeners.get(player.func_192039_O());
        if (l != null) {
            l.trigger(wsd);
        }
    }

    public static class Instance
    extends AbstractCriterionInstance {
        private final String flowerName;
        private final long neededMana;

        public Instance(String flowerName, long neededMana) {
            super(RESLOC);
            this.flowerName = flowerName;
            this.neededMana = neededMana;
        }

        public boolean test(ManaStatisticsWsd data) {
            return data.getTotalFlowerMana(this.flowerName) >= this.neededMana;
        }
    }

    public static class Listeners {
        private final PlayerAdvancements adv;
        private final Set<ICriterionTrigger.Listener<Instance>> listeners = new HashSet<ICriterionTrigger.Listener<Instance>>();

        public Listeners(PlayerAdvancements adv) {
            this.adv = adv;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        public void remove(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(ManaStatisticsWsd data) {
            ArrayList<ICriterionTrigger.Listener<Instance>> successfulInstances = new ArrayList<ICriterionTrigger.Listener<Instance>>();
            for (ICriterionTrigger.Listener<Instance> listener : this.listeners) {
                if (!((Instance)listener.func_192158_a()).test(data)) continue;
                successfulInstances.add(listener);
            }
            for (ICriterionTrigger.Listener listener : successfulInstances) {
                listener.func_192159_a(this.adv);
            }
        }
    }
}

