/*
 * Decompiled with CFR 0.152.
 */
package quaternary.botaniatweaks.asm.tweaks;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.ListIterator;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;
import quaternary.botaniatweaks.asm.tweaks.Tweak;

public class OrechidPriceTweak
extends Tweak {
    @Override
    protected Collection<String> computeAffectedClasses() {
        return ImmutableList.of((Object)"vazkii.botania.common.block.subtile.functional.SubTileOrechid");
    }

    @Override
    String getLogMessage(String transformedName) {
        return "Patching the orechid's price...";
    }

    @Override
    void doPatch(String transformedName, ClassNode node) {
        block0: for (MethodNode method : node.methods) {
            if (!method.name.equals("getCost") && !method.name.equals("getDelay")) continue;
            InsnList ins = method.instructions;
            ListIterator inserator = ins.iterator();
            while (inserator.hasNext()) {
                AbstractInsnNode in = (AbstractInsnNode)inserator.next();
                if (in.getOpcode() != 178) continue;
                FieldInsnNode staticGet = new FieldInsnNode(178, OrechidPriceTweak.getHooksClass(), "orechidGog", "Z");
                inserator.remove();
                inserator.add(staticGet);
                continue block0;
            }
        }
    }
}

