/*
 * Decompiled with CFR 0.152.
 */
package quaternary.botaniatweaks.asm.tweaks;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import quaternary.botaniatweaks.asm.tweaks.Tweak;

public class ManastormChargeOutputTweak
extends Tweak {
    @Override
    public Collection<String> computeAffectedClasses() {
        return ImmutableList.of((Object)"vazkii.botania.common.entity.EntityManaStorm");
    }

    @Override
    String getLogMessage(String transformedName) {
        return "Patching the manastorm charge's mana output...";
    }

    @Override
    public void doPatch(String transformedName, ClassNode node) {
        block0: for (MethodNode method : node.methods) {
            MethodInsnNode callInstruction;
            AbstractInsnNode instruction;
            int i;
            if (!method.name.equals("spawnBurst")) continue;
            InsnList ins = method.instructions;
            for (i = 0; i < ins.size(); ++i) {
                instruction = ins.get(i);
                if (instruction.getOpcode() != 16) continue;
                callInstruction = new MethodInsnNode(184, ManastormChargeOutputTweak.getHooksClass(), "getManastormBurstMana", "()I", false);
                ins.insertBefore(instruction, (AbstractInsnNode)callInstruction);
                ins.remove(instruction);
                break;
            }
            for (i = 0; i < ins.size(); ++i) {
                instruction = ins.get(i);
                if (instruction.getOpcode() != 17) continue;
                callInstruction = new MethodInsnNode(184, ManastormChargeOutputTweak.getHooksClass(), "getManastormBurstStartingMana", "()I", false);
                ins.insertBefore(instruction, (AbstractInsnNode)callInstruction);
                ins.remove(instruction);
                break;
            }
            for (i = 0; i < ins.size(); ++i) {
                instruction = ins.get(i);
                if (instruction.getOpcode() != 12) continue;
                callInstruction = new MethodInsnNode(184, ManastormChargeOutputTweak.getHooksClass(), "getManastormBurstLossjpgPerTick", "()F", false);
                ins.insertBefore(instruction, (AbstractInsnNode)callInstruction);
                ins.remove(instruction);
                break block0;
            }
        }
    }
}

