/*
 * Decompiled with CFR 0.152.
 */
package quaternary.botaniatweaks.asm.tweaks;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import quaternary.botaniatweaks.asm.tweaks.Tweak;
import quaternary.botaniatweaks.modules.shared.lib.GeneratingFlowers;

public class ManaStatisticsTweak
extends Tweak {
    @Override
    protected Collection<String> computeAffectedClasses() {
        return ImmutableList.copyOf(GeneratingFlowers.getAllFlowerClassesMayOrMayNotExist());
    }

    @Override
    String getLogMessage(String transformedName) {
        return "Adding managen statistics for the " + GeneratingFlowers.flowerNameFromClass(transformedName) + " flower...";
    }

    @Override
    void doPatch(String transformedName, ClassNode node) {
        for (MethodNode method : node.methods) {
            if (!method.name.equals("onUpdate")) continue;
            boolean addedAfterSuperHook = false;
            for (int insIndex = 0; insIndex < method.instructions.size(); ++insIndex) {
                MethodInsnNode methodInstruction;
                AbstractInsnNode instruction = method.instructions.get(insIndex);
                if (!addedAfterSuperHook && instruction instanceof MethodInsnNode && (methodInstruction = (MethodInsnNode)instruction).getOpcode() == 183 && methodInstruction.name.equals("onUpdate") && methodInstruction.owner.equals("vazkii/botania/api/subtile/SubTileGenerating")) {
                    InsnList hook = ManaStatisticsTweak.genInsnListHook(transformedName, "beginManaStatSection");
                    method.instructions.insert((AbstractInsnNode)methodInstruction, hook);
                    addedAfterSuperHook = true;
                }
                if (instruction.getOpcode() != 177) continue;
                InsnList hook = ManaStatisticsTweak.genInsnListHook(transformedName, "endManaStatSection");
                insIndex += hook.size();
                method.instructions.insertBefore(instruction, hook);
            }
            return;
        }
    }

    private static InsnList genInsnListHook(String transformedName, String hookMethodName) {
        String bytecodeClassName = transformedName.replace('.', '/');
        InsnList hook = new InsnList();
        hook.add((AbstractInsnNode)new LdcInsnNode((Object)GeneratingFlowers.flowerNameFromClass(transformedName)));
        hook.add((AbstractInsnNode)new VarInsnNode(25, 0));
        hook.add((AbstractInsnNode)new InsnNode(89));
        hook.add((AbstractInsnNode)new FieldInsnNode(180, bytecodeClassName, "mana", "I"));
        hook.add((AbstractInsnNode)new MethodInsnNode(184, ManaStatisticsTweak.getHooksClass(), hookMethodName, "(Ljava/lang/String;Lvazkii/botania/api/subtile/SubTileGenerating;I)V", false));
        return hook;
    }
}

