/*
 * Decompiled with CFR 0.152.
 */
package quaternary.botaniatweaks.asm.tweaks;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import quaternary.botaniatweaks.asm.tweaks.Tweak;
import quaternary.botaniatweaks.modules.shared.lib.GeneratingFlowers;

public class EverythingCanDecayTweak
extends Tweak {
    @Override
    public Collection<String> computeAffectedClasses() {
        return ImmutableList.copyOf((Collection)GeneratingFlowers.getAllFlowerDatas().stream().filter(data -> !data.isPassive).map(data -> data.className).collect(Collectors.toList()));
    }

    @Override
    String getLogMessage(String transformedName) {
        return "Patching the " + GeneratingFlowers.flowerNameFromClass(transformedName) + "'s decayability...";
    }

    @Override
    public void doPatch(String transformedName, ClassNode node) {
        for (MethodNode method : node.methods) {
            if (!method.name.equals("isPassiveFlower")) continue;
            node.methods.remove(method);
            break;
        }
        MethodNode newPassiveMethod = new MethodNode(1, "isPassiveFlower", "()Z", null, null);
        InsnList ins = newPassiveMethod.instructions;
        ins.add((AbstractInsnNode)new LdcInsnNode((Object)GeneratingFlowers.flowerNameFromClass(transformedName)));
        ins.add((AbstractInsnNode)new MethodInsnNode(184, EverythingCanDecayTweak.getHooksClass(), "shouldFlowerDecay", "(Ljava/lang/String;)Z", false));
        ins.add((AbstractInsnNode)new InsnNode(172));
        node.methods.add(newPassiveMethod);
    }
}

