/*
 * Decompiled with CFR 0.152.
 */
package lcrdrfs.entities;

import java.util.Random;
import lcrdrfs.ModItems;
import lcrdrfs.ModSounds;
import lcrdrfs.ai.EntityAILaserCreeperSwell;
import lcrdrfs.confighandler.ConfigHandler;
import lcrdrfs.entities.EntityLaserBeam;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityLaserCreeper
extends EntityMob {
    private static final DataParameter<Integer> STATE = EntityDataManager.func_187226_a(EntityLaserCreeper.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> POWERED = EntityDataManager.func_187226_a(EntityLaserCreeper.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IGNITED = EntityDataManager.func_187226_a(EntityLaserCreeper.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> SHOOTING = EntityDataManager.func_187226_a(EntityLaserCreeper.class, (DataSerializer)DataSerializers.field_187192_b);
    private int lastActiveTime;
    private int timeSinceIgnited;
    private int fuseTime = 30;
    private int explosionRadius = 3;
    private int droppedSkulls;
    private EntityAILaserCreeperSwell aiCreeperSwell;
    private EntityAIAttackMelee aiMelee;

    public EntityLaserCreeper(World world) {
        super(world);
    }

    protected void func_184651_r() {
        this.aiCreeperSwell = new EntityAILaserCreeperSwell(this);
        this.aiMelee = new EntityAIAttackMelee((EntityCreature)this, 1.0, false);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiCreeperSwell);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityOcelot.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiMelee);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    public int getMaxSafePointTries() {
        return this.func_70638_az() == null ? 3 : 3 + (int)(this.func_110143_aJ() - 1.0f);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        super.func_180430_e(distance, damageMultiplier);
        if (this.func_70089_S() && this.func_184187_bx() == null) {
            this.timeSinceIgnited = (int)((float)this.timeSinceIgnited + distance * 1.5f);
            if (this.timeSinceIgnited > this.fuseTime - 5) {
                this.timeSinceIgnited = this.fuseTime - 5;
            }
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATE, (Object)-1);
        this.field_70180_af.func_187214_a(POWERED, (Object)false);
        this.field_70180_af.func_187214_a(IGNITED, (Object)false);
        this.field_70180_af.func_187214_a(SHOOTING, (Object)0);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (((Boolean)this.field_70180_af.func_187225_a(POWERED)).booleanValue()) {
            nbt.func_74757_a("powered", true);
        }
        nbt.func_74777_a("Fuse", (short)this.fuseTime);
        nbt.func_74774_a("ExplosionRadius", (byte)this.explosionRadius);
        nbt.func_74757_a("ignited", this.hasIgnited());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.field_70180_af.func_187227_b(POWERED, (Object)nbt.func_74767_n("powered"));
        if (nbt.func_150297_b("Fuse", 99)) {
            this.fuseTime = nbt.func_74765_d("Fuse");
        }
        if (nbt.func_150297_b("ExplosionRadius", 99)) {
            this.explosionRadius = nbt.func_74771_c("ExplosionRadius");
        }
        if (nbt.func_74767_n("ignited")) {
            this.ignite();
        }
    }

    public void func_70071_h_() {
        if (!this.func_130014_f_().field_72995_K) {
            if (this.func_130014_f_().func_72820_D() < (long)(ConfigHandler.LASER_CREEPER_SPAWN_DELAY * 24000)) {
                this.func_70106_y();
            }
            if (this.func_70638_az() != null) {
                this.func_70625_a((Entity)this.func_70638_az(), 100.0f, 100.0f);
                this.func_70671_ap().func_75650_a(this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u + (double)this.func_70638_az().func_70047_e(), this.func_70638_az().field_70161_v, 10.0f, (float)this.func_70646_bf());
                float distance = (float)this.func_70011_f(this.func_70638_az().field_70165_t, this.func_70638_az().func_174813_aQ().field_72338_b, this.func_70638_az().field_70161_v);
                if (this.getRangeAttackTimer() < 130 && distance > 3.0f) {
                    this.setRangeAttackTimer(this.getRangeAttackTimer() + 2);
                }
                if (this.getRangeAttackTimer() == 100 && distance > 3.0f) {
                    this.shootMissile(this.func_70638_az(), distance);
                }
                if (this.getRangeAttackTimer() == 110 && distance > 3.0f) {
                    this.shootMissile(this.func_70638_az(), distance);
                }
                if (this.getRangeAttackTimer() == 120 && distance > 3.0f) {
                    this.shootMissile(this.func_70638_az(), distance);
                }
                if (this.getRangeAttackTimer() == 130 && distance > 3.0f) {
                    this.shootMissile(this.func_70638_az(), distance);
                }
            }
        }
        if (this.func_184187_bx() != null) {
            this.field_70721_aZ = 0.0f;
            this.field_184619_aG = 0.0f;
        }
        if (this.func_70089_S() && this.func_184187_bx() == null) {
            int i;
            this.lastActiveTime = this.timeSinceIgnited;
            if (this.hasIgnited()) {
                this.setCreeperState(1);
            }
            if ((i = this.getCreeperState()) > 0 && this.timeSinceIgnited == 0) {
                this.func_184185_a(SoundEvents.field_187572_ar, 1.0f, 0.5f);
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = this.fuseTime;
                this.explode();
            }
        }
        super.func_70071_h_();
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.func_184187_bx() != null && (source.equals(DamageSource.field_76368_d) || source.equals(DamageSource.field_76379_h))) {
            return false;
        }
        return super.func_70097_a(source, damage);
    }

    public void shootMissile(EntityLivingBase entity, float distance) {
        Random rand = this.func_130014_f_().field_73012_v;
        double heightY = 1.0;
        double direction = Math.toRadians(this.field_70761_aq);
        if (this.func_70685_l((Entity)entity) && !this.field_70128_L) {
            EntityLaserBeam missile = new EntityLaserBeam(this.func_130014_f_(), (EntityLivingBase)this, ConfigHandler.CREEPER_LASER_DAMAGE);
            double targetX = entity.field_70165_t + entity.field_70159_w - this.field_70165_t;
            double targetY = entity.field_70163_u - this.field_70163_u;
            double targetZ = entity.field_70161_v + entity.field_70179_y - this.field_70161_v;
            missile.func_70186_c(targetX, targetY, targetZ, 1.5f, 0.0f);
            if (this.getRangeAttackTimer() == 100) {
                direction = Math.toRadians(this.field_70761_aq - 30.0f);
                heightY = this.field_70163_u + 1.2;
            }
            if (this.getRangeAttackTimer() == 110) {
                direction = Math.toRadians(this.field_70761_aq + 30.0f);
                heightY = this.field_70163_u + 1.2;
            }
            if (this.getRangeAttackTimer() == 120) {
                direction = Math.toRadians(this.field_70761_aq - 30.0f);
                heightY = this.field_70163_u + 1.0;
            }
            if (this.getRangeAttackTimer() == 130) {
                direction = Math.toRadians(this.field_70761_aq + 30.0f);
                heightY = this.field_70163_u + 1.0;
            }
            missile.func_70107_b(this.field_70165_t + -Math.sin(direction) * 0.8, heightY, this.field_70161_v + Math.cos(direction) * 0.8);
            this.func_130014_f_().func_72838_d((Entity)missile);
            this.func_130014_f_().func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, ModSounds.LASERBEAM, SoundCategory.HOSTILE, 1.0f, 1.0f);
        }
        if (this.getRangeAttackTimer() >= 130) {
            this.setRangeAttackTimer(0);
        }
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187570_aq;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187568_ap;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (this.func_130014_f_().func_82736_K().func_82766_b("doMobLoot")) {
            if (cause.func_76346_g() instanceof EntitySkeleton) {
                int i = Item.func_150891_b((Item)Items.field_151096_cd);
                int j = Item.func_150891_b((Item)Items.field_151084_co);
                int k = i + this.field_70146_Z.nextInt(j - i + 1);
                this.func_145779_a(Item.func_150899_d((int)k), 1);
            } else if (cause.func_76346_g() instanceof EntityLaserCreeper && cause.func_76346_g() != this && ((EntityLaserCreeper)cause.func_76346_g()).getPowered() && ((EntityLaserCreeper)cause.func_76346_g()).isAIEnabled()) {
                ((EntityLaserCreeper)cause.func_76346_g()).incrementDroppedSkulls();
                this.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 4), 0.0f);
            }
        }
    }

    public boolean func_70652_k(Entity entity) {
        return true;
    }

    public boolean getPowered() {
        return (Boolean)this.field_70180_af.func_187225_a(POWERED);
    }

    @SideOnly(value=Side.CLIENT)
    public float getCreeperFlashIntensity(float renderTick) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * renderTick) / (float)(this.fuseTime - 2);
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        this.func_70099_a(new ItemStack(Items.field_151137_ax), 0.0f);
        this.func_70099_a(new ItemStack(Items.field_151016_H), 0.0f);
        this.func_70099_a(new ItemStack(ModItems.CREEPER_PLASMA, 1), 0.0f);
        if (this.func_130014_f_().field_73012_v.nextInt(50) == 0) {
            this.func_70099_a(new ItemStack(ModItems.PLASMA_POWER_UNIT, 1), 0.0f);
        }
    }

    public boolean func_70601_bi() {
        float light;
        long spawnDelay;
        long worldTime = this.func_130014_f_().func_82737_E();
        if (worldTime > (spawnDelay = (long)(ConfigHandler.LASER_CREEPER_SPAWN_DELAY * 24000)) && (light = this.func_70013_c()) <= 8.0f) {
            return this.func_130014_f_().func_72855_b(this.func_174813_aQ()) && this.func_130014_f_().func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.func_130014_f_().func_72953_d(this.func_174813_aQ());
        }
        return false;
    }

    protected boolean func_70814_o() {
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        return this.func_130014_f_().func_175642_b(EnumSkyBlock.BLOCK, blockpos) <= 8;
    }

    public int func_70641_bl() {
        return 3;
    }

    protected boolean func_70692_ba() {
        return !this.func_184218_aH();
    }

    public int getCreeperState() {
        return (Integer)this.field_70180_af.func_187225_a(STATE);
    }

    public void setCreeperState(int state) {
        this.field_70180_af.func_187227_b(STATE, (Object)state);
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        super.func_70077_a(lightningBolt);
        this.field_70180_af.func_187227_b(POWERED, (Object)true);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_151033_d) {
            this.func_130014_f_().func_184148_a(player, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187649_bu, this.func_184176_by(), 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
            player.func_184609_a(hand);
            if (!this.func_130014_f_().field_72995_K) {
                this.ignite();
                stack.func_77972_a(1, (EntityLivingBase)player);
                return true;
            }
        }
        return super.func_184645_a(player, hand);
    }

    private void explode() {
        if (!this.func_130014_f_().field_72995_K) {
            boolean flag = this.func_130014_f_().func_82736_K().func_82766_b("mobGriefing");
            float f = this.getPowered() ? 2.0f : 1.0f;
            this.field_70729_aU = true;
            this.func_130014_f_().func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)this.explosionRadius * f, flag);
            this.func_70106_y();
        }
    }

    public boolean hasIgnited() {
        return (Boolean)this.field_70180_af.func_187225_a(IGNITED);
    }

    public void ignite() {
        this.field_70180_af.func_187227_b(IGNITED, (Object)true);
    }

    public boolean isAIEnabled() {
        return this.droppedSkulls < 1 && this.func_130014_f_().func_82736_K().func_82766_b("doMobLoot");
    }

    public void incrementDroppedSkulls() {
        ++this.droppedSkulls;
    }

    public void setRangeAttackTimer(int state) {
        this.field_70180_af.func_187227_b(SHOOTING, (Object)state);
    }

    public int getRangeAttackTimer() {
        return (Integer)this.field_70180_af.func_187225_a(SHOOTING);
    }

    public void func_70098_U() {
        super.func_70098_U();
        if (this.func_184187_bx() instanceof EntityCreature) {
            EntityCreature entitycreature = (EntityCreature)this.func_184187_bx();
            this.field_70761_aq = entitycreature.field_70761_aq;
        }
    }
}

