/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.network;

import flaxbeard.cyberware.client.gui.ContainerEngineeringTable;
import flaxbeard.cyberware.common.block.tile.TileEntityEngineeringTable;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class EngineeringSwitchArchivePacket
implements IMessage {
    private BlockPos pos;
    private int dimensionId;
    private int entityId;
    private boolean direction;
    private boolean isComponent;

    public EngineeringSwitchArchivePacket() {
    }

    public EngineeringSwitchArchivePacket(BlockPos pos, EntityPlayer player, boolean direction, boolean isComponent) {
        this.dimensionId = player.field_70170_p.field_73011_w.getDimension();
        this.entityId = player.func_145782_y();
        this.pos = pos;
        this.direction = direction;
        this.isComponent = isComponent;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.direction);
        buf.writeBoolean(this.isComponent);
        buf.writeInt(this.entityId);
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.dimensionId);
    }

    public void fromBytes(ByteBuf buf) {
        this.direction = buf.readBoolean();
        this.isComponent = buf.readBoolean();
        this.entityId = buf.readInt();
        int x = buf.readInt();
        int y = buf.readInt();
        int z = buf.readInt();
        this.pos = new BlockPos(x, y, z);
        this.dimensionId = buf.readInt();
    }

    private static class DoSync
    implements Runnable {
        private BlockPos pos;
        private int dimensionId;
        private int entityId;
        private boolean direction;
        private boolean isComponent;

        private DoSync(BlockPos pos, int dimensionId, int entityId, boolean direction, boolean isComponent) {
            this.pos = pos;
            this.dimensionId = dimensionId;
            this.entityId = entityId;
            this.direction = direction;
            this.isComponent = isComponent;
        }

        @Override
        public void run() {
            WorldServer world = DimensionManager.getWorld((int)this.dimensionId);
            Entity e = world.func_73045_a(this.entityId);
            if (e instanceof EntityPlayer) {
                EntityPlayer p = (EntityPlayer)e;
                if (this.isComponent) {
                    if (p.field_71070_bA instanceof ContainerEngineeringTable) {
                        if (this.direction) {
                            ((ContainerEngineeringTable)p.field_71070_bA).nextComponentBox();
                        } else {
                            ((ContainerEngineeringTable)p.field_71070_bA).prevComponentBox();
                        }
                        TileEntityEngineeringTable tileEntityEngineeringTable = (TileEntityEngineeringTable)world.func_175625_s(this.pos);
                    }
                } else if (p.field_71070_bA instanceof ContainerEngineeringTable) {
                    if (this.direction) {
                        ((ContainerEngineeringTable)p.field_71070_bA).nextArchive();
                    } else {
                        ((ContainerEngineeringTable)p.field_71070_bA).prevArchive();
                    }
                    TileEntityEngineeringTable te = (TileEntityEngineeringTable)world.func_175625_s(this.pos);
                    te.lastPlayerArchive.put(p.func_189512_bd(), ((ContainerEngineeringTable)p.field_71070_bA).archive.func_174877_v());
                }
            }
        }
    }

    public static class EngineeringSwitchArchivePacketHandler
    implements IMessageHandler<EngineeringSwitchArchivePacket, IMessage> {
        public IMessage onMessage(EngineeringSwitchArchivePacket message, MessageContext ctx) {
            DimensionManager.getWorld((int)message.dimensionId).func_152344_a((Runnable)new DoSync(message.pos, message.dimensionId, message.entityId, message.direction, message.isComponent));
            return null;
        }
    }
}

